/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.VelocityLocation;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SemblanceProfileVelocityCollection
implements Java2D_PaintableInterface {
    protected ArrayList<VelocityLocation> m_list = new ArrayList();
    protected String m_fileName;
    protected float[] m_velocity = new float[10];
    protected boolean m_dirty = true;
    protected int m_requestedSampleCount = 10;
    protected float m_requestedSampleInterval = 4.0f;
    protected float m_requestedStartTime = 0.0f;
    protected int m_minPickedBin;
    protected int m_maxPickedBin;

    public int numBins() {
        return this.m_list.size();
    }

    public SemblanceProfileVelocityCollection(String fileName, int numBins, SeismicProfile profile) {
        try {
            this.m_fileName = fileName;
            for (int n = 0; n < numBins; ++n) {
                VelocityLocation loc = new VelocityLocation();
                loc.X = profile.binX(n);
                loc.Y = profile.binY(n);
                this.m_list.add(loc);
            }
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                this.save();
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int num = file.readInt();
            if (num != numBins) {
                file.close();
                return;
            }
            for (int n = 0; n < num; ++n) {
                this.m_list.get(n).readFromFile(file);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public VelocityLocation getVelocityLocation(int bin) {
        try {
            return this.m_list.get(bin);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public int getNumPickedBins() {
        try {
            int num = 0;
            for (VelocityLocation loc : this.m_list) {
                if (loc.numPicks() <= 0) continue;
                ++num;
            }
            return num;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void prepVelocity(float t0, float digi, int count) {
        try {
            this.m_requestedSampleCount = Math.max(count, 10);
            this.m_velocity = new float[this.m_requestedSampleCount];
            this.m_requestedSampleInterval = Math.max(digi, 2.0f);
            this.m_requestedStartTime = t0;
            this.m_minPickedBin = 1000000;
            this.m_maxPickedBin = 0;
            for (int n = 0; n < this.m_list.size(); ++n) {
                VelocityLocation loc = this.m_list.get(n);
                loc.setRequestedInterp(this.m_requestedStartTime, this.m_requestedSampleInterval, this.m_requestedSampleCount);
                if (loc.numPicks() <= 0) continue;
                this.m_minPickedBin = Math.min(this.m_minPickedBin, n);
                this.m_maxPickedBin = Math.max(this.m_maxPickedBin, n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[] getVelocity(int bin) throws Exception {
        try {
            if (bin <= this.m_minPickedBin) {
                return this.m_list.get(this.m_minPickedBin).getInterpolatedVelocity();
            }
            if (bin >= this.m_maxPickedBin) {
                return this.m_list.get(this.m_maxPickedBin).getInterpolatedVelocity();
            }
            VelocityLocation loc = this.m_list.get(bin);
            if (loc.numPicks() > 0) {
                return loc.getInterpolatedVelocity();
            }
            int b1 = bin - 1;
            VelocityLocation loc1 = this.m_list.get(b1);
            while (loc1.numPicks() < 1) {
                loc1 = this.m_list.get(--b1);
            }
            int b2 = bin + 1;
            VelocityLocation loc2 = this.m_list.get(b2);
            while (loc2.numPicks() < 1) {
                loc2 = this.m_list.get(++b2);
            }
            float wt = b2 - b1;
            float w2 = (float)(bin - b1) / wt;
            float w1 = (float)(b2 - bin) / wt;
            float[] v1 = loc1.getInterpolatedVelocity();
            float[] v2 = loc2.getInterpolatedVelocity();
            for (int s = 0; s < this.m_requestedSampleCount; ++s) {
                this.m_velocity[s] = w1 * v1[s] + w2 * v2[s];
            }
            return this.m_velocity;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save() {
        try {
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            file.writeInt(this.m_list.size());
            for (int n = 0; n < this.m_list.size(); ++n) {
                this.m_list.get(n).writeToFile(file);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.black);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (int n = 0; n < this.m_list.size(); ++n) {
                VelocityLocation loc = this.m_list.get(n);
                loc.PixelX = -999999;
                loc.PixelX = (int)(scaleX * (double)n + shiftX);
                for (int p = 0; p < loc.numPicks(); ++p) {
                    VelocityLocation.Pick pick = loc.pick(p);
                    int y = (int)(scaleY * pick.Time + shiftY);
                    g2d.fillRect(loc.PixelX - 2, y - 2, 5, 5);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

