/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SeismicProfileStack {
    public Ensemble read(String fileName) throws Exception {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            long len = file.length();
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, (int)len);
            buffer.order(ByteOrder.BIG_ENDIAN);
            file.read(buffer.array(), 0, (int)len);
            file.close();
            int version = buffer.getInt(0);
            if (version == 1000) {
                return this.readVersion1000(buffer);
            }
            throw new Exception("Unrecognized version");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected Ensemble readVersion1000(ByteBuffer buffer) throws Exception {
        try {
            Ensemble ensemble = new Ensemble();
            int indexVersion = 0;
            int indexDigi = 4;
            int indexTime0 = 8;
            int indexTraceCount = 12;
            int indexSampleCount = 16;
            int indexHeaderByteCount = 20;
            int version = buffer.getInt(indexVersion);
            float digi = buffer.getFloat(indexDigi);
            float t0 = buffer.getFloat(indexTime0);
            int numberOfTraces = buffer.getInt(indexTraceCount);
            int sampPerTrace = buffer.getInt(indexSampleCount);
            int numHeaderBytes = buffer.getInt(indexHeaderByteCount);
            float[] data = new float[sampPerTrace];
            for (int n = 0; n < numberOfTraces; ++n) {
                EnsembleTrace trace = ensemble.addTrace();
                FloatArrayWrapper wrapper = trace.data();
                int offset = numHeaderBytes + 4 * n * sampPerTrace;
                for (int s = 0; s < sampPerTrace; ++s) {
                    data[s] = buffer.getFloat(offset);
                    offset += 4;
                }
                wrapper.insertArray(data, sampPerTrace);
                wrapper.setFirstSampleCoord(t0);
                wrapper.setSampleInterval(digi);
            }
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void saveVersion1000(String fileName, Ensemble ensemble, float t0, float digi, int sampPerTrace) throws Exception {
        try {
            int version = 1000;
            int numHeaderBytes = 1000;
            int numberOfTraces = ensemble.traceCount();
            int numDataBytes = 4 * numberOfTraces * sampPerTrace;
            int totalBytes = numHeaderBytes + numDataBytes;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, totalBytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int indexVersion = 0;
            int indexDigi = 4;
            int indexTime0 = 8;
            int indexTraceCount = 12;
            int indexSampleCount = 16;
            int indexHeaderByteCount = 20;
            buffer.putInt(indexVersion, version);
            buffer.putFloat(indexDigi, digi);
            buffer.putFloat(indexTime0, t0);
            buffer.putInt(indexTraceCount, numberOfTraces);
            buffer.putInt(indexSampleCount, sampPerTrace);
            buffer.putInt(indexHeaderByteCount, numHeaderBytes);
            float[] data = new float[sampPerTrace];
            for (int n = 0; n < numberOfTraces; ++n) {
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                if (wrapper.length() > 0) {
                    wrapper.copyToArray(data);
                } else {
                    for (int s = 0; s < sampPerTrace; ++s) {
                        data[s] = 0.0f;
                    }
                }
                int offset = numHeaderBytes + 4 * n * sampPerTrace;
                for (int s = 0; s < sampPerTrace; ++s) {
                    buffer.putFloat(offset, data[s]);
                    offset += 4;
                }
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            file.write(buffer.array(), 0, totalBytes);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

