/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class DigiStack2D {
    protected boolean m_valid = false;
    public float[][] Dip;
    public float[][] Amplitude;
    protected float[] m_dipScan;
    protected Ensemble m_inputEnsemble;
    protected int m_traceRadius;
    protected float m_correlationWindow;
    protected float m_maxShift;
    protected int m_maxShift_Samples;
    protected int m_correlationWindow_Samples;
    protected int m_correlationWindow_Half;
    protected int m_samplesPerTrace;
    protected int m_numTraces;
    protected int m_zeroPadSamples;
    protected int m_dataLength;
    protected float m_sampleInterval;
    protected float m_time0;
    protected ArrayList<TraceData> m_traceList = new ArrayList();
    protected ArrayList<CorrelationData> m_corrList = new ArrayList();
    protected int m_minListIndex;
    protected int m_maxListIndex;

    public boolean valid() {
        return this.m_valid;
    }

    public static void testWithSine() {
        try {
            Ensemble ensemble = new Ensemble();
            float[] data = new float[200];
            double omega = 0.6283185307179586;
            float digi = 4.0f;
            for (int n = 0; n < 10; ++n) {
                EnsembleTrace trace = ensemble.addTrace();
                double shift = 1.66 * (double)n;
                for (int s = 0; s < data.length; ++s) {
                    data[s] = (float)Math.sin(omega * ((double)s - shift));
                }
                trace.data().insertArray(data, data.length);
                trace.data().setSampleInterval(digi);
            }
            DigiStack2D ds = new DigiStack2D();
            ds.compute(ensemble, 2, 10.0f * digi, 3.0f * digi);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void synthesize(double percentOriginal) {
        try {
            float frac = 0.01f * (float)percentOriginal;
            frac = Math.max(0.0f, frac);
            frac = Math.min(1.0f, frac);
            float[] temp = new float[this.m_samplesPerTrace];
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                trace.data().copyToArray(temp);
                for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                    temp[s] = this.Dip[n][s];
                }
                trace.data().insertArray(temp, this.m_samplesPerTrace);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void compute(Ensemble ensemble, int traceRadius, float correlationWindow, float maxShift) {
        try {
            this.m_valid = false;
            this.m_inputEnsemble = ensemble;
            this.m_traceRadius = traceRadius;
            this.m_correlationWindow = correlationWindow;
            this.m_maxShift = maxShift;
            this.m_traceRadius = Math.max(1, traceRadius);
            this.m_traceRadius = Math.min(10, traceRadius);
            if (!this.prep()) {
                return;
            }
            float[] temp = new float[this.m_samplesPerTrace];
            float[] hilb = new float[this.m_samplesPerTrace];
            FFT_1D_Wrapper fft = new FFT_1D_Wrapper(this.m_samplesPerTrace);
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                this.m_maxListIndex = 0;
                this.m_minListIndex = 100000;
                for (int r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                    int listIndex = r + this.m_traceRadius;
                    int ensembleIndex = n + r;
                    TraceData td = this.m_traceList.get(listIndex);
                    for (int s = 0; s < td.Data.length; ++s) {
                        td.Data[s] = 0.0f;
                        td.Hilbert[s] = 0.0f;
                    }
                    td.Valid = false;
                    if (ensembleIndex < 0 || ensembleIndex >= this.m_numTraces) continue;
                    EnsembleTrace trace = this.m_inputEnsemble.trace(ensembleIndex);
                    trace.data().copyToArray(temp);
                    System.arraycopy(temp, 0, hilb, 0, this.m_samplesPerTrace);
                    fft.rotatePhase(1.5707964f, hilb);
                    for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                        td.Data[this.m_zeroPadSamples + s] = temp[s];
                        td.Hilbert[this.m_zeroPadSamples + s] = hilb[s];
                    }
                    td.Valid = true;
                    this.m_maxListIndex = Math.max(this.m_maxListIndex, listIndex);
                    this.m_minListIndex = Math.min(this.m_minListIndex, listIndex);
                }
                this.work1(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void work1(int traceIndex) {
        try {
            TraceData centerTrace = this.m_traceList.get(this.m_traceRadius);
            for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                this.Dip[traceIndex][s] = 0.0f;
                this.Amplitude[traceIndex][s] = centerTrace.Data[s + this.m_zeroPadSamples];
                int numValid = 0;
                for (int r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                    int listIndex = r + this.m_traceRadius;
                    CorrelationData cd = this.m_corrList.get(listIndex);
                    TraceData td = this.m_traceList.get(listIndex);
                    cd.Valid = false;
                    if (td.Valid) {
                        this.computeCrossCorr(centerTrace, td, s, cd);
                    }
                    if (!cd.Valid) continue;
                    ++numValid;
                }
                if (numValid >= 2) {
                    float maxScan = 0.0f;
                    int maxDip = 0;
                    for (int dip = -this.m_maxShift_Samples; dip <= this.m_maxShift_Samples; ++dip) {
                        float dipScan = this.computeDipScan(dip);
                        if (dipScan > maxScan) {
                            maxScan = dipScan;
                            maxDip = dip;
                        }
                        this.m_dipScan[dip + this.m_maxShift_Samples] = dipScan;
                    }
                    this.Dip[traceIndex][s] = maxDip;
                    if (maxDip > -this.m_maxShift_Samples && maxDip < this.m_maxShift_Samples) {
                        double scan_m1 = this.m_dipScan[maxDip + this.m_maxShift_Samples - 1];
                        double scan_0 = this.m_dipScan[maxDip + this.m_maxShift_Samples];
                        double scan_p1 = this.m_dipScan[maxDip + this.m_maxShift_Samples + 1];
                        double a = 0.5 * (scan_p1 + scan_m1) - scan_0;
                        double b = 0.5 * (scan_p1 - scan_m1);
                        this.Dip[traceIndex][s] = (float)maxDip - (float)(b / (2.0 * a));
                    }
                }
                float[] fArray = this.Dip[traceIndex];
                int n = s;
                fArray[n] = fArray[n] / (float)this.m_traceRadius;
                double count = 1.0E-20;
                double amp = 0.0;
                int bug = 0;
                for (int r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                    int listIndex = r + this.m_traceRadius;
                    TraceData td = this.m_traceList.get(listIndex);
                    if (!td.Valid) continue;
                    float sample = (float)(s + this.m_zeroPadSamples) + this.Dip[traceIndex][s] * (float)r;
                    int low = (int)sample;
                    float w = sample - (float)low;
                    if (low > 0 && low < td.Data.length - 1) {
                        amp += (double)((1.0f - w) * td.Data[low]);
                        amp += (double)(w * td.Data[low + 1]);
                        count += 1.0;
                        continue;
                    }
                    ++bug;
                }
                this.Amplitude[traceIndex][s] = (float)(amp / count);
                if (traceIndex != 5) continue;
                System.out.println(String.format("%d  %f  %f  %f", s, Float.valueOf(centerTrace.Data[s + this.m_zeroPadSamples]), Float.valueOf(this.Dip[traceIndex][s]), Float.valueOf(this.Amplitude[traceIndex][s])));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected float computeDipScan(int d) {
        try {
            float sum = 0.0f;
            for (int r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                int listIndex = r + this.m_traceRadius;
                CorrelationData cd = this.m_corrList.get(listIndex);
                if (!cd.Valid) continue;
                float shift = (float)d * (float)r / (float)this.m_traceRadius;
                float sample = shift + (float)this.m_maxShift_Samples;
                int s1 = (int)sample;
                float w = sample - (float)s1;
                if (s1 >= 0) {
                    sum += (1.0f - w) * cd.Correlation[s1];
                }
                if (s1 + 1 >= cd.Correlation.length) continue;
                sum += w * cd.Correlation[s1 + 1];
            }
            return sum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    protected void computeCrossCorr(TraceData centerTrace, int sample, CorrelationData cd) {
        try {
            for (int shift = -this.m_maxShift_Samples; shift <= this.m_maxShift_Samples; ++shift) {
                for (int r = this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                }
                double sumN = 0.0;
                double sumNN = 0.0;
                double sumH = 0.0;
                double sumHH = 0.0;
                for (int w = -this.m_correlationWindow_Half; w <= this.m_correlationWindow_Half; ++w) {
                    int centerIndex = this.m_zeroPadSamples + sample + w;
                    int n = centerIndex + shift;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeCrossCorr(TraceData centerTrace, TraceData td, int sample, CorrelationData cd) {
        try {
            double sumN = 0.0;
            double sumNN = 0.0;
            double sumH = 0.0;
            double d = 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean prep() {
        try {
            Object cd;
            int r;
            this.m_valid = false;
            if (this.m_inputEnsemble.traceCount() < 3) {
                return false;
            }
            EnsembleTrace trace = this.m_inputEnsemble.trace(0);
            FloatArrayWrapper w = trace.data();
            this.m_numTraces = this.m_inputEnsemble.traceCount();
            this.m_samplesPerTrace = w.length();
            this.m_sampleInterval = w.getSampleInterval();
            this.m_time0 = w.getFirstSampleCoord_WithShifts();
            this.m_maxShift_Samples = (int)(0.5f + this.m_maxShift / this.m_sampleInterval);
            this.m_maxShift_Samples *= this.m_traceRadius;
            this.m_maxShift_Samples = Math.max(this.m_maxShift_Samples, 2);
            this.m_maxShift_Samples = Math.min(this.m_maxShift_Samples, 1000);
            this.m_dipScan = new float[1 + 2 * this.m_maxShift_Samples];
            this.m_correlationWindow_Samples = (int)(0.5f + this.m_correlationWindow / this.m_sampleInterval);
            this.m_correlationWindow_Samples = Math.max(this.m_correlationWindow_Samples, 12);
            this.m_correlationWindow_Samples = Math.min(this.m_correlationWindow_Samples, 200);
            this.m_correlationWindow_Half = this.m_correlationWindow_Samples / 2;
            this.m_correlationWindow_Samples = 1 + 2 * this.m_correlationWindow_Half;
            this.m_zeroPadSamples = 50 + 2 * this.m_correlationWindow_Samples + this.m_maxShift_Samples;
            this.m_dataLength = this.m_samplesPerTrace + 2 * this.m_zeroPadSamples;
            this.Amplitude = new float[this.m_numTraces][this.m_samplesPerTrace];
            this.Dip = new float[this.m_numTraces][this.m_samplesPerTrace];
            this.m_traceList.clear();
            for (r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                cd = new TraceData();
                ((TraceData)cd).Data = new float[this.m_dataLength];
                ((TraceData)cd).Hilbert = new float[this.m_dataLength];
                this.m_traceList.add((TraceData)cd);
            }
            this.m_corrList.clear();
            for (r = -this.m_traceRadius; r <= this.m_traceRadius; ++r) {
                cd = new CorrelationData();
                ((CorrelationData)cd).Correlation = new float[2 * this.m_maxShift_Samples + 1];
                this.m_corrList.add((CorrelationData)cd);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected class TraceData {
        public float[] Data;
        public float[] Hilbert;
        public boolean Valid;

        protected TraceData() {
        }
    }

    protected class CorrelationData {
        public float[] Correlation;
        public boolean Valid;

        protected CorrelationData() {
        }
    }
}

