/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Seismic.Echos;

import com.PecosLibrary.Seismic.Echos.EchosHeader;
import java.util.ArrayList;
import java.util.List;

public class EchosHeaders {
    public static final String xbias = "xbias";
    public static final String ybias = "ybias";
    public static final String wdepth = "wdepth";
    public static final String chan = "chan";
    public static final String shot = "shot";
    public static final String ffid = "ffid";
    public static final String shtstn = "shtstn";
    public static final String shtline = "shtline";
    public static final String shotx = "shotx";
    public static final String shoty = "shoty";
    public static final String selev = "selev";
    public static final String shtdpth = "shtdpth";
    public static final String uphole = "uphole";
    public static final String recstn = "recstn";
    public static final String recline = "recline";
    public static final String recx = "recx";
    public static final String recy = "recy";
    public static final String relev = "relev";
    public static final String inline = "inline";
    public static final String xline = "xline";
    public static final String cdp = "cdp";
    public static final String cdpx = "cdpx";
    public static final String cdpy = "cdpy";
    public static final String offset = "offset";
    static List<EchosHeader> _headers = new ArrayList<EchosHeader>();

    static void addHeader(String sName, String sType, String sModules, String sDescription) {
        EchosHeader header = new EchosHeader(sName, sType, sModules, sDescription);
        _headers.add(header);
    }

    public static String getHeaderDescription(String sHeader) {
        List<EchosHeader> headers = EchosHeaders.getEchosHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            EchosHeader eh = headers.get(i);
            if (!eh.Name.equals(sHeader)) continue;
            return eh.Description;
        }
        return "";
    }

    public static List<String> requiredResidualStaticsHeaders() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(inline);
        headerList.add(xline);
        headerList.add(cdpx);
        headerList.add(cdpy);
        headerList.add(shot);
        headerList.add(shtstn);
        headerList.add(shtline);
        headerList.add(shotx);
        headerList.add(shoty);
        headerList.add(recstn);
        headerList.add(recline);
        headerList.add(recx);
        headerList.add(recy);
        return headerList;
    }

    public static List<EchosHeader> getEchosHeaders() {
        if (_headers.isEmpty()) {
            EchosHeaders.addHeader("angmax", "Integer", "ANGTR", "Maximum angle in range used in muting");
            EchosHeaders.addHeader("angmin", "Integer", "ANGTR", "Minimum angle of range used in muting");
            EchosHeaders.addHeader("angtr", "Integer", "ANGTR", "Sequence number of ANGLE list card");
            EchosHeaders.addHeader("ant_x", "Floating point", "LANDXY NAVXY UKP2", "X coordinate of antenna");
            EchosHeaders.addHeader("ant_y", "Floating point", "LANDXY NAVXY UKP2", "Y coordinate of antenna");
            EchosHeaders.addHeader("avocang", "Integer", "ANGSTK", "Central angle of stacked angle trace");
            EchosHeaders.addHeader("avomid", "Floating point", "ANGATTR ANGSTK", " \tSine squared of center angle");
            EchosHeaders.addHeader("avotype", "Integer", "ANGATTR ANGSTK ", "\tType of AVO output trace");
            EchosHeaders.addHeader("azimuth", "Floating point", "GEOMLD INTRP5D UNIFORM ", "\tAzimuth, in degrees, of shot-receiver direction");
            EchosHeaders.addHeader("bin_x", "Floating point", "GEOMLD ", "\tX coordinate of bin location (3D only) ");
            EchosHeaders.addHeader("binx", "Double precision", "GEOMLD ", "\tX coordinate of bin location (3D only) ");
            EchosHeaders.addHeader("bin_y", "Floating point", "GEOMLD ", "\tY coordinate of bin location (3D only) ");
            EchosHeaders.addHeader("biny", "Double precision", "GEOMLD ", "\tY coordinate of bin location (3D only) ");
            EchosHeaders.addHeader("cable", "Integer", "GEOMLD ", "\tCable ID for multi-streamer case (Navigation only) ");
            EchosHeaders.addHeader("ccp", "Integer", "CCPBIN", " \tCommon conversion point bin number");
            EchosHeaders.addHeader("ccp_stat", "Integer", "CCPBIN ", "\tStation number at CCP location ");
            EchosHeaders.addHeader("ccp_x", "Floating point", "CCPBIN \t", "X coordinate of CCP location ");
            EchosHeaders.addHeader("ccp_y", "Floating point", "CCPBIN \t", "Y coordinate of CCP location ");
            EchosHeaders.addHeader("ccplbl", "Integer", "CCPBIN ", "\t3D geometry CCP label (combination of ccplbls and ccplblx) ");
            EchosHeaders.addHeader("ccplbls", "Integer", "CCPBIN ", "\t3D geometry CCP subline (inline) label ");
            EchosHeaders.addHeader("ccplblx", "Integer", "CCPBIN ", "\t3D geometry CCP crossline label ");
            EchosHeaders.addHeader(cdp, "Integer", "EXTRACT GEOMLD ", "\tCommon depth point number ");
            EchosHeaders.addHeader("cdp_shft", "Floating point", "QUIXTAT ", "\tSum of all CDP statics applied to the trace ");
            EchosHeaders.addHeader("cdp_stat", "Integer", "GEOMLD ", "\tStation number nearest to the CDP location ");
            EchosHeaders.addHeader("cdp_x", "Floating point", "DM3DSTK EXTRACT GEOMLD GIN GOUT HXINT MBSTK RTM STACKNG UNIFORM XINT ", "\tX coordinate of CDP location ");
            EchosHeaders.addHeader(cdpx, "Double precision", "DM3DSTK EXTRACT GEOMLD GIN GOUT HXINT MBSTK RTM STACKNG UNIFORM XINT ", "\tX coordinate of CDP location ");
            EchosHeaders.addHeader("cdp_y", "Floating point", "DM3DSTK EXTRACT GEOMLD GIN GOUT HXINT MBSTK RTM STACKNG UNIFORM XINT ", "\tY coordinate of CDP location ");
            EchosHeaders.addHeader(cdpy, "Double precision", "DM3DSTK EXTRACT GEOMLD GIN GOUT HXINT MBSTK RTM STACKNG UNIFORM XINT ", "\tY coordinate of CDP location ");
            EchosHeaders.addHeader("cdpdev", "Integer", "GEOMLD ", "\tDistance between midpoint and bin center ");
            EchosHeaders.addHeader(chan, "Integer", "MKDATA FMTIN GENRATE GIN LANDXY NAVDSK SEGD UKP2 \t", "Channel number assigned to trace, dependent on user-supplied CHANNEL ");
            EchosHeaders.addHeader("chanfir", "Integer", "LANDXY NAVDSK NAVXY UKP2 \t", "First channel number in shot ensemble (navigation trace only) ");
            EchosHeaders.addHeader("chanlas", "Integer", "LANDXY NAVDSK NAVXY UKP2 ", "\tLast channel number in shot ensemble (navigation trace only) ");
            EchosHeaders.addHeader("chanxy", "Floating point", "FMTIN LANDXY NAVDSK NAVTR UKP2 ", "\tx,y coordinate of channel (navigation trace only) ");
            EchosHeaders.addHeader("chset", "Integer", "SEGD ", "\tChannel set from which trace originated ");
            EchosHeaders.addHeader("cplscl", "Floating point", "CPLANL \tCCP", "scaling factors from APPLY option ");
            EchosHeaders.addHeader("csp", "Integer", "TRASEL", " \tCommon sequence point number ");
            EchosHeaders.addHeader("csp_x", "Floating point", "TRASEL \tX ", "coordinate value for CSP ");
            EchosHeaders.addHeader("csp_y", "Floating point", "TRASEL \tY ", "coordinate value for CSP ");
            EchosHeaders.addHeader("cstat_x", "Floating point", "GEOMLD ", "\tX coordinate of CDP station location ");
            EchosHeaders.addHeader("cstat_y", "Floating point", "GEOMLD ", "\tY coordinate of CDP station location ");
            EchosHeaders.addHeader("dataset", "Integer", "\tGIN", "Number of dataset to extract from archived tape ");
            EchosHeaders.addHeader("date", "Integer", "LANDXY NAVXY UKP2 ", "\tJulian date of shot (seismic acquisition system) ");
            EchosHeaders.addHeader("day", "Integer", "SEGD ", "\tJulian day on which recorded ");
            EchosHeaders.addHeader("descal", "Floating point", "SEG2 ", "\tDescaling factor ");
            EchosHeaders.addHeader("dipno", "Integer", "VSTACK ", "\tSequence number of the applied DIPVAL ");
            EchosHeaders.addHeader("dipval", "Floating point", "VSTACK ", "\tApplied dip value ");
            EchosHeaders.addHeader("edfl", "Integer", "AUTEDT ", "\tEdit flag identifying the traces to be edited ");
            EchosHeaders.addHeader("elev", "Floating point", "GEOMLD ", "\tSurface elevation at station location ");
            EchosHeaders.addHeader("ensno", "Integer", "DSIN ", "\tEnsemble number ");
            EchosHeaders.addHeader("envtrace", "Floating point", "TRATTR \t", "Cosine of the phase");
            EchosHeaders.addHeader("envtype", "Integer", "COPY TRATTR ", "\t1 = original trace input 2 = envelope of input 3 = cosine of instantaneous phase ");
            EchosHeaders.addHeader("eprec", "Floating point", "EPSTX ", "\tReceiver static correction ");
            EchosHeaders.addHeader("epsht", "Floating point", "EPSTX ", "\tShot static correction ");
            EchosHeaders.addHeader("etim", "Integer", "SEGD ", "\tEnd time from channel set header (milliseconds) ");
            EchosHeaders.addHeader("extbin", "Integer", "EBAPPLY ", "\t0 for original trace 1 for borrowed trace ");
            EchosHeaders.addHeader("fchan", "Integer", "SEGD \t", "Input channel number assigned to trace ");
            EchosHeaders.addHeader(ffid, "Integer", "SEG2 SEGD ", "\tField File IDentification number on tape ");
            EchosHeaders.addHeader("firlbls", "Integer", "WRITETS ", "\tFirst inline label in file (timeslice traces only) ");
            EchosHeaders.addHeader("firlblx", "Integer", "WRITETS", " \tFirst crossline label in file (timeslice traces only) ");
            EchosHeaders.addHeader("fold", "Integer", "RADSTK STACK ", "\tCDP fold of stacked trace ");
            EchosHeaders.addHeader("ftime", "Floating point", "SEGD ", "\tTiming word corresponding to first scan of record (floating point) ");
            EchosHeaders.addHeader("gates", "Integer", "PREPARE ", "\tCDP number, event time (ms), gate start time (ms), and gate end time (ms) (four 4-byte words per gate) ");
            EchosHeaders.addHeader("gun", "Integer", "GEOMLD ", "\tGun flag or gun ID for multi-gun shooting (Navigation only) ");
            EchosHeaders.addHeader("hour", "Integer", "FMTIN GEOMLD LANDXY NAVDSK NAVXY SEGD UKP2 ", "\tHour within day of shot (seismic acquisition system) ");
            EchosHeaders.addHeader(inline, "Integer", "GEOMLD ", "\t3D inline number");
            EchosHeaders.addHeader("iray", "Integer", "RADFOR RADMUS RADNLIN ", "Integer representation of ray parameter ");
            EchosHeaders.addHeader("isum", "Integer", "SMACTRM ", "\tFlag to indicate multiple removal ");
            EchosHeaders.addHeader("itflg", "Integer", "REGLO ", "\tInterpolation trace flag ");
            EchosHeaders.addHeader("ixcor", "Integer", "CORLAT ", "\tAll correlations that have a value of one ");
            EchosHeaders.addHeader("ixtr1", "Integer", "CORLAT ", "\tSequence number of original correlation, trace one");
            EchosHeaders.addHeader("ixtr2", "Integer", "CORLAT ", "\tSequence number of original correlation, trace two ");
            EchosHeaders.addHeader("ixtyp", "Integer", "HXINT ", "\tFlag for fold less than PNLSIZ+1 ");
            EchosHeaders.addHeader("jrs", "Integer", "DM3DSTK ", "\tNumber of samples in each scaling gate");
            EchosHeaders.addHeader("julday", "Integer", "FMTIN GEOMLD LANDXY NAVDSK NAVTR NAVXY SEGD UKP2", " \tJulian day of shot (seismic acquisition system) ");
            EchosHeaders.addHeader("kops", "Floating point", "KOPS ", "\tPeak shift value computed ");
            EchosHeaders.addHeader("lasttr", "Integer", "DSIN MKDATA FMTIN GENRATE GIN LANDXY NAVDSK NAVXY SEG2 SEGD SPKCHK UKP2 ", "\tLast trace of an ensemble: 1 = last trace 0 = not last trace ");
            EchosHeaders.addHeader("lat", "Floating point", "FMTIN LANDXY NAVDSK NAVXY UKP2 ", "\tLatitude of shot ");
            EchosHeaders.addHeader("lnsca", "Integer", "DM3DSTK ", "\tNumber of scaling gates ");
            EchosHeaders.addHeader("lon", "Floating point", "FMTIN LANDXY NAVDSK NAVXY UKP2 ", "\tLongitude of shot ");
            EchosHeaders.addHeader("maxval", "Floating point", "DSOUT ", "\tMaximum amplitude value in dataset ");
            EchosHeaders.addHeader("median", "Floating point", "BALANCE ", "\tMedian value of scalars ");
            EchosHeaders.addHeader("midpt", "Integer", "GEOMLD ", "\tStation number closest to the midpoint ");
            EchosHeaders.addHeader("mid_x", "Floating point", "GEOMLD ", "\tX coordinate of source-receiver midpoint ");
            EchosHeaders.addHeader("mid_y", "Floating point", "GEOMLD", " \tY coordinate of source-receiver midpoint ");
            EchosHeaders.addHeader("minute", "Integer", "FMTIN GEOMLD LANDXY NAVDSK NAVXY SEGD UKP2 \t", "Minute within the hour of shot (seismic acquisition system) ");
            EchosHeaders.addHeader("minval", "Floating point", "DSOUT ", "\tMinimum amplitude value in dataset ");
            EchosHeaders.addHeader("multno", "Integer", "SMACTRM ", "\tMultiple order number of output");
            EchosHeaders.addHeader("navshot", "Integer", "FMTIN LANDXY NAVDSK NAVTR NAVXY UKP2 ", "\tShot point number (navigation acquisition system) ");
            EchosHeaders.addHeader("ncomp", "Integer", "LANDXY NAVXY UKP2 ", "\tNumber of compasses (navigation trace only) ");
            EchosHeaders.addHeader("nday", "Integer", "FMTIN LANDXY NAVDSK NAVXY UKP2 ", "\tDay of shot; same as ALTDAY (navigation trace only) ");
            EchosHeaders.addHeader("ndip", "Integer", "VSTACK ", "\tTotal number of dips specified ");
            EchosHeaders.addHeader("nhr", "Integer", "FMTIN LANDXY NAVDSK NAVXY UKP2 ", "\tHour shot occurred; same as ALTHOUR (navigation trace only) ");
            EchosHeaders.addHeader("nline", "Integer", "NAVLINE ", "\tSail line sequence number ");
            EchosHeaders.addHeader("nlineid", "Integer", "FMTIN GEOMLD GIN LANDXY NAVDSK NAVLINE NAVTR NAVXY UKP2 ", "\tLine ID of shot");
            EchosHeaders.addHeader("nlive", "Integer", "STACK ", "\tNumber of live traces summed into the stacked trace ");
            EchosHeaders.addHeader("nlivo", "Integer", "DM3DSTK ", "\tNumber of original stack traces ");
            EchosHeaders.addHeader("nmin", "Integer", "FMTIN LANDXY NAVDSK NAVXY UKP2 \t", "Minute the shot occurred; same as ALTMIN (navigation trace only) ");
            EchosHeaders.addHeader("nsca", "Integer", "DM3DSTK ", "\tScaling values at each scaling gate, number of words varies ");
            EchosHeaders.addHeader("nsec", "Integer", "FMTIN LANDXY NAVDSK NAVXY UKP2 ", "\tSecond the shot occurred; same as ALTSEC (navigation trace only) ");
            EchosHeaders.addHeader("ntrx", "Integer", "RADNLIN ", "\tMaximum number of traces on input ");
            EchosHeaders.addHeader("numchan", "Integer", "FMTIN LANDXY NAVDSK NAVTR NAVXY UKP2 \t", "Number of channels per shot (navigation trace only) ");
            EchosHeaders.addHeader("numfile", "Integer", "LANDXY NAVXY UKP2 ", "\tFile number (navigation trace only - unreliable) ");
            EchosHeaders.addHeader("numreel", "Integer", "LANDXY NAVXY UKP2 ", "\tReel number (navigation trace only - unreliable) ");
            EchosHeaders.addHeader("obliq", "Integer", "TRASEL \t", "Line segment number for CSP ");
            EchosHeaders.addHeader(offset, "Integer", "DNMO GENRATE GEOMLD GIN ", "\tDistance between the shot and receiver ");
            EchosHeaders.addHeader("offsx", "Integer", "RADFOR RADMUS ", "\tUsed for proper inverse transform (no user input) ");
            EchosHeaders.addHeader("offtime", "Integer", "IEDIT MUTE STACK \t", "Contains the sample number of the last full amplitude sample ");
            EchosHeaders.addHeader("onset", "Integer", "MBSTK ", "\tSample number of the first non-zero sample ");
            EchosHeaders.addHeader("ontime", "Integer", "IEDIT MUTE STACK ", "\tContains the sample number of the first full amplitude sample ");
            EchosHeaders.addHeader("otflg", "Integer", "REGLO SMACTRM ", "\tOriginal trace flag ");
            EchosHeaders.addHeader("oth_shft", "Floating point", "QUIXTAT ", "\tTotal static shift from other than shot, receiver, or CDP component ");
            EchosHeaders.addHeader("pamp", "Floating point", "SURFAMP ", "\tPrimary analysis key scalar value ");
            EchosHeaders.addHeader("pilot", "Integer", "STATPIK STPK3D ", "\tPilot trace value (starting from 1) ");
            EchosHeaders.addHeader("prjcode", "Integer", "LANDXY NAVXY UKP2 ", "\tNavigation system projection code (navigation trace only) ");
            EchosHeaders.addHeader("proname", "Integer", "LANDXY NAVXY UKP2 ", "\tProduct of pamp and samp ");
            EchosHeaders.addHeader("psamp", "Floating point", "SURFAMP ", "\tProduct of PAMP and SAMP ");
            EchosHeaders.addHeader("pvalue", "Integer", "RADNPAR ", "\tParabola moveout time at reference offset ");
            EchosHeaders.addHeader("pwofset", "Integer", "CCPBIN ", "\tDistance between the source and CCP ");
            EchosHeaders.addHeader("rayp", "Floating point", "RADNPAR RADFOR RADMUS RADNLIN ", "\tDesignation for ray parameter (floating point) ");
            EchosHeaders.addHeader("rdepth", "Floating point", "GEOMLD ", "\tReceiver depth per channel (Navigation only) ");
            EchosHeaders.addHeader("reclblx", "Integer", "GEOMLD ", "\tReceiver position inline label ");
            EchosHeaders.addHeader("reclblx", "Integer", "GEOMLD ", "\tReceiver position xline label ");
            EchosHeaders.addHeader(recline, "Integer", "GEOMLD ", "\tReceiver line ");
            EchosHeaders.addHeader("rec_shft", "Floating point", "QUIXTAT \t", "Sum of all receiver statics applied to the trace");
            EchosHeaders.addHeader("rec_stat", "Integer", "COMPRES GEOMLD ", "\tStation number closest to the receiver (same as recvr) ");
            EchosHeaders.addHeader(recstn, "Integer", "GEOMLD ", "\tStation number within receiver line ");
            EchosHeaders.addHeader("rectim", "Integer", "SEGD ", "\tRecording time of shot, in seconds ");
            EchosHeaders.addHeader("recvr", "Integer", "GEOMLD ", "\tStation number closest to the receiver (same as rec_stat) ");
            EchosHeaders.addHeader("rec_x", "Floating point", "GEOMLD ", "\tX coordinate of receiver location ");
            EchosHeaders.addHeader(recx, "Double precision", "GEOMLD ", "\tX coordinate of receiver location ");
            EchosHeaders.addHeader("rec_y", "Floating point", "GEOMLD ", "\tY coordinate of receiver location ");
            EchosHeaders.addHeader(recy, "Double precision", "GEOMLD ", "\tY coordinate of receiver location ");
            EchosHeaders.addHeader(relev, "Floating point", "GEOMLD", " \tSurface elevation at station location ");
            EchosHeaders.addHeader("repeat", "Integer", "REPEAT ", "\tValue is the copy number ");
            EchosHeaders.addHeader("rline", "Integer", "GEOMLD ", "\tClosest receiver line to receiver position (SHTGRID) ");
            EchosHeaders.addHeader("rlinstn", "Integer", "GEOMLD ", "\tClosest receiver station to receiver position (SHTGRID) ");
            EchosHeaders.addHeader("rotang", "Floating point", "LANDXY NAVXY UKP2 ", "\tNot implemented ");
            EchosHeaders.addHeader("rstat_x", "Floating point", "GEOMLD ", "\tX coordinate of receiver station location ");
            EchosHeaders.addHeader("rstat_y", "Floating point", "GEOMLD ", "\tY coordinate of receiver station location ");
            EchosHeaders.addHeader("rvmo", "Floating point", "RVMO \t", "Amount of NMO correction at offset ");
            EchosHeaders.addHeader("samp", "Floating point", "SURFAMP ", "\tSecondary analysis key scalar value ");
            EchosHeaders.addHeader("savetr", "Floating point", "COPY ", "\tSaves a copy of current trace ");
            EchosHeaders.addHeader("scalarc", "Floating point", "EBAPPLY ENSEQU ", "\tOffset equalization scaling factor ");
            EchosHeaders.addHeader("scntno", "Integer", "SEGD ", "\tScan type number from which trace originated ");
            EchosHeaders.addHeader("second", "Integer", "FMTIN GEOMLD LANDXY NAVDSK NAVXY SEGD UKP2 \t", "Second within the minute of shot (seismic acquisition system) ");
            EchosHeaders.addHeader(selev, "Floating point", "GEOMLD ", "\tSurface elevation at shot location ");
            EchosHeaders.addHeader("seqno", "Integer", "DSIN MKDATA FMTIN GENRATE GIN HXINT LANDXY NAVDSK NAVXY SEG2 SEGD UKP2 ", "\tTrace sequence number within a shot ");
            EchosHeaders.addHeader(shot, "Integer", "CVA MKDATA FMTIN GEOMLD LANDXY NAVDSK NAVXY SEG2 SEGD UKP2", " \tShot sequence number ");
            EchosHeaders.addHeader(shtline, "Integer", "GEOMLD ", "\tShot line ");
            EchosHeaders.addHeader(shtstn, "Integer", "GEOMLD ", "\tStation number within shot line ");
            EchosHeaders.addHeader("sht_shft", "Floating point", "QUIXTAT ", "\tSum of all shot statics applied to the trace ");
            EchosHeaders.addHeader("sht-stat", "Integer", "GEOMLD ", "\tNumber of station location nearest shot ");
            EchosHeaders.addHeader("sht_x", "Floating point", "FMTIN GEOMLD LANDXY NAVDSK NAVXY UKP2 \t", "X coordinate of shot location ");
            EchosHeaders.addHeader(shotx, "Double precision", "FMTIN GEOMLD LANDXY NAVDSK NAVXY UKP2 \t", "X coordinate of shot location ");
            EchosHeaders.addHeader("sht_y", "Floating point", "FMTIN GEOMLD LANDXY NAVDSK NAVXY UKP2 \t", "Y coordinate of shot location ");
            EchosHeaders.addHeader(shoty, "Double precision", "FMTIN GEOMLD LANDXY NAVDSK NAVXY UKP2 ", "\tY coordinate of shot location ");
            EchosHeaders.addHeader(shtdpth, "Floating point", "GEOMLD ", "\tDepth of shot (feet or meters) ");
            EchosHeaders.addHeader("shtlbls", "Integer", "GEOMLD ", "\tSource position inline label");
            EchosHeaders.addHeader("shtlblx", "Integer", "GEOMLD ", "\tSource position xline label");
            EchosHeaders.addHeader("signal", "Integer", "SIGNAL ", "\tIndicates if input trace or signal trace: 1 = signal trace 0 = input trace ");
            EchosHeaders.addHeader("skew", "Floating point", "SEGD ", "\tMultiplexer skew in floating point");
            EchosHeaders.addHeader("sline", "Integer", "GEOMLD ", " Closest shot line to source position (SHTGRID) ");
            EchosHeaders.addHeader("slinesp", "Integer", "GEOMLD \t", "Source position crossline ");
            EchosHeaders.addHeader("soffset", "Integer", "COMPRES CVA GEOMLD ", "\tSigned distance between the shot and receiver ");
            EchosHeaders.addHeader("speq", "Floating point", "SPEQ \t", "Scalars from DESCALE option ");
            EchosHeaders.addHeader("sphin", "Integer", "LANDXY NAVXY UKP2 \t", "Input spheroid projection ");
            EchosHeaders.addHeader("sphout", "Integer", "LANDXY NAVXY UKP2 ", "\tOutput spheroid projection ");
            EchosHeaders.addHeader("sptrzero", "Integer", "FMTIN GEOMLD LANDXY NAVDSK NAVTR NAVXY UKP2 ", "\tShot sequence number = SHOT ");
            EchosHeaders.addHeader("sstat_x", "Floating point", "GEOMLD ", "\tX coordinate of shot station location ");
            EchosHeaders.addHeader("sstat_y", "Floating point", "GEOMLD ", "\tY coordinate of shot station location ");
            EchosHeaders.addHeader("stack", "Integer", "SEG2 ", "\tNumber of stacks (from input file) ");
            EchosHeaders.addHeader("statics", "Integer", "SYNSHOT \t", "Random static time shift ");
            EchosHeaders.addHeader("stim", "Integer", "SEGD ", "\tStart time from channel set header (milliseconds) ");
            EchosHeaders.addHeader("sweof", "Integer", "FMTIN LANDXY NAVXY UKP2 ", "\tSoftware EOF if = \u20131 ");
            EchosHeaders.addHeader("swofset", "Integer", "CCPBIN ", "\tDistance between the receiver and CCP ");
            EchosHeaders.addHeader("time", "Integer", "FMTIN LANDXY NAVDSK NAVTR NAVXY UKP2 ", "\tTime of shot in seconds (seismic acquisition system) JULDAY, HOUR, MINUTE, SECOND converted to integer seconds ");
            EchosHeaders.addHeader("tot_shft", "Floating point", "QUIXTAT STATIC ", "\tSum of all statics applied to the trace ");
            EchosHeaders.addHeader("type", "Integer", "COLTBL MKDATA FMTIN GENRATE GEOM2D GEOM3D GEOMLD GIN LANDXY NAVDSK NAVXY PATN3D PATTERN REFSOL SEG2 SEGD UKP2 ", "\tType of trace: 0 = data trace 1 = aux trace ");
            EchosHeaders.addHeader("unifold", "Integer", "UNIFORM \t", "Number of live traces that were summed to produce the output trace ");
            EchosHeaders.addHeader(uphole, "Floating point", "GEOMLD \t", "Uphole time (milliseconds) ");
            EchosHeaders.addHeader("valid", "Integer", "FMTIN LANDXY NAVDSK NAVTR NAVXY UKP2 ", "\tNot implemented ");
            EchosHeaders.addHeader("vel", "Integer", "CVA CVELDEF ETADEF RVMO VELDEF ", "\tVelocity applied to the trace ");
            EchosHeaders.addHeader("veli", "Integer", "DMOSG \t", "Value of CDP within velocity location");
            EchosHeaders.addHeader("veln", "Integer", "DMOSG \t", "Velocity location number ");
            EchosHeaders.addHeader("velseq", "Integer", "DMOSG \t", "Output CDP location sequence number ");
            EchosHeaders.addHeader("vertsum", "Integer", "VSTACK ", "\tNumber of traces contributing to the vertical stack ");
            EchosHeaders.addHeader("vessel", "Integer", "GEOMLD \t", "Vessel ID for multi-boat shooting (Navigation only) ");
            EchosHeaders.addHeader(wdepth, "Integer", "FMTIN GEOMLD NAVDSK WDEPTH ", "\tWater depth (Navigation only) ");
            EchosHeaders.addHeader(xbias, "Integer", "GEOMLD LANDXY ", "\tBias computed for line\u2019s original x coordinates ");
            EchosHeaders.addHeader("xkey", "Integer", "GIN ", "\tDuplicate record number ");
            EchosHeaders.addHeader(xline, "Integer", "GEOMLD \t", "3D crossline number ");
            EchosHeaders.addHeader(ybias, "Integer", "GEOMLD LANDXY", " \tBias computed for line\u2019s original y coordinates ");
            EchosHeaders.addHeader("year", "Integer", "SEGD ", "\tYear in which recorded ");
            EchosHeaders.addHeader("zone", "Integer", "LANDXY NAVXY UKP2 \t", "Not implemented");
        }
        return _headers;
    }
}

