/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.VNS;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class TomoProfile_VNS
implements Java2D_PaintableInterface {
    public float Size;
    public float Diagonal;
    public float SqrtTwo = (float)Math.sqrt(2.0);
    public float MaxHack = 3.4028235E37f;
    public double MaxDepth;
    public double MinSurfaceElevation;
    public double MaxSurfaceElevation;
    public double OriginZ;
    public double[] WorldX;
    public double[] WorldY;
    public double Offset = 0.0;
    public int NumZ;
    public int TotalNumX;
    public int MaxValidX;
    public float[][] Slowness_VNS;
    public float[][] Weight_VNS;
    public float[][] Count_VNS;
    public float[] Z_VNS;
    public boolean IsRegularGridValid = false;
    public float[][] Time;
    public float[][] Slowness;
    public float[] Elevation;
    public float[] WaterBottomZ;
    public float[][] Weight;
    public float[][] Count;
    public boolean ForceMarineSurvey = false;
    public float[] NodeDepth;
    public float ShotWorldZ;
    public int[] PathIndexX;
    public int[] PathIndexZ;
    public int NumPathPoints = 0;
    public int[] PathIndexX_VNS;
    public int[] PathIndexZ_VNS;
    public int[] LowerIndexX;
    public int[] LowerIndexY;
    public int[] UpperIndexX;
    public int[] UpperIndexY;
    public float[] LowerWeightX;
    public float[] LowerWeightY;
    public float[] UpperWeightX;
    public float[] UpperWeightY;
    public boolean[] LowerIndexValidX;
    public boolean[] LowerIndexValidY;
    public boolean[] UpperIndexValidX;
    public boolean[] UpperIndexValidY;
    public static final int AccuratePath_MaxCount = 2000;
    public float[] AccuratePath_FloatX = new float[2000];
    public int[] AccuratePath_IndexX = new int[2000];
    public float[] AccuratePath_FloatZ = new float[2000];
    public int[] AccuratePath_IndexZ = new int[2000];
    public float[] AccuratePath_Time = new float[2000];
    public float[] AccuratePath_Slowness = new float[2000];
    public int[] AccuratePath_Type = new int[2000];
    public static final int AccuratePath_TypeReceiver = 1000;
    public static final int AccuratePath_TypeShot = 1001;
    public static final int AccuratePath_TypeHorizontal = 1002;
    public static final int AccuratePath_TypeVertical = 1003;
    public int AccuratePath_Count = 0;
    public double AccuratePath_TempBestTime;
    public float ReceiverTime = 0.0f;
    protected boolean[] m_minimum;
    public static final int DrawVelocity = 1000;
    public static final int DrawTime = 1001;
    public static final int DrawWeight = 1002;
    public static final int DrawCount = 1003;

    public TomoProfile_VNS(double size, double minSurfaceElevation, double maxSurfaceElevation, float[] nodeDepth) {
        try {
            this.MinSurfaceElevation = minSurfaceElevation;
            this.MaxSurfaceElevation = maxSurfaceElevation;
            this.Size = (float)size;
            this.Diagonal = this.Size * this.SqrtTwo;
            this.TotalNumX = 200;
            this.NodeDepth = new float[nodeDepth.length];
            for (int n = 0; n < nodeDepth.length; ++n) {
                this.NodeDepth[n] = nodeDepth[n];
            }
            this.MaxDepth = this.NodeDepth[this.NodeDepth.length - 1];
            this.OriginZ = this.MinSurfaceElevation - this.MaxDepth;
            this.NumZ = 1 + (int)((this.MaxSurfaceElevation - this.OriginZ) / (double)this.Size);
            this.allocateMemory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_SetReceiver(float elev, float pickTime) {
        try {
            if (this.Offset > 1000.0) {
                this.ReceiverTime = 1.0f;
            }
            for (int n = 0; n < 2000; ++n) {
                this.AccuratePath_Time[n] = Float.MAX_VALUE;
            }
            this.AccuratePath_Count = 0;
            this.AccuratePath_FloatX[0] = (float)(this.Offset / (double)this.Size);
            this.AccuratePath_IndexX[0] = (int)this.AccuratePath_FloatX[0];
            this.AccuratePath_FloatZ[0] = (float)(((double)elev - this.OriginZ) / (double)this.Size);
            this.AccuratePath_IndexZ[0] = (int)this.AccuratePath_FloatZ[0];
            this.AccuratePath_Type[0] = 1000;
            this.AccuratePath_Time[0] = Float.MAX_VALUE;
            int indexX1 = Math.max(this.AccuratePath_IndexX[0] - 3, 0);
            int indexZ1 = Math.max(this.AccuratePath_IndexZ[0] - 3, 0);
            int indexZ2 = Math.min(this.AccuratePath_IndexZ[0] + 3, this.NumZ - 1);
            this.AccuratePath_Slowness[0] = this.Slowness[this.AccuratePath_IndexX[0]][this.AccuratePath_IndexZ[0]];
            boolean crap = false;
            for (int x = indexX1; x <= this.AccuratePath_IndexX[0]; ++x) {
                for (int z = indexZ1; z <= indexZ2; ++z) {
                    float avg = 0.5f * (this.AccuratePath_Slowness[0] + this.Slowness[x][z]);
                    double dx = this.AccuratePath_FloatX[0] - (float)x;
                    double dz = this.AccuratePath_FloatZ[0] - (float)z;
                    float dist = this.Size * (float)Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    float time = this.Time[x][z] + dist * avg;
                    if (!(time < this.AccuratePath_Time[0])) continue;
                    this.AccuratePath_Time[0] = time;
                }
            }
            this.AccuratePath_TempBestTime = Double.MAX_VALUE;
            this.accuratePath_CheckVertical(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0]);
            this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0] + 1);
            this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[0], this.AccuratePath_IndexZ[0]);
            ++this.AccuratePath_Count;
            while (this.AccuratePath_IndexX[this.AccuratePath_Count] > 0 && this.AccuratePath_Count < 1999) {
                this.AccuratePath_TempBestTime = Double.MAX_VALUE;
                if (this.AccuratePath_Type[this.AccuratePath_Count] == 1002) {
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] - 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] + 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count], this.AccuratePath_IndexZ[this.AccuratePath_Count] - 1);
                }
                if (this.AccuratePath_Type[this.AccuratePath_Count] == 1003) {
                    this.accuratePath_CheckVertical(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count] + 1);
                    this.accuratePath_CheckHorizontal(this.AccuratePath_IndexX[this.AccuratePath_Count] - 1, this.AccuratePath_IndexZ[this.AccuratePath_Count]);
                }
                ++this.AccuratePath_Count;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_CheckVertical(int ix, int iz) {
        try {
            if (iz < 0 || iz >= this.NumZ - 1 || ix < 0) {
                return;
            }
            double s1 = this.Slowness[ix][iz];
            double s2 = this.Slowness[ix][iz + 1];
            double t1 = this.Time[ix][iz];
            double t2 = this.Time[ix][iz + 1];
            double delta = 0.1;
            double oldFracX = this.AccuratePath_FloatX[this.AccuratePath_Count];
            double oldFracZ = this.AccuratePath_FloatZ[this.AccuratePath_Count];
            double oldSlow = this.AccuratePath_Slowness[this.AccuratePath_Count];
            int nextIndex = this.AccuratePath_Count + 1;
            for (double frac = delta / 2.0; frac < 1.0; frac += delta) {
                double time = frac * t2 + (1.0 - frac) * t1;
                double slow = frac * s2 + (1.0 - frac) * s1;
                double avg = 0.5 * (slow + oldSlow);
                double fracX = ix;
                double dx = fracX - oldFracX;
                double fracZ = (double)iz + frac;
                double dz = fracZ - oldFracZ;
                double dist = (double)this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                double totalTime = time + avg * dist;
                if (!(totalTime < this.AccuratePath_TempBestTime)) continue;
                this.AccuratePath_TempBestTime = totalTime;
                this.AccuratePath_Slowness[nextIndex] = (float)(frac * s2 + (1.0 - frac) * s1);
                this.AccuratePath_Time[nextIndex] = (float)time;
                this.AccuratePath_Type[nextIndex] = 1003;
                this.AccuratePath_FloatX[nextIndex] = ix;
                this.AccuratePath_IndexX[nextIndex] = ix;
                this.AccuratePath_FloatZ[nextIndex] = (float)fracZ;
                this.AccuratePath_IndexZ[nextIndex] = iz;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void accuratePath_CheckHorizontal(int ix, int iz) {
        try {
            if (iz < 0 || iz >= this.NumZ || ix < 0) {
                return;
            }
            double s1 = this.Slowness[ix][iz];
            double s2 = this.Slowness[ix + 1][iz];
            double t1 = this.Time[ix][iz];
            double t2 = this.Time[ix + 1][iz];
            double delta = 0.1;
            double oldFracX = this.AccuratePath_FloatX[this.AccuratePath_Count];
            double oldFracZ = this.AccuratePath_FloatZ[this.AccuratePath_Count];
            double oldSlow = this.AccuratePath_Slowness[this.AccuratePath_Count];
            int nextIndex = this.AccuratePath_Count + 1;
            for (double frac = delta / 2.0; frac < 1.0; frac += delta) {
                double time = frac * t2 + (1.0 - frac) * t1;
                double slow = frac * s2 + (1.0 - frac) * s1;
                double avg = 0.5 * (slow + oldSlow);
                double fracX = (double)ix + frac;
                double dx = fracX - oldFracX;
                double fracZ = iz;
                double dz = fracZ - oldFracZ;
                double dist = (double)this.Size * Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                double totalTime = time + avg * dist;
                if (!(totalTime < this.AccuratePath_TempBestTime)) continue;
                this.AccuratePath_TempBestTime = totalTime;
                this.AccuratePath_Slowness[nextIndex] = (float)slow;
                this.AccuratePath_Time[nextIndex] = (float)time;
                this.AccuratePath_Type[nextIndex] = 1002;
                this.AccuratePath_FloatX[nextIndex] = (float)fracX;
                this.AccuratePath_IndexX[nextIndex] = ix;
                this.AccuratePath_FloatZ[nextIndex] = iz;
                this.AccuratePath_IndexZ[nextIndex] = iz;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setReceiver(float elev, float pickTime) throws Exception {
        try {
            float floatIndexX = (float)(this.Offset / (double)this.Size);
            int indexX = (int)floatIndexX;
            float floatIndexZ = (float)(((double)elev - this.OriginZ) / (double)this.Size);
            int indexZ = (int)floatIndexZ;
            int minIndexX = 0;
            int minIndexZ = 0;
            this.ReceiverTime = Float.MAX_VALUE;
            int indexX1 = Math.max(indexX - 3, 0);
            int indexZ1 = Math.max(indexZ - 3, 0);
            int indexZ2 = Math.min(indexZ + 3, this.NumZ - 1);
            if (indexX < 0 || indexX >= this.Slowness.length) {
                throw new Exception("indexX < 0 || indexX >= Slowness.length");
            }
            indexZ = Math.max(indexZ, 0);
            indexZ = Math.min(indexZ, this.Slowness[0].length - 1);
            float recSlow = this.Slowness[indexX][indexZ];
            boolean crap = false;
            for (int x = indexX1; x <= indexX; ++x) {
                for (int z = indexZ1; z <= indexZ2; ++z) {
                    float avg = 0.5f * (recSlow + this.Slowness[x][z]);
                    double dx = floatIndexX - (float)x;
                    double dz = floatIndexZ - (float)z;
                    float dist = this.Size * (float)Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    float time = this.Time[x][z] + dist * avg;
                    if (!(time < this.ReceiverTime)) continue;
                    this.ReceiverTime = time;
                    minIndexX = x;
                    minIndexZ = z;
                }
            }
            if (this.ReceiverTime < 0.0f) {
                crap = true;
            }
            if (this.PathIndexX == null) {
                this.PathIndexX = new int[this.TotalNumX * 8];
                this.PathIndexZ = new int[this.TotalNumX * 8];
                this.PathIndexZ_VNS = new int[this.TotalNumX * 8];
            }
            if (this.PathIndexX.length < this.TotalNumX * 8) {
                this.PathIndexX = new int[this.TotalNumX * 8];
                this.PathIndexZ = new int[this.TotalNumX * 8];
                this.PathIndexZ_VNS = new int[this.TotalNumX * 8];
            }
            this.NumPathPoints = 0;
            this.PathIndexX[this.NumPathPoints] = minIndexX;
            this.PathIndexZ[this.NumPathPoints] = minIndexZ;
            this.PathIndexZ_VNS[this.NumPathPoints] = this.getNearestDepthIndex(minIndexX, minIndexZ);
            double diffX = this.Size * (float)this.PathIndexX[this.NumPathPoints];
            double diffZ = (double)this.ShotWorldZ - (this.OriginZ + (double)(this.Size * (float)this.PathIndexZ[this.NumPathPoints]));
            double distFromShot = Math.sqrt(1.0E-20 + diffX * diffX + diffZ * diffZ);
            ++this.NumPathPoints;
            while (distFromShot > 1.5 * (double)this.Size) {
                int currX = this.PathIndexX[this.NumPathPoints - 1];
                int currZ = this.PathIndexZ[this.NumPathPoints - 1];
                float currSlowness = this.Slowness[currX][currZ];
                int x1 = currX - 1;
                int x2 = x1 = Math.max(x1, 0);
                float minTime = Float.MAX_VALUE;
                minIndexX = 0;
                minIndexZ = 0;
                int minz = Math.max(currZ - 4, 0);
                int maxz = Math.min(currZ + 4, this.NumZ - 1);
                for (int x = x1; x <= x2; ++x) {
                    double dx = this.Size * (float)(x - currX);
                    for (int z = minz; z <= maxz; ++z) {
                        double dz;
                        double dist;
                        float avg;
                        float tt;
                        boolean same;
                        boolean bl = same = z == currZ && x == currX;
                        if (same || !((tt = this.Time[x][z] + (avg = 0.5f * (currSlowness + this.Slowness[x][z])) * (float)(dist = Math.sqrt(dx * dx + (dz = (double)(this.Size * (float)(z - currZ))) * dz))) < minTime)) continue;
                        minTime = tt;
                        minIndexX = x;
                        minIndexZ = z;
                    }
                }
                if (this.NumPathPoints > 3 * this.TotalNumX) {
                    crap = true;
                    this.NumPathPoints = 0;
                    return;
                }
                this.PathIndexX[this.NumPathPoints] = minIndexX;
                this.PathIndexZ[this.NumPathPoints] = minIndexZ;
                this.PathIndexZ_VNS[this.NumPathPoints] = this.getNearestDepthIndex(minIndexX, minIndexZ);
                diffX = this.Size * (float)this.PathIndexX[this.NumPathPoints];
                diffZ = (double)this.ShotWorldZ - (this.OriginZ + (double)(this.Size * (float)this.PathIndexZ[this.NumPathPoints]));
                distFromShot = Math.sqrt(1.0E-20 + diffX * diffX + diffZ * diffZ);
                ++this.NumPathPoints;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected int getNearestDepthIndex(int indexX, int indexGridZ) {
        try {
            int closest = 0;
            double z = this.OriginZ + (double)(this.Size * (float)indexGridZ);
            double mzd = 1.0E9;
            for (int nd = 0; nd < this.NodeDepth.length; ++nd) {
                double tz = this.Elevation[indexX] - this.NodeDepth[nd];
                double diff = Math.abs(tz - z);
                if (!(diff < mzd)) continue;
                mzd = diff;
                closest = nd;
            }
            return closest;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void computeRegularGrid() throws Exception {
        try {
            int numNodes = this.NodeDepth.length;
            for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                for (int m = 0; m < numNodes; ++m) {
                    this.Z_VNS[m] = this.Elevation[ix] - this.NodeDepth[m];
                }
                float top = this.Z_VNS[0];
                float bottom = this.Z_VNS[numNodes - 1];
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    double z = this.OriginZ + (double)(this.Size * (float)iz);
                    if (z <= (double)bottom) {
                        this.Slowness[ix][iz] = this.Slowness_VNS[ix][numNodes - 1];
                    }
                    if (z >= (double)top) {
                        float ratio = 1.0f + 0.05f * (float)((z - (double)top) / (double)this.Size);
                        this.Slowness[ix][iz] = ratio * this.Slowness_VNS[ix][0];
                    }
                    if (!(z > (double)bottom) || !(z < (double)top)) continue;
                    boolean found = false;
                    for (int m = 0; m < numNodes - 1 && !found; ++m) {
                        if (!(z <= (double)this.Z_VNS[m]) || !(z >= (double)this.Z_VNS[m + 1])) continue;
                        float topratio = (float)((z - (double)this.Z_VNS[m + 1]) / (double)(this.Z_VNS[m] - this.Z_VNS[m + 1]));
                        this.Slowness[ix][iz] = topratio * this.Slowness_VNS[ix][m] + (1.0f - topratio) * this.Slowness_VNS[ix][m + 1];
                        found = true;
                    }
                    if (found) continue;
                    throw new Exception("found == false");
                }
            }
            this.IsRegularGridValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void fireShot(float z) throws Exception {
        try {
            if (!this.IsRegularGridValid) {
                this.computeRegularGrid();
            }
            this.ShotWorldZ = z;
            this.NumPathPoints = 0;
            for (int ix = 0; ix <= this.MaxValidX; ++ix) {
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    this.Time[ix][iz] = Float.MAX_VALUE;
                }
            }
            int maxCol = 3;
            this.firstFewColumns(z, maxCol);
            for (int n = maxCol + 1; n <= this.MaxValidX; ++n) {
                this.updateColumn(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateColumn(int index) throws Exception {
        try {
            int n;
            float[] priorTime = this.Time[index - 1];
            for (n = 0; n < this.NumZ; ++n) {
                this.m_minimum[n] = false;
            }
            for (n = 0; n < this.NumZ - 1; ++n) {
                if (!(Math.abs(priorTime[n + 1] - priorTime[n]) < 1.0E-4f)) continue;
                priorTime[n + 1] = priorTime[n] - 1.0E-4f;
            }
            for (n = 1; n < this.NumZ - 1; ++n) {
                if (!(priorTime[n] <= priorTime[n + 1]) || !(priorTime[n] <= priorTime[n - 1])) continue;
                this.m_minimum[n] = true;
                this.updateVert(index, n);
            }
            if (priorTime[0] <= priorTime[1]) {
                this.m_minimum[0] = true;
                this.updateVert(index, 0);
            }
            if (priorTime[this.NumZ - 1] <= priorTime[this.NumZ - 2]) {
                this.m_minimum[this.NumZ - 1] = true;
                this.updateVert(index, this.NumZ - 1);
            }
            for (int iter = 1; iter <= 2; ++iter) {
                int z;
                for (z = 1; z < this.NumZ; ++z) {
                    if (this.m_minimum[z]) continue;
                    this.updateCorner(index, z, -1);
                }
                for (z = this.NumZ - 2; z >= 0; --z) {
                    if (this.m_minimum[z]) continue;
                    this.updateCorner(index, z, 1);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateVert(int x, int z) throws Exception {
        try {
            float tt;
            if (z == 0) {
                float tt2;
                float s0 = this.Slowness[x][z];
                float s1 = this.Slowness[x - 1][z + 1];
                float s2 = this.Slowness[x - 1][z];
                float avg = 0.333333f * (s0 + s1 + s2);
                float t1 = this.Time[x - 1][z + 1];
                float t2 = this.Time[x - 1][z];
                float dt = Math.abs(t1 - t2);
                if (dt < 0.99f * (tt2 = avg * this.Size)) {
                    float temp = t2 + (float)Math.sqrt(tt2 * tt2 - dt * dt);
                    this.Time[x][z] = Math.min(temp, this.Time[x][z]);
                    return;
                }
                float temp = t2 + avg * this.Size;
                this.Time[x][z] = Math.min(temp, this.Time[x][z]);
                return;
            }
            if (z == this.NumZ - 1) {
                float tt3;
                float s0 = this.Slowness[x][z];
                float s1 = this.Slowness[x - 1][z - 1];
                float s2 = this.Slowness[x - 1][z];
                float avg = 0.333333f * (s0 + s1 + s2);
                float t1 = this.Time[x - 1][z - 1];
                float t2 = this.Time[x - 1][z];
                float dt = Math.abs(t1 - t2);
                if (dt < 0.99f * (tt3 = avg * this.Size)) {
                    float temp = t2 + (float)Math.sqrt(tt3 * tt3 - dt * dt);
                    this.Time[x][z] = Math.min(temp, this.Time[x][z]);
                    return;
                }
                float temp = t2 + avg * this.Size;
                this.Time[x][z] = Math.min(temp, this.Time[x][z]);
                return;
            }
            float t1 = this.Time[x - 1][z + 1];
            float t2 = this.Time[x - 1][z];
            float t3 = this.Time[x - 1][z - 1];
            if (t1 > this.MaxHack || t2 > this.MaxHack || t3 > this.MaxHack) {
                return;
            }
            float s0 = this.Slowness[x][z];
            float s1 = this.Slowness[x - 1][z + 1];
            float s2 = this.Slowness[x - 1][z];
            float s3 = this.Slowness[x - 1][z - 1];
            float avg = 0.25f * (s1 + s2 + s3 + s0);
            float dt = Math.abs(t1 - t3);
            if (dt < 0.99f * (tt = this.Size * avg)) {
                float temp = t2 + (float)Math.sqrt(tt * tt - dt * dt);
                this.Time[x][z] = Math.min(temp, this.Time[x][z]);
                return;
            }
            float temp = t2 + avg * this.Size;
            this.Time[x][z] = Math.min(temp, this.Time[x][z]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void updateCorner(int x, int z, int dz) throws Exception {
        try {
            float tt;
            float t1 = this.Time[x - 1][z + dz];
            float t2 = this.Time[x - 1][z];
            float t3 = this.Time[x][z + dz];
            if (t1 > this.MaxHack || t2 > this.MaxHack || t3 > this.MaxHack) {
                return;
            }
            float s1 = this.Slowness[x - 1][z + dz];
            float s2 = this.Slowness[x - 1][z];
            float s3 = this.Slowness[x][z + dz];
            float s4 = this.Slowness[x][z];
            float avg = 0.25f * (s1 + s2 + s3 + s4);
            float diff = Math.abs(t2 - t3);
            if (diff < 0.99f * (tt = this.Diagonal * avg)) {
                float time = t1 + (float)Math.sqrt(tt * tt - diff * diff);
                this.Time[x][z] = Math.min(time, this.Time[x][z]);
                return;
            }
            float tv = t3 + avg * this.Size;
            float th = t2 + avg * this.Size;
            float td = t1 + avg * this.Diagonal;
            float temp = Math.min(td, Math.min(tv, th));
            this.Time[x][z] = Math.min(temp, this.Time[x][z]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void firstFewColumns(float z, int maxIndex) throws Exception {
        try {
            int n;
            float shotGridZ = (z -= (float)this.OriginZ) / this.Size;
            shotGridZ = Math.max(shotGridZ, 0.0f);
            int shotIndex = (int)shotGridZ;
            shotIndex = Math.max(shotIndex, 0);
            shotIndex = Math.min(shotIndex, this.NumZ - 1);
            float frac = shotGridZ - (float)shotIndex;
            float shotSlowness = this.Slowness[0][shotIndex];
            if (shotIndex <= this.NumZ - 2) {
                shotSlowness = frac * this.Slowness[0][shotIndex + 1] + (1.0f - frac) * this.Slowness[0][shotIndex];
            }
            double dist = z - this.Size * (float)shotIndex;
            double avergeSlowness = 0.5 * (double)(shotSlowness + this.Slowness[0][shotIndex]);
            this.Time[0][shotIndex] = (float)(avergeSlowness * dist);
            for (n = shotIndex - 1; n >= 0; --n) {
                avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n + 1]);
                this.Time[0][n] = this.Time[0][n + 1] + (float)(avergeSlowness * (double)this.Size);
            }
            if (shotIndex + 1 <= this.NumZ - 1) {
                dist = this.Size * (float)(shotIndex + 1) - z;
                avergeSlowness = 0.5 * (double)(shotSlowness + this.Slowness[0][shotIndex + 1]);
                this.Time[0][shotIndex + 1] = (float)(avergeSlowness * dist);
                for (n = shotIndex + 2; n < this.NumZ; ++n) {
                    avergeSlowness = 0.5 * (double)(this.Slowness[0][n] + this.Slowness[0][n - 1]);
                    this.Time[0][n] = this.Time[0][n - 1] + (float)(avergeSlowness * (double)this.Size);
                }
            }
            for (int col = 1; col <= maxIndex; ++col) {
                int n2;
                double dx = (float)col * this.Size;
                for (n2 = 0; n2 < this.NumZ; ++n2) {
                    avergeSlowness = 0.5 * (double)(shotSlowness + this.Slowness[col][n2]);
                    double dz = z - this.Size * (float)n2;
                    dist = Math.sqrt(dz * dz + dx * dx);
                    this.Time[col][n2] = (float)(avergeSlowness * dist);
                }
                for (n2 = shotIndex - 1; n2 >= 0; --n2) {
                    this.updateCorner(col, n2, 1);
                }
                for (n2 = shotIndex + 1; n2 < this.NumZ; ++n2) {
                    this.updateCorner(col, n2, -1);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void allocateMemory() {
        try {
            this.WorldX = new double[this.TotalNumX];
            this.WorldY = new double[this.TotalNumX];
            this.Slowness_VNS = new float[this.TotalNumX][this.NumZ];
            this.Weight_VNS = new float[this.TotalNumX][this.NumZ];
            this.Count_VNS = new float[this.TotalNumX][this.NumZ];
            this.Z_VNS = new float[this.NumZ];
            this.Time = new float[this.TotalNumX][this.NumZ];
            this.Slowness = new float[this.TotalNumX][this.NumZ];
            this.Weight = new float[this.TotalNumX][this.NumZ];
            this.Count = new float[this.TotalNumX][this.NumZ];
            this.Elevation = new float[this.TotalNumX];
            this.WaterBottomZ = new float[this.TotalNumX];
            this.m_minimum = new boolean[this.NumZ];
            this.LowerIndexValidX = new boolean[this.TotalNumX];
            this.LowerIndexValidY = new boolean[this.TotalNumX];
            this.UpperIndexValidX = new boolean[this.TotalNumX];
            this.UpperIndexValidY = new boolean[this.TotalNumX];
            this.LowerWeightX = new float[this.TotalNumX];
            this.LowerWeightY = new float[this.TotalNumX];
            this.UpperWeightX = new float[this.TotalNumX];
            this.UpperWeightY = new float[this.TotalNumX];
            this.LowerIndexX = new int[this.TotalNumX];
            this.LowerIndexY = new int[this.TotalNumX];
            this.UpperIndexX = new int[this.TotalNumX];
            this.UpperIndexY = new int[this.TotalNumX];
            this.PathIndexX = new int[2 * this.TotalNumX];
            this.PathIndexZ = new int[2 * this.TotalNumX];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setOffset(double offset) {
        try {
            this.NumPathPoints = 0;
            this.MaxValidX = 0;
            double dx = offset;
            double dy = 0.0;
            this.Offset = offset;
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / (double)this.Size);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = 1.0;
            double sin = 0.0;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = cos * (double)this.Size * (double)n;
                this.WorldY[n] = sin * (double)this.Size * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEndpoints(double x1, double y1, double x2, double y2) {
        try {
            this.NumPathPoints = 0;
            this.MaxValidX = 0;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.Offset = Math.sqrt(1.0E-5 + dx * dx + dy * dy);
            if (this.Offset < 5.0) {
                return;
            }
            boolean test = false;
            if (this.Offset > 2000.0) {
                test = true;
            }
            int num = 2 + (int)(this.Offset / (double)this.Size);
            this.MaxValidX = num + 1;
            if (this.MaxValidX >= this.TotalNumX) {
                this.TotalNumX = this.MaxValidX + 50;
                this.allocateMemory();
            }
            double cos = dx / this.Offset;
            double sin = dy / this.Offset;
            for (int n = 0; n <= this.MaxValidX; ++n) {
                this.WorldX[n] = x1 + cos * (double)this.Size * (double)n;
                this.WorldY[n] = y1 + sin * (double)this.Size * (double)n;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int z2;
            int z1;
            int x2;
            int ix;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixX = 1 + (int)(scaleX * (double)this.Size);
            int pixY = 1 + Math.abs((int)(scaleY * (double)this.Size));
            Color c = Color.BLACK;
            for (ix = 0; ix <= this.MaxValidX; ++ix) {
                double x = (double)(this.Size * (float)ix) - 0.5 * (double)this.Size;
                int x1 = (int)(x * scaleX + shiftX);
                for (int iz = 0; iz < this.NumZ; ++iz) {
                    boolean valid;
                    double z = this.OriginZ + (double)(this.Size * (float)iz) + 0.5 * (double)this.Size;
                    int z12 = (int)(z * scaleY + shiftY);
                    c = Color.WHITE;
                    boolean bl = valid = (double)this.Count[ix][iz] > 0.5;
                    if (supplementalData == 1000 && this.Slowness[ix][iz] > 0.001f) {
                        valid = true;
                        double v = 1000.0 / (double)this.Slowness[ix][iz];
                        c = colorWrapper.colorUsingValue(v);
                    }
                    if (supplementalData == 1001) {
                        c = colorWrapper.colorUsingValue(this.Time[ix][iz]);
                    }
                    if (supplementalData == 1002) {
                        c = colorWrapper.colorUsingValue(this.Weight[ix][iz]);
                    }
                    if (supplementalData == 1003) {
                        c = colorWrapper.colorUsingValue(this.Count[ix][iz]);
                    }
                    if (!valid) continue;
                    g2d.setColor(c);
                    g2d.fillRect(x1, z12, pixX, pixY);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (ix = 1; ix <= this.MaxValidX; ++ix) {
                int x1 = (int)(scaleX * (double)((float)(ix - 1) * this.Size) + shiftX);
                x2 = (int)(scaleX * (double)((float)ix * this.Size) + shiftX);
                z1 = (int)(scaleY * (double)this.Elevation[ix - 1] + shiftY);
                z2 = (int)(scaleY * (double)this.Elevation[ix] + shiftY);
                g2d.drawLine(x1, z1, x2, z2);
            }
            if (this.ForceMarineSurvey) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                for (ix = 1; ix <= this.MaxValidX; ++ix) {
                    int x1 = (int)(scaleX * (double)((float)(ix - 1) * this.Size) + shiftX);
                    x2 = (int)(scaleX * (double)((float)ix * this.Size) + shiftX);
                    z1 = (int)(scaleY * (double)this.WaterBottomZ[ix - 1] + shiftY);
                    z2 = (int)(scaleY * (double)this.WaterBottomZ[ix] + shiftY);
                    g2d.drawLine(x1, z1, x2, z2);
                }
            }
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange(-this.Size);
            rangeX.expandRange(this.Size + this.Size * (float)this.MaxValidX);
            rangeY.expandRange(this.OriginZ - (double)this.Size);
            rangeY.expandRange(this.OriginZ + (double)((float)this.NumZ * this.Size));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            for (int x = 0; x <= this.MaxValidX; ++x) {
                for (int z = 0; z < this.NumZ; ++z) {
                    if (supplementalData == 1001) {
                        rangeC.expandRange(this.Time[x][z]);
                    }
                    if (supplementalData == 1002) {
                        rangeC.expandRange(this.Weight[x][z]);
                    }
                    if (supplementalData == 1003) {
                        rangeC.expandRange(this.Count[x][z]);
                    }
                    if (supplementalData != 1000 || !(this.Slowness[x][z] > 0.001f)) continue;
                    rangeC.expandRange(1000.0 / (double)this.Slowness[x][z]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

