/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TomoEikonal3D_XtGeoConnection {
    protected static void saveArray3D(RandomAccessFile raf, float[][][] array, ByteBuffer buff, int nx, int ny, int nz) {
        try {
            int off = 0;
            for (int z = 0; z < nz; ++z) {
                for (int y = 0; y < ny; ++y) {
                    for (int x = 0; x < nx; ++x) {
                        float val = x + y * nx + z * nx * ny;
                        buff.putFloat(off, val);
                        off += 4;
                    }
                }
            }
            raf.write(buff.array(), 0, off);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected static void saveArray3D(RandomAccessFile raf, double[][][] array, ByteBuffer buff, int nx, int ny, int nz) {
        try {
            int off = 0;
            for (int z = 0; z < nz; ++z) {
                for (int y = 0; y < ny; ++y) {
                    for (int x = 0; x < nx; ++x) {
                        float val = x + y * nx + z * nx * ny;
                        buff.putFloat(off, val);
                        off += 4;
                    }
                }
            }
            raf.write(buff.array(), 0, off);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected static void saveArray2D(RandomAccessFile raf, float[][] array, ByteBuffer buff, int nx, int ny) {
        try {
            int off = 0;
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    buff.putFloat(off, array[x][y]);
                    off += 4;
                }
            }
            raf.write(buff.array(), 0, off);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static void saveTomoEikonal3D(TomoEikonal3D model, String fileName) throws Exception {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int nx = model.numX();
            int ny = model.numY();
            int nz = model.numZ();
            long numNodes = (long)nx * (long)ny * (long)nz;
            if (numNodes > 500000000L) {
                throw new Exception("Limit 500,000,000 nodes");
            }
            ByteBuffer buff = ByteBuffer.allocate((int)(4L * numNodes));
            buff.order(ByteOrder.LITTLE_ENDIAN);
            int version = 1000;
            buff.putInt(0, 2003004);
            buff.putInt(4, version);
            raf.write(buff.array(), 0, 8);
            if (version == 1000) {
                buff.putInt(0, Grid3DDescriptorInt.gdi_Total.ordinal());
                buff.putInt(4, Grid3DDescriptorDouble.gdd_Total.ordinal());
                raf.write(buff.array(), 0, 8);
                int numVolumes = 4;
                int numMembranes = 3;
                buff.putInt(4 * Grid3DDescriptorInt.gdi_NodeCountX.ordinal(), nx);
                buff.putInt(4 * Grid3DDescriptorInt.gdi_NodeCountY.ordinal(), ny);
                buff.putInt(4 * Grid3DDescriptorInt.gdi_NodeCountZ.ordinal(), nz);
                buff.putInt(4 * Grid3DDescriptorInt.gdi_VolumeCount.ordinal(), numVolumes);
                buff.putInt(4 * Grid3DDescriptorInt.gdi_MembraneCount.ordinal(), numMembranes);
                raf.write(buff.array(), 0, 4 * Grid3DDescriptorInt.gdi_Total.ordinal());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_OriginX.ordinal(), model.originX());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_OriginY.ordinal(), model.originY());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_OriginZ.ordinal(), model.originZ());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_NodeSpacingX.ordinal(), model.binSizeHorz());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_NodeSpacingY.ordinal(), model.binSizeHorz());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_NodeSpacingZ.ordinal(), model.binSizeVert());
                buff.putDouble(8 * Grid3DDescriptorDouble.gdd_Angle.ordinal(), model.inlineAngle());
                raf.write(buff.array(), 0, 8 * Grid3DDescriptorDouble.gdd_Total.ordinal());
                TomoEikonal3D_XtGeoConnection.saveArray3D(raf, model.slowness(), buff, nx, ny, nz);
                TomoEikonal3D_XtGeoConnection.saveArray3D(raf, model.count(), buff, nx, ny, nz);
                TomoEikonal3D_XtGeoConnection.saveArray3D(raf, model.error(), buff, nx, ny, nz);
                TomoEikonal3D_XtGeoConnection.saveArray3D(raf, model.weight(), buff, nx, ny, nz);
                TomoEikonal3D_XtGeoConnection.saveArray2D(raf, model.surfaceElevation(), buff, nx, ny);
                TomoEikonal3D_XtGeoConnection.saveArray2D(raf, model.surfaceGridZ(), buff, nx, ny);
                TomoEikonal3D_XtGeoConnection.saveArray2D(raf, model.waterBottomElevation(), buff, nx, ny);
            }
            raf.close();
            buff = null;
            System.gc();
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    protected static enum Grid3DDescriptorInt {
        gdi_NodeCountX,
        gdi_NodeCountY,
        gdi_NodeCountZ,
        gdi_VolumeCount,
        gdi_MembraneCount,
        gdi_Total;

    }

    protected static enum Grid3DDescriptorDouble {
        gdd_OriginX,
        gdd_OriginY,
        gdd_OriginZ,
        gdd_NodeSpacingX,
        gdd_NodeSpacingY,
        gdd_NodeSpacingZ,
        gdd_Angle,
        gdd_Total;

    }
}

