/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile_Lightweight;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D_Interpolator_Lightweight;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class TomoEikonal3D_Lightweight {
    protected HashMap<String, float[][]> m_interpolatedGridHash = new HashMap();
    public HashMap_Integers<Element> SourceHash = new HashMap_Integers();
    public HashMap_Integers<Element> ReceiverHash = new HashMap_Integers();
    protected String m_srcFileName;
    protected String m_recFileName;
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_originZ = 0.0;
    protected double m_binSizeHorz = 25.0;
    protected double m_binSizeVert = 25.0;
    protected double m_inlineAngle = 0.0;
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected double m_cosineInlineAngle = 0.0;
    protected double m_sineInlineAngle = 0.0;
    protected double m_inverseBinSizeHorz = 1.0;
    protected double m_inverseBinSizeVert = 1.0;
    protected boolean m_anisotropyValid = false;
    protected int m_anisotropyChunkSize = 3;
    protected int m_anisotropyNumX;
    protected int m_anisotropyNumY;
    protected float[][][] m_anisFraction;
    protected float[][][] m_anisFastAzimuth;
    protected String m_anisotropyFileName;
    protected boolean m_forceMarineSurvey;
    protected double m_waterVelocity;
    protected float[][] m_waterBottomElevation;
    protected String m_name = "";
    protected String m_gridFileName;
    protected String m_surfaceFileName;
    protected String m_waterBottomFileName;
    public static final String ModelFileName = "Model.slowness";
    public static final String SurfaceFileName = "Model.surface";
    public static final String WaterBottomFileName = "WaterBottom.surface";
    public static final String ReceiverFileName = "Model.receivers";
    public static final String ShotFileName = "Model.shots";
    public static final String AnisotropyFileName = "Model.anisotropy";
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_error;
    protected float[][][] m_count;
    protected float[][] m_tempPlane1;
    protected float[][] m_tempPlane2;
    protected float[][] m_tempPlane3;
    protected float[][] m_surfaceElevation;
    protected float[][] m_surfaceGridZ;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_countCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected boolean[][][] m_inAirCoarse;
    protected float[][] m_tempCoarse1;
    protected float[][] m_tempCoarse2;
    protected int m_numCoarseX;
    protected int m_numCoarseY;
    protected String m_historyFileName;
    protected History m_history;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public double GridX;
    public double GridY;
    public double GridZ;
    public double FloatIndexX;
    public double FloatIndexY;
    public double FloatIndexZ;
    public int LowerIndexX;
    public int LowerIndexY;
    public int LowerIndexZ;
    public float LowerWeightX;
    public float LowerWeightY;
    public float LowerWeightZ;
    public float UpperWeightX;
    public float UpperWeightY;
    public float UpperWeightZ;
    public boolean LowerIndexValidX;
    public boolean LowerIndexValidY;
    public boolean LowerIndexValidZ;
    public boolean UpperIndexValidX;
    public boolean UpperIndexValidY;
    public boolean UpperIndexValidZ;
    public float InterpolatedGridZ;
    public float InterpolatedElevation;
    public float InterpolatedWaterBottom;
    public float[] InterpolatedSlowness = new float[20];
    public float[] InterpolatedWeight = new float[20];
    public float[] InterpolatedCount = new float[20];
    public float SlownessAtWorld;
    public boolean OnEdge = false;
    public int EdgeIndexX;
    public int EdgeIndexY;
    public int UpperIndexX;
    public int UpperIndexY;
    public int UpperIndexZ = 0;
    public static final int NumStraightLine = 20;
    public int[] StraightLineLowerIndexX = new int[20];
    public int[] StraightLineLowerIndexY = new int[20];
    public int[] StraightLineLowerIndexZ = new int[20];
    public int[] StraightLineUpperIndexX = new int[20];
    public int[] StraightLineUpperIndexY = new int[20];
    public int[] StraightLineUpperIndexZ = new int[20];
    public float[] StraightLineLowerWeightX = new float[20];
    public float[] StraightLineLowerWeightY = new float[20];
    public float[] StraightLineLowerWeightZ = new float[20];
    public float[] StraightLineUpperWeightX = new float[20];
    public float[] StraightLineUpperWeightY = new float[20];
    public float[] StraightLineUpperWeightZ = new float[20];
    public float[] StraightLineSlowness = new float[20];
    public float[] StraightLineTime = new float[20];
    public float StraightLineTotalTime;
    public boolean[] StraightLineLowerIndexValidX = new boolean[20];
    public boolean[] StraightLineLowerIndexValidY = new boolean[20];
    public boolean[] StraightLineLowerIndexValidZ = new boolean[20];
    public boolean[] StraightLineUpperIndexValidX = new boolean[20];
    public boolean[] StraightLineUpperIndexValidY = new boolean[20];
    public boolean[] StraightLineUpperIndexValidZ = new boolean[20];
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    public boolean PrintCoarseCorner = false;
    public boolean PrintBottomLayer = false;
    protected Range_Double m_range = new Range_Double();
    protected float m_averageCoarseWeight;
    protected float m_averageWeight;
    protected float m_averageCoarseCount;
    protected float m_averageCount;
    protected TomoEikonal3D_Interpolator_Lightweight m_interpolator;
    public final float MinValidWeight = 1.0E-4f;
    public float WeightTime = 1.0f;
    public float MinimumValidTotalWeight = 0.1f;
    protected double[] m_tempVertSlowness = new double[100];
    public double TimeToIntermediateDatum = 0.0;
    public double TimeToFinalDatum = 0.0;
    public double Statics;

    public void applyUpholeVelocityLayer(String elevName, String velName) {
        try {
            float[][] z = this.m_interpolatedGridHash.get(elevName);
            float[][] v = this.m_interpolatedGridHash.get(velName);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float[] slowness = this.m_slowness[ix][iy];
                    float slow = (float)(1000.0 / (double)v[ix][iy]);
                    int zmin = (int)(((double)z[ix][iy] - this.m_originZ) / this.m_binSizeVert);
                    for (int iz = zmin + 1; iz < this.m_numZ; ++iz) {
                        if (iz < 0 || iz >= slowness.length) continue;
                        slowness[iz] = slow;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createInterpolatedGrid(String name, Table_Abstract table, String colX, String colY, String colV) {
        try {
            int iy;
            int ix;
            this.m_interpolatedGridHash.remove(name);
            int indexX = table.column_indexOfColumn(colX);
            int indexY = table.column_indexOfColumn(colY);
            int indexV = table.column_indexOfColumn(colV);
            int numRows = table.row_count();
            double[] x = new double[numRows];
            double[] y = new double[numRows];
            double[] v = new double[numRows];
            for (int r = 0; r < numRows; ++r) {
                x[r] = table.getDouble(r, indexX);
                y[r] = table.getDouble(r, indexY);
                v[r] = table.getDouble(r, indexV);
            }
            float[][] array = new float[this.numX()][this.numY()];
            int gap = 5;
            for (ix = 0; ix < this.m_numX; ix += gap) {
                for (iy = 0; iy < this.m_numY; iy += gap) {
                    this.setGridLocation(ix, iy, 0);
                    double s1 = 0.0;
                    double s2 = 1.0E-30;
                    for (int r = 0; r < numRows; ++r) {
                        double dx = this.WorldX - x[r];
                        double dy = this.WorldY - y[r];
                        double dsq = dx * dx + dy * dy;
                        double w = 10000.0 / (100.0 + dsq);
                        s1 += v[r] * w;
                        s2 += w;
                    }
                    double val = s1 / s2;
                    array[ix][iy] = (float)val;
                }
            }
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    boolean done;
                    boolean onGapX = ix % gap == 0;
                    boolean onGapY = iy % gap == 0;
                    boolean bl = done = onGapX && onGapY;
                    if (done) continue;
                    int x1 = ix / gap;
                    int minX = (x1 *= gap) - 2 * gap;
                    int maxX = x1 + 3 * gap;
                    minX = Math.max(minX, 0);
                    maxX = Math.min(maxX, this.m_numX - 1);
                    int y1 = iy / gap;
                    int minY = (y1 *= gap) - 2 * gap;
                    int maxY = y1 + 3 * gap;
                    minY = Math.max(minY, 0);
                    maxY = Math.min(maxY, this.m_numY - 1);
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    for (x1 = minX; x1 <= maxX; x1 += gap) {
                        for (y1 = minY; y1 <= maxY; y1 += gap) {
                            double dx = x1 - ix;
                            double dy = y1 - iy;
                            double dsq = dx * dx + dy * dy;
                            double w = 1.0 / (1.0 + dsq);
                            s1 += w * (double)array[x1][y1];
                            s2 += w;
                        }
                    }
                    double val = s1 / s2;
                    array[ix][iy] = (float)val;
                }
            }
            this.m_interpolatedGridHash.put(name, array);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Element getShotElement(int id) {
        try {
            if (!this.SourceHash.containsKey(id)) {
                this.SourceHash.put(new Element(id), id);
            }
            return this.SourceHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Element getReceiverElement(int id) {
        try {
            if (!this.ReceiverHash.containsKey(id)) {
                this.ReceiverHash.put(new Element(id), id);
            }
            return this.ReceiverHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveReceiverHash() {
        try {
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveSourceHash() {
        try {
            this.saveElement(this.SourceHash, this.m_srcFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void restoreComputedResiduals() {
        try {
            for (Element e : this.SourceHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void convertResidualsToZeroMean() {
        try {
            double w;
            double s1 = 0.0;
            double s2 = 1.0E-20;
            for (Element e : this.SourceHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            double avg = s1 / s2;
            for (Element e : this.SourceHash.getValues()) {
                e.Residual -= avg;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual -= avg;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double originZ() {
        return this.m_originZ;
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public double binSizeHorz() {
        return this.m_binSizeHorz;
    }

    public double binSizeVert() {
        return this.m_binSizeVert;
    }

    public double inlineAngle() {
        return this.m_inlineAngle;
    }

    public int numX() {
        return this.m_numX;
    }

    public int numY() {
        return this.m_numY;
    }

    public int numZ() {
        return this.m_numZ;
    }

    public boolean anisotropyValid() {
        return this.m_anisotropyValid;
    }

    public boolean forceMarineSurvey() {
        return this.m_forceMarineSurvey;
    }

    public double waterVelocity() {
        return this.m_waterVelocity;
    }

    public float[][] waterBottomElevation() {
        return this.m_waterBottomElevation;
    }

    public String name() {
        return this.m_name;
    }

    public float[][][] slowness() {
        return this.m_slowness;
    }

    public float[][][] weight() {
        return this.m_weight;
    }

    public float[][][] error() {
        return this.m_error;
    }

    public float[][][] count() {
        return this.m_count;
    }

    public float[][] surfaceElevation() {
        return this.m_surfaceElevation;
    }

    public float[][] surfaceGridZ() {
        return this.m_surfaceGridZ;
    }

    public synchronized void fireStraightLine(double sx, double sy, double sz, double rx, double ry, double rz) throws Exception {
        try {
            int n;
            double dx = (rx - sx) / 19.0;
            double dy = (ry - sy) / 19.0;
            double dz = (rz - sz) / 19.0;
            double delta = Math.sqrt(1.0E-20 + dx * dx + dy * dy + dz * dz);
            for (n = 0; n < 20; ++n) {
                double x = sx + dx * (double)n;
                double y = sy + dy * (double)n;
                double z = sz + dz * (double)n;
                this.setWorldLocation(x, y, z, true, true);
                this.StraightLineLowerIndexX[n] = this.LowerIndexX;
                this.StraightLineLowerIndexY[n] = this.LowerIndexY;
                this.StraightLineLowerIndexZ[n] = this.LowerIndexZ;
                this.StraightLineUpperIndexX[n] = this.UpperIndexX;
                this.StraightLineUpperIndexY[n] = this.UpperIndexY;
                this.StraightLineUpperIndexZ[n] = this.UpperIndexZ;
                this.StraightLineLowerWeightX[n] = this.LowerWeightX;
                this.StraightLineLowerWeightY[n] = this.LowerWeightY;
                this.StraightLineLowerWeightZ[n] = this.LowerWeightZ;
                this.StraightLineUpperWeightX[n] = this.UpperWeightX;
                this.StraightLineUpperWeightY[n] = this.UpperWeightY;
                this.StraightLineUpperWeightZ[n] = this.UpperWeightZ;
                this.StraightLineLowerIndexValidX[n] = this.LowerIndexValidX;
                this.StraightLineLowerIndexValidY[n] = this.LowerIndexValidY;
                this.StraightLineLowerIndexValidZ[n] = this.LowerIndexValidZ;
                this.StraightLineUpperIndexValidX[n] = this.UpperIndexValidX;
                this.StraightLineUpperIndexValidY[n] = this.UpperIndexValidY;
                this.StraightLineUpperIndexValidZ[n] = this.UpperIndexValidZ;
                this.StraightLineSlowness[n] = this.SlownessAtWorld;
            }
            this.StraightLineTime[0] = 0.0f;
            for (n = 1; n < 20; ++n) {
                float avg = 0.5f * (this.StraightLineSlowness[n - 1] + this.StraightLineSlowness[n]);
                this.StraightLineTime[n] = this.StraightLineTime[n - 1] + avg * (float)delta;
            }
            this.StraightLineTotalTime = this.StraightLineTime[19];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D_Lightweight(String name, String path) throws Exception {
        try {
            this.read(name, path);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D_Lightweight(TomoEikonal3D_Lightweight parentModel) throws Exception {
        try {
            this.m_binSizeHorz = parentModel.binSizeHorz();
            this.m_binSizeVert = parentModel.binSizeVert();
            this.m_inlineAngle = parentModel.inlineAngle();
            this.computeInternals();
            this.m_originX = parentModel.originX();
            this.m_originY = parentModel.originY();
            this.m_originZ = parentModel.originZ();
            this.m_numX = parentModel.numX();
            this.m_numY = parentModel.numY();
            this.m_numZ = parentModel.numZ();
            this.m_forceMarineSurvey = parentModel.forceMarineSurvey();
            this.m_waterVelocity = parentModel.waterVelocity();
            this.checkMem();
            float[][] parentElevation = parentModel.surfaceElevation();
            float[][] parentGridZ = parentModel.surfaceGridZ();
            float[][] parentWaterBottom = parentModel.waterBottomElevation();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_surfaceElevation[x][y] = parentElevation[x][y];
                    this.m_surfaceGridZ[x][y] = parentGridZ[x][y];
                    this.m_waterBottomElevation[x][y] = parentWaterBottom[x][y];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D_Lightweight(double binSizeHorz, double binSizeVert, double inlineAngle, double originX, double originY, double originZ, int numX, int numY, int numZ) throws Exception {
        try {
            this.m_binSizeHorz = binSizeHorz;
            this.m_binSizeVert = binSizeVert;
            this.m_inlineAngle = inlineAngle;
            this.computeInternals();
            this.m_originX = originX;
            this.m_originY = originY;
            this.m_originZ = originZ;
            this.m_numX = numX;
            this.m_numY = numY;
            this.m_numZ = numZ;
            this.m_forceMarineSurvey = false;
            this.m_waterVelocity = 1500.0;
            this.checkMem();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_surfaceElevation[x][y] = (float)(this.m_originZ + this.m_binSizeVert * (double)this.m_numZ);
                    this.m_surfaceGridZ[x][y] = 0.0f;
                    this.m_waterBottomElevation[x][y] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void copySlownessFromParent(TomoEikonal3D_Lightweight parentModel) throws Exception {
        try {
            float[][][] slowness = parentModel.slowness();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = slowness[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void updateParentWeightAndError(TomoEikonal3D_Lightweight parentModel) throws Exception {
        try {
            float[][][] weight = parentModel.weight();
            float[][][] error = parentModel.error();
            float[][][] count = parentModel.count();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        weight[x][y][z] = weight[x][y][z] + this.m_weight[x][y][z];
                        error[x][y][z] = error[x][y][z] + this.m_error[x][y][z];
                        count[x][y][z] = count[x][y][z] + this.m_count[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public History getHistory() {
        return this.m_history;
    }

    public void prepWaterVelocity() throws Exception {
        try {
            if (!this.forceMarineSurvey()) {
                return;
            }
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float depth = this.m_waterBottomElevation[ix][iy];
                    float heightAboveOrigin = (float)((double)(-depth) - this.m_originZ);
                    int index = (int)((double)heightAboveOrigin / this.m_binSizeVert);
                    if (index < 1) {
                        index = 1;
                    }
                    for (int iz = index + 1; iz < this.m_numZ; ++iz) {
                        this.m_slowness[ix][iy][iz] = 1000.0f / (float)this.m_waterVelocity;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public TomoEikonal3DProfile_Lightweight createNewProfile() throws Exception {
        try {
            return new TomoEikonal3DProfile_Lightweight(this.m_binSizeVert, this.m_originZ, this.m_numZ);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized boolean populateProfile(TomoEikonal3DProfile_Lightweight profile, double x1, double y1, double x2, double y2) throws Exception {
        try {
            profile.setEndpoints(x1, y1, x2, y2);
            if (profile.MaxValidX < 1) {
                return false;
            }
            profile.ForceMarineSurvey = this.forceMarineSurvey();
            for (int n = 0; n <= profile.MaxValidX; ++n) {
                this.setWorldLocation(profile.WorldX[n], profile.WorldY[n], true, true);
                profile.WaterBottomZ[n] = -this.InterpolatedWaterBottom;
                profile.GridZ[n] = this.InterpolatedGridZ;
                profile.Elevation[n] = this.InterpolatedElevation;
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    profile.Slowness[n][iz] = this.InterpolatedSlowness[iz];
                    profile.Weight[n][iz] = this.InterpolatedWeight[iz];
                    profile.Count[n][iz] = this.InterpolatedCount[iz];
                }
                profile.LowerIndexValidX[n] = this.LowerIndexValidX;
                profile.LowerIndexValidY[n] = this.LowerIndexValidY;
                profile.UpperIndexValidX[n] = this.UpperIndexValidX;
                profile.UpperIndexValidY[n] = this.UpperIndexValidY;
                profile.LowerWeightX[n] = this.LowerWeightX;
                profile.LowerWeightY[n] = this.LowerWeightY;
                profile.UpperWeightX[n] = this.UpperWeightX;
                profile.UpperWeightY[n] = this.UpperWeightY;
                profile.LowerIndexX[n] = this.LowerIndexX;
                profile.LowerIndexY[n] = this.LowerIndexY;
                profile.UpperIndexX[n] = this.UpperIndexX;
                profile.UpperIndexY[n] = this.UpperIndexY;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepCoarse(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            float slow;
            float w;
            float wz;
            int z;
            float wy;
            int y;
            float wx;
            int x;
            float sumSlow;
            int maxy;
            int miny;
            int maxx;
            int minx;
            int cy;
            int cx;
            int cz;
            int cy2;
            int cx2;
            int cy3;
            int cx3;
            this.m_coarseRadius = Math.max(4, radiusX);
            this.m_numValidCoarseX = this.m_numX / this.m_coarseRadius;
            if (this.m_numX % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseX;
            }
            this.m_numValidCoarseY = this.m_numY / this.m_coarseRadius;
            if (this.m_numY % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseY;
            }
            int numFunky = 0;
            this.m_range.clearRange();
            float maxCount = 0.0f;
            for (cx3 = 0; cx3 < this.m_numValidCoarseX; ++cx3) {
                for (cy3 = 0; cy3 < this.m_numValidCoarseY; ++cy3) {
                    for (int cz2 = 0; cz2 < this.m_numZ; ++cz2) {
                        float sumCount = 1.0E-20f;
                        float sumSlowness = 0.0f;
                        int numNotInAir = 0;
                        if (cx3 == this.m_numValidCoarseX - 1 && cy3 == this.m_numValidCoarseY / 2) {
                            numNotInAir = 0;
                        }
                        this.m_slownessCoarse[cx3][cy3][cz2] = 0.0f;
                        this.m_countCoarse[cx3][cy3][cz2] = 1.0E-20f;
                        int minx2 = cx3 * this.m_coarseRadius;
                        int maxx2 = Math.min(minx2 + this.m_coarseRadius - 1, this.m_numX - 1);
                        int miny2 = cy3 * this.m_coarseRadius;
                        int maxy2 = Math.min(miny2 + this.m_coarseRadius - 1, this.m_numY - 1);
                        int minz = Math.max(cz2 - 0, 0);
                        int maxz = Math.min(cz2 + 0, this.m_numZ - 1);
                        for (int x2 = minx2; x2 <= maxx2; ++x2) {
                            for (int y2 = miny2; y2 <= maxy2; ++y2) {
                                for (int z2 = minz; z2 <= maxz; ++z2) {
                                    if (!((float)z2 <= this.m_surfaceGridZ[x2][y2])) continue;
                                    ++numNotInAir;
                                    float count = this.m_count[x2][y2][z2];
                                    count = count * 0.5f / (0.5f + (float)Math.abs(z2 - cz2));
                                    float slowness = this.m_slowness[x2][y2][z2];
                                    sumSlowness += slowness * count;
                                    sumCount += count;
                                }
                            }
                        }
                        this.m_inAirCoarse[cx3][cy3][cz2] = numNotInAir == 0;
                        this.m_slownessCoarse[cx3][cy3][cz2] = sumSlowness / sumCount;
                        this.m_countCoarse[cx3][cy3][cz2] = sumCount;
                        if ((double)sumCount > 0.5) {
                            this.m_range.expandRange(1000.0f / this.m_slownessCoarse[cx3][cy3][cz2]);
                        }
                        if (Float.isNaN(this.m_slownessCoarse[cx3][cy3][cz2]) || Float.isInfinite(this.m_slownessCoarse[cx3][cy3][cz2])) {
                            ++numFunky;
                        }
                        maxCount = Math.max(maxCount, sumCount);
                    }
                }
            }
            this.m_range.print("After initial coarse computation");
            this.m_range.clearRange();
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    initial           =====================");
                for (cx3 = 0; cx3 < 4; ++cx3) {
                    for (cy3 = 0; cy3 < 4; ++cy3) {
                        String s = String.format("%d  %d   %f   %f", cx3, cy3, Float.valueOf(1.0f / this.m_slownessCoarse[cx3][cy3][0]), Float.valueOf(this.m_countCoarse[cx3][cy3][0]));
                        System.out.println(s);
                    }
                }
            }
            float[] courseCount = this.m_countCoarse[this.m_numValidCoarseX / 2][this.m_numValidCoarseY / 2];
            float[] courseSlow = this.m_slownessCoarse[this.m_numValidCoarseX / 2][this.m_numValidCoarseY / 2];
            float minValidCount = 5.0f;
            int minValidZ = this.m_numZ;
            for (int cx4 = 0; cx4 < this.m_numValidCoarseX; ++cx4) {
                for (int cy4 = 0; cy4 < this.m_numValidCoarseY; ++cy4) {
                    for (int cz3 = 0; cz3 < this.m_numZ; ++cz3) {
                        if (!(this.m_countCoarse[cx4][cy4][cz3] > minValidCount)) continue;
                        minValidZ = Math.min(minValidZ, cz3);
                        cz3 = 100000;
                    }
                }
            }
            boolean keepGoing = true;
            int radH = 7;
            int radZ = 0;
            int maxRadH = Math.min(this.m_numValidCoarseX, this.m_numValidCoarseY);
            while (keepGoing) {
                keepGoing = false;
                for (cx2 = 0; cx2 < this.m_numValidCoarseX; ++cx2) {
                    for (cy2 = 0; cy2 < this.m_numValidCoarseY; ++cy2) {
                        for (int cz4 = minValidZ; cz4 < this.m_numZ; ++cz4) {
                            this.m_temp1Coarse[cx2][cy2][cz4] = this.m_slownessCoarse[cx2][cy2][cz4];
                            this.m_temp2Coarse[cx2][cy2][cz4] = this.m_countCoarse[cx2][cy2][cz4];
                        }
                    }
                }
                for (cz = minValidZ; cz < this.m_numZ; ++cz) {
                    for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                        for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                            if (this.m_inAirCoarse[cx][cy][cz] || !(this.m_countCoarse[cx][cy][cz] < minValidCount)) continue;
                            keepGoing = true;
                            minx = Math.max(cx - radH, 0);
                            maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
                            miny = Math.max(cy - radH, 0);
                            maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
                            int minz = Math.max(cz - radZ, minValidZ);
                            int maxz = Math.min(cz + radZ, this.m_numZ - 1);
                            float sumCount = 1.0E-20f;
                            sumSlow = 0.0f;
                            for (x = minx; x <= maxx; ++x) {
                                wx = 1.5f / (0.5f + (float)Math.abs(x - cx));
                                for (y = miny; y <= maxy; ++y) {
                                    wy = 1.5f / (0.5f + (float)Math.abs(y - cy));
                                    for (z = minz; z <= maxz; ++z) {
                                        wz = 1.5f / (0.5f + (float)Math.abs(z - cz));
                                        if (this.m_inAirCoarse[x][y][z] || !(this.m_temp2Coarse[x][y][z] > 0.5f * minValidCount)) continue;
                                        w = wx * wy * wz * this.m_temp2Coarse[x][y][z];
                                        slow = this.m_temp1Coarse[x][y][z];
                                        sumSlow += w * slow;
                                        sumCount += w;
                                    }
                                }
                            }
                            if (!(sumCount >= minValidCount)) continue;
                            this.m_slownessCoarse[cx][cy][cz] = sumSlow / sumCount;
                            this.m_countCoarse[cx][cy][cz] = 1.01f * minValidCount;
                            this.m_range.expandRange(1000.0f / this.m_slownessCoarse[cx][cy][cz]);
                            if (Math.abs(this.m_slownessCoarse[cx][cy][cz]) < 1.0E-5f) {
                                ++numFunky;
                            }
                            if (!Float.isNaN(this.m_slownessCoarse[cx][cy][cz]) && !Float.isInfinite(this.m_slownessCoarse[cx][cy][cz])) continue;
                            ++numFunky;
                        }
                    }
                }
                if ((radH += 6) >= maxRadH) {
                    radH = 10;
                    ++radZ;
                }
                System.out.println("end of keep going " + radH + "  " + radZ);
            }
            radH = 5;
            for (cz = minValidZ - 1; cz >= 0; --cz) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        if (this.m_inAirCoarse[cx][cy][cz]) continue;
                        minx = Math.max(cx - radH, 0);
                        maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
                        miny = Math.max(cy - radH, 0);
                        maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
                        float sumCount = 1.0E-20f;
                        float sumSlow2 = 0.0f;
                        for (int x3 = minx; x3 <= maxx; ++x3) {
                            float wx2 = 1.0f / (1.0f + (float)Math.abs(x3 - cx));
                            for (int y3 = miny; y3 <= maxy; ++y3) {
                                float wy2 = 1.0f / (1.0f + (float)Math.abs(y3 - cy));
                                if (this.m_inAirCoarse[x3][y3][cz + 1]) continue;
                                float w2 = wx2 * wy2 * this.m_temp2Coarse[x3][y3][cz + 1];
                                float slow2 = 0.995f * this.m_temp1Coarse[x3][y3][cz];
                                sumSlow2 += w2 * slow2;
                                sumCount += w2;
                            }
                        }
                        this.m_slownessCoarse[cx][cy][cz] = sumSlow2 / sumCount;
                        this.m_countCoarse[cx][cy][cz] = 1.01f * minValidCount;
                        if (Math.abs(this.m_slownessCoarse[cx][cy][cz]) < 1.0E-5f) {
                            ++numFunky;
                        }
                        if (!Float.isNaN(this.m_slownessCoarse[cx][cy][cz]) && !Float.isInfinite(this.m_slownessCoarse[cx][cy][cz])) continue;
                        ++numFunky;
                    }
                }
            }
            this.m_range.print("After keepGoing");
            this.m_range.clearRange();
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after filling dead    =================");
                for (cx2 = 0; cx2 < 4; ++cx2) {
                    for (cy2 = 0; cy2 < 4; ++cy2) {
                        String s = String.format("%d  %d   %f   %f", cx2, cy2, Float.valueOf(1.0f / this.m_slownessCoarse[cx2][cy2][0]), Float.valueOf(this.m_countCoarse[cx2][cy2][0]));
                        System.out.println(s);
                    }
                }
            }
            for (cz = 0; cz < this.m_numZ; ++cz) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy5 = 0; cy5 < this.m_numValidCoarseY; ++cy5) {
                        if (this.m_inAirCoarse[cx][cy5][cz]) continue;
                        minx = Math.max(cx - 2, 0);
                        maxx = Math.min(cx + 2, this.m_numValidCoarseX - 1);
                        miny = Math.max(cy5 - 2, 0);
                        maxy = Math.min(cy5 + 2, this.m_numValidCoarseY - 1);
                        int minz = Math.max(cz - 1, 0);
                        int maxz = Math.min(cz + 1, this.m_numZ - 1);
                        float sumCount = 1.0E-20f;
                        sumSlow = 0.0f;
                        for (x = minx; x <= maxx; ++x) {
                            wx = 0.5f / (0.5f + (float)Math.abs(x - cx));
                            for (y = miny; y <= maxy; ++y) {
                                wy = 0.5f / (0.5f + (float)Math.abs(y - cy5));
                                for (z = minz; z <= maxz; ++z) {
                                    wz = 0.1f / (0.1f + (float)Math.abs(z - cz));
                                    if (this.m_inAirCoarse[x][y][z]) continue;
                                    w = wx * wy * wz * this.m_countCoarse[x][y][z];
                                    slow = this.m_slownessCoarse[x][y][z];
                                    sumSlow += w * slow;
                                    sumCount += w;
                                }
                            }
                        }
                        if (sumSlow < 0.1f) {
                            ++numFunky;
                        }
                        this.m_temp1Coarse[cx][cy5][cz] = sumSlow / sumCount;
                        this.m_range.expandRange(1000.0f / this.m_temp1Coarse[cx][cy5][cz]);
                    }
                }
            }
            this.m_range.print("After smoothing coarse");
            this.m_range.clearRange();
            double sumCount = 0.0;
            for (int cz5 = 0; cz5 < this.m_numZ; ++cz5) {
                for (int cx5 = 0; cx5 < this.m_numValidCoarseX; ++cx5) {
                    for (int cy6 = 0; cy6 < this.m_numValidCoarseY; ++cy6) {
                        sumCount += (double)this.m_slownessCoarse[cx5][cy6][cz5];
                        this.m_slownessCoarse[cx5][cy6][cz5] = this.m_temp1Coarse[cx5][cy6][cz5];
                    }
                }
            }
            this.m_averageCoarseWeight = (float)(sumCount / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
            this.m_averageCoarseCount = (float)(sumCount / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after smoothing   =====================");
                for (int cx6 = 0; cx6 < 4; ++cx6) {
                    for (int cy7 = 0; cy7 < 4; ++cy7) {
                        String s = String.format("%d  %d   %f   %f", cx6, cy7, Float.valueOf(1.0f / this.m_slownessCoarse[cx6][cy7][0]), Float.valueOf(this.m_countCoarse[cx6][cy7][0]));
                        System.out.println(s);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void freeInterpolator() {
        try {
            this.m_interpolator = null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smooth_basic(int radiusX, int radiusZ) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        float sum1 = 0.0f;
                        float sum2 = 1.0E-20f;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - radiusZ, 0);
                        int maxz = Math.min(z + radiusZ, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    if (!((float)iz <= this.m_surfaceGridZ[ix][iy])) continue;
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    float w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    float s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        if (!(sum2 > 1.0f)) continue;
                        this.m_slowness[x][y][z] = sum1 / sum2;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smooth_external(int radiusX, int radiusZ) {
        try {
            int z;
            int y;
            int x;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        this.m_error[x][y][z] = this.m_slowness[x][y][z];
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        float sum1 = 0.0f;
                        float sum2 = 1.0E-20f;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - radiusZ, 0);
                        int maxz = Math.min(z + radiusZ, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    if (!((float)iz <= this.m_surfaceGridZ[ix][iy])) continue;
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    float w = wx * wy * wz;
                                    float s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        if (!(sum2 > 1.0f)) continue;
                        this.m_slowness[x][y][z] = sum1 / sum2;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smooth_Weight(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            int z;
            int y;
            int x;
            this.prepCoarse(radiusX, radiusZ, useweight, usedistance);
            double sumWeight = 0.0;
            for (int x2 = 0; x2 < this.m_numX; ++x2) {
                for (int y2 = 0; y2 < this.m_numY; ++y2) {
                    for (int z2 = 0; z2 < this.m_numZ; ++z2) {
                        sumWeight += (double)this.m_weight[x2][y2][z2];
                    }
                }
            }
            this.m_averageWeight = (float)(sumWeight / (double)(this.m_numX * this.m_numY * this.m_numZ));
            float scalar = this.m_averageWeight / this.m_averageCoarseWeight;
            float fractionCoarse = 0.5f;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        int cx = x / this.m_coarseRadius;
                        int cy = y / this.m_coarseRadius;
                        float coarseWeight = scalar * this.m_countCoarse[cx][cy][z];
                        float coarseSlow = this.m_slownessCoarse[cx][cy][z];
                        float fineWeight = this.m_weight[x][y][z];
                        float fineSlow = this.m_slowness[x][y][z];
                        coarseWeight = fractionCoarse * coarseWeight;
                        fineWeight = (1.0f - fractionCoarse) * fineWeight;
                        float slow = (coarseWeight * coarseSlow + fineWeight * fineSlow) / (coarseWeight + fineWeight);
                        this.m_weight[x][y][z] = coarseWeight + fineWeight;
                        this.m_error[x][y][z] = slow;
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        float sum1 = 0.0f;
                        float sum2 = 1.0E-20f;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - 0, 0);
                        int maxz = Math.min(z + 0, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    float w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    float s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        this.m_slowness[x][y][z] = sum1 / sum2;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smoothPlane(int z, int radius, boolean useweight, boolean usedistance) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_tempPlane1[x][y] = this.m_slowness[x][y][z];
                    this.m_tempPlane2[x][y] = 1.0E-7f + this.m_weight[x][y][z];
                }
            }
            boolean test = false;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int minx = Math.max(x - radius, 0);
                    int maxx = Math.min(x + radius, this.m_numX - 1);
                    int miny = Math.max(y - radius, 0);
                    int maxy = Math.min(y + radius, this.m_numY - 1);
                    if (x == 30 && y == 30) {
                        test = true;
                    }
                    double s1 = 0.0;
                    double s2 = 1.0E-10;
                    for (int ix = minx; ix <= maxx; ++ix) {
                        for (int iy = miny; iy <= maxy; ++iy) {
                            double w = 1.0;
                            if (useweight) {
                                w = this.m_tempPlane2[ix][iy];
                            }
                            if (usedistance) {
                                float dx = Math.abs(x - ix);
                                float dy = Math.abs(y - iy);
                                w /= (double)(1.0f + dx + dy);
                            }
                            s1 += w * (double)this.m_tempPlane1[ix][iy];
                            s2 += w;
                        }
                    }
                    this.m_slowness[x][y][z] = (float)(s1 / s2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromStraightLine(float pick, float offsetWeight) {
        try {
            if (pick < 5.0f) {
                return;
            }
            float timeError = Math.abs(pick - this.StraightLineTotalTime);
            float timeWeight = this.WeightTime / (this.WeightTime + timeError);
            float weight = 100.0f * timeWeight * (offsetWeight = Math.max(offsetWeight, 0.01f));
            if (weight < this.MinimumValidTotalWeight) {
                return;
            }
            float frac = this.StraightLineTotalTime / pick;
            frac = Math.max(0.67f, frac);
            frac = Math.min(1.33f, frac);
            for (int n = 0; n < 20; ++n) {
                float wx = this.StraightLineLowerWeightX[n];
                float wy = this.StraightLineLowerWeightY[n];
                float wz = this.StraightLineLowerWeightZ[n];
                int x = this.StraightLineLowerIndexX[n];
                int y = this.StraightLineLowerIndexY[n];
                int z = this.StraightLineLowerIndexZ[n];
                float w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray = this.m_count[x][y];
                int n2 = z;
                fArray[n2] = fArray[n2] + frac;
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray2 = this.m_count[x][y];
                int n3 = z;
                fArray2[n3] = fArray2[n3] + frac;
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray3 = this.m_count[x][y];
                int n4 = z;
                fArray3[n4] = fArray3[n4] + frac;
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray4 = this.m_count[x][y];
                int n5 = z;
                fArray4[n5] = fArray4[n5] + frac;
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray5 = this.m_count[x][y];
                int n6 = z;
                fArray5[n6] = fArray5[n6] + frac;
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray6 = this.m_count[x][y];
                int n7 = z;
                fArray6[n7] = fArray6[n7] + frac;
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray7 = this.m_count[x][y];
                int n8 = z;
                fArray7[n8] = fArray7[n8] + frac;
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                float[] fArray8 = this.m_count[x][y];
                int n9 = z;
                fArray8[n9] = fArray8[n9] + frac;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromProfile(TomoEikonal3DProfile_Lightweight profile, float pick, float offsetWeight, int sprayZ, float scalarSprayZ) {
        try {
            if (pick < 5.0f) {
                return;
            }
            int numPath = profile.NumPathPoints;
            int[] pathIndexX = profile.PathIndexX;
            int[] pathIndexZ = profile.PathIndexZ;
            sprayZ = Math.max(0, sprayZ);
            scalarSprayZ = Math.max(0.05f, scalarSprayZ);
            float timeError = Math.abs(pick - profile.ReceiverTime);
            float timeWeight = this.WeightTime / (this.WeightTime + timeError);
            float weight = 100.0f * timeWeight * (offsetWeight = Math.max(offsetWeight, 0.01f));
            if (weight < this.MinimumValidTotalWeight) {
                return;
            }
            float frac = profile.ReceiverTime / pick;
            frac = Math.max(0.67f, frac);
            frac = Math.min(1.33f, frac);
            for (int p = 0; p < numPath; ++p) {
                float w;
                float wz;
                int z;
                float wy;
                float wx;
                int y;
                int x;
                int px = profile.PathIndexX[p];
                int pz = profile.PathIndexZ[p];
                int zmin = Math.max(pz - sprayZ, 0);
                int zmax = Math.min(pz + sprayZ, this.m_numZ - 1);
                if (profile.LowerIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    x = profile.LowerIndexX[px];
                    y = profile.LowerIndexY[px];
                    wx = profile.LowerWeightX[px];
                    wy = profile.LowerWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        if (x < 0 || y < 0) {
                            w = 1.0E-4f;
                        }
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = fArray[n] + wz * frac;
                    }
                }
                if (profile.LowerIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    x = profile.LowerIndexX[px];
                    y = profile.UpperIndexY[px];
                    wx = profile.LowerWeightX[px];
                    wy = profile.UpperWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = fArray[n] + wz * frac;
                    }
                }
                if (profile.UpperIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    x = profile.UpperIndexX[px];
                    y = profile.UpperIndexY[px];
                    wx = profile.UpperWeightX[px];
                    wy = profile.UpperWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = fArray[n] + wz * frac;
                    }
                }
                if (!profile.UpperIndexValidX[px] || !profile.LowerIndexValidY[px]) continue;
                x = profile.UpperIndexX[px];
                y = profile.LowerIndexY[px];
                wx = profile.UpperWeightX[px];
                wy = profile.LowerWeightY[px];
                z = zmin;
                while (z <= zmax) {
                    wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                    w = wx * wy * weight * wz;
                    this.m_weight[x][y][z] = this.m_weight[x][y][z] + w;
                    this.m_error[x][y][z] = this.m_error[x][y][z] + w * frac;
                    float[] fArray = this.m_count[x][y];
                    int n = z++;
                    fArray[n] = fArray[n] + wz * frac;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finishUpdate(int smoothH, int smoothZ, float extrapolateDown, float extrapolateUp, float fractionCoarse, int totalIterations, int currentIteration, float maxPercentChange) {
        try {
            float maxFracChange = 1.0f + maxPercentChange / 100.0f;
            float minFracChange = 1.0f / maxFracChange;
            double weightSum = 0.0;
            double countMax = 0.0;
            double countSum = 0.0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    float[] slowness = this.m_slowness[x][y];
                    float[] weight = this.m_weight[x][y];
                    float[] error = this.m_error[x][y];
                    float[] count = this.m_count[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        countMax = Math.max(countMax, (double)count[z]);
                        countSum += (double)count[z];
                        if (!(weight[z] > 1.0E-4f)) continue;
                        weightSum += (double)weight[z];
                        float frac = error[z] / weight[z];
                        frac = Math.max(minFracChange, frac);
                        frac = Math.min(maxFracChange, frac);
                        float newSlowness = slowness[z] / frac;
                        float change = newSlowness - slowness[z];
                        slowness[z] = slowness[z] + 0.6f * change;
                    }
                }
            }
            double averageWeight = weightSum / (double)(this.m_numX * this.m_numY * this.m_numZ);
            if (this.m_interpolator == null) {
                this.m_interpolator = new TomoEikonal3D_Interpolator_Lightweight();
                this.m_interpolator.prepare(this, 3, totalIterations);
            }
            this.m_interpolator.smooth(smoothH, smoothZ, fractionCoarse, currentIteration);
            this.prepareAirSlowness();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepUpdate() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_weight[x][y][z] = 0.0f;
                        this.m_error[x][y][z] = 0.0f;
                        this.m_count[x][y][z] = 0.0f;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected float velAtDepth(float depth, int ix, int iy) {
        try {
            int maxIndex = (int)this.m_surfaceGridZ[ix][iy];
            float z = this.m_surfaceElevation[ix][iy] - depth;
            float indexFloat = (z -= (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
            int index = (int)indexFloat;
            float[] slowness = this.m_slowness[ix][iy];
            if (index >= maxIndex) {
                return 1000.0f / slowness[maxIndex];
            }
            if (indexFloat <= 0.0f) {
                return 1000.0f / slowness[0];
            }
            if (index >= 0 && index < maxIndex) {
                float frac = indexFloat - (float)index;
                float v1 = 1000.0f / slowness[index];
                float v2 = 1000.0f / slowness[index + 1];
                float v = frac * v2 + (1.0f - frac) * v1;
                return v;
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected float countAtDepth(float depth, int ix, int iy) {
        try {
            int maxIndex = (int)this.m_surfaceGridZ[ix][iy];
            float z = this.m_surfaceElevation[ix][iy] - depth;
            float indexFloat = (z -= (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
            int index = (int)indexFloat;
            float[] count = this.m_count[ix][iy];
            if (index >= maxIndex) {
                return count[maxIndex];
            }
            if (indexFloat <= 0.0f) {
                return count[0];
            }
            if (index >= 0 && index < maxIndex) {
                float frac = indexFloat - (float)index;
                float c1 = count[index];
                float c2 = count[index + 1];
                float c = frac * c2 + (1.0f - frac) * c1;
                return c;
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected void readArray3D(float[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                raf.read(ba.array(), 0, num);
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        arr[x][y][z] = ba.getFloat(n);
                        n += 4;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void read(String modelName, String fullPath) {
        try {
            this.m_name = modelName;
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = raf.readInt();
            int version = raf.readInt();
            if (magic != 8300129) {
                raf.close();
                return;
            }
            if (version == 1002) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
                this.readArray3D(this.m_count, raf);
            }
            if (version == 1001) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
            }
            if (version == 1000) {
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
            }
            raf.close();
            if (Tools_FileSystem.exists_file(this.m_waterBottomFileName)) {
                raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
                magic = raf.readInt();
                version = raf.readInt();
                if (magic != 5537222) {
                    raf.close();
                    return;
                }
                if (version == 1000) {
                    this.readGrid(raf, this.m_waterBottomElevation);
                }
                raf.close();
            }
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = raf.readInt();
            version = raf.readInt();
            if (magic != 334534534) {
                raf.close();
                return;
            }
            if (version == 1000) {
                this.readGrid(raf, this.m_surfaceElevation);
                this.readGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.readElement(this.ReceiverHash, this.m_recFileName);
            this.readElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = fullPath + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveArray3D(float[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        ba.putFloat(n, arr[x][y][z]);
                        n += 4;
                    }
                }
                raf.write(ba.array(), 0, num);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save(String fullPath) {
        try {
            Tools_FileSystem.deletePathIfExists(fullPath);
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = 8300129;
            int version = 1002;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1002) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
                this.saveArray3D(this.m_count, raf);
            }
            if (version == 1001) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
            }
            if (version == 1000) {
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
            }
            raf.close();
            raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
            magic = 5537222;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_waterBottomElevation);
            }
            raf.close();
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = 334534534;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_surfaceElevation);
                this.saveGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = fullPath + "/History.txt";
            if (this.getHistory() == null) {
                this.m_history = new History(this.m_historyFileName);
                this.getHistory().addWithTime("Model created");
                this.getHistory().save();
            } else {
                this.getHistory().save();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            hash.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = raf.readInt();
            if (magic != 244) {
                return;
            }
            int version = raf.readInt();
            int count = raf.readInt();
            for (int n = 0; n < count; ++n) {
                Element e = new Element(raf, version);
                hash.put(e, e.ID);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = 244;
            int version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            raf.writeInt(hash.size());
            for (Element e : hash.getValues()) {
                e.save(raf, version);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    ba.putFloat(i, grid[ix][iy]);
                    i += 4;
                }
            }
            raf.write(ba.array(), 0, num);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            raf.read(ba.array(), 0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    grid[ix][iy] = ba.getFloat(i);
                    i += 4;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void checkMem() {
        try {
            if (this.m_slowness == null) {
                this.m_slowness = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_weight = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_error = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_count = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_waterBottomElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceGridZ = new float[this.m_numX][this.m_numY];
                this.InterpolatedSlowness = new float[this.m_numZ];
                this.InterpolatedWeight = new float[this.m_numZ];
                this.InterpolatedCount = new float[this.m_numZ];
                this.m_tempPlane1 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane2 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane3 = new float[this.m_numX][this.m_numY];
                this.m_numCoarseX = 1 + this.m_numX / 4;
                this.m_numCoarseY = 1 + this.m_numY / 4;
                this.m_slownessCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_countCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp1Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp2Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_inAirCoarse = new boolean[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_tempCoarse1 = new float[this.m_numCoarseX][this.m_numCoarseY];
                this.m_tempCoarse2 = new float[this.m_numCoarseX][this.m_numCoarseY];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void forceIncreasingVelocity(float frac) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    for (int z = maxIndex = Math.min(maxIndex, this.m_numZ - 1); z >= 1; --z) {
                        float currentVelocity = 1000.0f / this.m_slowness[x][y][z - 1];
                        float minimumPreferredVelocity = frac * 1000.0f / this.m_slowness[x][y][z];
                        if (!(currentVelocity < minimumPreferredVelocity)) continue;
                        this.m_slowness[x][y][z - 1] = 1000.0f / minimumPreferredVelocity;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareAirSlowness() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    if ((maxIndex = Math.min(maxIndex, this.m_numZ - 1)) + 1 < this.m_numZ) {
                        this.m_slowness[x][y][maxIndex + 1] = this.m_slowness[x][y][maxIndex];
                    }
                    for (int z = maxIndex + 2; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = 1.1f * this.m_slowness[x][y][maxIndex];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setVelocityGradient(double v1, double v2) throws Exception {
        try {
            this.checkMem();
            if (this.m_forceMarineSurvey) {
                v1 = Math.max(v1, 1.2 * this.m_waterVelocity);
            }
            v2 = Math.max(v2, 1.2 * v1);
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    maxIndex = Math.min(maxIndex, this.m_numZ - 1);
                    double alpha = (v1 - v2) / (double)this.m_surfaceGridZ[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double v = alpha * (double)z + v2;
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
            for (int z = 0; z < this.m_numZ; ++z) {
                this.smoothPlane(z, 5, false, false);
            }
            this.prepareAirSlowness();
            this.prepWaterVelocity();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeInternals() {
        try {
            this.m_cosineInlineAngle = Math.cos(this.m_inlineAngle);
            this.m_sineInlineAngle = Math.sin(this.m_inlineAngle);
            this.m_binSizeHorz = Math.max(1.0, this.m_binSizeHorz);
            this.m_binSizeVert = Math.max(1.0, this.m_binSizeVert);
            this.m_inverseBinSizeHorz = 1.0 / this.m_binSizeHorz;
            this.m_inverseBinSizeVert = 1.0 / this.m_binSizeVert;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setGridLocation(int indexX, int indexY, int indexZ) {
        try {
            this.GridX = (double)indexX * this.m_binSizeHorz;
            this.GridY = (double)indexY * this.m_binSizeHorz;
            this.GridZ = (double)indexZ * this.m_binSizeVert;
            this.WorldX = this.m_originX + this.m_cosineInlineAngle * this.GridX - this.m_sineInlineAngle * this.GridY;
            this.WorldY = this.m_originY + this.m_cosineInlineAngle * this.GridY + this.m_sineInlineAngle * this.GridX;
            this.WorldZ = this.m_originZ + this.GridZ;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeStatics_ComputeIntDatum(double x, double y, double z, double velocity, double finalDatum, double repVel) {
        try {
            this.setWorldLocation(x, y, true, true);
            double v = 1000.0 / (double)this.InterpolatedSlowness[0];
            if (velocity >= v) {
                double intDatum = this.m_originZ;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            v = 1000.0 / (double)this.InterpolatedSlowness[this.m_numZ - 1];
            if (velocity <= v) {
                double intDatum = this.m_originZ + (double)(this.m_numZ - 1) * this.m_binSizeVert;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            for (int n = this.m_numZ - 1; n >= 1; --n) {
                double v1 = 1000.0 / (double)this.InterpolatedSlowness[n];
                double v2 = 1000.0 / (double)this.InterpolatedSlowness[n - 1];
                if (!(v1 >= velocity)) continue;
                double intDatum = this.m_originZ + (double)n * this.m_binSizeVert;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            this.computeStatics(x, y, z, this.m_originZ, finalDatum, repVel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeStatics(double x, double y, double z, double intDatum, double finalDatum, double repVel) {
        try {
            this.TimeToFinalDatum = 1000.0 * (finalDatum - intDatum) / repVel;
            this.setWorldLocation(x, y, true, true);
            this.TimeToIntermediateDatum = 0.0;
            if (z > intDatum) {
                int n;
                int num = this.m_tempVertSlowness.length;
                double dz = (z - intDatum) / (double)(num - 1);
                for (n = 0; n < num; ++n) {
                    double worldZ = z - dz * (double)n;
                    double gridZ = worldZ - this.m_originZ;
                    double floatIndexZ = gridZ * this.m_inverseBinSizeVert;
                    floatIndexZ = Math.max(floatIndexZ, 1.0E-6);
                    floatIndexZ = Math.min(floatIndexZ, (double)this.m_numZ - 1.0E-5);
                    int indexZ = (int)floatIndexZ;
                    double fracZ = floatIndexZ - (double)indexZ;
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ] * this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ] * this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ] * this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ] * this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    if (indexZ < this.m_numZ - 1) {
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ + 1] * this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ + 1] * this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ + 1] * this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ + 1] * this.UpperWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.LowerWeightY) * fracZ;
                    }
                    this.m_tempVertSlowness[n] = s1 / s2;
                }
                for (n = 1; n < num; ++n) {
                    double avg = 0.5 * (this.m_tempVertSlowness[n - 1] + this.m_tempVertSlowness[n]);
                    this.TimeToIntermediateDatum += avg * dz;
                }
            }
            this.Statics = this.TimeToFinalDatum - this.TimeToIntermediateDatum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, double worldZ, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            double dz;
            this.setWorldLocation(worldX, worldY, fixEdgeIndices, interpolateGrids);
            this.WorldZ = worldZ;
            this.GridZ = dz = worldZ - this.m_originZ;
            this.FloatIndexZ = this.GridZ * this.m_inverseBinSizeVert;
            if (this.FloatIndexZ <= 0.0) {
                this.FloatIndexZ = 0.0;
                this.LowerIndexZ = 0;
                this.UpperIndexZ = 0;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ >= (double)(this.m_numZ - 1)) {
                this.FloatIndexZ = this.m_numZ - 1;
                this.LowerIndexZ = this.m_numZ - 1;
                this.UpperIndexZ = this.m_numZ - 1;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ > 0.0 && this.FloatIndexZ < (double)(this.m_numZ - 1)) {
                this.LowerIndexZ = (int)this.FloatIndexZ;
                this.UpperIndexZ = this.LowerIndexZ + 1;
                this.UpperWeightZ = (float)(this.FloatIndexZ - (double)this.LowerIndexZ);
                this.LowerWeightZ = 1.0f - this.UpperWeightZ;
            }
            this.UpperIndexValidZ = true;
            this.LowerIndexValidZ = true;
            if (interpolateGrids) {
                if (this.LowerIndexZ < 0) {
                    return;
                }
                this.SlownessAtWorld = this.LowerWeightZ * this.InterpolatedSlowness[this.LowerIndexZ] + this.UpperWeightZ * this.InterpolatedSlowness[this.UpperIndexZ];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            this.FloatIndexX = this.GridX * this.m_inverseBinSizeHorz;
            this.FloatIndexY = this.GridY * this.m_inverseBinSizeHorz;
            this.LowerIndexX = (int)this.FloatIndexX;
            this.LowerIndexY = (int)this.FloatIndexY;
            while (this.LowerIndexX > (int)this.FloatIndexX) {
                --this.LowerIndexX;
            }
            while (this.LowerIndexY > (int)this.FloatIndexY) {
                --this.LowerIndexY;
            }
            this.UpperWeightX = (float)(this.FloatIndexX - (double)this.LowerIndexX);
            this.UpperWeightY = (float)(this.FloatIndexY - (double)this.LowerIndexY);
            this.LowerWeightX = 1.0f - this.UpperWeightX;
            this.LowerWeightY = 1.0f - this.UpperWeightY;
            this.UpperIndexValidX = this.LowerIndexX + 1 < this.m_numX;
            this.UpperIndexValidY = this.LowerIndexY + 1 < this.m_numY;
            this.LowerIndexValidX = this.LowerIndexX >= 0;
            boolean bl = this.LowerIndexValidY = this.LowerIndexY >= 0;
            if (this.LowerIndexValidX && this.LowerIndexValidY && this.UpperIndexValidX && this.UpperIndexValidY) {
                this.OnEdge = false;
                this.UpperIndexX = this.LowerIndexX + 1;
                this.UpperIndexY = this.LowerIndexY + 1;
            } else {
                this.OnEdge = true;
                this.EdgeIndexX = this.LowerIndexX;
                this.EdgeIndexX = Math.max(this.EdgeIndexX, 0);
                this.EdgeIndexX = Math.min(this.EdgeIndexX, this.m_numX - 1);
                this.EdgeIndexY = this.LowerIndexX;
                this.EdgeIndexY = Math.max(this.EdgeIndexY, 0);
                this.EdgeIndexY = Math.min(this.EdgeIndexY, this.m_numY - 1);
                if (fixEdgeIndices) {
                    this.UpperIndexX = this.LowerIndexX = this.EdgeIndexX;
                    this.UpperIndexY = this.LowerIndexY = this.EdgeIndexY;
                    this.LowerWeightX = 1.0f;
                    this.LowerWeightY = 1.0f;
                    this.UpperWeightX = 0.0f;
                    this.UpperWeightY = 0.0f;
                }
            }
            if (!interpolateGrids) {
                return;
            }
            if (this.OnEdge && !fixEdgeIndices) {
                throw new Exception("fixEdgeIndices == false");
            }
            this.InterpolatedWaterBottom = this.LowerWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedElevation = this.LowerWeightX * this.LowerWeightY * this.m_surfaceElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedGridZ = this.LowerWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.UpperIndexY];
            for (int n = 0; n < this.m_numZ; ++n) {
                this.InterpolatedSlowness[n] = this.LowerWeightX * this.LowerWeightY * this.m_slowness[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_slowness[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_slowness[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_slowness[this.LowerIndexX][this.UpperIndexY][n];
                this.InterpolatedWeight[n] = this.LowerWeightX * this.LowerWeightY * this.m_weight[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_weight[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_weight[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_weight[this.LowerIndexX][this.UpperIndexY][n];
                this.InterpolatedCount[n] = this.LowerWeightX * this.LowerWeightY * this.m_count[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_count[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_count[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_count[this.LowerIndexX][this.UpperIndexY][n];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class Element {
        public int ID;
        public double Count = 1.0E-5;
        public double Error = 0.0;
        public double Residual = 0.0;
        public double ComputedResidual = 0.0;

        public Element(int id) {
            this.ID = id;
        }

        public Element(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    this.ID = raf.readInt();
                    this.Count = raf.readDouble();
                    this.Error = raf.readDouble();
                    this.Residual = raf.readDouble();
                    this.ComputedResidual = raf.readDouble();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    raf.writeInt(this.ID);
                    raf.writeDouble(this.Count);
                    raf.writeDouble(this.Error);
                    raf.writeDouble(this.Residual);
                    raf.writeDouble(this.ComputedResidual);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addError(float error) {
            this.Count += 1.0;
            this.Error += (double)Math.abs(error);
            this.Residual += (double)error;
        }
    }
}

