/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;

public class TomoEikonal3D_Interpolator {
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_error;
    protected float[][][] m_count;
    protected float[][] m_surfaceElevation;
    protected float[][] m_surfaceGridZ;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_countCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected boolean[][][] m_inAirCoarse;
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    protected float m_minValidCount = 10.0f;
    protected float m_averageCoarseCount = 1.0f;
    protected float m_averageCount = 9.0f;
    protected int m_totalIterations = 1;
    protected int m_currentIteration = 1;
    protected float[] m_weightH;
    protected float[] m_weightZ;
    protected double m_maxCoarseCount = 0.0;

    public void prepare(TomoEikonal3D tomo, int coarseRadius, int totalIterations) {
        try {
            this.m_totalIterations = totalIterations;
            this.m_coarseRadius = Math.max(3, coarseRadius);
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            this.m_surfaceElevation = tomo.surfaceElevation();
            this.m_surfaceGridZ = tomo.surfaceGridZ();
            this.m_slowness = tomo.slowness();
            this.m_weight = tomo.weight();
            this.m_error = tomo.error();
            this.m_count = tomo.count();
            this.m_numValidCoarseX = 1 + this.m_numX / this.m_coarseRadius;
            this.m_numValidCoarseY = 1 + this.m_numY / this.m_coarseRadius;
            this.m_slownessCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_countCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp1Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp2Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_inAirCoarse = new boolean[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            int maxH = Math.max(this.m_numValidCoarseX + 1, this.m_numValidCoarseY + 1);
            this.m_weightH = new float[maxH];
            this.m_weightZ = new float[this.m_numZ];
            for (int z = 0; z < this.m_numZ; ++z) {
                this.m_weightZ[z] = 0.1f / (0.1f + (float)z);
            }
            for (int h = 0; h < maxH; ++h) {
                this.m_weightH[h] = 0.5f / (0.5f + (float)h);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smooth(int radiusX, int radiusZ, float fractionCoarse, int currentIteration) {
        try {
            int z;
            int y;
            int x;
            System.out.println("iter " + currentIteration + " of " + this.m_totalIterations);
            this.m_currentIteration = currentIteration;
            this.initCoarse();
            this.horizontal();
            this.smoothCoarse(radiusX, radiusZ);
            double sumCount = 0.0;
            for (int x2 = 0; x2 < this.m_numX; ++x2) {
                for (int y2 = 0; y2 < this.m_numY; ++y2) {
                    for (int z2 = 0; z2 < this.m_numZ; ++z2) {
                        sumCount += (double)this.m_count[x2][y2][z2];
                    }
                }
            }
            this.m_averageCount = (float)(sumCount / (double)(this.m_numX * this.m_numY * this.m_numZ));
            float scalar = this.m_averageCount / this.m_averageCoarseCount;
            int numFunky = 0;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        int cx = x / this.m_coarseRadius;
                        int cy = y / this.m_coarseRadius;
                        double coarseCount = scalar * this.m_countCoarse[cx][cy][z];
                        double coarseSlow = this.m_slownessCoarse[cx][cy][z];
                        double fineCount = this.m_count[x][y][z];
                        double fineSlow = this.m_slowness[x][y][z];
                        double slow = ((coarseCount = (double)fractionCoarse * coarseCount) * coarseSlow + (fineCount = (double)(1.0f - fractionCoarse) * fineCount) * fineSlow) / (coarseCount + fineCount);
                        if (Math.abs(slow) < (double)1.0E-5f) {
                            ++numFunky;
                        }
                        if (Double.isNaN(slow) || Double.isInfinite(slow)) {
                            ++numFunky;
                        }
                        this.m_error[x][y][z] = (float)slow;
                        this.m_weight[x][y][z] = (float)(coarseCount + fineCount);
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        double sum1 = 0.0;
                        double sum2 = 1.0E-20;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - 0, 0);
                        int maxz = Math.min(z + 0, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    if (!((float)iz <= this.m_surfaceGridZ[ix][iy])) continue;
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    double w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    double s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        if (sum2 > 1.0) {
                            this.m_slowness[x][y][z] = (float)(sum1 / sum2);
                        }
                        if (Math.abs(this.m_slowness[x][y][z]) < 1.0E-5f) {
                            ++numFunky;
                        }
                        if (!Float.isNaN(this.m_slowness[x][y][z]) && !Float.isInfinite(this.m_slowness[x][y][z])) continue;
                        ++numFunky;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smoothCoarse(int radiusX, int radiusZ) {
        try {
            for (int cz = 0; cz < this.m_numZ; ++cz) {
                for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        if (this.m_inAirCoarse[cx][cy][cz]) continue;
                        int minx = Math.max(cx - radiusX, 0);
                        int maxx = Math.min(cx + radiusX, this.m_numValidCoarseX - 1);
                        int miny = Math.max(cy - radiusX, 0);
                        int maxy = Math.min(cy + radiusX, this.m_numValidCoarseY - 1);
                        int minz = Math.max(cz - radiusZ, 0);
                        int maxz = Math.min(cz + radiusZ, this.m_numZ - 1);
                        double sumCount = 1.0E-20;
                        double sumSlow = 0.0;
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = this.m_weightH[Math.abs(x - cx)];
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = this.m_weightH[Math.abs(y - cy)];
                                for (int z = minz; z <= maxz; ++z) {
                                    float wz = this.m_weightZ[Math.abs(z - cz)];
                                    if (this.m_inAirCoarse[x][y][z]) continue;
                                    double w = wx * wy * wz * this.m_countCoarse[x][y][z];
                                    double slow = this.m_slownessCoarse[x][y][z];
                                    sumSlow += w * slow;
                                    sumCount += w;
                                }
                            }
                        }
                        this.m_temp1Coarse[cx][cy][cz] = (float)(sumSlow / sumCount);
                    }
                }
            }
            double sumCount = 0.0;
            for (int cz = 0; cz < this.m_numZ; ++cz) {
                for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        if (this.m_inAirCoarse[cx][cy][cz]) continue;
                        this.m_slownessCoarse[cx][cy][cz] = this.m_temp1Coarse[cx][cy][cz];
                        sumCount += (double)this.m_countCoarse[cx][cy][cz];
                    }
                }
            }
            this.m_averageCoarseCount = (float)(sumCount / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void horizontal() {
        try {
            int cx;
            int minValidZ = this.minValidZ();
            boolean keepGoing = true;
            int radH = 25;
            int radZ = 0;
            int maxRadH = Math.min(this.m_numValidCoarseX, this.m_numValidCoarseY) / 3;
            while (keepGoing) {
                keepGoing = false;
                this.copyToTemp();
                for (int cz = minValidZ; cz < this.m_numZ; ++cz) {
                    for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                        for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                            boolean ok;
                            if (this.m_inAirCoarse[cx][cy][cz] || !(this.m_temp2Coarse[cx][cy][cz] < this.m_minValidCount) || (ok = this.compute(cx, cy, cz, radH, radZ))) continue;
                            keepGoing = true;
                        }
                    }
                }
                radH += 42;
                ++radZ;
            }
            this.copyToTemp();
            for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    double slow = this.m_temp1Coarse[cx][cy][minValidZ];
                    float downExtrapolation = 0.995f;
                    if (this.m_currentIteration == 1) {
                        downExtrapolation = 0.98f;
                    }
                    int numExtrap = 0;
                    for (int cz = minValidZ - 1; cz >= 0; --cz) {
                        if (numExtrap >= 4) {
                            downExtrapolation = 1.0f;
                        }
                        this.m_slownessCoarse[cx][cy][cz] = (float)(slow *= (double)downExtrapolation);
                        this.m_countCoarse[cx][cy][cz] = 1.01f * this.m_minValidCount;
                        ++numExtrap;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected boolean compute(int cx, int cy, int cz, int radH, int radZ) {
        try {
            if (this.m_inAirCoarse[cx][cy][cz] || this.m_temp2Coarse[cx][cy][cz] >= this.m_minValidCount) {
                return true;
            }
            double sumCount = 1.0E-10;
            double sumSlow = 0.0;
            int minx = Math.max(cx - radH, 0);
            int maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
            int miny = Math.max(cy - radH, 0);
            int maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
            int minz = Math.max(cz - radZ, 0);
            int maxz = Math.min(cz + radZ, this.m_numZ - 1);
            for (int x = minx; x <= maxx; ++x) {
                float wx = this.m_weightH[Math.abs(x - cx)];
                for (int y = miny; y <= maxy; ++y) {
                    float wy = this.m_weightH[Math.abs(y - cy)];
                    for (int z = minz; z <= maxz; ++z) {
                        if (this.m_inAirCoarse[x][y][z] || !(this.m_temp2Coarse[x][y][z] >= this.m_minValidCount)) continue;
                        float wz = this.m_weightZ[Math.abs(z - cz)];
                        double w = wx * wy * wz * this.m_temp2Coarse[x][y][z];
                        double slow = this.m_temp1Coarse[x][y][z];
                        sumSlow += w * slow;
                        sumCount += w;
                    }
                }
            }
            if (sumCount <= (double)this.m_minValidCount) {
                return false;
            }
            this.m_slownessCoarse[cx][cy][cz] = (float)(sumSlow / sumCount);
            this.m_countCoarse[cx][cy][cz] = 1.01f * this.m_minValidCount;
            return true;
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    protected void vertical() {
        try {
            this.copyToTemp();
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        if (this.m_inAirCoarse[cx][cy][cz] || !(this.m_temp2Coarse[cx][cy][cz] < this.m_minValidCount)) continue;
                        float sumCount = 1.0E-10f;
                        float sum = 0.0f;
                        int minx = Math.max(cx - 2, 0);
                        int maxx = Math.min(cx + 2, this.m_numValidCoarseX - 1);
                        int miny = Math.max(cy - 2, 0);
                        int maxy = Math.min(cy + 2, this.m_numValidCoarseY - 1);
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(x - cx));
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(y - cy));
                                for (int z = 0; z < this.m_numZ; ++z) {
                                    if (this.m_inAirCoarse[x][y][z] || !(this.m_temp2Coarse[x][y][z] > this.m_minValidCount)) continue;
                                    float f = 0.5f / (0.5f + (float)Math.abs(z - cz));
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected int minValidZ() {
        try {
            int minValidZ = this.m_numZ;
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        if (!(this.m_countCoarse[cx][cy][cz] > this.m_minValidCount)) continue;
                        minValidZ = Math.min(minValidZ, cz);
                        cz = 10000;
                        if (minValidZ != 0) continue;
                        return 0;
                    }
                }
            }
            return minValidZ;
        }
        catch (Exception error) {
            error.printStackTrace();
            return 0;
        }
    }

    protected void copyToTemp() {
        try {
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        this.m_temp1Coarse[cx][cy][cz] = this.m_slownessCoarse[cx][cy][cz];
                        this.m_temp2Coarse[cx][cy][cz] = this.m_countCoarse[cx][cy][cz];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void initCoarse() {
        try {
            this.m_maxCoarseCount = 0.0;
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        double sumCount = 1.0E-20;
                        double sumSlowness = 0.0;
                        int numNotInAir = 0;
                        this.m_slownessCoarse[cx][cy][cz] = 0.0f;
                        this.m_countCoarse[cx][cy][cz] = 1.0E-20f;
                        int minx = cx * this.m_coarseRadius;
                        int maxx = Math.min(minx + this.m_coarseRadius - 1, this.m_numX - 1);
                        int miny = cy * this.m_coarseRadius;
                        int maxy = Math.min(miny + this.m_coarseRadius - 1, this.m_numY - 1);
                        int minz = Math.max(cz - 0, 0);
                        int maxz = Math.min(cz + 0, this.m_numZ - 1);
                        for (int x = minx; x <= maxx; ++x) {
                            for (int y = miny; y <= maxy; ++y) {
                                for (int z = minz; z <= maxz; ++z) {
                                    if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                                    ++numNotInAir;
                                    double count = this.m_count[x][y][z];
                                    count = count * 0.5 / (double)(0.5f + (float)Math.abs(z - cz));
                                    double slowness = this.m_slowness[x][y][z];
                                    sumSlowness += slowness * count;
                                    sumCount += count;
                                }
                            }
                        }
                        this.m_inAirCoarse[cx][cy][cz] = numNotInAir == 0;
                        this.m_slownessCoarse[cx][cy][cz] = (float)(sumSlowness / sumCount);
                        this.m_countCoarse[cx][cy][cz] = (float)sumCount;
                        this.m_maxCoarseCount = Math.max(this.m_maxCoarseCount, sumCount);
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

