/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile_Anisotropy;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D_Interpolator;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class TomoEikonal3D {
    protected HashMap<String, float[][]> m_interpolatedGridHash = new HashMap();
    public HashMap_Integers<Element> SourceHash = new HashMap_Integers();
    public HashMap_Integers<Element> ReceiverHash = new HashMap_Integers();
    protected String m_srcFileName;
    protected String m_recFileName;
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_originZ = 0.0;
    protected double m_binSizeHorz = 25.0;
    protected double m_binSizeVert = 25.0;
    protected double m_inlineAngle = 0.0;
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected double m_cosineInlineAngle = 0.0;
    protected double m_sineInlineAngle = 0.0;
    protected double m_inverseBinSizeHorz = 1.0;
    protected double m_inverseBinSizeVert = 1.0;
    protected boolean m_anisotropyValid = false;
    protected int m_anisotropyChunkSize = 3;
    protected int m_anisotropyNumX;
    protected int m_anisotropyNumY;
    protected float[][][] m_anisFraction;
    protected float[][][] m_anisFastAzimuth;
    protected String m_anisotropyFileName;
    protected boolean m_forceMarineSurvey;
    protected double m_waterVelocity;
    protected float[][] m_waterBottomElevation;
    protected String m_name = "";
    protected String m_gridFileName;
    protected String m_surfaceFileName;
    protected String m_waterBottomFileName;
    public static final String ModelFileName = "Model.slowness";
    public static final String SurfaceFileName = "Model.surface";
    public static final String WaterBottomFileName = "WaterBottom.surface";
    public static final String ReceiverFileName = "Model.receivers";
    public static final String ShotFileName = "Model.shots";
    public static final String AnisotropyFileName = "Model.anisotropy";
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_error;
    protected float[][][] m_count;
    protected float[][] m_tempPlane1;
    protected float[][] m_tempPlane2;
    protected float[][] m_tempPlane3;
    protected float[][] m_surfaceElevation;
    protected float[][] m_surfaceGridZ;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_countCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected boolean[][][] m_inAirCoarse;
    protected float[][] m_tempCoarse1;
    protected float[][] m_tempCoarse2;
    protected int m_numCoarseX;
    protected int m_numCoarseY;
    protected String m_historyFileName;
    protected History m_history;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public double GridX;
    public double GridY;
    public double GridZ;
    public double FloatIndexX;
    public double FloatIndexY;
    public double FloatIndexZ;
    public int LowerIndexX;
    public int LowerIndexY;
    public int LowerIndexZ;
    public float LowerWeightX;
    public float LowerWeightY;
    public float LowerWeightZ;
    public float UpperWeightX;
    public float UpperWeightY;
    public float UpperWeightZ;
    public boolean LowerIndexValidX;
    public boolean LowerIndexValidY;
    public boolean LowerIndexValidZ;
    public boolean UpperIndexValidX;
    public boolean UpperIndexValidY;
    public boolean UpperIndexValidZ;
    public float InterpolatedGridZ;
    public float InterpolatedElevation;
    public float InterpolatedWaterBottom;
    public float[] InterpolatedSlowness = new float[20];
    public float[] InterpolatedWeight = new float[20];
    public float[] InterpolatedCount = new float[20];
    public double SlownessAtWorld;
    public boolean OnEdge = false;
    public int EdgeIndexX;
    public int EdgeIndexY;
    public int UpperIndexX;
    public int UpperIndexY;
    public int UpperIndexZ = 0;
    public static final int NumStraightLine = 20;
    public int[] StraightLineLowerIndexX = new int[20];
    public int[] StraightLineLowerIndexY = new int[20];
    public int[] StraightLineLowerIndexZ = new int[20];
    public int[] StraightLineUpperIndexX = new int[20];
    public int[] StraightLineUpperIndexY = new int[20];
    public int[] StraightLineUpperIndexZ = new int[20];
    public float[] StraightLineLowerWeightX = new float[20];
    public float[] StraightLineLowerWeightY = new float[20];
    public float[] StraightLineLowerWeightZ = new float[20];
    public float[] StraightLineUpperWeightX = new float[20];
    public float[] StraightLineUpperWeightY = new float[20];
    public float[] StraightLineUpperWeightZ = new float[20];
    public float[] StraightLineSlowness = new float[20];
    public float[] StraightLineTime = new float[20];
    public double StraightLineTotalTime;
    public boolean[] StraightLineLowerIndexValidX = new boolean[20];
    public boolean[] StraightLineLowerIndexValidY = new boolean[20];
    public boolean[] StraightLineLowerIndexValidZ = new boolean[20];
    public boolean[] StraightLineUpperIndexValidX = new boolean[20];
    public boolean[] StraightLineUpperIndexValidY = new boolean[20];
    public boolean[] StraightLineUpperIndexValidZ = new boolean[20];
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    public boolean PrintCoarseCorner = false;
    public boolean PrintBottomLayer = false;
    protected Range_Double m_range = new Range_Double();
    protected float m_averageCoarseWeight;
    protected float m_averageWeight;
    protected float m_averageCoarseCount;
    protected float m_averageCount;
    protected TomoEikonal3D_Interpolator m_interpolator;
    public final float MinValidWeight = 1.0E-4f;
    public float WeightTime = 1.0f;
    public float MinimumValidTotalWeight = 0.1f;
    protected double[] m_tempVertSlowness = new double[100];
    public double TimeToIntermediateDatum = 0.0;
    public double TimeToFinalDatum = 0.0;
    public double Statics;

    public synchronized void applyUpholeVelocityLayer(String elevName, String velName) {
        try {
            float[][] z = this.m_interpolatedGridHash.get(elevName);
            float[][] v = this.m_interpolatedGridHash.get(velName);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float[] slowness = this.m_slowness[ix][iy];
                    float slow = 1000.0f / v[ix][iy];
                    int zmin = (int)(((double)z[ix][iy] - this.m_originZ) / this.m_binSizeVert);
                    for (int iz = zmin + 1; iz < this.m_numZ; ++iz) {
                        if (iz < 0 || iz >= slowness.length) continue;
                        slowness[iz] = slow;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void generateLayers(double ... layers) {
        try {
            int num = layers.length;
            int nodesPerLayer = this.m_numZ / num;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        int layer = iz / nodesPerLayer;
                        layer = Math.min(layer, num - 1);
                        layer = num - 1 - layer;
                        this.m_slowness[ix][iy][iz] = (float)(1000.0 / layers[layer]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void createInterpolatedGrid(String name, Table_Abstract table, String colX, String colY, String colV) {
        try {
            int iy;
            int ix;
            this.m_interpolatedGridHash.remove(name);
            int indexX = table.column_indexOfColumn(colX);
            int indexY = table.column_indexOfColumn(colY);
            int indexV = table.column_indexOfColumn(colV);
            int numRows = table.row_count();
            double[] x = new double[numRows];
            double[] y = new double[numRows];
            double[] v = new double[numRows];
            for (int r = 0; r < numRows; ++r) {
                x[r] = table.getDouble(r, indexX);
                y[r] = table.getDouble(r, indexY);
                v[r] = table.getDouble(r, indexV);
            }
            float[][] array = new float[this.numX()][this.numY()];
            int gap = 5;
            for (ix = 0; ix < this.m_numX; ix += gap) {
                for (iy = 0; iy < this.m_numY; iy += gap) {
                    this.setGridLocation(ix, iy, 0);
                    double s1 = 0.0;
                    double s2 = 1.0E-30;
                    for (int r = 0; r < numRows; ++r) {
                        double dx = this.WorldX - x[r];
                        double dy = this.WorldY - y[r];
                        double dsq = dx * dx + dy * dy;
                        double w = 10000.0 / (100.0 + dsq);
                        s1 += v[r] * w;
                        s2 += w;
                    }
                    double val = s1 / s2;
                    array[ix][iy] = (float)val;
                }
            }
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    boolean done;
                    boolean onGapX = ix % gap == 0;
                    boolean onGapY = iy % gap == 0;
                    boolean bl = done = onGapX && onGapY;
                    if (done) continue;
                    int x1 = ix / gap;
                    int minX = (x1 *= gap) - 2 * gap;
                    int maxX = x1 + 3 * gap;
                    minX = Math.max(minX, 0);
                    maxX = Math.min(maxX, this.m_numX - 1);
                    int y1 = iy / gap;
                    int minY = (y1 *= gap) - 2 * gap;
                    int maxY = y1 + 3 * gap;
                    minY = Math.max(minY, 0);
                    maxY = Math.min(maxY, this.m_numY - 1);
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    for (x1 = minX; x1 <= maxX; x1 += gap) {
                        for (y1 = minY; y1 <= maxY; y1 += gap) {
                            double dx = x1 - ix;
                            double dy = y1 - iy;
                            double dsq = dx * dx + dy * dy;
                            double w = 1.0 / (1.0 + dsq);
                            s1 += w * (double)array[x1][y1];
                            s2 += w;
                        }
                    }
                    double val = s1 / s2;
                    array[ix][iy] = (float)val;
                }
            }
            this.m_interpolatedGridHash.put(name, array);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Element getShotElement(int id) {
        try {
            if (!this.SourceHash.containsKey(id)) {
                this.SourceHash.put(new Element(id), id);
            }
            return this.SourceHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Element getReceiverElement(int id) {
        try {
            if (!this.ReceiverHash.containsKey(id)) {
                this.ReceiverHash.put(new Element(id), id);
            }
            return this.ReceiverHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveReceiverHash() {
        try {
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveSourceHash() {
        try {
            this.saveElement(this.SourceHash, this.m_srcFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void restoreComputedResiduals() {
        try {
            for (Element e : this.SourceHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.writeResidualsToDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void convertResidualsToZeroMean() {
        try {
            double w;
            double s1 = 0.0;
            double s2 = 1.0E-20;
            for (Element e : this.SourceHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            double avg = s1 / s2;
            for (Element e : this.SourceHash.getValues()) {
                e.Residual -= avg;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual -= avg;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.writeResidualsToDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double originZ() {
        return this.m_originZ;
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public double binSizeHorz() {
        return this.m_binSizeHorz;
    }

    public double binSizeVert() {
        return this.m_binSizeVert;
    }

    public double inlineAngle() {
        return this.m_inlineAngle;
    }

    public int numX() {
        return this.m_numX;
    }

    public int numY() {
        return this.m_numY;
    }

    public int numZ() {
        return this.m_numZ;
    }

    public boolean anisotropyValid() {
        return this.m_anisotropyValid;
    }

    public boolean forceMarineSurvey() {
        return this.m_forceMarineSurvey;
    }

    public double waterVelocity() {
        return this.m_waterVelocity;
    }

    public float[][] waterBottomElevation() {
        return this.m_waterBottomElevation;
    }

    public String name() {
        return this.m_name;
    }

    public float[][][] slowness() {
        return this.m_slowness;
    }

    public float[][][] weight() {
        return this.m_weight;
    }

    public float[][][] error() {
        return this.m_error;
    }

    public float[][][] count() {
        return this.m_count;
    }

    public float[][] surfaceElevation() {
        return this.m_surfaceElevation;
    }

    public float[][] surfaceGridZ() {
        return this.m_surfaceGridZ;
    }

    public synchronized void fireStraightLine(double sx, double sy, double sz, double rx, double ry, double rz) throws Exception {
        try {
            int n;
            double dx = (rx - sx) / 19.0;
            double dy = (ry - sy) / 19.0;
            double dz = (rz - sz) / 19.0;
            double delta = Math.sqrt(1.0E-20 + dx * dx + dy * dy + dz * dz);
            for (n = 0; n < 20; ++n) {
                double x = sx + dx * (double)n;
                double y = sy + dy * (double)n;
                double z = sz + dz * (double)n;
                this.setWorldLocation(x, y, z, true, true);
                this.StraightLineLowerIndexX[n] = this.LowerIndexX;
                this.StraightLineLowerIndexY[n] = this.LowerIndexY;
                this.StraightLineLowerIndexZ[n] = this.LowerIndexZ;
                this.StraightLineUpperIndexX[n] = this.UpperIndexX;
                this.StraightLineUpperIndexY[n] = this.UpperIndexY;
                this.StraightLineUpperIndexZ[n] = this.UpperIndexZ;
                this.StraightLineLowerWeightX[n] = this.LowerWeightX;
                this.StraightLineLowerWeightY[n] = this.LowerWeightY;
                this.StraightLineLowerWeightZ[n] = this.LowerWeightZ;
                this.StraightLineUpperWeightX[n] = this.UpperWeightX;
                this.StraightLineUpperWeightY[n] = this.UpperWeightY;
                this.StraightLineUpperWeightZ[n] = this.UpperWeightZ;
                this.StraightLineLowerIndexValidX[n] = this.LowerIndexValidX;
                this.StraightLineLowerIndexValidY[n] = this.LowerIndexValidY;
                this.StraightLineLowerIndexValidZ[n] = this.LowerIndexValidZ;
                this.StraightLineUpperIndexValidX[n] = this.UpperIndexValidX;
                this.StraightLineUpperIndexValidY[n] = this.UpperIndexValidY;
                this.StraightLineUpperIndexValidZ[n] = this.UpperIndexValidZ;
                this.StraightLineSlowness[n] = (float)this.SlownessAtWorld;
            }
            this.StraightLineTime[0] = 0.0f;
            for (n = 1; n < 20; ++n) {
                double avg = 0.5f * (this.StraightLineSlowness[n - 1] + this.StraightLineSlowness[n]);
                this.StraightLineTime[n] = this.StraightLineTime[n - 1] + (float)(avg * delta);
            }
            this.StraightLineTotalTime = this.StraightLineTime[19];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D(String name) throws Exception {
        try {
            this.read(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D(TomoEikonal3D parentModel) throws Exception {
        try {
            this.m_binSizeHorz = parentModel.binSizeHorz();
            this.m_binSizeVert = parentModel.binSizeVert();
            this.m_inlineAngle = parentModel.inlineAngle();
            this.computeInternals();
            this.m_originX = parentModel.originX();
            this.m_originY = parentModel.originY();
            this.m_originZ = parentModel.originZ();
            this.m_numX = parentModel.numX();
            this.m_numY = parentModel.numY();
            this.m_numZ = parentModel.numZ();
            this.m_forceMarineSurvey = parentModel.forceMarineSurvey();
            this.m_waterVelocity = parentModel.waterVelocity();
            this.checkMem();
            float[][] parentElevation = parentModel.surfaceElevation();
            float[][] parentGridZ = parentModel.surfaceGridZ();
            float[][] parentWaterBottom = parentModel.waterBottomElevation();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_surfaceElevation[x][y] = parentElevation[x][y];
                    this.m_surfaceGridZ[x][y] = parentGridZ[x][y];
                    this.m_waterBottomElevation[x][y] = parentWaterBottom[x][y];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void copySlownessFromParent(TomoEikonal3D parentModel) throws Exception {
        try {
            float[][][] slowness = parentModel.slowness();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = slowness[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void updateParentWeightAndError(TomoEikonal3D parentModel) throws Exception {
        try {
            float[][][] weight = parentModel.weight();
            float[][][] error = parentModel.error();
            float[][][] count = parentModel.count();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        weight[x][y][z] = weight[x][y][z] + this.m_weight[x][y][z];
                        error[x][y][z] = error[x][y][z] + this.m_error[x][y][z];
                        count[x][y][z] = count[x][y][z] + this.m_count[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public TomoEikonal3D(double inlineAngle, double maxDepth, double binSizeHorz, double binSizeVert, boolean allocateMemory, boolean forceMarineSurvey, double waterVelocity) throws Exception {
        try {
            this.m_forceMarineSurvey = forceMarineSurvey;
            this.m_waterVelocity = waterVelocity;
            this.m_binSizeHorz = binSizeHorz;
            this.m_binSizeVert = binSizeVert;
            this.m_inlineAngle = inlineAngle;
            this.computeInternals();
            double minGridX = Double.MAX_VALUE;
            double minGridY = Double.MAX_VALUE;
            double minWorldZ = Double.MAX_VALUE;
            double maxWaterDepth = Double.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double z = table.getDouble(n, indexZ);
                    double waterDepth = 0.0;
                    if (this.m_forceMarineSurvey) {
                        z = 0.0;
                        waterDepth = table.getDouble(n, indexWaterDepth);
                        maxWaterDepth = Math.max(maxWaterDepth, waterDepth);
                    } else {
                        z -= 10.0;
                    }
                    this.setWorldLocation(x, y, z, false, false);
                    minGridX = Math.min(minGridX, this.GridX - this.m_binSizeHorz);
                    minGridY = Math.min(minGridY, this.GridY - this.m_binSizeHorz);
                    minWorldZ = Math.min(minWorldZ, z);
                }
            }
            this.m_originX = this.m_cosineInlineAngle * minGridX - this.m_sineInlineAngle * minGridY;
            this.m_originY = this.m_cosineInlineAngle * minGridY + this.m_sineInlineAngle * minGridX;
            int numMarinesNodes = 0;
            if (this.m_forceMarineSurvey) {
                this.m_originZ = -maxWaterDepth - maxDepth;
                numMarinesNodes = (int)(Math.abs(this.m_originZ) / binSizeVert) + 1;
                this.m_originZ = 0.0 - binSizeVert * (double)(numMarinesNodes - 1);
            } else {
                this.m_originZ = minWorldZ - maxDepth;
                int tempZ = (int)(this.m_originZ / binSizeVert) - 2;
                this.m_originZ = (double)tempZ * binSizeVert;
            }
            int minIndexX = Integer.MAX_VALUE;
            int minIndexY = Integer.MAX_VALUE;
            int maxIndexX = Integer.MIN_VALUE;
            int maxIndexY = Integer.MIN_VALUE;
            int maxIndexZ = Integer.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double z = table.getDouble(n, indexZ);
                    this.setWorldLocation(x, y, false, false);
                    if (!this.LowerIndexValidX) {
                        throw new Exception("LowerIndexValidX == false");
                    }
                    if (!this.LowerIndexValidY) {
                        throw new Exception("LowerIndexValidY == false");
                    }
                    minIndexX = Math.min(minIndexX, this.LowerIndexX);
                    minIndexY = Math.min(minIndexY, this.LowerIndexY);
                    maxIndexX = Math.max(maxIndexX, this.LowerIndexX + 2);
                    maxIndexY = Math.max(maxIndexY, this.LowerIndexY + 1);
                    int nodeZ = (int)((z - this.m_originZ) / this.m_binSizeVert);
                    maxIndexZ = Math.max(maxIndexZ, nodeZ + 1);
                }
            }
            this.m_numX = 1 + maxIndexX - minIndexX;
            this.m_numY = 1 + maxIndexY - minIndexY;
            this.m_numZ = 1 + maxIndexZ;
            if (this.m_forceMarineSurvey) {
                this.m_numZ = numMarinesNodes;
            }
            if (allocateMemory) {
                this.checkMem();
                this.initializeSurface();
                if (this.m_forceMarineSurvey) {
                    this.initializeWaterBottom();
                }
                this.setVelocityGradient(3000.0, 9000.0);
                this.writeResidualsToDatabase();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized History getHistory() {
        return this.m_history;
    }

    public synchronized void prepWaterVelocity() throws Exception {
        try {
            if (!this.forceMarineSurvey()) {
                return;
            }
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float depth = this.m_waterBottomElevation[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        double z = this.m_originZ + (double)iz * this.m_binSizeVert;
                        if (!(z > (double)(-depth))) continue;
                        this.m_slowness[ix][iy][iz] = 1000.0f / (float)this.m_waterVelocity;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized void initializeWaterBottom() throws Exception {
        try {
            Grid3D grid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "WaterDepth", true);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float z;
                    this.setGridLocation(ix, iy, 0);
                    this.m_waterBottomElevation[ix][iy] = z = grid.getNearestValue(this.WorldX, this.WorldY, true);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized void initializeSurface() throws Exception {
        try {
            Grid3D surfGrid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "Elevation", true);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy, 0);
                    float z = surfGrid.getNearestValue(this.WorldX, this.WorldY, true);
                    if (this.m_forceMarineSurvey) {
                        z = 0.0f;
                    }
                    float gridz = (z - (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
                    this.m_surfaceElevation[ix][iy] = z;
                    this.m_surfaceGridZ[ix][iy] = gridz;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized TomoEikonal3DProfile_Anisotropy createNewProfile_Anisotropy() throws Exception {
        try {
            return new TomoEikonal3DProfile_Anisotropy(this.m_binSizeVert, this.m_originZ, this.m_numZ);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized boolean populateProfile_Anisotropy(TomoEikonal3DProfile_Anisotropy profile, double x1, double y1, double x2, double y2) throws Exception {
        try {
            if (!this.anisotropyValid()) {
                throw new Exception("Anisotropy not valid");
            }
            profile.setEndpoints(x1, y1, x2, y2);
            if (profile.MaxValidX < 1) {
                return false;
            }
            double azimuth = Math.atan2(y2 - y1, x2 - x1);
            for (int n = 0; n <= profile.MaxValidX; ++n) {
                this.setWorldLocation(profile.WorldX[n], profile.WorldY[n], true, true);
                profile.GridZ[n] = this.InterpolatedGridZ;
                profile.Elevation[n] = this.InterpolatedElevation;
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    profile.Weight[n][iz] = this.InterpolatedWeight[iz];
                }
                profile.LowerIndexValidX[n] = this.LowerIndexValidX;
                profile.LowerIndexValidY[n] = this.LowerIndexValidY;
                profile.UpperIndexValidX[n] = this.UpperIndexValidX;
                profile.UpperIndexValidY[n] = this.UpperIndexValidY;
                profile.LowerWeightX[n] = this.LowerWeightX;
                profile.LowerWeightY[n] = this.LowerWeightY;
                profile.UpperWeightX[n] = this.UpperWeightX;
                profile.UpperWeightY[n] = this.UpperWeightY;
                profile.LowerIndexX[n] = this.LowerIndexX;
                profile.LowerIndexY[n] = this.LowerIndexY;
                profile.UpperIndexX[n] = this.UpperIndexX;
                profile.UpperIndexY[n] = this.UpperIndexY;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized TomoEikonal3DProfile createNewProfile() throws Exception {
        try {
            return new TomoEikonal3DProfile(this.m_binSizeVert, this.m_originZ, this.m_numZ);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized boolean populateProfile(TomoEikonal3DProfile profile, double x1, double y1, double x2, double y2) throws Exception {
        try {
            profile.setEndpoints(x1, y1, x2, y2);
            if (profile.MaxValidX < 1) {
                return false;
            }
            profile.ForceMarineSurvey = this.forceMarineSurvey();
            for (int n = 0; n <= profile.MaxValidX; ++n) {
                this.setWorldLocation(profile.WorldX[n], profile.WorldY[n], true, true);
                profile.WaterBottomZ[n] = -this.InterpolatedWaterBottom;
                profile.GridZ[n] = this.InterpolatedGridZ;
                profile.Elevation[n] = this.InterpolatedElevation;
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    profile.Slowness[n][iz] = this.InterpolatedSlowness[iz];
                    profile.Weight[n][iz] = this.InterpolatedWeight[iz];
                    profile.Count[n][iz] = this.InterpolatedCount[iz];
                }
                profile.LowerIndexValidX[n] = this.LowerIndexValidX;
                profile.LowerIndexValidY[n] = this.LowerIndexValidY;
                profile.UpperIndexValidX[n] = this.UpperIndexValidX;
                profile.UpperIndexValidY[n] = this.UpperIndexValidY;
                profile.LowerWeightX[n] = this.LowerWeightX;
                profile.LowerWeightY[n] = this.LowerWeightY;
                profile.UpperWeightX[n] = this.UpperWeightX;
                profile.UpperWeightY[n] = this.UpperWeightY;
                profile.LowerIndexX[n] = this.LowerIndexX;
                profile.LowerIndexY[n] = this.LowerIndexY;
                profile.UpperIndexX[n] = this.UpperIndexX;
                profile.UpperIndexY[n] = this.UpperIndexY;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepCoarse(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            double slow;
            double w;
            float wz;
            int z;
            float wy;
            int y;
            float wx;
            int x;
            double sumCount;
            int maxz;
            int maxy;
            int miny;
            int maxx;
            int minx;
            int cy;
            int cx;
            int cz;
            int cy2;
            int cx2;
            int cy3;
            int cx3;
            this.m_coarseRadius = Math.max(4, radiusX);
            this.m_numValidCoarseX = this.m_numX / this.m_coarseRadius;
            if (this.m_numX % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseX;
            }
            this.m_numValidCoarseY = this.m_numY / this.m_coarseRadius;
            if (this.m_numY % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseY;
            }
            int numFunky = 0;
            this.m_range.clearRange();
            double maxCount = 0.0;
            for (cx3 = 0; cx3 < this.m_numValidCoarseX; ++cx3) {
                for (cy3 = 0; cy3 < this.m_numValidCoarseY; ++cy3) {
                    for (int cz2 = 0; cz2 < this.m_numZ; ++cz2) {
                        double sumCount2 = 1.0E-20;
                        double sumSlowness = 0.0;
                        int numNotInAir = 0;
                        if (cx3 == this.m_numValidCoarseX - 1 && cy3 == this.m_numValidCoarseY / 2) {
                            numNotInAir = 0;
                        }
                        this.m_slownessCoarse[cx3][cy3][cz2] = 0.0f;
                        this.m_countCoarse[cx3][cy3][cz2] = 1.0E-20f;
                        int minx2 = cx3 * this.m_coarseRadius;
                        int maxx2 = Math.min(minx2 + this.m_coarseRadius - 1, this.m_numX - 1);
                        int miny2 = cy3 * this.m_coarseRadius;
                        int maxy2 = Math.min(miny2 + this.m_coarseRadius - 1, this.m_numY - 1);
                        int minz = Math.max(cz2 - 0, 0);
                        int maxz2 = Math.min(cz2 + 0, this.m_numZ - 1);
                        for (int x2 = minx2; x2 <= maxx2; ++x2) {
                            for (int y2 = miny2; y2 <= maxy2; ++y2) {
                                for (int z2 = minz; z2 <= maxz2; ++z2) {
                                    if (!((float)z2 <= this.m_surfaceGridZ[x2][y2])) continue;
                                    ++numNotInAir;
                                    double count = this.m_count[x2][y2][z2];
                                    count = count * 0.5 / (double)(0.5f + (float)Math.abs(z2 - cz2));
                                    double slowness = this.m_slowness[x2][y2][z2];
                                    sumSlowness += slowness * count;
                                    sumCount2 += count;
                                }
                            }
                        }
                        this.m_inAirCoarse[cx3][cy3][cz2] = numNotInAir == 0;
                        this.m_slownessCoarse[cx3][cy3][cz2] = (float)(sumSlowness / sumCount2);
                        this.m_countCoarse[cx3][cy3][cz2] = (float)sumCount2;
                        if (sumCount2 > 0.5) {
                            this.m_range.expandRange(1000.0f / this.m_slownessCoarse[cx3][cy3][cz2]);
                        }
                        if (Float.isNaN(this.m_slownessCoarse[cx3][cy3][cz2]) || Float.isInfinite(this.m_slownessCoarse[cx3][cy3][cz2])) {
                            ++numFunky;
                        }
                        maxCount = Math.max(maxCount, sumCount2);
                    }
                }
            }
            this.m_range.print("After initial coarse computation");
            this.m_range.clearRange();
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    initial           =====================");
                for (cx3 = 0; cx3 < 4; ++cx3) {
                    for (cy3 = 0; cy3 < 4; ++cy3) {
                        String s = String.format("%d  %d   %f   %f", cx3, cy3, Float.valueOf(1.0f / this.m_slownessCoarse[cx3][cy3][0]), Float.valueOf(this.m_countCoarse[cx3][cy3][0]));
                        System.out.println(s);
                    }
                }
            }
            float[] courseCount = this.m_countCoarse[this.m_numValidCoarseX / 2][this.m_numValidCoarseY / 2];
            float[] courseSlow = this.m_slownessCoarse[this.m_numValidCoarseX / 2][this.m_numValidCoarseY / 2];
            float minValidCount = 5.0f;
            int minValidZ = this.m_numZ;
            for (int cx4 = 0; cx4 < this.m_numValidCoarseX; ++cx4) {
                for (int cy4 = 0; cy4 < this.m_numValidCoarseY; ++cy4) {
                    for (int cz3 = 0; cz3 < this.m_numZ; ++cz3) {
                        if (!(this.m_countCoarse[cx4][cy4][cz3] > minValidCount)) continue;
                        minValidZ = Math.min(minValidZ, cz3);
                        cz3 = 100000;
                    }
                }
            }
            boolean keepGoing = true;
            int radH = 7;
            int radZ = 0;
            int maxRadH = Math.min(this.m_numValidCoarseX, this.m_numValidCoarseY);
            while (keepGoing) {
                keepGoing = false;
                for (cx2 = 0; cx2 < this.m_numValidCoarseX; ++cx2) {
                    for (cy2 = 0; cy2 < this.m_numValidCoarseY; ++cy2) {
                        for (int cz4 = minValidZ; cz4 < this.m_numZ; ++cz4) {
                            this.m_temp1Coarse[cx2][cy2][cz4] = this.m_slownessCoarse[cx2][cy2][cz4];
                            this.m_temp2Coarse[cx2][cy2][cz4] = this.m_countCoarse[cx2][cy2][cz4];
                        }
                    }
                }
                for (cz = minValidZ; cz < this.m_numZ; ++cz) {
                    for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                        for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                            if (this.m_inAirCoarse[cx][cy][cz] || !(this.m_countCoarse[cx][cy][cz] < minValidCount)) continue;
                            keepGoing = true;
                            minx = Math.max(cx - radH, 0);
                            maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
                            miny = Math.max(cy - radH, 0);
                            maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
                            int minz = Math.max(cz - radZ, minValidZ);
                            maxz = Math.min(cz + radZ, this.m_numZ - 1);
                            sumCount = 1.0E-20;
                            double sumSlow = 0.0;
                            for (x = minx; x <= maxx; ++x) {
                                wx = 1.5f / (0.5f + (float)Math.abs(x - cx));
                                for (y = miny; y <= maxy; ++y) {
                                    wy = 1.5f / (0.5f + (float)Math.abs(y - cy));
                                    for (z = minz; z <= maxz; ++z) {
                                        wz = 1.5f / (0.5f + (float)Math.abs(z - cz));
                                        if (this.m_inAirCoarse[x][y][z] || !(this.m_temp2Coarse[x][y][z] > 0.5f * minValidCount)) continue;
                                        w = wx * wy * wz * this.m_temp2Coarse[x][y][z];
                                        slow = this.m_temp1Coarse[x][y][z];
                                        sumSlow += w * slow;
                                        sumCount += w;
                                    }
                                }
                            }
                            if (!(sumCount >= (double)minValidCount)) continue;
                            this.m_slownessCoarse[cx][cy][cz] = (float)(sumSlow / sumCount);
                            this.m_countCoarse[cx][cy][cz] = 1.01f * minValidCount;
                            this.m_range.expandRange(1000.0f / this.m_slownessCoarse[cx][cy][cz]);
                            if (Math.abs(this.m_slownessCoarse[cx][cy][cz]) < 1.0E-5f) {
                                ++numFunky;
                            }
                            if (!Float.isNaN(this.m_slownessCoarse[cx][cy][cz]) && !Float.isInfinite(this.m_slownessCoarse[cx][cy][cz])) continue;
                            ++numFunky;
                        }
                    }
                }
                if ((radH += 6) >= maxRadH) {
                    radH = 10;
                    ++radZ;
                }
                System.out.println("end of keep going " + radH + "  " + radZ);
            }
            radH = 5;
            for (cz = minValidZ - 1; cz >= 0; --cz) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        if (this.m_inAirCoarse[cx][cy][cz]) continue;
                        minx = Math.max(cx - radH, 0);
                        maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
                        miny = Math.max(cy - radH, 0);
                        maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
                        double sumCount3 = 1.0E-20;
                        double sumSlow = 0.0;
                        for (int x3 = minx; x3 <= maxx; ++x3) {
                            float wx2 = 1.0f / (1.0f + (float)Math.abs(x3 - cx));
                            for (int y3 = miny; y3 <= maxy; ++y3) {
                                float wy2 = 1.0f / (1.0f + (float)Math.abs(y3 - cy));
                                if (this.m_inAirCoarse[x3][y3][cz + 1]) continue;
                                double w2 = wx2 * wy2 * this.m_temp2Coarse[x3][y3][cz + 1];
                                double slow2 = 0.995f * this.m_temp1Coarse[x3][y3][cz];
                                sumSlow += w2 * slow2;
                                sumCount3 += w2;
                            }
                        }
                        this.m_slownessCoarse[cx][cy][cz] = (float)(sumSlow / sumCount3);
                        this.m_countCoarse[cx][cy][cz] = 1.01f * minValidCount;
                        if (Math.abs(this.m_slownessCoarse[cx][cy][cz]) < 1.0E-5f) {
                            ++numFunky;
                        }
                        if (!Float.isNaN(this.m_slownessCoarse[cx][cy][cz]) && !Float.isInfinite(this.m_slownessCoarse[cx][cy][cz])) continue;
                        ++numFunky;
                    }
                }
            }
            this.m_range.print("After keepGoing");
            this.m_range.clearRange();
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after filling dead    =================");
                for (cx2 = 0; cx2 < 4; ++cx2) {
                    for (cy2 = 0; cy2 < 4; ++cy2) {
                        String s = String.format("%d  %d   %f   %f", cx2, cy2, Float.valueOf(1.0f / this.m_slownessCoarse[cx2][cy2][0]), Float.valueOf(this.m_countCoarse[cx2][cy2][0]));
                        System.out.println(s);
                    }
                }
            }
            for (cz = 0; cz < this.m_numZ; ++cz) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy5 = 0; cy5 < this.m_numValidCoarseY; ++cy5) {
                        if (this.m_inAirCoarse[cx][cy5][cz]) continue;
                        minx = Math.max(cx - 2, 0);
                        maxx = Math.min(cx + 2, this.m_numValidCoarseX - 1);
                        miny = Math.max(cy5 - 2, 0);
                        maxy = Math.min(cy5 + 2, this.m_numValidCoarseY - 1);
                        int minz = Math.max(cz - 1, 0);
                        maxz = Math.min(cz + 1, this.m_numZ - 1);
                        sumCount = 1.0E-20;
                        double sumSlow = 0.0;
                        for (x = minx; x <= maxx; ++x) {
                            wx = 0.5f / (0.5f + (float)Math.abs(x - cx));
                            for (y = miny; y <= maxy; ++y) {
                                wy = 0.5f / (0.5f + (float)Math.abs(y - cy5));
                                for (z = minz; z <= maxz; ++z) {
                                    wz = 0.1f / (0.1f + (float)Math.abs(z - cz));
                                    if (this.m_inAirCoarse[x][y][z]) continue;
                                    w = wx * wy * wz * this.m_countCoarse[x][y][z];
                                    slow = this.m_slownessCoarse[x][y][z];
                                    sumSlow += w * slow;
                                    sumCount += w;
                                }
                            }
                        }
                        if (sumSlow < (double)0.1f) {
                            ++numFunky;
                        }
                        this.m_temp1Coarse[cx][cy5][cz] = (float)(sumSlow / sumCount);
                        this.m_range.expandRange(1000.0f / this.m_temp1Coarse[cx][cy5][cz]);
                    }
                }
            }
            this.m_range.print("After smoothing coarse");
            this.m_range.clearRange();
            double sumCount4 = 0.0;
            for (int cz5 = 0; cz5 < this.m_numZ; ++cz5) {
                for (int cx5 = 0; cx5 < this.m_numValidCoarseX; ++cx5) {
                    for (int cy6 = 0; cy6 < this.m_numValidCoarseY; ++cy6) {
                        sumCount4 += (double)this.m_slownessCoarse[cx5][cy6][cz5];
                        this.m_slownessCoarse[cx5][cy6][cz5] = this.m_temp1Coarse[cx5][cy6][cz5];
                    }
                }
            }
            this.m_averageCoarseWeight = (float)(sumCount4 / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
            this.m_averageCoarseCount = (float)(sumCount4 / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after smoothing   =====================");
                for (int cx6 = 0; cx6 < 4; ++cx6) {
                    for (int cy7 = 0; cy7 < 4; ++cy7) {
                        String s = String.format("%d  %d   %f   %f", cx6, cy7, Float.valueOf(1.0f / this.m_slownessCoarse[cx6][cy7][0]), Float.valueOf(this.m_countCoarse[cx6][cy7][0]));
                        System.out.println(s);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void freeInterpolator() {
        try {
            this.m_interpolator = null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void smooth_basic(int radiusX, int radiusZ) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        double sum1 = 0.0;
                        double sum2 = 1.0E-20;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - radiusZ, 0);
                        int maxz = Math.min(z + radiusZ, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    if (!((float)iz <= this.m_surfaceGridZ[ix][iy])) continue;
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    double w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    double s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        if (!(sum2 > 1.0)) continue;
                        this.m_slowness[x][y][z] = (float)(sum1 / sum2);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void smooth_external(int radiusX, int radiusZ) {
        try {
            int z;
            int y;
            int x;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        this.m_error[x][y][z] = this.m_slowness[x][y][z];
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                        double sum1 = 0.0;
                        double sum2 = 1.0E-20;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - radiusZ, 0);
                        int maxz = Math.min(z + radiusZ, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    if (!((float)iz <= this.m_surfaceGridZ[ix][iy])) continue;
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    double w = wx * wy * wz;
                                    double s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        if (!(sum2 > 1.0)) continue;
                        this.m_slowness[x][y][z] = (float)(sum1 / sum2);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void setLayerVel(double z1, double v1, double z2, double v2, Java2D_Polygon poly) {
        try {
            float s1 = (float)(1000.0 / v1);
            float s2 = (float)(1000.0 / v2);
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    boolean ok = true;
                    if (poly != null) {
                        this.setGridLocation(x, y, 0);
                        ok = poly.contains(this.WorldX, this.WorldY);
                    }
                    if (!ok) continue;
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double elev = this.m_originZ + (double)z * this.m_binSizeVert;
                        if (!(elev >= z1) || !(elev <= z2)) continue;
                        this.m_slowness[x][y][z] = s1 + (s2 - s1) * (float)(elev - z1) / (float)(z2 - z1);
                    }
                }
            }
            this.prepareAirSlowness();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void smooth_Weight(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            int z;
            int y;
            int x;
            this.prepCoarse(radiusX, radiusZ, useweight, usedistance);
            double sumWeight = 0.0;
            for (int x2 = 0; x2 < this.m_numX; ++x2) {
                for (int y2 = 0; y2 < this.m_numY; ++y2) {
                    for (int z2 = 0; z2 < this.m_numZ; ++z2) {
                        sumWeight += (double)this.m_weight[x2][y2][z2];
                    }
                }
            }
            this.m_averageWeight = (float)(sumWeight / (double)(this.m_numX * this.m_numY * this.m_numZ));
            float scalar = this.m_averageWeight / this.m_averageCoarseWeight;
            float fractionCoarse = 0.5f;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        int cx = x / this.m_coarseRadius;
                        int cy = y / this.m_coarseRadius;
                        double coarseWeight = scalar * this.m_countCoarse[cx][cy][z];
                        double coarseSlow = this.m_slownessCoarse[cx][cy][z];
                        double fineWeight = this.m_weight[x][y][z];
                        double fineSlow = this.m_slowness[x][y][z];
                        coarseWeight = (double)fractionCoarse * coarseWeight;
                        fineWeight = (double)(1.0f - fractionCoarse) * fineWeight;
                        double slow = (coarseWeight * coarseSlow + fineWeight * fineSlow) / (coarseWeight + fineWeight);
                        this.m_weight[x][y][z] = (float)(coarseWeight + fineWeight);
                        this.m_error[x][y][z] = (float)slow;
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        double sum1 = 0.0;
                        double sum2 = 1.0E-20;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - 0, 0);
                        int maxz = Math.min(z + 0, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    double w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    double s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        this.m_slowness[x][y][z] = (float)(sum1 / sum2);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void smoothPlane(int z, int radius, boolean useweight, boolean usedistance) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_tempPlane1[x][y] = this.m_slowness[x][y][z];
                    this.m_tempPlane2[x][y] = 1.0E-7f + this.m_weight[x][y][z];
                }
            }
            boolean test = false;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int minx = Math.max(x - radius, 0);
                    int maxx = Math.min(x + radius, this.m_numX - 1);
                    int miny = Math.max(y - radius, 0);
                    int maxy = Math.min(y + radius, this.m_numY - 1);
                    if (x == 30 && y == 30) {
                        test = true;
                    }
                    double s1 = 0.0;
                    double s2 = 1.0E-10;
                    for (int ix = minx; ix <= maxx; ++ix) {
                        for (int iy = miny; iy <= maxy; ++iy) {
                            double w = 1.0;
                            if (useweight) {
                                w = this.m_tempPlane2[ix][iy];
                            }
                            if (usedistance) {
                                float dx = Math.abs(x - ix);
                                float dy = Math.abs(y - iy);
                                w /= (double)(1.0f + dx + dy);
                            }
                            s1 += w * (double)this.m_tempPlane1[ix][iy];
                            s2 += w;
                        }
                    }
                    this.m_slowness[x][y][z] = (float)(s1 / s2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromStraightLine(float pick, float offsetWeight) {
        try {
            if (pick < 5.0f) {
                return;
            }
            double timeError = Math.abs((double)pick - this.StraightLineTotalTime);
            double timeWeight = (double)this.WeightTime / ((double)this.WeightTime + timeError);
            double weight = 100.0 * timeWeight * (double)(offsetWeight = Math.max(offsetWeight, 0.01f));
            if (weight < (double)this.MinimumValidTotalWeight) {
                return;
            }
            double frac = this.StraightLineTotalTime / (double)pick;
            frac = Math.max((double)0.67f, frac);
            frac = Math.min((double)1.33f, frac);
            for (int n = 0; n < 20; ++n) {
                double wx = this.StraightLineLowerWeightX[n];
                double wy = this.StraightLineLowerWeightY[n];
                double wz = this.StraightLineLowerWeightZ[n];
                int x = this.StraightLineLowerIndexX[n];
                int y = this.StraightLineLowerIndexY[n];
                int z = this.StraightLineLowerIndexZ[n];
                double w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray = this.m_count[x][y];
                int n2 = z;
                fArray[n2] = (float)((double)fArray[n2] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray2 = this.m_count[x][y];
                int n3 = z;
                fArray2[n3] = (float)((double)fArray2[n3] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray3 = this.m_count[x][y];
                int n4 = z;
                fArray3[n4] = (float)((double)fArray3[n4] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineLowerWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineLowerIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray4 = this.m_count[x][y];
                int n5 = z;
                fArray4[n5] = (float)((double)fArray4[n5] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray5 = this.m_count[x][y];
                int n6 = z;
                fArray5[n6] = (float)((double)fArray5[n6] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray6 = this.m_count[x][y];
                int n7 = z;
                fArray6[n7] = (float)((double)fArray6[n7] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray7 = this.m_count[x][y];
                int n8 = z;
                fArray7[n8] = (float)((double)fArray7[n8] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = this.StraightLineUpperWeightZ[n];
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = this.StraightLineUpperIndexZ[n];
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray8 = this.m_count[x][y];
                int n9 = z;
                fArray8[n9] = (float)((double)fArray8[n9] + frac);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromProfile(TomoEikonal3DProfile profile, float pick, float offsetWeight, int sprayZ, float scalarSprayZ) {
        try {
            if (pick < 5.0f) {
                return;
            }
            int numPath = profile.NumPathPoints;
            int[] pathIndexX = profile.PathIndexX;
            int[] pathIndexZ = profile.PathIndexZ;
            sprayZ = Math.max(0, sprayZ);
            scalarSprayZ = Math.max(0.05f, scalarSprayZ);
            double timeError = Math.abs((double)pick - profile.ReceiverTime);
            double timeWeight = (double)this.WeightTime / ((double)this.WeightTime + timeError);
            double weight = 100.0 * timeWeight * (double)(offsetWeight = Math.max(offsetWeight, 0.01f));
            if (weight < (double)this.MinimumValidTotalWeight) {
                return;
            }
            double frac = profile.ReceiverTime / (double)pick;
            frac = Math.max((double)0.67f, frac);
            frac = Math.min((double)1.33f, frac);
            for (int p = 0; p < numPath; ++p) {
                double w;
                double wz;
                int z;
                double wy;
                double wx;
                int y;
                int x;
                int px = profile.PathIndexX[p];
                int pz = profile.PathIndexZ[p];
                int zmin = Math.max(pz - sprayZ, 0);
                int zmax = Math.min(pz + sprayZ, this.m_numZ - 1);
                if (profile.LowerIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    x = profile.LowerIndexX[px];
                    y = profile.LowerIndexY[px];
                    wx = profile.LowerWeightX[px];
                    wy = profile.LowerWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        if (x < 0 || y < 0) {
                            w = 1.0E-4f;
                        }
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = (float)((double)fArray[n] + wz * frac);
                    }
                }
                if (profile.LowerIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    x = profile.LowerIndexX[px];
                    y = profile.UpperIndexY[px];
                    wx = profile.LowerWeightX[px];
                    wy = profile.UpperWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = (float)((double)fArray[n] + wz * frac);
                    }
                }
                if (profile.UpperIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    x = profile.UpperIndexX[px];
                    y = profile.UpperIndexY[px];
                    wx = profile.UpperWeightX[px];
                    wy = profile.UpperWeightY[px];
                    z = zmin;
                    while (z <= zmax) {
                        wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                        w = wx * wy * weight * wz;
                        this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                        this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                        float[] fArray = this.m_count[x][y];
                        int n = z++;
                        fArray[n] = (float)((double)fArray[n] + wz * frac);
                    }
                }
                if (!profile.UpperIndexValidX[px] || !profile.LowerIndexValidY[px]) continue;
                x = profile.UpperIndexX[px];
                y = profile.LowerIndexY[px];
                wx = profile.UpperWeightX[px];
                wy = profile.LowerWeightY[px];
                z = zmin;
                while (z <= zmax) {
                    wz = scalarSprayZ / (scalarSprayZ + (float)Math.abs(z - pz));
                    w = wx * wy * weight * wz;
                    this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                    this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                    float[] fArray = this.m_count[x][y];
                    int n = z++;
                    fArray[n] = (float)((double)fArray[n] + wz * frac);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void finishUpdate(int smoothH, int smoothZ, float extrapolateDown, float extrapolateUp, float fractionCoarse, int totalIterations, int currentIteration, float maxPercentChange) {
        try {
            float maxFracChange = 1.0f + maxPercentChange / 100.0f;
            float minFracChange = 1.0f / maxFracChange;
            double weightSum = 0.0;
            double countMax = 0.0;
            double countSum = 0.0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    float[] slowness = this.m_slowness[x][y];
                    float[] weight = this.m_weight[x][y];
                    float[] error = this.m_error[x][y];
                    float[] count = this.m_count[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        countMax = Math.max(countMax, (double)count[z]);
                        countSum += (double)count[z];
                        if (!(weight[z] > 1.0E-4f)) continue;
                        weightSum += (double)weight[z];
                        double frac = error[z] / weight[z];
                        frac = Math.max((double)minFracChange, frac);
                        frac = Math.min((double)maxFracChange, frac);
                        double newSlowness = (double)slowness[z] / frac;
                        double change = newSlowness - (double)slowness[z];
                        slowness[z] = slowness[z] + (float)(0.6 * change);
                    }
                }
            }
            double averageWeight = weightSum / (double)(this.m_numX * this.m_numY * this.m_numZ);
            if (this.m_interpolator == null) {
                this.m_interpolator = new TomoEikonal3D_Interpolator();
                this.m_interpolator.prepare(this, 3, totalIterations);
            }
            this.m_interpolator.smooth(smoothH, smoothZ, fractionCoarse, currentIteration);
            this.prepareAirSlowness();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void printAverages() {
        try {
            double sums = 0.0;
            double sumw = 0.0;
            double sumc = 0.0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        sums += (double)this.m_slowness[x][y][z];
                        sumw += (double)this.m_weight[x][y][z];
                        sumc += (double)this.m_count[x][y][z];
                    }
                }
            }
            double avgs = sums / (double)(this.m_numX * this.m_numY * this.m_numZ);
            double avgw = sumw / (double)(this.m_numX * this.m_numY * this.m_numZ);
            double avgc = sumc / (double)(this.m_numX * this.m_numY * this.m_numZ);
            String s = String.format("printAverages:   Average s = %f  w = %f  c = %f", avgs, avgw, avgc);
            System.out.println(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void prepUpdate() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_weight[x][y][z] = 0.0f;
                        this.m_error[x][y][z] = 0.0f;
                        this.m_count[x][y][z] = 0.0f;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized Grid3D getEmptyGrid3D() throws Exception {
        try {
            Grid3D_Conversion gc = new Grid3D_Conversion();
            gc.setBinSize(this.m_binSizeHorz, this.m_binSizeHorz);
            gc.setInlineAngle(this.m_inlineAngle);
            gc.setOrigin(this.m_originX, this.m_originY);
            gc.setBinCounts(this.m_numX, this.m_numY);
            Grid3D grid = new Grid3D(gc);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getWaterBottomGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_waterBottomElevation[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getSurfaceGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_surfaceElevation[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected synchronized double velAtDepth(float depth, int ix, int iy) {
        try {
            int maxIndex = (int)this.m_surfaceGridZ[ix][iy];
            float z = this.m_surfaceElevation[ix][iy] - depth;
            float indexFloat = (z -= (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
            int index = (int)indexFloat;
            float[] slowness = this.m_slowness[ix][iy];
            if (index >= maxIndex) {
                return 1000.0f / slowness[maxIndex];
            }
            if (indexFloat <= 0.0f) {
                return 1000.0f / slowness[0];
            }
            if (index >= 0 && index < maxIndex) {
                double frac = indexFloat - (float)index;
                double v1 = 1000.0f / slowness[index];
                double v2 = 1000.0f / slowness[index + 1];
                double v = frac * v2 + (1.0 - frac) * v1;
                return v;
            }
            return -9999.0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    protected synchronized double countAtDepth(float depth, int ix, int iy) {
        try {
            int maxIndex = (int)this.m_surfaceGridZ[ix][iy];
            float z = this.m_surfaceElevation[ix][iy] - depth;
            float indexFloat = (z -= (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
            int index = (int)indexFloat;
            float[] count = this.m_count[ix][iy];
            if (index >= maxIndex) {
                return count[maxIndex];
            }
            if (indexFloat <= 0.0f) {
                return count[0];
            }
            if (index >= 0 && index < maxIndex) {
                double frac = indexFloat - (float)index;
                double c1 = count[index];
                double c2 = count[index + 1];
                double c = frac * c2 + (1.0 - frac) * c1;
                return c;
            }
            return -9999.0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public synchronized void computeWeatheringVelocity(float depth, boolean updateZ) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int numDead = 0;
            numDead += this.computeWeatheringVelocity(p.shotTable(), depth);
            if ((numDead += this.computeWeatheringVelocity(p.receiverTable(), depth)) > 0) {
                Tools_RefractionStaticsProject tools = new Tools_RefractionStaticsProject();
                tools.interpolateBadValuesUsingInverseFourth(Pecos.getColNameVel(0), 100.0, 20000.0);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), Pecos.getColNameVel(0));
            RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Set weathering velocity using tomo model");
            RefractionStaticsProject.delayTimeData().getHistory().save();
            if (updateZ) {
                DelayTimeModel.singleton().computeRefractorElevations(p.receiverTable());
                DelayTimeModel.singleton().computeRefractorElevations(p.shotTable());
                RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Recompute refractor elevations");
                RefractionStaticsProject.delayTimeData().getHistory().save();
            }
            try {
                this.getHistory().addWithTime("Computed weathering velocity:");
                this.getHistory().add("Depth = " + Double.toString(depth));
                this.getHistory().add("Update refractor elevation = " + Boolean.toString(updateZ));
                this.getHistory().save();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized int computeWeatheringVelocity(Table_Abstract table, float depth) {
        try {
            int indexDead = table.column_indexOfColumn("Killed");
            int indexV0 = table.column_indexOfColumn(Pecos.getColNameVel(0));
            int indexV1 = table.column_indexOfColumn(Pecos.getColNameVel(1));
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int numDead = 0;
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexDead)) {
                    table.putDouble(n, indexV0, -9999.0);
                    ++numDead;
                    continue;
                }
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                this.setWorldLocation(x, y, z - (double)depth, true, true);
                double v0 = 1000.0 / Math.max(this.SlownessAtWorld, (double)1.0E-4f);
                double v1 = table.getDouble(n, indexV1);
                v0 = Math.min(v0, 0.8 * v1);
                v0 = Math.max(v0, 0.15 * v1);
                table.putDouble(n, indexV0, v0);
            }
            return numDead;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public synchronized Grid3D getMinValidElevationGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 0.0f;
                    int iz = 0;
                    while ((float)iz < this.m_surfaceGridZ[ix][iy]) {
                        if (this.m_count[ix][iy][iz] > 0.5f) {
                            data[ix][iy] = (float)(this.m_originZ + this.m_binSizeVert * (double)iz);
                            iz = 100000;
                        }
                        ++iz;
                    }
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getValidDepthGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 0.0f;
                    int iz = 0;
                    while ((float)iz < this.m_surfaceGridZ[ix][iy]) {
                        if (this.m_count[ix][iy][iz] > 0.5f) {
                            data[ix][iy] = (float)(this.m_binSizeVert * (double)(this.m_surfaceGridZ[ix][iy] - (float)iz));
                            iz = 100000;
                        }
                        ++iz;
                    }
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getCountAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = (float)this.countAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getVelocityAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = (float)this.velAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getVelocityAtElevationGrid3D(int z) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            z = Math.max(z, 0);
            z = Math.min(z, this.m_numZ - 1);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 1000.0f / this.m_slowness[ix][iy][z];
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized Grid3D getWeightAtElevationGrid3D(int z) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            z = Math.max(z, 0);
            z = Math.min(z, this.m_numZ - 1);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_weight[ix][iy][z];
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized void writeResidualsToDatabase() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.writeResidualsToDatabase(this.SourceHash, p.shotTable(), "ShotID");
            this.writeResidualsToDatabase(this.ReceiverHash, p.receiverTable(), "ReceiverID");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void writeResidualsToDatabase(HashMap_Integers<Element> hash, Table_Abstract table, String idname) {
        try {
            int indexID = table.column_indexOfColumn(idname);
            int indexError = table.column_append("Tomo3D_TotalError", DataType.Double);
            int indexResidual = table.column_append("Tomo3D_ResidualError", DataType.Double);
            int numBad = 0;
            for (int n = 0; n < table.row_count(); ++n) {
                table.putDouble(n, indexError, 0.0);
                table.putDouble(n, indexResidual, 0.0);
                int id = table.getInt(n, indexID);
                if (hash.containsKey(id)) {
                    Element e = hash.get(id);
                    table.putDouble(n, indexError, e.Error);
                    table.putDouble(n, indexResidual, e.Residual);
                    continue;
                }
                ++numBad;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.geometryDatabase().writeColumnContentsToDatabase(table, "Tomo3D_TotalError");
            p.geometryDatabase().writeColumnContentsToDatabase(table, "Tomo3D_ResidualError");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void readArray3D(float[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                raf.read(ba.array(), 0, num);
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        arr[x][y][z] = ba.getFloat(n);
                        n += 4;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void readArray3D(double[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                raf.read(ba.array(), 0, num);
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        arr[x][y][z] = ba.getFloat(n);
                        n += 4;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void read(String modelName) {
        try {
            this.m_name = modelName;
            String tomoPath = RefractionStaticsProject.singleton().eikonal3DProjectsPath();
            String fullPath = tomoPath + "/" + modelName;
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = raf.readInt();
            int version = raf.readInt();
            if (magic != 8300129) {
                raf.close();
                return;
            }
            if (version == 1002) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
                this.readArray3D(this.m_count, raf);
            }
            if (version == 1001) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
            }
            if (version == 1000) {
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                this.readArray3D(this.m_slowness, raf);
                this.readArray3D(this.m_weight, raf);
                this.readArray3D(this.m_error, raf);
            }
            raf.close();
            if (Tools_FileSystem.exists_file(this.m_waterBottomFileName)) {
                raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
                magic = raf.readInt();
                version = raf.readInt();
                if (magic != 5537222) {
                    raf.close();
                    return;
                }
                if (version == 1000) {
                    this.readGrid(raf, this.m_waterBottomElevation);
                }
                raf.close();
            }
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = raf.readInt();
            version = raf.readInt();
            if (magic != 334534534) {
                raf.close();
                return;
            }
            if (version == 1000) {
                this.readGrid(raf, this.m_surfaceElevation);
                this.readGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.readElement(this.ReceiverHash, this.m_recFileName);
            this.readElement(this.SourceHash, this.m_srcFileName);
            this.writeResidualsToDatabase();
            this.m_historyFileName = fullPath + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
            this.readAnisotropy(fullPath);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void saveArray3D(float[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        ba.putFloat(n, arr[x][y][z]);
                        n += 4;
                    }
                }
                raf.write(ba.array(), 0, num);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void saveArray3D(double[][][] arr, RandomAccessFile raf) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            for (int z = 0; z < this.m_numZ; ++z) {
                int n = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        ba.putFloat(n, (float)arr[x][y][z]);
                        n += 4;
                    }
                }
                raf.write(ba.array(), 0, num);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void save(String modelName) {
        try {
            this.m_name = modelName;
            String tomoPath = RefractionStaticsProject.singleton().eikonal3DProjectsPath();
            Object fullPath = tomoPath + "/" + modelName;
            Tools_FileSystem.deletePathIfExists((String)fullPath);
            fullPath = Tools_FileSystem.confirmSubDirectoryExists(tomoPath, modelName);
            this.m_gridFileName = (String)fullPath + "/Model.slowness";
            this.m_surfaceFileName = (String)fullPath + "/Model.surface";
            this.m_waterBottomFileName = (String)fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = 8300129;
            int version = 1002;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1002) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
                this.saveArray3D(this.m_count, raf);
            }
            if (version == 1001) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
            }
            if (version == 1000) {
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                this.saveArray3D(this.m_slowness, raf);
                this.saveArray3D(this.m_weight, raf);
                this.saveArray3D(this.m_error, raf);
            }
            raf.close();
            raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
            magic = 5537222;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_waterBottomElevation);
            }
            raf.close();
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = 334534534;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_surfaceElevation);
                this.saveGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = (String)fullPath + "/Model.shots";
            this.m_recFileName = (String)fullPath + "/Model.receivers";
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = (String)fullPath + "/History.txt";
            if (this.getHistory() == null) {
                this.m_history = new History(this.m_historyFileName);
                this.getHistory().addWithTime("Model created");
                this.getHistory().save();
            } else {
                this.getHistory().save();
            }
            this.saveAnisotropy((String)fullPath);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void saveAnisotropy(String fullPath) {
        try {
            this.m_anisotropyFileName = fullPath + "/Model.anisotropy";
            if (!this.m_anisotropyValid) {
                Tools_FileSystem.deleteFile(this.m_anisotropyFileName);
            } else {
                RandomAccessFile raf = new RandomAccessFile(this.m_anisotropyFileName, "rw");
                int magic = 123098;
                int version = 1000;
                raf.writeInt(magic);
                raf.writeInt(version);
                if (version == 1000) {
                    int y;
                    int x;
                    int n;
                    int z;
                    raf.writeInt(this.m_anisotropyChunkSize);
                    raf.writeInt(this.m_anisotropyNumX);
                    raf.writeInt(this.m_anisotropyNumY);
                    int num = 4 * this.m_anisotropyNumX * this.m_anisotropyNumY;
                    ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
                    for (z = 0; z < this.m_numZ; ++z) {
                        n = 0;
                        for (x = 0; x < this.m_anisotropyNumX; ++x) {
                            for (y = 0; y < this.m_anisotropyNumY; ++y) {
                                ba.putFloat(n, this.m_anisFraction[x][y][z]);
                                n += 4;
                            }
                        }
                        raf.write(ba.array(), 0, num);
                    }
                    for (z = 0; z < this.m_numZ; ++z) {
                        n = 0;
                        for (x = 0; x < this.m_anisotropyNumX; ++x) {
                            for (y = 0; y < this.m_anisotropyNumY; ++y) {
                                ba.putFloat(n, this.m_anisFastAzimuth[x][y][z]);
                                n += 4;
                            }
                        }
                        raf.write(ba.array(), 0, num);
                    }
                }
                raf.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void readAnisotropy(String fullPath) {
        try {
            this.m_anisotropyValid = false;
            this.m_anisFraction = null;
            this.m_anisFastAzimuth = null;
            this.m_anisotropyFileName = fullPath + "/Model.anisotropy";
            if (!Tools_FileSystem.exists_file(this.m_anisotropyFileName)) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(this.m_anisotropyFileName, "rw");
            int magic = raf.readInt();
            if (magic != 123098) {
                return;
            }
            int version = raf.readInt();
            if (version == 1000) {
                int y;
                int x;
                int n;
                int z;
                this.m_anisotropyChunkSize = raf.readInt();
                this.m_anisotropyNumX = raf.readInt();
                this.m_anisotropyNumY = raf.readInt();
                this.m_anisFraction = new float[this.m_anisotropyNumX][this.m_anisotropyNumY][this.m_numZ];
                this.m_anisFastAzimuth = new float[this.m_anisotropyNumX][this.m_anisotropyNumY][this.m_numZ];
                int num = 4 * this.m_anisotropyNumX * this.m_anisotropyNumY;
                ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
                for (z = 0; z < this.m_numZ; ++z) {
                    raf.read(ba.array(), 0, num);
                    n = 0;
                    for (x = 0; x < this.m_anisotropyNumX; ++x) {
                        for (y = 0; y < this.m_anisotropyNumY; ++y) {
                            this.m_anisFraction[x][y][z] = ba.getFloat(n);
                            n += 4;
                        }
                    }
                }
                for (z = 0; z < this.m_numZ; ++z) {
                    raf.read(ba.array(), 0, num);
                    n = 0;
                    for (x = 0; x < this.m_anisotropyNumX; ++x) {
                        for (y = 0; y < this.m_anisotropyNumY; ++y) {
                            this.m_anisFastAzimuth[x][y][z] = ba.getFloat(n);
                            n += 4;
                        }
                    }
                }
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void readElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            hash.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = raf.readInt();
            if (magic != 244) {
                return;
            }
            int version = raf.readInt();
            int count = raf.readInt();
            for (int n = 0; n < count; ++n) {
                Element e = new Element(raf, version);
                hash.put(e, e.ID);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void saveElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = 244;
            int version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            raf.writeInt(hash.size());
            for (Element e : hash.getValues()) {
                e.save(raf, version);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void saveGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    ba.putFloat(i, grid[ix][iy]);
                    i += 4;
                }
            }
            raf.write(ba.array(), 0, num);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void readGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            raf.read(ba.array(), 0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    grid[ix][iy] = ba.getFloat(i);
                    i += 4;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void checkMem() {
        try {
            if (this.m_slowness == null) {
                this.m_slowness = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_weight = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_error = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_count = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_waterBottomElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceGridZ = new float[this.m_numX][this.m_numY];
                this.InterpolatedSlowness = new float[this.m_numZ];
                this.InterpolatedWeight = new float[this.m_numZ];
                this.InterpolatedCount = new float[this.m_numZ];
                this.m_tempPlane1 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane2 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane3 = new float[this.m_numX][this.m_numY];
                this.m_numCoarseX = 1 + this.m_numX / 4;
                this.m_numCoarseY = 1 + this.m_numY / 4;
                this.m_slownessCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_countCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp1Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp2Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_inAirCoarse = new boolean[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_tempCoarse1 = new float[this.m_numCoarseX][this.m_numCoarseY];
                this.m_tempCoarse2 = new float[this.m_numCoarseX][this.m_numCoarseY];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void forceIncreasingVelocity(float frac) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    for (int z = maxIndex = Math.min(maxIndex, this.m_numZ - 1); z >= 1; --z) {
                        double currentVelocity = 1000.0f / this.m_slowness[x][y][z - 1];
                        double minimumPreferredVelocity = frac * 1000.0f / this.m_slowness[x][y][z];
                        if (!(currentVelocity < minimumPreferredVelocity)) continue;
                        this.m_slowness[x][y][z - 1] = (float)(1000.0 / minimumPreferredVelocity);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void prepareAirSlowness() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    if ((maxIndex = Math.min(maxIndex, this.m_numZ - 1)) + 1 < this.m_numZ) {
                        this.m_slowness[x][y][maxIndex + 1] = this.m_slowness[x][y][maxIndex];
                    }
                    for (int z = maxIndex + 2; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = 1.1f * this.m_slowness[x][y][maxIndex];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void computeVelocityUsingPicks(int method) throws Exception {
        try {
            this.checkMem();
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            double depth = this.m_binSizeVert * (double)(this.m_numZ - 1);
            double inc = 0.25 * this.m_binSizeVert;
            pc.prepTempData(depth, inc);
            double[] vel = new double[this.m_numZ];
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy, 0);
                    if (method == 1) {
                        float[] slowness = this.m_slowness[ix][iy];
                        pc.computeElevationProfile(this.WorldX, this.WorldY, this.m_originZ, this.m_binSizeVert, vel);
                        for (int iz = 0; iz < this.m_numZ; ++iz) {
                            slowness[iz] = (float)(1000.0 / vel[iz]);
                        }
                    }
                    if (method != 0) continue;
                    pc.computeInterpolatedProfile(this.WorldX, this.WorldY);
                    double[] v = pc.TempProfile;
                    double delta = pc.tempSize();
                    float[] slowness = this.m_slowness[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        int index;
                        double binDepth = (double)(this.m_surfaceGridZ[ix][iy] - (float)iz) * this.m_binSizeVert;
                        slowness[iz] = binDepth <= 0.0 ? (float)(1000.0 / v[0]) : ((index = (int)(binDepth / inc)) < v.length ? (float)(1000.0 / v[index]) : (float)(1000.0 / v[v.length - 1]));
                    }
                }
            }
            this.smooth_basic(6, 1);
            this.prepareAirSlowness();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void setVelocityGradient(double v1, double v2) throws Exception {
        try {
            this.checkMem();
            if (this.m_forceMarineSurvey) {
                v1 = Math.max(v1, 1.2 * this.m_waterVelocity);
            }
            v2 = Math.max(v2, 1.2 * v1);
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    maxIndex = Math.min(maxIndex, this.m_numZ - 1);
                    double alpha = (v1 - v2) / (double)this.m_surfaceGridZ[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double v = alpha * (double)z + v2;
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
            for (int z = 0; z < this.m_numZ; ++z) {
                this.smoothPlane(z, 5, false, false);
            }
            this.prepareAirSlowness();
            this.prepWaterVelocity();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void computeInternals() {
        try {
            this.m_cosineInlineAngle = Math.cos(this.m_inlineAngle);
            this.m_sineInlineAngle = Math.sin(this.m_inlineAngle);
            this.m_binSizeHorz = Math.max(1.0, this.m_binSizeHorz);
            this.m_binSizeVert = Math.max(1.0, this.m_binSizeVert);
            this.m_inverseBinSizeHorz = 1.0 / this.m_binSizeHorz;
            this.m_inverseBinSizeVert = 1.0 / this.m_binSizeVert;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized Java2D_PaintablePointArray createPointArray() {
        try {
            int num = this.m_numX * this.m_numY;
            Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray();
            pa.setLength(num);
            int n = 0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.setGridLocation(x, y, 0);
                    pa.setX(n, this.WorldX);
                    pa.setY(n, this.WorldY);
                    ++n;
                }
            }
            pa.UseColorScale = false;
            pa.SymbolColor = new Color(255, 111, 111, 128);
            pa.SymbolSize = 3;
            return pa;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public synchronized void setGridLocation(int indexX, int indexY, int indexZ) {
        try {
            this.GridX = (double)indexX * this.m_binSizeHorz;
            this.GridY = (double)indexY * this.m_binSizeHorz;
            this.GridZ = (double)indexZ * this.m_binSizeVert;
            this.WorldX = this.m_originX + this.m_cosineInlineAngle * this.GridX - this.m_sineInlineAngle * this.GridY;
            this.WorldY = this.m_originY + this.m_cosineInlineAngle * this.GridY + this.m_sineInlineAngle * this.GridX;
            this.WorldZ = this.m_originZ + this.GridZ;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void computeStatics_ComputeIntDatum(double x, double y, double z, double velocity, double finalDatum, double repVel) {
        try {
            this.setWorldLocation(x, y, true, true);
            double v = 1000.0 / (double)this.InterpolatedSlowness[0];
            if (velocity >= v) {
                double intDatum = this.m_originZ;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            v = 1000.0 / (double)this.InterpolatedSlowness[this.m_numZ - 1];
            if (velocity <= v) {
                double intDatum = this.m_originZ + (double)(this.m_numZ - 1) * this.m_binSizeVert;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            for (int n = this.m_numZ - 1; n >= 1; --n) {
                double v1 = 1000.0 / (double)this.InterpolatedSlowness[n];
                double v2 = 1000.0 / (double)this.InterpolatedSlowness[n - 1];
                if (!(v1 >= velocity)) continue;
                double intDatum = this.m_originZ + (double)n * this.m_binSizeVert;
                this.computeStatics(x, y, z, intDatum, finalDatum, repVel);
                return;
            }
            this.computeStatics(x, y, z, this.m_originZ, finalDatum, repVel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void computeStatics(double x, double y, double z, double intDatum, double finalDatum, double repVel) {
        try {
            this.TimeToFinalDatum = 1000.0 * (finalDatum - intDatum) / repVel;
            this.setWorldLocation(x, y, true, true);
            this.TimeToIntermediateDatum = 0.0;
            if (z > intDatum) {
                int n;
                int num = this.m_tempVertSlowness.length;
                double dz = (z - intDatum) / (double)(num - 1);
                for (n = 0; n < num; ++n) {
                    double worldZ = z - dz * (double)n;
                    double gridZ = worldZ - this.m_originZ;
                    double floatIndexZ = gridZ * this.m_inverseBinSizeVert;
                    floatIndexZ = Math.max(floatIndexZ, 1.0E-6);
                    floatIndexZ = Math.min(floatIndexZ, (double)this.m_numZ - 1.0E-5);
                    int indexZ = (int)floatIndexZ;
                    double fracZ = floatIndexZ - (double)indexZ;
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ] * this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ] * this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ] * this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ] * this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    if (indexZ < this.m_numZ - 1) {
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ + 1] * this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ + 1] * this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ + 1] * this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ + 1] * this.UpperWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.LowerWeightY) * fracZ;
                    }
                    this.m_tempVertSlowness[n] = s1 / s2;
                }
                for (n = 1; n < num; ++n) {
                    double avg = 0.5 * (this.m_tempVertSlowness[n - 1] + this.m_tempVertSlowness[n]);
                    this.TimeToIntermediateDatum += avg * dz;
                }
            }
            this.Statics = this.TimeToFinalDatum - this.TimeToIntermediateDatum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, double worldZ, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            double dz;
            this.setWorldLocation(worldX, worldY, fixEdgeIndices, interpolateGrids);
            this.WorldZ = worldZ;
            this.GridZ = dz = worldZ - this.m_originZ;
            this.FloatIndexZ = this.GridZ * this.m_inverseBinSizeVert;
            if (this.FloatIndexZ <= 0.0) {
                this.FloatIndexZ = 0.0;
                this.LowerIndexZ = 0;
                this.UpperIndexZ = 0;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ >= (double)(this.m_numZ - 1)) {
                this.FloatIndexZ = this.m_numZ - 1;
                this.LowerIndexZ = this.m_numZ - 1;
                this.UpperIndexZ = this.m_numZ - 1;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ > 0.0 && this.FloatIndexZ < (double)(this.m_numZ - 1)) {
                this.LowerIndexZ = (int)this.FloatIndexZ;
                this.UpperIndexZ = this.LowerIndexZ + 1;
                this.UpperWeightZ = (float)(this.FloatIndexZ - (double)this.LowerIndexZ);
                this.LowerWeightZ = 1.0f - this.UpperWeightZ;
            }
            this.UpperIndexValidZ = true;
            this.LowerIndexValidZ = true;
            if (interpolateGrids) {
                if (this.LowerIndexZ < 0) {
                    return;
                }
                this.SlownessAtWorld = this.LowerWeightZ * this.InterpolatedSlowness[this.LowerIndexZ] + this.UpperWeightZ * this.InterpolatedSlowness[this.UpperIndexZ];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            this.FloatIndexX = this.GridX * this.m_inverseBinSizeHorz;
            this.FloatIndexY = this.GridY * this.m_inverseBinSizeHorz;
            this.LowerIndexX = (int)this.FloatIndexX;
            this.LowerIndexY = (int)this.FloatIndexY;
            while (this.LowerIndexX > (int)this.FloatIndexX) {
                --this.LowerIndexX;
            }
            while (this.LowerIndexY > (int)this.FloatIndexY) {
                --this.LowerIndexY;
            }
            this.UpperWeightX = (float)(this.FloatIndexX - (double)this.LowerIndexX);
            this.UpperWeightY = (float)(this.FloatIndexY - (double)this.LowerIndexY);
            this.LowerWeightX = 1.0f - this.UpperWeightX;
            this.LowerWeightY = 1.0f - this.UpperWeightY;
            this.UpperIndexValidX = this.LowerIndexX + 1 < this.m_numX;
            this.UpperIndexValidY = this.LowerIndexY + 1 < this.m_numY;
            this.LowerIndexValidX = this.LowerIndexX >= 0;
            boolean bl = this.LowerIndexValidY = this.LowerIndexY >= 0;
            if (this.LowerIndexValidX && this.LowerIndexValidY && this.UpperIndexValidX && this.UpperIndexValidY) {
                this.OnEdge = false;
                this.UpperIndexX = this.LowerIndexX + 1;
                this.UpperIndexY = this.LowerIndexY + 1;
            } else {
                this.OnEdge = true;
                this.EdgeIndexX = this.LowerIndexX;
                this.EdgeIndexX = Math.max(this.EdgeIndexX, 0);
                this.EdgeIndexX = Math.min(this.EdgeIndexX, this.m_numX - 1);
                this.EdgeIndexY = this.LowerIndexX;
                this.EdgeIndexY = Math.max(this.EdgeIndexY, 0);
                this.EdgeIndexY = Math.min(this.EdgeIndexY, this.m_numY - 1);
                if (fixEdgeIndices) {
                    this.UpperIndexX = this.LowerIndexX = this.EdgeIndexX;
                    this.UpperIndexY = this.LowerIndexY = this.EdgeIndexY;
                    this.LowerWeightX = 1.0f;
                    this.LowerWeightY = 1.0f;
                    this.UpperWeightX = 0.0f;
                    this.UpperWeightY = 0.0f;
                }
            }
            if (!interpolateGrids) {
                return;
            }
            if (this.OnEdge && !fixEdgeIndices) {
                throw new Exception("fixEdgeIndices == false");
            }
            this.InterpolatedWaterBottom = this.LowerWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedElevation = this.LowerWeightX * this.LowerWeightY * this.m_surfaceElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedGridZ = this.LowerWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.UpperIndexY];
            for (int n = 0; n < this.m_numZ; ++n) {
                this.InterpolatedSlowness[n] = this.LowerWeightX * this.LowerWeightY * this.m_slowness[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_slowness[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_slowness[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_slowness[this.LowerIndexX][this.UpperIndexY][n];
                this.InterpolatedWeight[n] = this.LowerWeightX * this.LowerWeightY * this.m_weight[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_weight[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_weight[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_weight[this.LowerIndexX][this.UpperIndexY][n];
                this.InterpolatedCount[n] = this.LowerWeightX * this.LowerWeightY * this.m_count[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_count[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_count[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_count[this.LowerIndexX][this.UpperIndexY][n];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getElevationAtVelocity(double x, double y, double v) throws Exception {
        try {
            this.setWorldLocation(x, y, true, true);
            double vel = 1000.0 / (double)this.InterpolatedSlowness[0];
            if (v >= vel) {
                double intDatum = this.m_originZ;
                return intDatum;
            }
            vel = 1000.0 / (double)this.InterpolatedSlowness[this.m_numZ - 1];
            if (v <= vel) {
                double intDatum = this.m_originZ + (double)(this.m_numZ - 1) * this.m_binSizeVert;
                return intDatum;
            }
            for (int n = this.m_numZ - 1; n >= 1; --n) {
                double v1 = 1000.0 / (double)this.InterpolatedSlowness[n];
                double v2 = 1000.0 / (double)this.InterpolatedSlowness[n - 1];
                if (!(v1 >= v)) continue;
                double intDatum = this.m_originZ + (double)n * this.m_binSizeVert;
                return intDatum;
            }
            return this.m_originZ;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class Element {
        public int ID;
        public double Count = 1.0E-5;
        public double Error = 0.0;
        public double Residual = 0.0;
        public double ComputedResidual = 0.0;

        public Element(int id) {
            this.ID = id;
        }

        public Element(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    this.ID = raf.readInt();
                    this.Count = raf.readDouble();
                    this.Error = raf.readDouble();
                    this.Residual = raf.readDouble();
                    this.ComputedResidual = raf.readDouble();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    raf.writeInt(this.ID);
                    raf.writeDouble(this.Count);
                    raf.writeDouble(this.Error);
                    raf.writeDouble(this.Residual);
                    raf.writeDouble(this.ComputedResidual);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addError(float error) {
            this.Count += 1.0;
            this.Error += (double)Math.abs(error);
            this.Residual += (double)error;
        }
    }
}

