/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.InteractiveModel;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Math.Matrix_Simple;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class TomoInteractiveModel_PickedCurve
implements Java2D_PaintableInterface {
    public double WorldX;
    public double WorldY;
    public int BasemapPixelX;
    public int BasemapPixelY;
    public ArrayList<PickedPoint> PointList = new ArrayList();
    public TomoEikonal3DProfile m_tomoProfile;
    public Table_Abstract TablePicks = new Table_Memory();
    public Table_Abstract TableModel = new Table_Memory();
    public double[] Velocity;
    public double[] Weight;
    public double[] Count;
    public double[] Error;
    public double MaximumDepth = 0.0;
    public double LayerThickness = 1.0;
    public double[] PsuedoPickOffset;
    public double[] PsuedoPickTime;
    public double[] ComputedPickTime;
    public double PsuedoPickMaximumOffset;
    public double PsuedoPickOffsetIncrement;
    public ArrayList<CubicSegment> CubicList = new ArrayList();
    public double CubicExtrapolation_Slope;
    public double CubicExtrapolation_Intercept;
    public boolean ApplyLMO = false;
    public double VelocityLMO = 6000.0;
    public Color LineColor = new Color(255, 0, 0, 0);
    public BasicStroke LineStroke = new BasicStroke(4.0f);
    public BasicStroke LineStrokeComp = new BasicStroke(2.0f);
    public static int PaintPicks = 1000;
    public static int PaintModel = 2000;

    public TomoInteractiveModel_PickedCurve() {
    }

    public TomoInteractiveModel_PickedCurve(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 10293839) {
                throw new Exception("wrong magic");
            }
            int version = file.readInt();
            if (version == 1000) {
                this.WorldX = file.readDouble();
                this.WorldY = file.readDouble();
                int count = file.readInt();
                for (int n = 0; n < count; ++n) {
                    PickedPoint p = new PickedPoint();
                    p.Offset = file.readDouble();
                    p.Time = file.readDouble();
                    this.PointList.add(p);
                }
                return;
            }
            throw new Exception("Bad version");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setUserPicks(int count, float[] t, float[] x) throws Exception {
        try {
            this.CubicList.clear();
            this.PointList.clear();
            PickedPoint p = new PickedPoint();
            p.Offset = 0.0;
            p.Time = 0.0;
            this.PointList.add(p);
            PickedPoint prior = p;
            for (int n = 0; n < count; ++n) {
                p = new PickedPoint();
                p.Offset = x[n];
                p.Time = t[n];
                if (!(p.Offset > prior.Offset + 1.0) || !(p.Time > prior.Time + 1.0)) continue;
                this.PointList.add(p);
                prior = p;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getTimeFromUserPicks(double offset) throws Exception {
        try {
            if (offset <= 0.0) {
                return 0.0;
            }
            if (this.PointList.size() < 2) {
                throw new Exception("PointList.size()");
            }
            for (int n = 1; n < this.PointList.size(); ++n) {
                PickedPoint pa = this.PointList.get(n - 1);
                PickedPoint pb = this.PointList.get(n);
                if (!(offset <= pb.Offset)) continue;
                double slope = (pb.Time - pa.Time) / (pb.Offset - pa.Offset);
                double intercept = pa.Time - slope * pa.Offset;
                return slope * offset + intercept;
            }
            PickedPoint pa = this.PointList.get(this.PointList.size() - 2);
            PickedPoint pb = this.PointList.get(this.PointList.size() - 1);
            double slope = (pb.Time - pa.Time) / (pb.Offset - pa.Offset);
            double intercept = pa.Time - slope * pa.Offset;
            return slope * offset + intercept;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int magic = 10293839;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.WorldX);
                file.writeDouble(this.WorldY);
                file.writeInt(this.PointList.size());
                for (PickedPoint p : this.PointList) {
                    file.writeDouble(p.Offset);
                    file.writeDouble(p.Time);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeModelUsingTomoProfile(double maxDepth, double layerThickness) throws Exception {
        try {
            if (this.PsuedoPickOffset == null) {
                throw new Exception("Call computePsuedoPicks first");
            }
            double maxOffset = this.PsuedoPickOffset[this.PsuedoPickOffset.length - 1];
            this.LayerThickness = Math.max(2.0, layerThickness);
            int numZ = 1 + (int)(maxDepth / this.LayerThickness);
            int numX = 10 + (int)(maxOffset / this.LayerThickness);
            this.MaximumDepth = (double)(numZ - 1) * this.LayerThickness;
            double gridOriginZ = 0.0 - this.MaximumDepth;
            this.m_tomoProfile = new TomoEikonal3DProfile(this.LayerThickness, gridOriginZ, numZ, numX);
            int numPicks = this.PsuedoPickOffset.length;
            double[] errorArray = new double[numZ];
            double[] minSampleOffset = new double[numZ];
            double[] maxSampleOffset = new double[numZ];
            double[] midSampleOffset = new double[numZ];
            this.Weight = new double[numZ];
            this.Count = new double[numZ];
            this.Error = new double[numZ];
            this.Velocity = new double[numZ];
            double[] velocityStart = new double[numZ];
            double[] velocityTemp = new double[numZ];
            double v0 = 1000.0 * this.PsuedoPickOffset[1] / this.PsuedoPickTime[1];
            double v1 = 1.01 * v0;
            if (numPicks >= 2) {
                double dx = this.PsuedoPickOffset[numPicks - 1] - this.PsuedoPickOffset[numPicks - 2];
                double dt = this.PsuedoPickTime[numPicks - 1] - this.PsuedoPickTime[numPicks - 2];
                v1 = 1.1 * (1000.0 * dx / dt);
            }
            for (int z = 0; z < numZ; ++z) {
                double v;
                this.Velocity[z] = v = v1 + (v0 - v1) * (double)z / (double)(numZ - 1);
                velocityStart[z] = v;
                for (int x = 0; x < numX; ++x) {
                    this.m_tomoProfile.Slowness[x][z] = (float)(1000.0 / this.Velocity[z]);
                }
            }
            int iter = 0;
            int maxIter = 70;
            int minIter = 20;
            double maxError = 1.0;
            double avgError = 10000.0;
            double numValid = 0.0;
            double numNotValid = 0.0;
            double maxUsedOffset = 0.0;
            boolean keepGoing = avgError > maxError && iter < maxIter;
            boolean bl = keepGoing = keepGoing || iter < minIter;
            while (keepGoing) {
                int z;
                int n;
                for (int z2 = 0; z2 < numZ; ++z2) {
                    minSampleOffset[z2] = 1.0E7;
                    maxSampleOffset[z2] = 0.0;
                    errorArray[z2] = 0.0;
                    this.Weight[z2] = 1.0E-10;
                    this.Count[z2] = 0.0;
                    this.Error[z2] = 0.0;
                }
                this.m_tomoProfile.MaxValidX = numX - 1;
                this.m_tomoProfile.fireShot(-0.1f);
                avgError = 0.0;
                numValid = 1.0E-10;
                numNotValid = 1.0E-10;
                maxUsedOffset = 0.0;
                boolean hack = false;
                int minSampledZ = numZ - 1;
                for (n = 0; n < numPicks; ++n) {
                    this.m_tomoProfile.setOffset((float)this.PsuedoPickOffset[n]);
                    this.m_tomoProfile.setReceiver(-0.1f, (float)this.PsuedoPickTime[n]);
                    int numPathPoints = this.m_tomoProfile.NumPathPoints;
                    int minZ = 100000;
                    for (int p = 1; p < numPathPoints - 1; ++p) {
                        int z3 = this.m_tomoProfile.PathIndexZ[p];
                        minZ = Math.min(minZ, z3);
                    }
                    if (minZ >= numZ) continue;
                    minSampleOffset[minZ] = Math.min(minSampleOffset[minZ], this.PsuedoPickOffset[n]);
                    maxSampleOffset[minZ] = Math.max(maxSampleOffset[minZ], this.PsuedoPickOffset[n]);
                }
                for (z = 0; z < numZ; ++z) {
                    midSampleOffset[z] = minSampleOffset[z] < maxSampleOffset[z] ? 0.5 * (minSampleOffset[z] + maxSampleOffset[z]) : 1.0E20;
                }
                for (n = 0; n < numPicks; ++n) {
                    int z4;
                    int p;
                    this.m_tomoProfile.setOffset((float)this.PsuedoPickOffset[n]);
                    this.m_tomoProfile.setReceiver(-0.1f, (float)this.PsuedoPickTime[n]);
                    double error = this.PsuedoPickTime[n] - this.m_tomoProfile.ReceiverTime;
                    double weight = 1.0;
                    double fraction = this.m_tomoProfile.ReceiverTime / this.PsuedoPickTime[n];
                    fraction = Math.min(fraction, 1.5);
                    fraction = Math.max(fraction, 0.6);
                    maxUsedOffset = Math.max(maxUsedOffset, this.PsuedoPickOffset[n]);
                    int numPathPoints = this.m_tomoProfile.NumPathPoints;
                    int minZ = 100000;
                    for (p = 1; p < numPathPoints - 1; ++p) {
                        z4 = this.m_tomoProfile.PathIndexZ[p];
                        minZ = Math.min(minZ, z4);
                    }
                    minSampledZ = Math.min(minSampledZ, minZ);
                    if (minZ < numZ && this.PsuedoPickOffset[n] >= midSampleOffset[minZ]) {
                        for (p = 1; p < numPathPoints - 1; ++p) {
                            z4 = this.m_tomoProfile.PathIndexZ[p];
                            errorArray[z4] = errorArray[z4] + weight * fraction;
                            this.Weight[z4] = this.Weight[z4] + weight;
                            this.Count[z4] = this.Count[z4] + 1.0;
                            this.Error[z4] = this.Error[z4] + Math.abs(error);
                        }
                    }
                    avgError += Math.abs(error);
                    numValid += 1.0;
                }
                for (z = 0; z < numZ; ++z) {
                    double fraction = 1.0;
                    if (this.Weight[z] > 0.1) {
                        fraction = errorArray[z] / this.Weight[z];
                    }
                    fraction = Math.sqrt(fraction);
                    fraction = Math.max(0.9, fraction);
                    fraction = Math.min(1.1, fraction);
                    velocityTemp[z] = this.Velocity[z] * fraction;
                    this.Velocity[z] = this.Velocity[z] * fraction;
                }
                velocityTemp[numZ - 1] = v0;
                this.Velocity[numZ - 1] = v0;
                for (z = minSampledZ - 1; z >= 0; --z) {
                    this.Velocity[z] = 1.005 * this.Velocity[z + 1];
                }
                for (z = 0; z < numZ; ++z) {
                    velocityTemp[z] = this.Velocity[z];
                }
                for (z = minSampledZ + 1; z < numZ - 1; ++z) {
                    this.Velocity[z] = 0.25 * velocityTemp[z - 1] + 0.5 * velocityTemp[z] + 0.25 * velocityTemp[z + 1];
                }
                for (z = numZ - 2; z >= minSampledZ + 1; --z) {
                    double increment = 1.001;
                    if (!(this.Velocity[z] <= increment * this.Velocity[z + 1])) continue;
                    this.Velocity[z] = increment * this.Velocity[z + 1];
                }
                velocityTemp[numZ - 1] = v0;
                this.Velocity[numZ - 1] = v0;
                for (z = 0; z < numZ; ++z) {
                    for (int x = 0; x < numX; ++x) {
                        this.m_tomoProfile.Slowness[x][z] = (float)(1000.0 / this.Velocity[z]);
                    }
                }
                double fractionMinZ = errorArray[minSampledZ] / this.Weight[minSampledZ];
                System.out.println(String.format("Iter = %d   error = %f  Velocity[minZ] = %f  fraction[minZ] = %f minSampledZ=%d", iter, Float.valueOf((float)(avgError /= numValid)), Float.valueOf((float)this.Velocity[minSampledZ]), Float.valueOf((float)fractionMinZ), minSampledZ));
                keepGoing = avgError > maxError && ++iter < maxIter;
                keepGoing = keepGoing || iter < minIter;
            }
            this.TableModel.row_clear(false);
            int colDepth = this.TableModel.column_append("Depth", DataType.Double);
            int colVel = this.TableModel.column_append("Velocity", DataType.Double);
            int colCount = this.TableModel.column_append("Ray count", DataType.Double);
            int colWeight = this.TableModel.column_append("Ray weight", DataType.Double);
            int colError = this.TableModel.column_append("Average Error", DataType.Double);
            double depth = 0.0;
            for (int z = numZ - 1; z >= 0; --z) {
                int row = this.TableModel.row_increment();
                double error = this.Error[z] / (1.0E-10 + this.Count[z]);
                this.TableModel.putDouble(row, colDepth, depth);
                this.TableModel.putDouble(row, colVel, this.Velocity[z]);
                this.TableModel.putDouble(row, colCount, this.Count[z]);
                this.TableModel.putDouble(row, colWeight, this.Weight[z]);
                this.TableModel.putDouble(row, colError, error);
                depth += this.m_tomoProfile.Size;
            }
            this.TablePicks.row_clear(false);
            int colOffset = this.TablePicks.column_append("Offset", DataType.Double);
            int colPickTime = this.TablePicks.column_append("Pick Time", DataType.Double);
            int colModelTime = this.TablePicks.column_append("Model Time", DataType.Double);
            colError = this.TablePicks.column_append("Error", DataType.Double);
            this.m_tomoProfile.MaxValidX = numX - 1;
            this.m_tomoProfile.fireShot(-0.1f);
            for (int n = 0; n < numPicks; ++n) {
                int row = this.TablePicks.row_increment();
                this.m_tomoProfile.setOffset((float)this.PsuedoPickOffset[n]);
                this.m_tomoProfile.setReceiver(-0.1f, (float)this.PsuedoPickTime[n]);
                this.ComputedPickTime[n] = this.m_tomoProfile.ReceiverTime;
                this.TablePicks.putDouble(row, colPickTime, this.PsuedoPickTime[n]);
                this.TablePicks.putDouble(row, colOffset, this.PsuedoPickOffset[n]);
                this.TablePicks.putDouble(row, colModelTime, this.m_tomoProfile.ReceiverTime);
                double error = this.PsuedoPickTime[n] - this.m_tomoProfile.ReceiverTime;
                this.TablePicks.putDouble(row, colError, error);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computePsuedoPicks(double maxOffset, double offsetIncrement) throws Exception {
        try {
            this.PsuedoPickOffset = null;
            this.PsuedoPickTime = null;
            if (this.PointList.size() < 2) {
                return;
            }
            offsetIncrement = Math.max(1.0, offsetIncrement);
            int count = 1 + (int)(maxOffset / offsetIncrement);
            this.PsuedoPickOffsetIncrement = offsetIncrement;
            this.PsuedoPickMaximumOffset = (double)count * this.PsuedoPickOffsetIncrement;
            if (this.CubicList.size() >= 1) {
                this.PsuedoPickOffset = new double[count];
                this.PsuedoPickTime = new double[count];
                this.ComputedPickTime = new double[count];
                for (int n = 0; n < count; ++n) {
                    this.PsuedoPickOffset[n] = (double)(n + 1) * this.PsuedoPickOffsetIncrement;
                    this.PsuedoPickTime[n] = this.CubicExtrapolation_Slope * this.PsuedoPickOffset[n] + this.CubicExtrapolation_Intercept;
                    for (CubicSegment cs : this.CubicList) {
                        if (!cs.inside(this.PsuedoPickOffset[n])) continue;
                        this.PsuedoPickTime[n] = cs.time(this.PsuedoPickOffset[n]);
                    }
                }
                return;
            }
            if (this.PointList.size() < 2) {
                throw new Exception("PointList.size()");
            }
            this.PsuedoPickOffset = new double[count];
            this.PsuedoPickTime = new double[count];
            this.ComputedPickTime = new double[count];
            for (int n = 0; n < count; ++n) {
                this.PsuedoPickOffset[n] = (double)(n + 1) * this.PsuedoPickOffsetIncrement;
                this.PsuedoPickTime[n] = this.getTimeFromUserPicks(this.PsuedoPickOffset[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeCubicSegments() {
        try {
            this.CubicList.clear();
            if (this.PointList.size() <= 2) {
                return;
            }
            PickedPoint pa = this.PointList.get(this.PointList.size() - 2);
            PickedPoint pb = this.PointList.get(this.PointList.size() - 1);
            this.CubicExtrapolation_Slope = (pb.Time - pa.Time) / (pb.Offset - pa.Offset);
            this.CubicExtrapolation_Intercept = pa.Time - this.CubicExtrapolation_Slope * pa.Offset;
            int numCubicSegments = this.PointList.size() - 2;
            Matrix_Simple matrix = new Matrix_Simple(4, 4);
            Matrix_Simple rhs = new Matrix_Simple(4, 1);
            for (int nc = 0; nc < numCubicSegments; ++nc) {
                PickedPoint p1 = this.PointList.get(nc);
                PickedPoint p2 = this.PointList.get(nc + 1);
                PickedPoint p3 = this.PointList.get(nc + 2);
                double xa = (p1.Offset + p2.Offset) / 2.0;
                double ta = (p1.Time + p2.Time) / 2.0;
                double slopea = (p2.Time - p1.Time) / (p2.Offset - p1.Offset);
                if (nc == 0) {
                    xa = p1.Offset;
                    ta = p1.Time;
                }
                double xb = (p2.Offset + p3.Offset) / 2.0;
                double tb = (p2.Time + p3.Time) / 2.0;
                double slopeb = (p3.Time - p2.Time) / (p3.Offset - p2.Offset);
                if (nc == numCubicSegments - 1) {
                    xb = p3.Offset;
                    tb = p3.Time;
                }
                matrix.Data[0][0] = 1.0;
                matrix.Data[0][1] = xa;
                matrix.Data[0][2] = xa * xa;
                matrix.Data[0][3] = xa * xa * xa;
                matrix.Data[1][0] = 1.0;
                matrix.Data[1][1] = xb;
                matrix.Data[1][2] = xb * xb;
                matrix.Data[1][3] = xb * xb * xb;
                matrix.Data[2][0] = 0.0;
                matrix.Data[2][1] = 1.0;
                matrix.Data[2][2] = 2.0 * xa;
                matrix.Data[2][3] = 3.0 * xa * xa;
                matrix.Data[3][0] = 0.0;
                matrix.Data[3][1] = 1.0;
                matrix.Data[3][2] = 2.0 * xb;
                matrix.Data[3][3] = 3.0 * xb * xb;
                rhs.Data[0][0] = ta;
                rhs.Data[1][0] = tb;
                rhs.Data[2][0] = slopea;
                rhs.Data[3][0] = slopeb;
                Matrix_Simple result = matrix.solve(rhs);
                CubicSegment cs = new CubicSegment();
                cs.XA = xa;
                cs.TA = ta;
                cs.XB = xb;
                cs.TB = tb;
                cs.a = result.Data[0][0];
                cs.b = result.Data[1][0];
                cs.c = result.Data[2][0];
                cs.d = result.Data[3][0];
                this.CubicList.add(cs);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (supplementalData == PaintPicks) {
                this.Java2D_PaintPicks(paintParameter, supplementalData);
                return;
            }
            if (supplementalData == PaintModel) {
                this.Java2D_PaintModel(paintParameter, supplementalData);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintModel(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            double y;
            int n;
            if (this.Velocity == null) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int numZ = this.Velocity.length;
            for (n = 0; n < this.Velocity.length; ++n) {
                if (n >= numZ - 1 || this.Count[n] > 0.5) {
                    g2d.setColor(Color.blue);
                } else {
                    g2d.setColor(Color.red);
                }
                y = this.LayerThickness * (double)(numZ - 1 - n);
                int ix = (int)(scaleX * this.Velocity[n] + shiftX);
                int iy1 = (int)(scaleY * y + shiftY);
                int iy2 = (int)(scaleY * (y + this.LayerThickness) + shiftY);
                g2d.drawLine(ix, iy1, ix, iy2);
            }
            for (n = numZ - 2; n >= 0; --n) {
                if (n >= numZ - 3 || this.Count[n] > 0.5 && this.Count[n + 1] > 0.5) {
                    g2d.setColor(Color.blue);
                } else {
                    g2d.setColor(Color.red);
                }
                y = this.LayerThickness * (double)(numZ - 1 - n);
                int iy = (int)(scaleY * y + shiftY);
                int ix1 = (int)(scaleX * this.Velocity[n + 1] + shiftX);
                int ix2 = (int)(scaleX * this.Velocity[n] + shiftX);
                g2d.drawLine(ix1, iy, ix2, iy);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintPicks(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int iy2;
            int ix2;
            int iy1;
            int ix1;
            double t2;
            int n;
            if (this.PointList.size() < 2) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int dotSize = 11;
            int half = dotSize / 2;
            g2d.setColor(Color.red);
            for (PickedPoint p : this.PointList) {
                double t = p.Time;
                if (this.ApplyLMO) {
                    t -= 1000.0 * p.Offset / this.VelocityLMO;
                }
                int ix12 = (int)(scaleX * p.Offset + shiftX);
                int iy12 = (int)(scaleY * t + shiftY);
                g2d.fillOval(ix12 - half, iy12 - half, dotSize, dotSize);
            }
            if (this.PsuedoPickOffset == null) {
                return;
            }
            g2d.setColor(Color.red);
            for (n = 1; n < this.PsuedoPickOffset.length; ++n) {
                double t1 = this.PsuedoPickTime[n - 1];
                t2 = this.PsuedoPickTime[n];
                if (this.ApplyLMO) {
                    t1 -= 1000.0 * this.PsuedoPickOffset[n - 1] / this.VelocityLMO;
                    t2 -= 1000.0 * this.PsuedoPickOffset[n] / this.VelocityLMO;
                }
                ix1 = (int)(scaleX * this.PsuedoPickOffset[n - 1] + shiftX);
                iy1 = (int)(scaleY * t1 + shiftY);
                ix2 = (int)(scaleX * this.PsuedoPickOffset[n] + shiftX);
                iy2 = (int)(scaleY * t2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
            g2d.setColor(Color.blue);
            g2d.setStroke(this.LineStrokeComp);
            for (n = 1; n < this.PsuedoPickOffset.length; ++n) {
                double t1 = this.ComputedPickTime[n - 1];
                t2 = this.ComputedPickTime[n];
                if (this.ApplyLMO) {
                    t1 -= 1000.0 * this.PsuedoPickOffset[n - 1] / this.VelocityLMO;
                    t2 -= 1000.0 * this.PsuedoPickOffset[n] / this.VelocityLMO;
                }
                ix1 = (int)(scaleX * this.PsuedoPickOffset[n - 1] + shiftX);
                iy1 = (int)(scaleY * t1 + shiftY);
                ix2 = (int)(scaleX * this.PsuedoPickOffset[n] + shiftX);
                iy2 = (int)(scaleY * t2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == PaintModel) {
                if (this.Velocity == null) {
                    return;
                }
                rangeX.expandRange(this.Velocity);
                rangeY.expandRange(0.0);
                rangeY.expandRange(this.MaximumDepth);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public class PickedPoint {
        public double Time = 0.0;
        public double Offset = 0.0;
    }

    public class CubicSegment {
        public double XA;
        public double XB;
        public double TA;
        public double TB;
        public double a;
        public double b;
        public double c;
        public double d;

        public boolean inside(double x) {
            return x >= this.XA && x <= this.XB;
        }

        public double time(double x) {
            return this.a + this.b * x + this.c * x * x + this.d * x * x * x;
        }
    }
}

