/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.ResetableIterator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Ensemble.Worker.Import.EnsembleWorker_ScanProjectTraces;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class ShotEnsembleIterator
implements ResetableIterator<Ensemble> {
    RefractionStaticsProject _project;
    Ensemble _ensemble;
    boolean _bUseFlow;
    protected EnsembleWorker_Sequence _sequence;
    protected EnsembleWorker_Base _inputWorker;
    boolean _bFailed;
    String _sFailureReason;
    String _sMainWorker;
    boolean _bInitialized = false;
    boolean _bInitializeSuccess = false;
    boolean _bHalt = false;
    String _sMessageLevel2 = "";
    double _dPercentDone;

    public ShotEnsembleIterator(RefractionStaticsProject project, boolean bUseFlow, EnsembleWorker_Sequence sequence, String sMainWorker) {
        this._project = project;
        this._bUseFlow = bUseFlow;
        this._sequence = sequence;
        this._sMainWorker = sMainWorker;
    }

    protected boolean checkSequence() {
        try {
            String sPlane;
            if (this._sequence.size() < 1) {
                this._sFailureReason = "Sequence undefined";
                this._bFailed = true;
                return false;
            }
            this._inputWorker = this._sequence.worker(0);
            String sTmp = sPlane = this._inputWorker.parameterTree().string_get("ScanPlane", EnsembleWorker_ScanProjectTraces.ScanPlaneEnum.Shot.name());
            if (!this._inputWorker.isEnsembleSource()) {
                this._sFailureReason = "Sequence has incorrect structure";
                this._bFailed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this._sFailureReason = error.getMessage();
            this._bFailed = true;
            return false;
        }
    }

    @Override
    public boolean getHalt() {
        return this._bHalt;
    }

    @Override
    public void setHalt(boolean bHalt) {
        this._bHalt = bHalt;
    }

    @Override
    public String getMessageLevel2() {
        return this._sMessageLevel2;
    }

    @Override
    public double getPercentDone() {
        return this._dPercentDone;
    }

    @Override
    public boolean hasNext() throws Exception {
        boolean bHasNext = this._inputWorker.hasMoreEnsembles() && !this._bHalt;
        return bHasNext;
    }

    @Override
    public Ensemble next() throws Exception {
        this.initialize();
        if (!this._bInitializeSuccess) {
            throw new Exception(this._sFailureReason);
        }
        Ensemble ensemble = this._inputWorker.nextEnsemble();
        for (int n = 1; n < this._sequence.size(); ++n) {
            EnsembleWorker_Base w = this._sequence.worker(n);
            w.performWork(ensemble);
            ensemble = w.output(0);
        }
        this._dPercentDone = this._inputWorker.percentDone();
        this._sMessageLevel2 = this._inputWorker.ActionString;
        return ensemble;
    }

    void initialize() throws Exception {
        if (!this._bInitialized) {
            this._bInitialized = true;
            boolean bCheckSequenceOK = this.checkSequence();
            if (!bCheckSequenceOK) {
                throw new Exception(this._sFailureReason);
            }
            this._bInitializeSuccess = bCheckSequenceOK;
        }
    }

    @Override
    public void reset() throws Exception {
        this.initialize();
        this._bHalt = false;
        this._sMessageLevel2 = "";
        this._dPercentDone = 0.0;
        this._inputWorker.resetInputWorker();
    }
}

