/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashKey_Integers;
import com.PecosCore.Refraction.IMoveoutTrendData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Math.LineFit;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;

public class InteractiveMoveoutTrend
extends GenericObjectListener
implements IMoveoutTrendData {
    public double MaxOffset = 30000.0;
    public double OffsetBinSize = 1000.0;
    public double GridSize = 5000.0;
    protected ArrayList<Location> m_list = new ArrayList();
    protected HashKey_Integers m_key = new HashKey_Integers(0);
    public HashMap<HashKey_Integers, Location> m_map = new HashMap();

    public InteractiveMoveoutTrend(double grid, double max_off, double off_bin) {
        this.MaxOffset = max_off;
        this.OffsetBinSize = off_bin;
        this.GridSize = grid;
    }

    public void clear() {
        this.m_map.clear();
        this.m_list.clear();
    }

    protected Location location(double x, double y) {
        try {
            int ix = (int)(0.5 + x / this.GridSize);
            int iy = (int)(0.5 + y / this.GridSize);
            this.m_key.setKey(ix, iy);
            if (!this.m_map.containsKey(this.m_key)) {
                HashKey_Integers k = new HashKey_Integers(ix, iy);
                Location loc = new Location((double)ix * this.GridSize, (double)iy * this.GridSize, this.MaxOffset, this.OffsetBinSize);
                this.m_map.put(k, loc);
                this.m_list.add(loc);
            }
            return this.m_map.get(this.m_key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void add(double x, double y, double off, double pick, boolean recompute) {
        try {
            Location loc = this.location(x, y);
            loc.add(off, pick);
            if (recompute) {
                loc.computeAlphaBeta();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeAlphaBeta() {
        try {
            for (Location loc : this.m_list) {
                loc.computeAlphaBeta();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void applyShifts(Ensemble ensemble, boolean useEndpoints) throws Exception {
        try {
            if (this.m_map.size() < 1) {
                return;
            }
            if (ensemble.traceCount() < 1) {
                return;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexIMT = ensemble.dictionary().addEntry("Trace", "IMTREND", DataType.Float);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double off = trace.header().getDouble(indexOff);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                double x = 0.5 * (sx + rx);
                double y = 0.5 * (sy + ry);
                float timeMid = this.getTime(x, y, (float)off, true);
                if (useEndpoints) {
                    float timeShot = this.getTime(sx, sy, (float)off, true);
                    float timeRec = this.getTime(rx, ry, (float)off, true);
                    float time = (timeMid + timeShot + timeRec) / 3.0f;
                    trace.data().addShiftToFirstSampleCoord(-time);
                    trace.header().putDouble(indexIMT, time);
                    continue;
                }
                trace.data().addShiftToFirstSampleCoord(-timeMid);
                trace.header().putDouble(indexIMT, timeMid);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addPicks(Ensemble ensemble, boolean useEndpoints) throws Exception {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double pick = trace.header().getDouble(indexPick);
                if (!(pick > 4.0) || !(pick < 20000.0)) continue;
                double off = trace.header().getDouble(indexOff);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                double x = 0.5 * (sx + rx);
                double y = 0.5 * (sy + ry);
                this.add(x, y, off, pick, true);
                if (!useEndpoints) continue;
                this.add(rx, ry, off, pick, true);
                this.add(sx, sy, off, pick, true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getVelocity(double x, double y, float offset) throws Exception {
        try {
            float minOff = 0.98f * offset;
            minOff = Math.max(minOff, 0.0f);
            float maxOff = 1.02f * offset;
            float t0 = this.getTime(x, y, minOff, true);
            float t1 = this.getTime(x, y, maxOff, true);
            if (t1 <= t0) {
                return 30000.0f;
            }
            float v = 1000.0f * (maxOff - minOff) / (t1 - t0);
            v = Math.min(v, 35000.0f);
            v = Math.max(v, 100.0f);
            return v;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getTime(double x, double y, float offset, boolean includeSelected) throws Exception {
        try {
            double sumTime = 0.0;
            double sumWeight = 1.0E-80;
            int count = 0;
            for (Location loc : this.m_list) {
                double time = loc.getTimeAtOffset(offset);
                if (!loc.TimeValid) continue;
                ++count;
                double dx = 0.001 * (x - loc.X);
                double dy = 0.001 * (y - loc.Y);
                double rsq = dx * dx + dy * dy;
                double w = 1.0 / (1.0 + rsq * rsq);
                sumTime += (w *= loc.TimeWeight) * time;
                sumWeight += w;
            }
            if (count < 1) {
                return 0.0f;
            }
            return (float)(sumTime / sumWeight);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class Location {
        public double X;
        public double Y;
        public double OffsetBinSize = 1000.0;
        public int PixelX;
        public int PixelY;
        public ArrayList<OffsetBin> List = new ArrayList();
        public boolean TimeValid = false;
        public double TimeWeight = 0.0;

        public Location(double x, double y, double max_off, double off_bin_size) {
            this.X = x;
            this.Y = y;
            this.OffsetBinSize = off_bin_size;
            for (double off = 0.5 * this.OffsetBinSize; off <= max_off; off += this.OffsetBinSize) {
                this.List.add(new OffsetBin(off));
            }
        }

        public Location(RandomAccessFile file) throws Exception {
            try {
                int magic = file.readInt();
                if (magic != 6647433) {
                    throw new Exception("magic != 6647433");
                }
                int version = file.readInt();
                if (version == 1000) {
                    this.X = file.readDouble();
                    this.Y = file.readDouble();
                    this.OffsetBinSize = file.readDouble();
                    int len = file.readInt();
                    for (int n = 0; n < len; ++n) {
                        double off = file.readDouble();
                        OffsetBin offsetBin = new OffsetBin(off);
                    }
                } else {
                    throw new Exception("bad version");
                }
                this.computeAlphaBeta();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void computeAlphaBeta() {
            try {
                for (OffsetBin b : this.List) {
                    b.Linear.compute();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile file) {
        }

        public double getTimeAtOffset(double offset) throws Exception {
            try {
                this.TimeValid = false;
                this.TimeWeight = 0.0;
                double sum = 0.0;
                int bin = (int)(offset / this.OffsetBinSize);
                boolean keepgoing = true;
                for (int rad = 0; rad < 5 && keepgoing; ++rad) {
                    double t;
                    double weight;
                    OffsetBin ob;
                    int b = bin + rad;
                    if (b >= 0 && b < this.List.size()) {
                        ob = this.List.get(b);
                        if (!ob.Linear.valid()) {
                            ob.Linear.compute();
                        }
                        if (ob.Linear.valid()) {
                            weight = 1.0 / (0.2 + (double)Math.abs(b - bin));
                            t = ob.Linear.get_y(offset);
                            this.TimeValid = true;
                            sum += t * (weight *= (double)ob.Linear.Count);
                            this.TimeWeight += weight;
                            keepgoing = false;
                        }
                    }
                    if ((b = bin - rad) < 0 || b >= this.List.size()) continue;
                    ob = this.List.get(b);
                    if (!ob.Linear.valid()) {
                        ob.Linear.compute();
                    }
                    if (!ob.Linear.valid()) continue;
                    weight = 1.0 / (0.2 + (double)Math.abs(b - bin));
                    t = ob.Linear.get_y(offset);
                    this.TimeValid = true;
                    sum += t * (weight *= (double)ob.Linear.Count);
                    this.TimeWeight += weight;
                    keepgoing = false;
                }
                if (this.TimeValid) {
                    return sum / this.TimeWeight;
                }
                return 0.0;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public void add(double off, double pick) {
            try {
                int b = (int)(off / this.OffsetBinSize);
                if (b >= this.List.size()) {
                    return;
                }
                if (pick > 0.0) {
                    this.List.get(b).add_pick(off, pick);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void subtract(double off, double pick) {
        }
    }

    public static class OffsetBin {
        public double CenterOffset;
        public LineFit Linear = new LineFit();

        public OffsetBin(double center_offset) {
            this.CenterOffset = center_offset;
        }

        public void add_pick(double offset, double pick) {
            this.Linear.add(offset, pick);
        }

        public void subtract_pick(double pick) {
        }
    }
}

