/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.GLI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;

public class GliInteractiveModel_SingleLocation
implements Java2D_PaintableInterface {
    public boolean Permanent = true;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public int BasemapPixelX;
    public int BasemapPixelY;
    public boolean ApplyLMO = false;
    public double VelocityLMO = 5000.0;
    protected boolean m_travelTimesValid = false;
    protected boolean m_modelValid = false;
    protected String m_reasonNotValid = "";
    protected double[] m_pickedOffset = new double[100];
    protected double[] m_pickedTime = new double[100];
    protected double[] m_velocity = new double[100];
    protected double[] m_top = new double[100];
    protected double[] m_bottom = new double[100];
    protected double[] m_thickness = new double[500];
    protected int m_validPickCount = 0;
    protected double[] m_SRTime = new double[100];
    protected double[] m_SRDistance = new double[100];
    public Color LineColor = Color.BLUE;
    public static int PaintPicks = 1000;
    public static int PaintModel = 2000;
    public static int PaintSegments = 2001;

    public int validPickCount() {
        return this.m_validPickCount;
    }

    public boolean modelValid() {
        return this.m_modelValid;
    }

    public String reasonNotValid() {
        return this.m_reasonNotValid;
    }

    public void clearPicks() {
        this.m_validPickCount = 0;
    }

    public void addPick(double offset, double time) {
        try {
            if (this.Permanent) {
                System.out.println("Permanent:  addPick");
            }
            this.m_travelTimesValid = false;
            this.m_modelValid = false;
            this.m_reasonNotValid = "Offset, time pick added";
            if (this.m_validPickCount >= this.m_pickedOffset.length) {
                return;
            }
            this.m_pickedOffset[this.m_validPickCount] = offset;
            this.m_pickedTime[this.m_validPickCount] = 0.001 * time;
            ++this.m_validPickCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public GliInteractiveModel_SingleLocation() {
    }

    public GliInteractiveModel_SingleLocation(RandomAccessFile file) throws Exception {
        try {
            int version = file.readInt();
            if (version == 1000) {
                this.WorldX = file.readDouble();
                this.WorldY = file.readDouble();
                this.WorldZ = file.readDouble();
                this.m_validPickCount = file.readInt();
                for (int i = 0; i < this.m_validPickCount; ++i) {
                    this.m_pickedOffset[i] = file.readDouble();
                    this.m_pickedTime[i] = file.readDouble();
                }
                return;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int version = 1000;
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.WorldX);
                file.writeDouble(this.WorldY);
                file.writeDouble(this.WorldZ);
                file.writeInt(this.m_validPickCount);
                for (int i = 0; i < this.m_validPickCount; ++i) {
                    file.writeDouble(this.m_pickedOffset[i]);
                    file.writeDouble(this.m_pickedTime[i]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeGliModel(boolean debug) {
        try {
            if (this.Permanent) {
                System.out.println("Permanent:  computeGliModel");
            }
            this.m_travelTimesValid = false;
            this.m_modelValid = false;
            if (this.m_validPickCount < 1) {
                this.m_reasonNotValid = "Nothing is picked";
                return;
            }
            this.m_velocity[0] = this.m_pickedOffset[0] / this.m_pickedTime[0];
            if (RefractionStaticsProject.singleton().gliNewModelLayerCount() <= 0) {
                this.m_modelValid = true;
                this.m_thickness[0] = 200.0;
                this.m_top[0] = 0.0;
                this.m_bottom[0] = this.m_top[0] + this.m_thickness[0];
                return;
            }
            boolean pause = false;
            for (int l = 1; l <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                double deltaOffset = this.m_pickedOffset[l] - this.m_pickedOffset[l - 1];
                double deltaTime = this.m_pickedTime[l] - this.m_pickedTime[l - 1];
                this.m_velocity[l] = deltaOffset / deltaTime;
                if (!(this.m_velocity[l] < 1.0005 * this.m_velocity[l - 1])) continue;
                this.m_reasonNotValid = "Picked velocities do not increase in time";
                return;
            }
            double[] v = this.m_velocity;
            double[] x = this.m_pickedOffset;
            double[] h = this.m_thickness;
            double[] t = this.m_SRTime;
            double[] d = this.m_SRDistance;
            double num = x[0] * Math.sqrt(v[1] * v[1] - v[0] * v[0]);
            double denom = 2.0 * (v[1] + v[0]);
            h[0] = num / denom;
            t[0] = h[0] / (v[0] * Math.sqrt(1.0 - v[0] * v[0] / (v[1] * v[1])));
            d[0] = h[0] * Math.sqrt(v[0] * v[0] / (v[1] * v[1] - v[0] * v[0]));
            this.m_top[0] = 0.0;
            this.m_bottom[0] = this.m_top[0] + h[0];
            this.m_top[1] = this.m_bottom[0];
            this.m_bottom[1] = 1.1 * this.m_top[1];
            h[1] = this.m_bottom[1] - this.m_top[1];
            for (int layer = 1; layer < RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++layer) {
                double upperTime = 2.0 * t[layer - 1] + (x[layer] - 2.0 * d[layer - 1]) / v[layer];
                double layerTime = x[layer] / v[layer + 1];
                double upperSumT = 0.0;
                double upperSumD = 0.0;
                for (int i = 0; i < layer; ++i) {
                    upperSumT += h[i] / (v[i] * Math.sqrt(1.0 - v[i] * v[i] / (v[layer + 1] * v[layer + 1])));
                    upperSumD += h[i] * Math.sqrt(v[i] * v[i] / (v[layer + 1] * v[layer + 1] - v[i] * v[i]));
                }
                double factor = Math.sqrt(v[layer + 1] * v[layer + 1] / (v[layer + 1] * v[layer + 1] - v[layer] * v[layer])) / v[layer] - Math.sqrt(v[layer] * v[layer] / (v[layer + 1] * v[layer + 1] - v[layer] * v[layer])) / v[layer + 1];
                h[layer] = ((upperTime - layerTime) / 2.0 - upperSumT + upperSumD / v[layer + 1]) / factor;
                t[layer] = upperSumT + h[layer] * (Math.sqrt(v[layer + 1] * v[layer + 1] / (v[layer + 1] * v[layer + 1] - v[layer] * v[layer])) / v[layer]);
                d[layer] = upperSumD + h[layer] * Math.sqrt(v[layer] * v[layer] / (v[layer + 1] * v[layer + 1] - v[layer] * v[layer]));
                this.m_bottom[layer] = this.m_top[layer] + h[layer];
                this.m_top[layer + 1] = this.m_bottom[layer];
                this.m_bottom[layer + 1] = 1.2 * this.m_top[layer];
            }
            if (debug) {
                pause = false;
            }
            this.m_modelValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getTravelTime_GliModel(double offset) {
        try {
            double minTime = offset / this.m_velocity[0];
            for (int l = 0; l <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                double time = 2.0 * this.m_SRTime[l] + (offset - 2.0 * this.m_SRDistance[l]) / this.m_velocity[l];
                double tempTime = minTime;
                minTime = Math.min(time, tempTime);
            }
            return 1000.0 * minTime;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public double getVelocityFromDepth_GliModel(double depth) throws Exception {
        try {
            if (!this.m_modelValid) {
                throw new Exception("Model not valid");
            }
            if (RefractionStaticsProject.singleton().gliNewModelLayerCount() == 0) {
                return this.m_velocity[0];
            }
            if (depth <= 0.0) {
                return this.m_velocity[0];
            }
            if (depth >= this.m_bottom[RefractionStaticsProject.singleton().gliNewModelLayerCount()]) {
                return this.m_velocity[RefractionStaticsProject.singleton().gliNewModelLayerCount()];
            }
            for (int l = 0; l <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                if (!(depth >= this.m_top[l]) || !(depth <= this.m_bottom[l])) continue;
                return this.m_velocity[l];
            }
            this.m_modelValid = false;
            return 100.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.m_modelValid) {
                return;
            }
            if (supplementalData == PaintPicks) {
                this.Java2D_PaintPicks(paintParameter, supplementalData);
                return;
            }
            if (supplementalData == PaintModel) {
                this.Java2D_PaintModel(paintParameter, supplementalData);
                return;
            }
            if (supplementalData == PaintSegments) {
                this.Java2D_PaintSegments(paintParameter, supplementalData);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintPicks(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (!this.m_modelValid) {
                if (this.Permanent) {
                    System.out.println("Permanent:  m_modelValid == false");
                }
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.GREEN);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int x = (int)(scaleX * this.m_pickedOffset[0] + shiftX);
            double t = 1000.0 * this.m_pickedTime[0];
            if (this.ApplyLMO) {
                t -= 1000.0 * this.m_pickedOffset[0] / this.VelocityLMO;
            }
            int ti = (int)(scaleY * t + shiftY);
            g2d.drawLine(0, 0, x, ti);
            for (int i = 1; i <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++i) {
                int ix1 = (int)(scaleX * this.m_pickedOffset[i - 1] + shiftX);
                int ix2 = (int)(scaleX * this.m_pickedOffset[i] + shiftX);
                double t1 = 1000.0 * this.m_pickedTime[i - 1];
                double t2 = 1000.0 * this.m_pickedTime[i];
                if (this.ApplyLMO) {
                    t1 -= 1000.0 * this.m_pickedOffset[i - 1] / this.VelocityLMO;
                    t2 -= 1000.0 * this.m_pickedOffset[i] / this.VelocityLMO;
                }
                int iy1 = (int)(scaleY * t1 + shiftY);
                int iy2 = (int)(scaleY * t2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintModel(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int l;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_4);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (l = 0; l < RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                int ix1 = (int)(scaleX * this.m_velocity[l] + shiftX);
                int ix2 = (int)(scaleX * this.m_velocity[l + 1] + shiftX);
                int iy = (int)(scaleY * this.m_bottom[l] + shiftY);
                g2d.drawLine(ix1, iy, ix2, iy);
            }
            for (l = 0; l <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                int ix = (int)(scaleX * this.m_velocity[l] + shiftX);
                int iy1 = (int)(scaleY * this.m_top[l] + shiftY);
                int iy2 = (int)(scaleY * this.m_bottom[l] + shiftY);
                if (l == RefractionStaticsProject.singleton().gliNewModelLayerCount()) {
                    iy2 = 2000;
                }
                g2d.drawLine(ix, iy1, ix, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void Java2D_PaintSegments(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int l;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (!this.m_modelValid) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(this.LineColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (l = 0; l < RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                int ix1 = (int)(scaleX * this.m_velocity[l] + shiftX);
                int ix2 = (int)(scaleX * this.m_velocity[l + 1] + shiftX);
                int iy = (int)(scaleY * this.m_bottom[l] + shiftY);
                g2d.drawLine(ix1, iy, ix2, iy);
            }
            for (l = 0; l <= RefractionStaticsProject.singleton().gliNewModelLayerCount(); ++l) {
                int ix = (int)(scaleX * this.m_velocity[l] + shiftX);
                int iy1 = (int)(scaleY * this.m_top[l] + shiftY);
                int iy2 = (int)(scaleY * this.m_bottom[l] + shiftY);
                if (l == RefractionStaticsProject.singleton().gliNewModelLayerCount()) {
                    iy2 = 2000;
                }
                g2d.drawLine(ix, iy1, ix, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == PaintSegments) {
                if (!this.m_modelValid) {
                    return;
                }
                rangeX.expandRange(this.m_velocity[0] * 0.9);
                rangeX.expandRange(this.m_velocity[this.m_velocity.length - 1] * 1.1);
                rangeY.expandRange(-20.0);
                rangeY.expandRange(this.m_bottom[this.m_bottom.length - 1] + 50.0);
            }
            if (supplementalData == PaintModel) {
                if (!this.m_modelValid) {
                    return;
                }
                rangeX.expandRange(this.m_velocity[0] * 0.9);
                rangeX.expandRange(this.m_velocity[RefractionStaticsProject.singleton().gliNewModelLayerCount()] * 1.1);
                rangeY.expandRange(-20.0);
                rangeY.expandRange(this.m_bottom[RefractionStaticsProject.singleton().gliNewModelLayerCount()] * 1.1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

