/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class WaterBottomCorrection {
    protected static WaterBottomCorrection m_singleton = null;

    public static int getIndexFromMethod(Method method) {
        try {
            return method.ordinal();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 2;
        }
    }

    public static Method getMethodFromIndex(int index) {
        try {
            return Method.values()[index];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Method.VerticalTime;
        }
    }

    protected WaterBottomCorrection() {
    }

    public static WaterBottomCorrection singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new WaterBottomCorrection();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static float computeThreadSafe(Method method, float waterDepth, float pointDepth, double waterVelocity, double refractorVelocity) throws Exception {
        try {
            if (method == Method.None) {
                return 0.0f;
            }
            if (waterDepth < 1.0f) {
                return 0.0f;
            }
            if ((pointDepth = Math.max(0.0f, pointDepth)) >= waterDepth) {
                return 0.0f;
            }
            double heightAboveOceanBottom = waterDepth - pointDepth;
            if (method == Method.VerticalTime) {
                return 0.0f - (float)(1000.0 * heightAboveOceanBottom / waterVelocity);
            }
            refractorVelocity = Math.max(refractorVelocity, 1.2 * waterVelocity);
            double temp = 1000.0 * heightAboveOceanBottom * Math.sqrt(refractorVelocity * refractorVelocity - waterVelocity * waterVelocity) / (waterVelocity * refractorVelocity);
            return 0.0f - (float)temp;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float compute(Method method, double waterDepth, double pointDepth, double waterVelocity, double refractorVelocity) {
        try {
            if (method == Method.None) {
                return 0.0f;
            }
            if (waterDepth < 1.0) {
                return 0.0f;
            }
            if ((pointDepth = Math.max(0.0, pointDepth)) >= waterDepth) {
                return 0.0f;
            }
            double heightAboveOceanBottom = waterDepth - pointDepth;
            if (method == Method.VerticalTime) {
                return 0.0f - (float)(1000.0 * heightAboveOceanBottom / waterVelocity);
            }
            refractorVelocity = Math.max(refractorVelocity, 1.2 * waterVelocity);
            double temp = 1000.0 * heightAboveOceanBottom * Math.sqrt(refractorVelocity * refractorVelocity - waterVelocity * waterVelocity) / (waterVelocity * refractorVelocity);
            return 0.0f - (float)temp;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public void compute(Ensemble ensemble) {
        try {
            this.computeWithMethod(ensemble, RefractionStaticsProject.singleton().getWaterDepthCorrectionMethod());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void computeWithMethod(Ensemble ensemble, Method method) {
        try {
            this.computeWithMethod("Shot", ensemble, method);
            this.computeWithMethod("Receiver", ensemble, method);
            int indexShotCorrection = ensemble.dictionary().addEntry("Shot", "WaterBottomCorrection", DataType.Double);
            int indexRecCorrection = ensemble.dictionary().addEntry("Receiver", "WaterBottomCorrection", DataType.Double);
            int indexTraceCorrection = ensemble.dictionary().addEntry("Trace", "WaterBottomCorrection", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double corrRec = ensemble.trace(n).header().getDouble(indexRecCorrection);
                double corrSht = ensemble.trace(n).header().getDouble(indexShotCorrection);
                double total = corrRec + corrSht;
                ensemble.trace(n).header().putDouble(indexTraceCorrection, total);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void computeWithMethod(String table, Ensemble ensemble, Method method) {
        try {
            int indexCorrection = ensemble.dictionary().addEntry(table, "WaterBottomCorrection", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace(n).header().putDouble(indexCorrection, 0.0);
            }
            if (method == Method.None) {
                return;
            }
            if (!ensemble.dictionary().containsEntry(table, "WaterDepth")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry(table, "PointDepth")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry(table, Pecos.getColNameVel(1))) {
                method = Method.VerticalTime;
            }
            int indexWaterDepth = ensemble.dictionary().getEntryIndex_ReturnInvalid(table, "WaterDepth");
            int indexPointDepth = ensemble.dictionary().getEntryIndex_ReturnInvalid(table, "PointDepth");
            int indexVelocity = ensemble.dictionary().getEntryIndex_ReturnInvalid(table, Pecos.getColNameVel(1));
            double waterVel = RefractionStaticsProject.singleton().getWaterVelocity();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double waterDepth = ensemble.trace(n).header().getDouble(indexWaterDepth);
                double pointDepth = ensemble.trace(n).header().getDouble(indexPointDepth);
                double corr = 0.0;
                if (method == Method.VerticalTime) {
                    corr = this.compute(method, waterDepth, pointDepth, waterVel, 2.0 * waterVel);
                }
                if (method == Method.RaypathCorrection) {
                    double refVel = ensemble.trace(n).header().getDouble(indexVelocity);
                    corr = this.compute(method, waterDepth, pointDepth, waterVel, refVel);
                }
                ensemble.trace(n).header().putDouble(indexCorrection, corr);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum Method {
        None("Do not apply a correction"),
        VerticalTime("Use travel time from shot (or receiver) to water bottom"),
        RaypathCorrection("Raypath correction (computed using refractor velocity)");

        public final String Description;

        private Method(String description) {
            this.Description = description;
        }
    }
}

