/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class UpholeCorrection {
    protected static UpholeCorrection m_singleton = null;
    public double UpholeTime = 0.0;
    public double PointDepth = 0.0;
    public double[] DelayTime = new double[10];
    public double[] Velocity = new double[10];
    public double UpholeVelocity = 0.0;
    public double WeatheringThickness = 0.0;

    public static int getIndexFromMethod(Method method) {
        try {
            return method.ordinal();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 2;
        }
    }

    public static Method getMethodFromIndex(int index) {
        try {
            return Method.values()[index];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Method.SoftwareDeterminesBest;
        }
    }

    protected UpholeCorrection() {
    }

    public static UpholeCorrection singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new UpholeCorrection();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public float compute(int branch, Method method) {
        try {
            if (this.DelayTime[1] < 1.0 || this.Velocity[1] < 100.0 || this.PointDepth < 1.0) {
                if (method == Method.JustUseUpholeTime) {
                    return (float)this.UpholeTime;
                }
                return 0.0f;
            }
            if (method == Method.None) {
                return 0.0f;
            }
            if (method == Method.JustUseUpholeTime) {
                if (this.UpholeTime > 0.2) {
                    return (float)Math.max(this.UpholeTime, 0.0);
                }
                if (this.Velocity[1] < 100.0) {
                    return 0.0f;
                }
                double approxVel = 0.5 * this.Velocity[1];
                double uphole = 1000.0 * Math.max(this.PointDepth, 0.0) / approxVel;
                uphole = Math.max(uphole, 0.0);
                uphole = Math.min(uphole, 50.0);
                return (float)uphole;
            }
            if (this.DelayTime[1] < 1.0 || this.Velocity[1] < 100.0 || this.PointDepth < 1.0) {
                return 0.0f;
            }
            this.UpholeVelocity = this.UpholeTime > 2.0 ? 1000.0 * this.PointDepth / this.UpholeTime : 0.5 * this.Velocity[1];
            this.UpholeVelocity = Math.min(this.UpholeVelocity, 0.65 * this.Velocity[1]);
            this.UpholeVelocity = Math.max(this.UpholeVelocity, 0.35 * this.Velocity[1]);
            double fac1 = Math.sqrt(this.Velocity[1] * this.Velocity[1] - this.UpholeVelocity * this.UpholeVelocity);
            double fac2 = this.Velocity[1] * this.UpholeVelocity / fac1;
            this.WeatheringThickness = 0.001 * this.DelayTime[1] * fac2;
            if (this.PointDepth < this.WeatheringThickness) {
                double angle = Math.asin(this.UpholeVelocity / this.Velocity[1]);
                double path1 = this.PointDepth / (this.UpholeVelocity * Math.cos(angle));
                double path2 = this.PointDepth * Math.tan(angle) / this.Velocity[1];
                double upholeCorr = path1 - path2;
                upholeCorr *= 1000.0;
                upholeCorr = Math.max(0.0, upholeCorr);
                return (float)upholeCorr;
            }
            return (float)this.DelayTime[1];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public static float computeThreadSafe(int branch, int row, Method method, float[][] delayTimes, float[][] velocities, float[] pointDepth, float[] upholeTime) throws Exception {
        try {
            double fac1;
            if (delayTimes[row][1] < 1.0f || velocities[row][1] < 100.0f || pointDepth[row] < 1.0f) {
                if (method == Method.JustUseUpholeTime) {
                    return upholeTime[row];
                }
                return 0.0f;
            }
            if (method == Method.None) {
                return 0.0f;
            }
            if (method == Method.JustUseUpholeTime) {
                if ((double)upholeTime[row] > 0.2) {
                    return Math.max(upholeTime[row], 0.0f);
                }
                if (velocities[row][1] < 100.0f) {
                    return 0.0f;
                }
                double approxVel = 0.5 * (double)velocities[row][1];
                double uphole = 1000.0 * Math.max((double)pointDepth[row], 0.0) / approxVel;
                uphole = Math.max(uphole, 0.0);
                uphole = Math.min(uphole, 50.0);
                return (float)uphole;
            }
            if (delayTimes[row][1] < 1.0f || velocities[row][1] < 100.0f || pointDepth[row] < 1.0f) {
                return 0.0f;
            }
            double upholeVelocity = upholeTime[row] > 2.0f ? (double)(1000.0f * pointDepth[row] / upholeTime[row]) : 0.5 * (double)velocities[row][1];
            upholeVelocity = Math.min(upholeVelocity, 0.65 * (double)velocities[row][1]);
            double fac2 = (double)velocities[row][1] * (upholeVelocity = Math.max(upholeVelocity, 0.35 * (double)velocities[row][1])) / (fac1 = Math.sqrt((double)(velocities[row][1] * velocities[row][1]) - upholeVelocity * upholeVelocity));
            double weatheringThickness = 0.001 * (double)delayTimes[row][1] * fac2;
            if ((double)pointDepth[row] < weatheringThickness) {
                double angle = Math.asin(upholeVelocity / (double)velocities[row][1]);
                double path1 = (double)pointDepth[row] / (upholeVelocity * Math.cos(angle));
                double path2 = (double)pointDepth[row] * Math.tan(angle) / (double)velocities[row][1];
                double upholeCorr = path1 - path2;
                upholeCorr *= 1000.0;
                upholeCorr = Math.max(0.0, upholeCorr);
                return (float)upholeCorr;
            }
            return delayTimes[row][1];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void compute(Ensemble ensemble) {
        try {
            this.computeWithMethod(ensemble, RefractionStaticsProject.singleton().getUpholeCorrectionMethod());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void computeWithMethod(Ensemble ensemble, Method method) {
        try {
            int indexUpholeCorrection = ensemble.dictionary().addEntry("Shot", "UpholeCorrection", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace(n).header().putDouble(indexUpholeCorrection, 0.0);
            }
            if (method == Method.None) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "UpholeTime")) {
                return;
            }
            int indexUphole = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "UpholeTime");
            int indexDepth = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "PointDepth");
            int indexDelayTime = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", Pecos.getColNameDT(1));
            int indexVelocity = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", Pecos.getColNameVel(1));
            int indexWaterDepth = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "WaterDepth");
            this.PointDepth = 0.0;
            this.DelayTime[1] = -9999.0;
            this.Velocity[1] = -9999.0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                boolean shotInWater = false;
                if (indexWaterDepth >= 0) {
                    double depth = ensemble.trace(n).header().getDouble(indexWaterDepth);
                    shotInWater = depth > 0.0;
                }
                this.UpholeTime = ensemble.trace(n).header().getDouble(indexUphole);
                if (indexDepth >= 0) {
                    this.PointDepth = ensemble.trace(n).header().getDouble(indexDepth);
                }
                if (indexDelayTime >= 0) {
                    this.DelayTime[1] = ensemble.trace(n).header().getDouble(indexDelayTime);
                }
                if (indexVelocity >= 0) {
                    this.Velocity[1] = ensemble.trace(n).header().getDouble(indexVelocity);
                }
                double corr = this.compute(1, method);
                if (shotInWater) {
                    corr = 0.0;
                }
                ensemble.trace(n).header().putDouble(indexUpholeCorrection, corr);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static enum Method {
        None("Do not apply an uphole correction"),
        JustUseUpholeTime("Use the uphole time"),
        SoftwareDeterminesBest("Raypath correction (computed using delay time solution)");

        public final String Description;

        private Method(String description) {
            this.Description = description;
        }
    }
}

