/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchColors;
import java.awt.Color;
import java.awt.Graphics2D;

public class DelayTimeModelProfiler
implements Java2D_PaintableInterface {
    protected double m_startWorldX;
    protected double m_startWorldY;
    protected double m_endWorldX;
    protected double m_endWorldY;
    protected double m_length;
    protected double m_delta;
    protected boolean m_worldOK = false;
    protected boolean m_valid = false;
    protected double[][] m_depth = new double[10][200];
    protected double[][] m_velocity = new double[10][200];
    protected boolean[] m_depthOK = new boolean[10];
    protected boolean[] m_velocityOK = new boolean[10];
    protected int m_maxBranch = 0;

    public void setLocation(double x1, double y1, double x2, double y2) {
        try {
            this.m_startWorldX = x1;
            this.m_startWorldY = y1;
            this.m_endWorldX = x2;
            this.m_endWorldY = y2;
            double dx = this.m_endWorldX - this.m_startWorldX;
            double dy = this.m_endWorldY - this.m_startWorldY;
            this.m_length = Math.sqrt(dx * dx + dy * dy + 1.0E-4);
            this.m_delta = this.m_length / (double)this.m_depth[0].length;
            this.m_worldOK = true;
            this.compute();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void compute() {
        try {
            String name;
            int b;
            this.m_valid = false;
            for (int b2 = 0; b2 <= 8; ++b2) {
                this.m_depthOK[b2] = false;
                this.m_velocityOK[b2] = false;
            }
            if (!this.m_worldOK) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_maxBranch = project.delayTimeData().branchAssignment().maxBranch();
            int[] indexShotZ = new int[3 + this.m_maxBranch];
            int[] indexShotV = new int[3 + this.m_maxBranch];
            int[] indexRecZ = new int[3 + this.m_maxBranch];
            int[] indexRecV = new int[3 + this.m_maxBranch];
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            int indexSX = shotTable.column_indexOfColumn("Easting");
            int indexSY = shotTable.column_indexOfColumn("Northing");
            int indexSK = shotTable.column_indexOfColumn("Killed");
            int indexRX = recTable.column_indexOfColumn("Easting");
            int indexRY = recTable.column_indexOfColumn("Northing");
            int indexRK = recTable.column_indexOfColumn("Killed");
            indexShotZ[0] = shotTable.column_indexOfColumn("Elevation");
            indexRecZ[0] = recTable.column_indexOfColumn("Elevation");
            this.m_depthOK[0] = true;
            for (b = 1; b <= this.m_maxBranch; ++b) {
                name = Pecos.getColNameElev(b);
                indexShotZ[b] = -9999;
                if (shotTable.column_exists(name)) {
                    indexShotZ[b] = shotTable.column_indexOfColumn(name);
                }
                indexRecZ[b] = -9999;
                if (recTable.column_exists(name)) {
                    indexRecZ[b] = recTable.column_indexOfColumn(name);
                }
                this.m_depthOK[b] = indexShotZ[b] >= 0 || indexRecZ[b] >= 0;
            }
            for (b = 0; b <= this.m_maxBranch; ++b) {
                name = Pecos.getColNameVel(b);
                indexShotV[b] = -9999;
                if (shotTable.column_exists(name)) {
                    indexShotV[b] = shotTable.column_indexOfColumn(name);
                }
                indexRecV[b] = -9999;
                if (recTable.column_exists(name)) {
                    indexRecV[b] = recTable.column_indexOfColumn(name);
                }
                this.m_velocityOK[b] = indexShotV[b] >= 0 || indexRecV[b] >= 0;
            }
            int num = this.m_depth[0].length;
            double dx = (this.m_endWorldX - this.m_startWorldX) / (double)(num - 1);
            double dy = (this.m_endWorldY - this.m_startWorldY) / (double)(num - 1);
            double[] sumV = new double[10];
            double[] sumVW = new double[10];
            double[] sumZ = new double[10];
            double[] sumZW = new double[10];
            for (int n = 0; n < num; ++n) {
                double v;
                double z;
                int b3;
                double weight;
                double rsq;
                double dely;
                double delx;
                double y1;
                double x1;
                int row;
                int b4;
                double x = this.m_startWorldX + dx * (double)n;
                double y = this.m_startWorldY + dy * (double)n;
                for (b4 = 0; b4 < 10; ++b4) {
                    sumV[b4] = 0.0;
                    sumVW[b4] = 1.0E-70;
                    sumZ[b4] = 0.0;
                    sumZW[b4] = 1.0E-70;
                }
                for (row = 0; row < recTable.row_count(); ++row) {
                    if (recTable.getBool(row, indexRK)) continue;
                    x1 = recTable.getDouble(row, indexRX);
                    y1 = recTable.getDouble(row, indexRY);
                    delx = x - x1;
                    dely = y - y1;
                    rsq = delx * delx + dely * dely + 1.0;
                    weight = 1.0 / rsq;
                    for (b3 = 0; b3 <= this.m_maxBranch; ++b3) {
                        if (indexRecZ[b3] >= 0) {
                            z = recTable.getDouble(row, indexRecZ[b3]);
                            sumZ[b3] = sumZ[b3] + z * weight;
                            sumZW[b3] = sumZW[b3] + weight;
                        }
                        if (indexRecV[b3] < 0) continue;
                        v = recTable.getDouble(row, indexRecV[b3]);
                        sumV[b3] = sumV[b3] + v * weight;
                        sumVW[b3] = sumVW[b3] + weight;
                    }
                }
                for (row = 0; row < shotTable.row_count(); ++row) {
                    if (shotTable.getBool(row, indexSK)) continue;
                    x1 = shotTable.getDouble(row, indexSX);
                    y1 = shotTable.getDouble(row, indexSY);
                    delx = x - x1;
                    dely = y - y1;
                    rsq = delx * delx + dely * dely + 1.0;
                    weight = 1.0 / rsq;
                    for (b3 = 0; b3 <= this.m_maxBranch; ++b3) {
                        if (indexShotZ[b3] >= 0) {
                            z = shotTable.getDouble(row, indexShotZ[b3]);
                            sumZ[b3] = sumZ[b3] + z * weight;
                            sumZW[b3] = sumZW[b3] + weight;
                        }
                        if (indexShotV[b3] < 0) continue;
                        v = shotTable.getDouble(row, indexShotV[b3]);
                        sumV[b3] = sumV[b3] + v * weight;
                        sumVW[b3] = sumVW[b3] + weight;
                    }
                }
                for (b4 = 0; b4 <= this.m_maxBranch; ++b4) {
                    this.m_depth[b4][n] = sumZ[b4] / sumZW[b4];
                    this.m_velocity[b4][n] = sumV[b4] / sumVW[b4];
                }
            }
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return supplementalData != PlotType.Map.ordinal();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    protected void mapPlot(Java2D_PaintParameter paintParameter) {
        try {
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            transform.drawLine(g2d, this.m_startWorldX, this.m_startWorldY, this.m_endWorldX, this.m_endWorldY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void depthPlot(Java2D_PaintParameter paintParameter) {
        try {
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setFont(Tools_FontLibrary.Font14);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stringWidth = g2d.getFontMetrics().stringWidth("0");
            for (int b = 0; b <= this.m_maxBranch; ++b) {
                if (b == 0) {
                    g2d.setColor(Color.black);
                } else {
                    g2d.setColor(BranchColors.solidColor(b));
                }
                if (b == 0) {
                    s = "Surface elevation";
                    iy1 = (int)(scaleY * this.m_depth[b][0] + shiftY);
                    g2d.drawString((String)s, 10, iy1 + 3 + stringHeight);
                } else {
                    s = "Refractor " + Integer.toString(b) + " Elevation";
                    iy1 = (int)(scaleY * this.m_depth[b][0] + shiftY);
                    g2d.drawString((String)s, 10, iy1 - 3);
                }
                if (!this.m_depthOK[b]) continue;
                for (int n = 0; n < this.m_depth[b].length - 1; ++n) {
                    double x1 = this.m_delta * (double)n;
                    double x2 = this.m_delta * (double)(n + 1);
                    int ix1 = (int)(scaleX * x1 + shiftX);
                    int iy1 = (int)(scaleY * this.m_depth[b][n] + shiftY);
                    int ix2 = (int)(scaleX * x2 + shiftX);
                    int iy2 = (int)(scaleY * this.m_depth[b][n + 1] + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            transform.drawLine(g2d, this.m_startWorldX, this.m_startWorldY, this.m_endWorldX, this.m_endWorldY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void velPlot(Java2D_PaintParameter paintParameter) {
        try {
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setFont(Tools_FontLibrary.Font14);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stringWidth = g2d.getFontMetrics().stringWidth("0");
            for (int b = 0; b <= this.m_maxBranch; ++b) {
                if (b == 0) {
                    g2d.setColor(Color.black);
                } else {
                    g2d.setColor(BranchColors.solidColor(b));
                }
                if (b == 0) {
                    s = "Weathering velocity";
                    iy1 = (int)(scaleY * this.m_velocity[b][0] + shiftY);
                    g2d.drawString((String)s, 10, iy1 - 6);
                } else {
                    s = "Refractor " + Integer.toString(b) + " Velocity";
                    iy1 = (int)(scaleY * this.m_velocity[b][0] + shiftY);
                    g2d.drawString((String)s, 10, iy1 + 3 + stringHeight);
                }
                if (!this.m_velocityOK[b]) continue;
                for (int n = 0; n < this.m_velocity[b].length - 1; ++n) {
                    double x1 = this.m_delta * (double)n;
                    double x2 = this.m_delta * (double)(n + 1);
                    int ix1 = (int)(scaleX * x1 + shiftX);
                    int iy1 = (int)(scaleY * this.m_velocity[b][n] + shiftY);
                    int ix2 = (int)(scaleX * x2 + shiftX);
                    int iy2 = (int)(scaleY * this.m_velocity[b][n + 1] + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            transform.drawLine(g2d, this.m_startWorldX, this.m_startWorldY, this.m_endWorldX, this.m_endWorldY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.m_worldOK) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (supplementalData == PlotType.Map.ordinal()) {
                this.mapPlot(paintParameter);
            }
            if (supplementalData == PlotType.Depth.ordinal()) {
                this.depthPlot(paintParameter);
            }
            if (supplementalData == PlotType.Velocity.ordinal()) {
                this.velPlot(paintParameter);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            int b;
            if (this.m_valid) {
                // empty if block
            }
            if (this.m_valid && supplementalData == PlotType.Depth.ordinal()) {
                rangeX.expandRange(0.0);
                rangeX.expandRange(this.m_length);
                for (b = 0; b <= this.m_maxBranch; ++b) {
                    if (!this.m_depthOK[b]) continue;
                    rangeY.expandRange(this.m_depth[b]);
                }
                rangeY.addPercentBuffer(5.0);
            }
            if (this.m_valid && supplementalData == PlotType.Velocity.ordinal()) {
                rangeX.expandRange(0.0);
                rangeX.expandRange(this.m_length);
                for (b = 0; b <= this.m_maxBranch; ++b) {
                    if (!this.m_velocityOK[b]) continue;
                    rangeY.expandRange(this.m_velocity[b]);
                }
                rangeY.addPercentBuffer(5.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static enum PlotType {
        Map,
        Velocity,
        Depth;

    }
}

