/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.AxisGrid;
import com.PecosLibrary.Math.AxisGrid_PathNode;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class DelayTimeData {
    protected String m_path;
    protected BranchAssignment m_branchAssignmentData;
    protected String m_branchFileName;
    protected boolean m_velocity_analysis_standard = true;
    protected double m_analysisGridSize = 300.0;
    protected double m_grid_origin_x = 0.0;
    protected double m_grid_origin_y = 0.0;
    protected int m_grid_count_x = 10;
    protected int m_grid_count_y = 10;
    protected AxisGrid m_temp_axis_grid;
    protected String m_grid_path;
    protected HashMap<String, AxisGrid> m_grid_map = new HashMap();
    protected double[] m_sum1 = new double[20];
    protected double[] m_sum2 = new double[20];
    protected WeakReference<RefractionStaticsProject> m_projectRef;
    protected String m_historyFileName;
    protected History m_history;
    protected ParameterTree m_information;
    protected String m_paramFileName;
    public boolean WeatherVelocityModified = false;

    public boolean is_standard_velocity() {
        try {
            if (this.m_velocity_analysis_standard) {
                return true;
            }
            int max_branch = this.branchAssignment().maxBranch();
            for (int b = 1; b <= max_branch; ++b) {
                if (this.grid_exists(b, "Velocity")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean is_gridded_velocity() {
        return !this.is_standard_velocity();
    }

    public void set_is_gridded_velocity(boolean is_gridded) {
        try {
            this.m_velocity_analysis_standard = !is_gridded;
            this.m_information.bool_put("StandardVelocityAnalysis", this.m_velocity_analysis_standard);
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String grid_name(int branch, String attribute) {
        return attribute + "_" + String.valueOf(branch);
    }

    public String grid_file_name(int branch, String attribute) {
        return this.m_grid_path + "/" + this.grid_name(branch, attribute);
    }

    public void grid_update_velocity_in_tables() {
        try {
            for (int b = 1; b <= this.branchAssignment().maxBranch(); ++b) {
                String col = Pecos.getColNameVel(b);
                String grid = this.grid_name(b, "Velocity");
                this.grid(b, "Velocity").update_table(((RefractionStaticsProject)this.m_projectRef.get()).getShotTable(), col);
                this.grid(b, "Velocity").update_table(((RefractionStaticsProject)this.m_projectRef.get()).getRecTable(), col);
                this.grid_save(b, "Velocity");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void grid_create_all_velocity_grids_from_tables() {
        try {
            for (int b = 1; b <= this.branchAssignment().maxBranch(); ++b) {
                String col = Pecos.getColNameVel(b);
                String grid = this.grid_name(b, "Velocity");
                this.grid(b, "Velocity").create_from_tables(((RefractionStaticsProject)this.m_projectRef.get()).getShotTable(), ((RefractionStaticsProject)this.m_projectRef.get()).getRecTable(), col);
                this.grid_save(b, "Velocity");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void grid_velocity_update_finish(int b, float max_percent_change, float raypathFoldPercent) throws Exception {
        try {
            float[][] array_v = this.grid(b, "Velocity").grid();
            float[][] array_w = this.grid(b, "Velocity").array("SumW");
            float[][] array_wf = this.grid(b, "Velocity").array("SumWF");
            float[][] array_err = this.grid(b, "Velocity").array("SumError");
            float[][] array_count = this.grid(b, "Velocity").array("Count");
            int nx = this.grid(b, "Velocity").numCellsX();
            int ny = this.grid(b, "Velocity").numCellsY();
            double sum_w = 0.0;
            double count_w = 0.01;
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    if (!(array_w[x][y] > 0.25f)) continue;
                    sum_w += (double)array_w[x][y];
                    count_w += 1.0;
                }
            }
            double average_w = sum_w / count_w;
            float min_w = (float)(0.01 * (double)raypathFoldPercent * average_w);
            boolean[][] b1 = new boolean[nx][ny];
            boolean[][] b2 = new boolean[nx][ny];
            float max_ratio = 1.0f + 0.01f * max_percent_change;
            float min_ratio = 1.0f / max_ratio;
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    b1[x][y] = false;
                    float v = array_v[x][y];
                    float w = array_w[x][y];
                    float wf = array_wf[x][y];
                    if (w > min_w) {
                        b1[x][y] = true;
                        float ratio = wf / w;
                        ratio = Math.min(ratio, max_ratio);
                        ratio = Math.max(ratio, min_ratio);
                        float new_v = v * ratio;
                        float change = new_v - v;
                        array_v[x][y] = new_v = v - 0.6f * change;
                        continue;
                    }
                    b1[x][y] = false;
                    array_w[x][y] = 0.01f * (float)average_w;
                }
            }
            boolean keepgoing = true;
            while (keepgoing) {
                int x;
                keepgoing = false;
                for (x = 0; x < nx; ++x) {
                    for (int y = 0; y < ny; ++y) {
                        b2[x][y] = b1[x][y];
                        if (b1[x][y]) continue;
                        keepgoing = true;
                        int numadjacent = 0;
                        int minx = Math.max(x - 4, 0);
                        int maxx = Math.min(x + 4, nx - 1);
                        int miny = Math.max(y - 4, 0);
                        int maxy = Math.min(y + 4, ny - 1);
                        double s1 = 0.0;
                        double s2 = 1.0E-10;
                        for (int ix = minx; ix <= maxx; ++ix) {
                            for (int iy = miny; iy <= maxy; ++iy) {
                                if (!b1[ix][iy]) continue;
                                int dx = Math.abs(x - ix);
                                int dy = Math.abs(y - iy);
                                if (dx <= 1 && dy <= 1) {
                                    ++numadjacent;
                                }
                                double w = 1.0 / (1.0 + (double)dx + (double)dy);
                                s1 += (double)array_v[ix][iy] * w;
                                s2 += w;
                            }
                        }
                        if (numadjacent < true) continue;
                        b2[x][y] = true;
                        array_v[x][y] = (float)(s1 / s2);
                    }
                }
                for (x = 0; x < nx; ++x) {
                    for (int y = 0; y < ny; ++y) {
                        b1[x][y] = b2[x][y];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float grid_velocity_update(int b, double sx, double sy, double rx, double ry, float picked_travel_time, float corner) throws Exception {
        try {
            float predicted = this.grid_time_noanisotropy(b, sx, sy, rx, ry);
            float error = Math.abs(predicted - picked_travel_time);
            float w = corner / (error + corner);
            float r = picked_travel_time / predicted;
            float[][] array_w = this.grid(b, "Velocity").array("SumW");
            float[][] array_wf = this.grid(b, "Velocity").array("SumWF");
            float[][] array_err = this.grid(b, "Velocity").array("SumError");
            float[][] array_count = this.grid(b, "Velocity").array("Count");
            for (int n = 0; n < this.m_temp_axis_grid.PathNodeCount; ++n) {
                AxisGrid_PathNode node = (AxisGrid_PathNode)this.m_temp_axis_grid.PathNodeList.get(n);
                int x = node.IndexX;
                int y = node.IndexY;
                float[] fArray = array_w[x];
                int n2 = y;
                fArray[n2] = fArray[n2] + w;
                float[] fArray2 = array_wf[x];
                int n3 = y;
                fArray2[n3] = fArray2[n3] + w * r;
                float[] fArray3 = array_err[x];
                int n4 = y;
                fArray3[n4] = fArray3[n4] + error;
                float[] fArray4 = array_count[x];
                int n5 = y;
                fArray4[n5] = fArray4[n5] + 1.0f;
            }
            return Math.abs(predicted - picked_travel_time);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void grid_prep_velocity_update(int branch) throws Exception {
        try {
            this.grid(branch, "Velocity").array_clear("SumW", 0.0f);
            this.grid(branch, "Velocity").array_clear("SumWF", 0.0f);
            this.grid(branch, "Velocity").array_clear("SumError", 0.0f);
            this.grid(branch, "Velocity").array_clear("Count", 0.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float grid_time_anisotropy(int branch, double sx, double sy, double rx, double ry) throws Exception {
        try {
            this.m_temp_axis_grid.prep_path_nodes(sx, sy, rx, ry);
            AxisGrid grid_v = this.grid(branch, "Velocity");
            AxisGrid grid_mag = this.grid(branch, "Magnitude");
            AxisGrid grid_az = this.grid(branch, "Azimuth");
            float t = 0.0f;
            for (int n = 0; n < this.m_temp_axis_grid.PathNodeCount; ++n) {
                AxisGrid_PathNode node = (AxisGrid_PathNode)this.m_temp_axis_grid.PathNodeList.get(n);
                float v = grid_v.getValue(node.IndexX, node.IndexY);
                float az = grid_az.getValue(node.IndexX, node.IndexY);
                float mag = grid_mag.getValue(node.IndexX, node.IndexY);
                float angle = (float)Math.cos(2.0 * ((double)az - this.m_temp_axis_grid.PathAzimuth));
                float dt = 1000.0f * (float)(this.m_temp_axis_grid.PathSegmentLength / (double)(v *= 1.0f + 0.01f * mag * angle));
                if (n == 0 || n == this.m_temp_axis_grid.PathNodeCount - 1) {
                    dt *= 0.5f;
                }
                t += dt;
            }
            return t;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float grid_time_noanisotropy(int branch, double sx, double sy, double rx, double ry) throws Exception {
        try {
            this.m_temp_axis_grid.prep_path_nodes(sx, sy, rx, ry);
            AxisGrid grid_v = this.grid(branch, "Velocity");
            float t = 0.0f;
            for (int n = 0; n < this.m_temp_axis_grid.PathNodeCount; ++n) {
                AxisGrid_PathNode node = (AxisGrid_PathNode)this.m_temp_axis_grid.PathNodeList.get(n);
                float v = grid_v.getValue(node.IndexX, node.IndexY);
                float dt = 1000.0f * (float)(this.m_temp_axis_grid.PathSegmentLength / (double)v);
                if (n == 0 || n == this.m_temp_axis_grid.PathNodeCount - 1) {
                    dt *= 0.5f;
                }
                t += dt;
            }
            return t;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void grid_save(int branch, String attribute) throws Exception {
        try {
            this.grid(branch, attribute).save(this.grid_file_name(branch, attribute));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean grid_exists(int branch, String attribute) throws Exception {
        try {
            String name = this.grid_name(branch, attribute);
            if (this.m_grid_map.containsKey(name)) {
                return true;
            }
            String file = this.grid_file_name(branch, attribute);
            return Tools_FileSystem.exists_file(file);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public AxisGrid grid(int branch, String attribute) throws Exception {
        try {
            String name = this.grid_name(branch, attribute);
            if (!this.m_grid_map.containsKey(name)) {
                String file = this.grid_file_name(branch, attribute);
                if (Tools_FileSystem.exists_file(file)) {
                    AxisGrid grid = new AxisGrid(file);
                    this.m_grid_map.put(name, grid);
                } else {
                    AxisGrid grid = new AxisGrid(this.m_grid_origin_x, this.m_grid_origin_y, this.m_analysisGridSize, this.m_analysisGridSize, this.m_grid_count_x, this.m_grid_count_y);
                    grid.save(file);
                    this.m_grid_map.put(name, grid);
                }
            }
            this.m_temp_axis_grid.compare(this.m_grid_map.get(name));
            return this.m_grid_map.get(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ParameterTree information() {
        return this.m_information;
    }

    public void saveInformation() {
        try {
            this.m_information.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public DelayTimeData(String path, RefractionStaticsProject p) throws Exception {
        try {
            this.m_projectRef = new WeakReference<RefractionStaticsProject>(p);
            if (!Tools_FileSystem.exists_path(path)) {
                throw new Exception("Path does not exist");
            }
            this.m_analysisGridSize = 100.0;
            if (((RefractionStaticsProject)this.m_projectRef.get()).units_feet()) {
                this.m_analysisGridSize = 300.0;
            }
            this.m_path = path;
            this.m_paramFileName = this.m_path + "/ProjectDescription.xml";
            this.m_information = new ParameterTree();
            if (Tools_FileSystem.exists_file(this.m_paramFileName)) {
                this.m_information.read(this.m_paramFileName);
            } else {
                this.m_information.double_put("AnalysisGridSize", this.m_analysisGridSize);
                p.rangeX().print("DelayTimeData consructor");
                double minx = p.rangeX().rangeMin() - 2.0 * this.m_analysisGridSize;
                double maxx = p.rangeX().rangeMax() + 2.0 * this.m_analysisGridSize;
                int nx = 1 + (int)((maxx - minx) / this.m_analysisGridSize);
                double miny = p.rangeY().rangeMin() - 2.0 * this.m_analysisGridSize;
                double maxy = p.rangeY().rangeMax() + 2.0 * this.m_analysisGridSize;
                int ny = 1 + (int)((maxy - miny) / this.m_analysisGridSize);
                this.m_information.double_put("GridOriginX", minx);
                this.m_information.double_put("GridOriginY", miny);
                this.m_information.int_put("GridCountX", nx);
                this.m_information.int_put("GridCountY", ny);
                this.saveInformation();
            }
            this.m_analysisGridSize = this.m_information.double_get("AnalysisGridSize", this.m_analysisGridSize);
            this.m_grid_origin_x = this.m_information.double_get("GridOriginX", 0.0);
            this.m_grid_origin_y = this.m_information.double_get("GridOriginY", 0.0);
            this.m_grid_count_x = this.m_information.int_get("GridCountX", 10);
            this.m_grid_count_y = this.m_information.int_get("GridCountY", 10);
            this.m_temp_axis_grid = new AxisGrid(this.m_grid_origin_x, this.m_grid_origin_y, this.m_analysisGridSize, this.m_analysisGridSize, this.m_grid_count_x, this.m_grid_count_y);
            this.m_grid_path = this.m_path + "/Grids";
            Tools_FileSystem.confirmSubDirectoryExists(path, "Grids");
            this.m_velocity_analysis_standard = this.m_information.bool_get("StandardVelocityAnalysis", true);
            this.m_branchAssignmentData = new BranchAssignment();
            this.m_branchFileName = this.m_path + "/Branch.xml";
            this.m_branchAssignmentData.read(this.m_branchFileName);
            this.removeUnusedRefractorData();
            this.confirmDelayTimeAnisotropyColumnsExist();
            this.m_historyFileName = this.m_path + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public History getHistory() {
        return this.m_history;
    }

    public boolean forceIncreasingVelocities() {
        try {
            this.WeatherVelocityModified = false;
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            boolean mod1 = this.forceIncreasingVelocities(shotTable);
            boolean mod2 = this.forceIncreasingVelocities(recTable);
            return mod1 || mod2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean forceIncreasingVelocities(Table_Abstract table) {
        try {
            boolean mods = false;
            double delta = 1.0;
            int maxBranch = this.m_branchAssignmentData.maxBranch();
            if (maxBranch < 1) {
                return mods;
            }
            String colName1 = Pecos.getColNameVel(0);
            String colName2 = Pecos.getColNameVel(1);
            if (table.column_exists(colName2) && table.column_exists(colName1)) {
                int index1 = table.column_indexOfColumn(colName1);
                int index2 = table.column_indexOfColumn(colName2);
                for (int row = 0; row < table.row_count(); ++row) {
                    double v2;
                    double v1 = table.getDouble(row, index1);
                    if (!(v1 > 0.8 * (v2 = table.getDouble(row, index2)))) continue;
                    this.WeatherVelocityModified = true;
                    mods = true;
                    table.putDouble(row, index1, 0.8 * v2);
                }
            }
            for (int b = 2; b <= maxBranch; ++b) {
                colName1 = Pecos.getColNameVel(b - 1);
                colName2 = Pecos.getColNameVel(b);
                if (!table.column_exists(colName2) || !table.column_exists(colName1)) continue;
                int index1 = table.column_indexOfColumn(colName1);
                int index2 = table.column_indexOfColumn(colName2);
                for (int row = 0; row < table.row_count(); ++row) {
                    double v1 = table.getDouble(row, index1);
                    double v2 = table.getDouble(row, index2);
                    if (!(v2 < v1 + delta)) continue;
                    mods = true;
                    table.putDouble(row, index2, v1 + delta);
                }
            }
            return mods;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean forceIncreasingDelayTimes() {
        try {
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            boolean mod1 = this.forceIncreasingDelayTimes(shotTable);
            boolean mod2 = this.forceIncreasingDelayTimes(recTable);
            return mod1 || mod2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean forceIncreasingDelayTimes(Table_Abstract table) {
        try {
            boolean mods = false;
            double delta = 0.1;
            int maxBranch = this.m_branchAssignmentData.maxBranch();
            for (int b = 2; b <= maxBranch; ++b) {
                String colName1 = Pecos.getColNameDT(b - 1);
                String colName2 = Pecos.getColNameDT(b);
                if (!table.column_exists(colName2) || !table.column_exists(colName1)) continue;
                int index1 = table.column_indexOfColumn(colName1);
                int index2 = table.column_indexOfColumn(colName2);
                for (int row = 0; row < table.row_count(); ++row) {
                    double v1 = table.getDouble(row, index1);
                    double v2 = table.getDouble(row, index2);
                    if (!(v2 < v1 + delta)) continue;
                    mods = true;
                    table.putDouble(row, index2, v1 + delta);
                }
            }
            return mods;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void recomputeShotDelayTimes(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "FBP_User")) {
                return;
            }
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            int maxBranch = this.branchAssignment().maxBranch();
            for (int b = 1; b <= maxBranch; ++b) {
                this.m_sum1[b] = 0.0;
                this.m_sum2[b] = 1.0E-50;
            }
            this.branchAssignment().assignBranch(ensemble, "Branch_DelayTime");
            ensemble.prepDelayTimeAnalysisIndices();
            int headerIndex_BranchUser = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int k = 0; k < ensemble.traceCount(); ++k) {
                Column_Abstract header = ensemble.trace(k).header();
                int branch = header.getInt(headerIndex_BranchUser);
                if (branch < 1) continue;
                float offset = (float)header.getDouble(headerIndex_Offset);
                float recVel = (float)header.getDouble(ensemble.HeaderIndex_RecVel[branch]);
                float shotVel = (float)header.getDouble(ensemble.HeaderIndex_ShotVel[branch]);
                float tt = 1000.0f * offset / (0.5f * (recVel + shotVel));
                double recDT = header.getDouble(ensemble.HeaderIndex_RecDT[branch]);
                double upholeCorrection = header.getDouble(indexUpholeCorr);
                double wbCorrection = header.getDouble(indexWbCorr);
                double pick = header.getDouble(indexPick);
                double shotDT = pick + upholeCorrection + wbCorrection - (double)tt - recDT;
                this.m_sum1[branch] = this.m_sum1[branch] + Math.max(shotDT, 0.0);
                this.m_sum2[branch] = this.m_sum2[branch] + 1.0;
            }
            for (int branch = 1; branch <= maxBranch; ++branch) {
                double dt = this.m_sum1[branch] / this.m_sum2[branch];
                int index = ensemble.HeaderIndex_ShotDT[branch];
                for (int k = 0; k < ensemble.traceCount(); ++k) {
                    Column_Abstract header = ensemble.trace(k).header();
                    double oldDT = header.getDouble(index);
                    header.putDouble(index, dt);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getAnalysisGridBinSize() {
        return this.m_analysisGridSize;
    }

    public void computeRefractorTravelTimes(Ensemble ensemble) {
        try {
            ensemble.prepDelayTimeAnalysisIndices();
            DelayTimeData dtd = RefractionStaticsProject.singleton().getDelayTimeData();
            boolean use_gridded = dtd.is_gridded_velocity();
            if (use_gridded) {
                for (int branch = 1; branch <= this.branchAssignment().maxBranch(); ++branch) {
                    String colName = "TravelTime" + Integer.toString(branch);
                    int headerIndexTT = ensemble.dictionary().addEntry("Trace", colName, DataType.Double);
                    for (int k = 0; k < ensemble.traceCount(); ++k) {
                        Column_Abstract header = ensemble.trace(k).header();
                        double sx = header.getDouble(ensemble.HeaderIndex_ShotX);
                        double sy = header.getDouble(ensemble.HeaderIndex_ShotY);
                        double rx = header.getDouble(ensemble.HeaderIndex_RecX);
                        double ry = header.getDouble(ensemble.HeaderIndex_RecY);
                        float tt = dtd.grid_time_anisotropy(branch, sx, sy, rx, ry);
                        header.putFloat(headerIndexTT, tt);
                    }
                }
            } else {
                int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
                for (int branch = 1; branch <= this.branchAssignment().maxBranch(); ++branch) {
                    String colName = "TravelTime" + Integer.toString(branch);
                    int headerIndexTT = ensemble.dictionary().addEntry("Trace", colName, DataType.Double);
                    for (int k = 0; k < ensemble.traceCount(); ++k) {
                        Column_Abstract header = ensemble.trace(k).header();
                        float offset = header.getFloat(headerIndex_Offset);
                        float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[branch]);
                        float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[branch]);
                        float vel = 0.5f * (recVel + shotVel);
                        float tt = 1000.0f * offset / vel;
                        header.putFloat(headerIndexTT, tt);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void predictPicks(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean bApplyDtAnis, boolean applyWaterBottom) throws Exception {
        try {
            int maxBranch = this.m_branchAssignmentData.maxBranch();
            if (maxBranch < 1) {
                return;
            }
            int headerIndex_Corr = -9999;
            if (bApplyUphole) {
                UpholeCorrection.singleton().compute(ensemble);
                headerIndex_Corr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            }
            int headerIndex_WB = -9999;
            if (applyWaterBottom) {
                WaterBottomCorrection.singleton().compute(ensemble);
                headerIndex_WB = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            }
            if (!this.m_branchAssignmentData.hasBranch(1)) {
                return;
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            if (!ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                return;
            }
            int headerIndex_BranchUser = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int headerIndex_Azimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            int headerIndex_PredPick = ensemble.dictionary().addEntry("Trace", "FBP_PredDelayTime", DataType.Float);
            ensemble.prepDelayTimeAnalysisIndices();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.ShiftsOK = false;
                Column_Abstract header = trace.header();
                header.putFloat(headerIndex_PredPick, -9999.0f);
                int branch = header.getInt(headerIndex_BranchUser);
                float off = header.getFloat(headerIndex_Offset);
                float azimuth = header.getFloat(headerIndex_Azimuth);
                if (branch < 1) continue;
                float predictedPick = 0.0f;
                float corr = 0.0f;
                if (headerIndex_Corr >= 0) {
                    corr = header.getFloat(headerIndex_Corr);
                }
                int indexTT = ensemble.HeaderIndex_TravelTime[branch];
                float travelTime = header.getFloat(indexTT);
                float shotDT = header.getFloat(ensemble.HeaderIndex_ShotDT[branch]);
                float recDT = header.getFloat(ensemble.HeaderIndex_RecDT[branch]);
                float shotAnisAz = header.getFloat(ensemble.HeaderIndex_ShotDTAnisAz[branch]);
                float shotAnisMag = header.getFloat(ensemble.HeaderIndex_ShotDTAnisMag[branch]);
                float shotAnis = shotAnisMag * (float)Math.cos(2.0f * (azimuth - shotAnisAz));
                float recAnisAz = header.getFloat(ensemble.HeaderIndex_RecDTAnisAz[branch]);
                float recAnisMag = header.getFloat(ensemble.HeaderIndex_RecDTAnisMag[branch]);
                float recAnis = recAnisMag * (float)Math.cos(2.0f * (azimuth - recAnisAz));
                if (applyWaterBottom) {
                    float wbcorr = header.getFloat(headerIndex_WB);
                    predictedPick -= wbcorr;
                }
                if (bApplyUphole) {
                    predictedPick -= corr;
                }
                if (bTravelTime) {
                    predictedPick += travelTime;
                }
                if (bDelayTime) {
                    predictedPick += shotDT + recDT;
                }
                if (bApplyDtAnis) {
                    predictedPick -= shotAnis + recAnis;
                }
                header.putFloat(headerIndex_PredPick, predictedPick);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void applyShifts(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean bApplyDtAnis) throws Exception {
        this.applyShifts(ensemble, bDelayTime, bTravelTime, bApplyUphole, bApplyDtAnis, true);
    }

    public void applyShifts(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean bApplyDtAnis, boolean applyWaterBottom) throws Exception {
        try {
            float tt;
            EnsembleTrace trace;
            int n;
            int maxBranch = this.m_branchAssignmentData.maxBranch();
            if (maxBranch < 1) {
                return;
            }
            if (maxBranch == 1) {
                this.applyShifts_SingleBranch(ensemble, bDelayTime, bTravelTime, bApplyUphole, bApplyDtAnis, applyWaterBottom);
                return;
            }
            int headerIndex_Corr = -9999;
            if (bApplyUphole) {
                UpholeCorrection.singleton().compute(ensemble);
                headerIndex_Corr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            }
            int headerIndex_WB = -9999;
            if (applyWaterBottom) {
                WaterBottomCorrection.singleton().compute(ensemble);
                headerIndex_WB = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            }
            if (!this.m_branchAssignmentData.hasBranch(1)) {
                return;
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            if (!ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                return;
            }
            int headerIndex_BranchUser = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int headerIndex_Azimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            int headerIndex_Pick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int headerIndex_ErrorDT = ensemble.dictionary().addEntry("Trace", "DelayTimeError", DataType.Float);
            ensemble.prepDelayTimeAnalysisIndices();
            int firstValid = Integer.MAX_VALUE;
            int lastValid = 0;
            for (int n2 = 0; n2 < ensemble.traceCount(); ++n2) {
                float error;
                EnsembleTrace trace2 = ensemble.trace(n2);
                trace2.ShiftsOK = false;
                Column_Abstract header = trace2.header();
                header.putFloat(headerIndex_ErrorDT, 0.0f);
                int branch = header.getInt(headerIndex_BranchUser);
                float off = header.getFloat(headerIndex_Offset);
                float azimuth = header.getFloat(headerIndex_Azimuth);
                if (branch < 1) continue;
                trace2.ShiftsOK = true;
                firstValid = Math.min(n2, firstValid);
                lastValid = n2;
                float pick = header.getFloat(headerIndex_Pick);
                float totalCorr = 0.0f;
                float corr = 0.0f;
                if (headerIndex_Corr >= 0) {
                    corr = header.getFloat(headerIndex_Corr);
                }
                int indexTT = ensemble.HeaderIndex_TravelTime[branch];
                float travelTime = header.getFloat(indexTT);
                float shotDT = header.getFloat(ensemble.HeaderIndex_ShotDT[branch]);
                float recDT = header.getFloat(ensemble.HeaderIndex_RecDT[branch]);
                float shotAnisAz = header.getFloat(ensemble.HeaderIndex_ShotDTAnisAz[branch]);
                float shotAnisMag = header.getFloat(ensemble.HeaderIndex_ShotDTAnisMag[branch]);
                float shotAnis = shotAnisMag * (float)Math.cos(2.0f * (azimuth - shotAnisAz));
                float recAnisAz = header.getFloat(ensemble.HeaderIndex_RecDTAnisAz[branch]);
                float recAnisMag = header.getFloat(ensemble.HeaderIndex_RecDTAnisMag[branch]);
                float recAnis = recAnisMag * (float)Math.cos(2.0f * (azimuth - recAnisAz));
                totalCorr = travelTime + recDT + shotDT + recAnis + shotAnis - corr;
                if (applyWaterBottom) {
                    float wbcorr = header.getFloat(headerIndex_WB);
                    trace2.data().addShiftToFirstSampleCoord(wbcorr);
                }
                if (bApplyUphole) {
                    trace2.ShiftUpholeCorrection = corr;
                    trace2.data().addShiftToFirstSampleCoord(corr);
                }
                if (bTravelTime) {
                    trace2.ShiftTT = travelTime;
                    trace2.data().addShiftToFirstSampleCoord(-trace2.ShiftTT);
                    trace2.ShiftVel = 1000.0f * off / trace2.ShiftTT;
                }
                if (bDelayTime) {
                    trace2.ShiftDT = shotDT + recDT;
                    trace2.data().addShiftToFirstSampleCoord(-trace2.ShiftDT);
                }
                if (bApplyDtAnis) {
                    trace2.data().addShiftToFirstSampleCoord(-shotAnis);
                    trace2.data().addShiftToFirstSampleCoord(-recAnis);
                }
                if (!(Math.abs(error = pick - totalCorr) < 400.0f)) continue;
                header.putFloat(headerIndex_ErrorDT, error);
            }
            if (firstValid > lastValid) {
                return;
            }
            EnsembleTrace vt = ensemble.trace(firstValid);
            for (n = 0; n < firstValid; ++n) {
                trace = ensemble.trace(n);
                if (bApplyUphole) {
                    trace.data().addShiftToFirstSampleCoord(vt.ShiftUpholeCorrection);
                }
                if (bTravelTime) {
                    float off = trace.header().getFloat(headerIndex_Offset);
                    tt = 1000.0f * off / vt.ShiftVel;
                    trace.data().addShiftToFirstSampleCoord(-tt);
                }
                if (!bDelayTime) continue;
                trace.data().addShiftToFirstSampleCoord(-vt.ShiftDT);
            }
            vt = ensemble.trace(lastValid);
            for (n = lastValid + 1; n < ensemble.traceCount(); ++n) {
                trace = ensemble.trace(n);
                if (bApplyUphole) {
                    trace.data().addShiftToFirstSampleCoord(vt.ShiftUpholeCorrection);
                }
                if (bTravelTime) {
                    float off = trace.header().getFloat(headerIndex_Offset);
                    tt = 1000.0f * off / vt.ShiftVel;
                    trace.data().addShiftToFirstSampleCoord(-tt);
                }
                if (!bDelayTime) continue;
                trace.data().addShiftToFirstSampleCoord(-vt.ShiftDT);
            }
            for (n = firstValid + 1; n < lastValid; ++n) {
                float dt;
                trace = ensemble.trace(n);
                if (trace.ShiftsOK) continue;
                int lowerIndex = n - 1;
                EnsembleTrace vt1 = ensemble.trace(lowerIndex);
                while (!vt1.ShiftsOK) {
                    vt1 = ensemble.trace(--lowerIndex);
                }
                int upperIndex = n + 1;
                EnsembleTrace vt2 = ensemble.trace(upperIndex);
                while (!vt2.ShiftsOK) {
                    vt2 = ensemble.trace(++upperIndex);
                }
                float w2 = (float)(n - lowerIndex) / (float)(upperIndex - lowerIndex);
                float w1 = 1.0f - w2;
                if (bTravelTime) {
                    float vel1 = vt1.ShiftVel;
                    float vel2 = vt2.ShiftVel;
                    float vel = w1 * vel1 + w2 * vel2;
                    float off = trace.header().getFloat(headerIndex_Offset);
                    float tt2 = 1000.0f * off / vel;
                    trace.data().addShiftToFirstSampleCoord(-tt2);
                }
                if (bApplyUphole) {
                    dt = w1 * vt1.ShiftUpholeCorrection + w2 * vt2.ShiftUpholeCorrection;
                    trace.data().addShiftToFirstSampleCoord(dt);
                }
                if (!bDelayTime) continue;
                dt = w1 * vt1.ShiftDT + w2 * vt2.ShiftDT;
                trace.data().addShiftToFirstSampleCoord(-dt);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void applyShifts_SingleBranch(Ensemble ensemble, boolean bDelayTime, boolean bTravelTime, boolean bApplyUphole, boolean bApplyDtAnis, boolean applyWaterBottom) throws Exception {
        try {
            boolean maxBranch = true;
            int headerIndex_Corr = -9999;
            if (bApplyUphole) {
                UpholeCorrection.singleton().compute(ensemble);
                headerIndex_Corr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            }
            int headerIndex_WB = -9999;
            if (applyWaterBottom) {
                WaterBottomCorrection.singleton().compute(ensemble);
                headerIndex_WB = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            }
            if (!this.m_branchAssignmentData.hasBranch(1)) {
                return;
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            if (!ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                return;
            }
            int headerIndex_BranchUser = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int headerIndex_Azimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            int headerIndex_Pick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int headerIndex_ErrorDT = ensemble.dictionary().addEntry("Trace", "DelayTimeError", DataType.Float);
            ensemble.prepDelayTimeAnalysisIndices();
            int firstValid = Integer.MAX_VALUE;
            int lastValid = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float error;
                EnsembleTrace trace = ensemble.trace(n);
                trace.ShiftsOK = false;
                Column_Abstract header = trace.header();
                header.putFloat(headerIndex_ErrorDT, 0.0f);
                int branch = 1;
                float off = header.getFloat(headerIndex_Offset);
                float azimuth = header.getFloat(headerIndex_Azimuth);
                if (branch < true) continue;
                trace.ShiftsOK = true;
                firstValid = Math.min(n, firstValid);
                lastValid = n;
                float pick = header.getFloat(headerIndex_Pick);
                float totalCorr = 0.0f;
                float corr = 0.0f;
                if (headerIndex_Corr >= 0) {
                    corr = header.getFloat(headerIndex_Corr);
                }
                int indexTT = ensemble.HeaderIndex_TravelTime[branch];
                float travelTime = header.getFloat(indexTT);
                float shotDT = header.getFloat(ensemble.HeaderIndex_ShotDT[branch]);
                float recDT = header.getFloat(ensemble.HeaderIndex_RecDT[branch]);
                float shotAnisAz = header.getFloat(ensemble.HeaderIndex_ShotDTAnisAz[branch]);
                float shotAnisMag = header.getFloat(ensemble.HeaderIndex_ShotDTAnisMag[branch]);
                float shotAnis = shotAnisMag * (float)Math.cos(2.0f * (azimuth - shotAnisAz));
                float recAnisAz = header.getFloat(ensemble.HeaderIndex_RecDTAnisAz[branch]);
                float recAnisMag = header.getFloat(ensemble.HeaderIndex_RecDTAnisMag[branch]);
                float recAnis = recAnisMag * (float)Math.cos(2.0f * (azimuth - recAnisAz));
                totalCorr = travelTime + recDT + shotDT + recAnis + shotAnis - corr;
                if (applyWaterBottom) {
                    float wbcorr = header.getFloat(headerIndex_WB);
                    trace.data().addShiftToFirstSampleCoord(wbcorr);
                }
                if (bApplyUphole) {
                    trace.ShiftUpholeCorrection = corr;
                    trace.data().addShiftToFirstSampleCoord(corr);
                }
                if (bTravelTime) {
                    trace.ShiftTT = travelTime;
                    trace.data().addShiftToFirstSampleCoord(-trace.ShiftTT);
                    trace.ShiftVel = 1000.0f * off / trace.ShiftTT;
                }
                if (bDelayTime) {
                    trace.ShiftDT = shotDT + recDT;
                    trace.data().addShiftToFirstSampleCoord(-trace.ShiftDT);
                }
                if (bApplyDtAnis) {
                    trace.data().addShiftToFirstSampleCoord(-shotAnis);
                    trace.data().addShiftToFirstSampleCoord(-recAnis);
                }
                if (!(Math.abs(error = pick - totalCorr) < 400.0f)) continue;
                header.putFloat(headerIndex_ErrorDT, error);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public String path() {
        return this.m_path;
    }

    public void interpolateTable(Table_Abstract table, int branch) {
        try {
            if (!this.m_branchAssignmentData.interpolateBranchAtLocation(branch, 0.0, 0.0)) {
                return;
            }
            String colNameError = Pecos.getColNameError(branch);
            String colNameCount = Pecos.getColNameCount(branch);
            String colNameDT = Pecos.getColNameDT(branch);
            String colNameVel = Pecos.getColNameVel(branch);
            int indexDT = table.column_append(colNameDT, DataType.Double);
            int indexVel = table.column_append(colNameVel, DataType.Double);
            int indexCount = table.column_append(colNameCount, DataType.Double);
            int indexError = table.column_append(colNameError, DataType.Double);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                this.m_branchAssignmentData.interpolateBranchAtLocation(branch, x, y);
                table.putDouble(row, indexDT, this.m_branchAssignmentData.InterpolatedDt);
                table.putDouble(row, indexVel, this.m_branchAssignmentData.InterpolatedVel);
                table.putDouble(row, indexCount, 0.0);
                table.putDouble(row, indexError, 0.0);
            }
            IDatabaseConnection db = ((RefractionStaticsProject)this.m_projectRef.get()).geometryDatabase();
            db.addColumn(table.name(), colNameDT, DataType.Double);
            db.addColumn(table.name(), colNameVel, DataType.Double);
            db.addColumn(table.name(), colNameError, DataType.Double);
            db.addColumn(table.name(), colNameCount, DataType.Double);
            db.writeColumnContentsToDatabase(table, colNameDT);
            db.writeColumnContentsToDatabase(table, colNameVel);
            String sql = String.format("UPDATE %s SET %s = 0.0", table.name(), colNameError);
            db.executeUpdateStatement(sql);
            sql = String.format("UPDATE %s SET %s = 0.0", table.name(), colNameCount);
            db.executeUpdateStatement(sql);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateFromBranch_IfNeeded() {
        try {
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            Table_Abstract recTable = ((RefractionStaticsProject)this.m_projectRef.get()).receiverTable();
            Table_Abstract shotTable = ((RefractionStaticsProject)this.m_projectRef.get()).shotTable();
            for (int branch = 1; branch <= maxbranch; ++branch) {
                String colNameDT = Pecos.getColNameDT(branch);
                String colNameVel = Pecos.getColNameVel(branch);
                if (recTable.column_exists(colNameDT) && recTable.column_exists(colNameVel) && shotTable.column_exists(colNameDT) && shotTable.column_exists(colNameVel)) continue;
                this.interpolateTable(recTable, branch);
                this.interpolateTable(shotTable, branch);
            }
            ((RefractionStaticsProject)this.m_projectRef.get()).reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateFromBranch() {
        try {
            this.removeAllRefractorData();
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            Table_Abstract recTable = ((RefractionStaticsProject)this.m_projectRef.get()).receiverTable();
            Table_Abstract shotTable = ((RefractionStaticsProject)this.m_projectRef.get()).shotTable();
            for (int branch = 1; branch <= maxbranch; ++branch) {
                this.interpolateTable(recTable, branch);
                this.interpolateTable(shotTable, branch);
            }
            ((RefractionStaticsProject)this.m_projectRef.get()).reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void confirmDelayTimeAnisotropyColumnsExist() {
        try {
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            IDatabaseConnection db = ((RefractionStaticsProject)this.m_projectRef.get()).geometryDatabase();
            for (int b = 1; b <= maxbranch; ++b) {
                String colNameAz = Pecos.getColNameDtAnisAz(b);
                String colNameMag = Pecos.getColNameDtAnisMag(b);
                ((RefractionStaticsProject)this.m_projectRef.get()).confirmReceiverColumn_Double(colNameMag, 0.0);
                ((RefractionStaticsProject)this.m_projectRef.get()).confirmReceiverColumn_Double(colNameAz, 0.0);
                ((RefractionStaticsProject)this.m_projectRef.get()).confirmShotColumn_Double(colNameMag, 0.0);
                ((RefractionStaticsProject)this.m_projectRef.get()).confirmShotColumn_Double(colNameAz, 0.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearDelayTimeAnisotropy() {
        try {
            this.confirmDelayTimeAnisotropyColumnsExist();
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            IDatabaseConnection db = ((RefractionStaticsProject)this.m_projectRef.get()).geometryDatabase();
            Table_Abstract shotTable = ((RefractionStaticsProject)this.m_projectRef.get()).shotTable();
            Table_Abstract recTable = ((RefractionStaticsProject)this.m_projectRef.get()).receiverTable();
            for (int b = 1; b <= maxbranch; ++b) {
                String colNameAz = Pecos.getColNameDtAnisAz(b);
                String colNameMag = Pecos.getColNameDtAnisMag(b);
                int index = shotTable.column_indexOfColumn(colNameMag);
                shotTable.column_setToValue(index, 0.0);
                index = shotTable.column_indexOfColumn(colNameAz);
                shotTable.column_setToValue(index, 0.0);
                index = recTable.column_indexOfColumn(colNameMag);
                recTable.column_setToValue(index, 0.0);
                index = recTable.column_indexOfColumn(colNameAz);
                recTable.column_setToValue(index, 0.0);
                db.writeColumnContentsToDatabase(recTable, colNameAz);
                db.writeColumnContentsToDatabase(recTable, colNameMag);
                db.writeColumnContentsToDatabase(shotTable, colNameAz);
                db.writeColumnContentsToDatabase(shotTable, colNameMag);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeAllRefractorData() {
        try {
            this.removeRefractorData(1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeUnusedRefractorData() {
        try {
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            this.removeRefractorData(maxbranch + 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeRefractorData(int firstBranch) {
        try {
            int branch;
            int maxbranch = this.m_branchAssignmentData.maxBranch();
            IDatabaseConnection db = ((RefractionStaticsProject)this.m_projectRef.get()).geometryDatabase();
            for (branch = firstBranch; branch <= 6; ++branch) {
                String colNameDT = Pecos.getColNameDT(branch);
                String colNameVel = Pecos.getColNameVel(branch);
                String colNameError = Pecos.getColNameError(branch);
                String colNameCount = Pecos.getColNameCount(branch);
                String colNameElev = Pecos.getColNameElev(branch);
                String colNameDtAz = Pecos.getColNameDtAnisAz(branch);
                String colNameDtMag = Pecos.getColNameDtAnisMag(branch);
                db.dropColumn("Shot", colNameDtAz);
                db.dropColumn("Receiver", colNameDtAz);
                db.dropColumn("Shot", colNameDtMag);
                db.dropColumn("Receiver", colNameDtMag);
                db.dropColumn("Shot", colNameElev);
                db.dropColumn("Receiver", colNameElev);
                db.dropColumn("Shot", colNameCount);
                db.dropColumn("Receiver", colNameCount);
                db.dropColumn("Shot", colNameError);
                db.dropColumn("Receiver", colNameError);
                db.dropColumn("Shot", colNameDT);
                db.dropColumn("Receiver", colNameDT);
                db.dropColumn("Shot", colNameVel);
                db.dropColumn("Receiver", colNameVel);
            }
            for (branch = firstBranch - 1; branch <= 6; ++branch) {
                if (branch < 0) continue;
                String colNameMaxOff = Pecos.getColNameMaxOff(branch);
                db.dropColumn("Shot", colNameMaxOff);
                db.dropColumn("Receiver", colNameMaxOff);
            }
            ((RefractionStaticsProject)this.m_projectRef.get()).reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String branchFileName() {
        return this.m_branchFileName;
    }

    public BranchAssignment branchAssignment() {
        return this.m_branchAssignmentData;
    }

    public void setBranchAssignment(BranchAssignment ba) throws Exception {
        try {
            if (ba == null) {
                return;
            }
            this.m_branchAssignmentData = ba;
            this.saveBranchAssignment();
            this.m_branchAssignmentData.prepHistory(this.m_history);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void saveBranchAssignment() throws Exception {
        try {
            this.m_branchAssignmentData.save(this.m_branchFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

