/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Refraction.BranchAssignmentEntry;
import com.PecosCore.Refraction.BranchAssignmentLocation;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchColors;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BranchAssignment
extends GenericObjectListener
implements Java2D_PaintableInterface,
Serializable {
    protected InterpolationMethod m_interpolationMethod = InterpolationMethod.InverseSquare;
    public ArrayList<Location> LocationList = new ArrayList();
    protected Location m_currentLocation;
    public int DefiningBranch = 1;
    public static final String PlotTypeMap = "PlotTypeMap";
    public static final String PlotTypeBranch = "PlotTypeBranch";
    protected PlotType m_plotType = PlotType.None;
    protected Color m_dotColor = new Color(110, 110, 255, 100);
    protected Color m_boxColor = new Color(255, 255, 222);
    protected String m_branchMessage = "Press \"1\" to define branch 1, \"2\" to define branch 2, etc.";
    protected String m_interpMessage = "Dashed lines show interpolated values";
    protected boolean m_showKillRadius = true;
    protected double m_killRadius = 40.0;
    protected Color m_killColor = new Color(200, 200, 200, 50);
    protected int[] m_polyX = new int[4];
    protected int[] m_polyY = new int[4];
    public boolean ApplyLMO = false;
    public double VelLMO = 100.0;
    public boolean ModelApplied = false;
    protected static final String KeyLocation = "Location";
    protected static final String KeyX = "X";
    protected static final String KeyY = "Y";
    protected static final String KeyEntry = "Entry";
    protected static final String KeyRefractor = "Refractor";
    protected static final String KeyMinimumOffset = "MinimumOffset";
    protected static final String KeyMaximumOffset = "MaximumOffset";
    protected static final String KeyTimeAtMinimumOffset = "TimeAtMinimumOffset";
    protected static final String KeyTimeAtMaximumOffset = "TimeAtMaximumOffset";
    public int Location_ExactBranch = 0;
    public boolean Location_OffsetLessThanFirst;
    public boolean Location_OffsetMoreThanLast;
    public int Location_BranchMinIndex;
    public int Location_BranchMaxIndex;
    public double Location_BranchFraction;
    public double Location_Velocity;
    public double Location_DelayTime;
    public double Location_PickTime;
    public boolean InterpolatedValid = false;
    public int InterpolatedBranch = 0;
    public double InterpolatedMinOff = 0.0;
    public double InterpolatedMaxOff = 0.0;
    public double InterpolatedVel = 0.0;
    public double InterpolatedDt = 0.0;
    public double InterpolatedV0 = 0.0;
    public boolean OffsetRangesOK = true;
    public String OffsetRangeErrorMessage = "";

    public InterpolationMethod interpolationMethod() {
        return this.m_interpolationMethod;
    }

    public void setInterpolationMethod(InterpolationMethod im) {
        this.m_interpolationMethod = im;
    }

    public void mergeOtherLocationList(ArrayList<Location> list) {
        try {
            for (Location loc : list) {
                this.LocationList.add(loc.duplicate());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Location currentLocation() {
        return this.m_currentLocation;
    }

    public boolean getShowKillRadius() {
        return this.m_showKillRadius;
    }

    public void setShowKillRadius(boolean show) {
        this.m_showKillRadius = show;
    }

    public void setKillRadius(double radius) {
        this.m_killRadius = Math.max(0.0, radius);
    }

    public double getKillRadius() {
        return this.m_killRadius;
    }

    public BranchAssignment() {
    }

    public BranchAssignment(BranchAssignmentLocation[] branchAssignmentLocation) {
        for (BranchAssignmentLocation branchLocation : branchAssignmentLocation) {
            Location location = new Location();
            location.X = branchLocation.getX();
            location.Y = branchLocation.getY();
            for (BranchAssignmentEntry branchEntry : branchLocation.getEntries()) {
                Entry entry = new Entry();
                entry.MinimumOffset = branchEntry.getMinOffset();
                entry.MaximumOffset = branchEntry.getMaxOffset();
                entry.TimeAtMinimumOffset = branchEntry.getTimeAtMinOffset();
                entry.TimeAtMaximumOffset = branchEntry.getTimeAtMaxOffset();
                entry.Refractor = branchEntry.getRefractor();
                location.EntryList.add(entry);
            }
            this.LocationList.add(location);
        }
    }

    public void prepHistory(History h) {
        try {
            int num = this.LocationList.size();
            h.addWithTime("Branch assignment modified");
            if (num == 0) {
                h.add("No branches assigned");
                return;
            }
            int max = this.maxBranch();
            h.add("Maximum branch = " + Integer.toString(max));
            for (int b = 1; b <= max; ++b) {
                double minOff = Double.MAX_VALUE;
                double maxOff = Double.MIN_VALUE;
                for (Location location : this.LocationList) {
                    for (Entry entry : location.EntryList) {
                        if (entry.Refractor != b) continue;
                        minOff = Math.min(minOff, entry.MinimumOffset);
                        maxOff = Math.max(maxOff, entry.MaximumOffset);
                    }
                }
                if (minOff > maxOff) {
                    h.add(String.format("Branch for refractor %d not valid", b));
                    continue;
                }
                h.add(String.format("Branch %d offset range: %d - %d", b, (int)minOff, (int)maxOff));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void copy(int from, int to) {
        try {
            for (Location location : this.LocationList) {
                location.copy(from, to);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void assignBranch_UsingGeomErrorData(Ensemble ensemble) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace.GeometryError geomError = ensemble.trace(n).geometryErrorData();
                geomError.prepOffAz();
                double mx = 0.5 * (geomError.ShotX + geomError.ReceiverX);
                double my = 0.5 * (geomError.ShotY + geomError.ReceiverY);
                double off = geomError.Offset;
                geomError.Branch = this.getBranch(mx, my, off);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void assignBranch(Ensemble ensemble, String branchName) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            int headerIndex_BranchUser = ensemble.dictionary().addEntry("Trace", branchName, DataType.Int);
            int headerIndex_Offset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int headerIndex_MidX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int headerIndex_MidY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                header.putInt(headerIndex_BranchUser, -9999);
                double mx = header.getDouble(headerIndex_MidX);
                double my = header.getDouble(headerIndex_MidY);
                double off = header.getDouble(headerIndex_Offset);
                int b = this.getBranch(mx, my, off);
                header.putInt(headerIndex_BranchUser, b);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftPicksUsingDelayTime_ZeroMean(Ensemble ensemble, String shiftName, String branchName) {
        try {
            for (int branch = 1; branch <= this.maxBranch(); ++branch) {
                String dtName = Pecos.getColNameDT(branch);
                if (!ensemble.dictionary().containsEntry("Shot", dtName) || !ensemble.dictionary().containsEntry("Receiver", dtName) || !ensemble.dictionary().containsEntry("Trace", branchName) || !ensemble.dictionary().containsEntry("Trace", shiftName)) continue;
                int indexShotDT = ensemble.dictionary().getEntryIndex("Shot", dtName);
                int indexRecDT = ensemble.dictionary().getEntryIndex("Receiver", dtName);
                int indexBranch = ensemble.dictionary().getEntryIndex("Trace", branchName);
                int indexShift = ensemble.dictionary().getEntryIndex("Trace", shiftName);
                double count = 1.0E-30;
                double sum = 0.0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    if (header.getInt(indexBranch) != branch) continue;
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    sum += shift;
                    count += 1.0;
                }
                double averageShift = sum / count;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    if (header.getInt(indexBranch) != branch) continue;
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    float currentShift = header.getFloat(indexShift);
                    header.putFloat(indexShift, currentShift += (float)(shift -= averageShift));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftAllPicksUsingDelayTime_ZeroMean(Ensemble ensemble, String shiftName, int branch) {
        try {
            String dtName = Pecos.getColNameDT(branch);
            if (ensemble.dictionary().containsEntry("Shot", dtName) && ensemble.dictionary().containsEntry("Receiver", dtName) && ensemble.dictionary().containsEntry("Trace", shiftName)) {
                int indexShotDT = ensemble.dictionary().getEntryIndex("Shot", dtName);
                int indexRecDT = ensemble.dictionary().getEntryIndex("Receiver", dtName);
                int indexShift = ensemble.dictionary().getEntryIndex("Trace", shiftName);
                double count = 1.0E-30;
                double sum = 0.0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    sum += shift;
                    count += 1.0;
                }
                double averageShift = sum / count;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    float currentShift = header.getFloat(indexShift);
                    header.putFloat(indexShift, currentShift += (float)(shift -= averageShift));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftTracesUsingDelayTime_ZeroMean(Ensemble ensemble, String branchName) {
        try {
            for (int branch = 1; branch <= this.maxBranch(); ++branch) {
                String dtName = Pecos.getColNameDT(branch);
                if (!ensemble.dictionary().containsEntry("Shot", dtName) || !ensemble.dictionary().containsEntry("Receiver", dtName) || !ensemble.dictionary().containsEntry("Trace", branchName)) continue;
                int indexShotDT = ensemble.dictionary().getEntryIndex("Shot", dtName);
                int indexRecDT = ensemble.dictionary().getEntryIndex("Receiver", dtName);
                int indexBranch = ensemble.dictionary().getEntryIndex("Trace", branchName);
                double count = 1.0E-30;
                double sum = 0.0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    if (header.getInt(indexBranch) != branch) continue;
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    sum += shift;
                    count += 1.0;
                }
                double averageShift = sum / count;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    if (header.getInt(indexBranch) != branch) continue;
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    FloatArrayWrapper wrapper = ensemble.trace(n).data();
                    wrapper.addShiftToFirstSampleCoord((float)(shift -= averageShift));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftAllTracesUsingDelayTime_ZeroMean(Ensemble ensemble, int branch) {
        try {
            String dtName = Pecos.getColNameDT(branch);
            if (ensemble.dictionary().containsEntry("Shot", dtName) && ensemble.dictionary().containsEntry("Receiver", dtName)) {
                int indexShotDT = ensemble.dictionary().getEntryIndex("Shot", dtName);
                int indexRecDT = ensemble.dictionary().getEntryIndex("Receiver", dtName);
                double count = 1.0E-30;
                double sum = 0.0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    sum += shift;
                    count += 1.0;
                }
                double averageShift = sum / count;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double shotDT = header.getDouble(indexShotDT);
                    double recDT = header.getDouble(indexRecDT);
                    if (!(shotDT > 0.0) || !(recDT > 0.0)) continue;
                    double shift = 0.0 - (shotDT + recDT);
                    FloatArrayWrapper wrapper = ensemble.trace(n).data();
                    wrapper.addShiftToFirstSampleCoord((float)(shift -= averageShift));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateDelayTimeInfo(Ensemble ensemble) {
        try {
            this.interpolateDelayTimeInfo(ensemble, "Shot");
            this.interpolateDelayTimeInfo(ensemble, "Receiver");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateDelayTimeInfo(Ensemble ensemble, String table) {
        try {
            int branch;
            if (ensemble.traceCount() < 1) {
                return;
            }
            for (branch = 1; branch <= 5; ++branch) {
                int n;
                int index;
                if (ensemble.dictionary().containsEntry(table, Pecos.getColNameDT(branch))) {
                    index = ensemble.dictionary().getEntryIndex(table, Pecos.getColNameDT(branch));
                    for (n = 0; n < ensemble.traceCount(); ++n) {
                        ensemble.trace(n).header().putDouble(index, -9999.0);
                    }
                }
                if (!ensemble.dictionary().containsEntry(table, Pecos.getColNameVel(branch))) continue;
                index = ensemble.dictionary().getEntryIndex(table, Pecos.getColNameVel(branch));
                for (n = 0; n < ensemble.traceCount(); ++n) {
                    ensemble.trace(n).header().putDouble(index, -9999.0);
                }
            }
            for (branch = 1; branch <= this.maxBranch(); ++branch) {
                int indexX = ensemble.dictionary().getEntryIndex(table, "Easting");
                int indexY = ensemble.dictionary().getEntryIndex(table, "Northing");
                int indexDT = ensemble.dictionary().addEntry(table, Pecos.getColNameDT(branch), DataType.Double);
                int indexVel = ensemble.dictionary().addEntry(table, Pecos.getColNameVel(branch), DataType.Double);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double x = header.getDouble(indexX);
                    double y = header.getDouble(indexY);
                    this.interpolateBranchAtLocation(branch, x, y);
                    header.putDouble(indexDT, this.InterpolatedDt);
                    header.putDouble(indexVel, this.InterpolatedVel);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getBranch(double x, double y, double offset) {
        try {
            for (int branch = 1; branch <= this.maxBranch(); ++branch) {
                if (!this.hasBranch(branch)) continue;
                this.interpolateBranchAtLocation(branch, x, y);
                if (!(offset >= this.InterpolatedMinOff) || !(offset <= this.InterpolatedMaxOff)) continue;
                return branch;
            }
            return -9999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public void interpolateAtLocation(double x, double y, double offset) {
        try {
            this.Location_OffsetLessThanFirst = false;
            this.Location_OffsetMoreThanLast = false;
            this.Location_ExactBranch = 0;
            this.Location_BranchMinIndex = -9999;
            this.Location_BranchMaxIndex = -9999;
            double oldMaxOff = 0.0;
            double priorVel = 0.0;
            double priorDT = 0.0;
            for (int branch = 1; branch <= this.maxBranch(); ++branch) {
                if (!this.hasBranch(branch)) continue;
                this.interpolateBranchAtLocation(branch, x, y);
                this.Location_Velocity = this.InterpolatedVel;
                this.Location_DelayTime = this.InterpolatedDt;
                this.Location_PickTime = 2.0 * this.Location_DelayTime + 1000.0 * offset / this.Location_Velocity;
                if (offset >= this.InterpolatedMinOff && offset <= this.InterpolatedMaxOff) {
                    this.Location_ExactBranch = branch;
                    return;
                }
                if (branch == 1 && offset <= this.InterpolatedMinOff) {
                    this.Location_OffsetLessThanFirst = true;
                    this.Location_BranchMinIndex = 1;
                    this.Location_BranchMaxIndex = 1;
                    this.Location_BranchFraction = 1.0;
                    return;
                }
                if (branch == this.maxBranch()) {
                    this.Location_OffsetMoreThanLast = true;
                    this.Location_BranchMinIndex = branch;
                    this.Location_BranchMaxIndex = branch;
                    this.Location_BranchFraction = 1.0;
                    return;
                }
                if (offset <= this.InterpolatedMinOff) {
                    this.Location_BranchMinIndex = branch - 1;
                    this.Location_BranchMaxIndex = branch;
                    double r1 = offset - oldMaxOff;
                    double r2 = this.InterpolatedMinOff - oldMaxOff;
                    this.Location_BranchFraction = 1.0;
                    if (r2 > 0.1) {
                        this.Location_BranchFraction = r1 / r2;
                    }
                    this.Location_Velocity = (1.0 - this.Location_BranchFraction) * priorVel + this.Location_BranchFraction * this.InterpolatedVel;
                    this.Location_DelayTime = (1.0 - this.Location_BranchFraction) * priorDT + this.Location_BranchFraction * this.InterpolatedDt;
                    this.Location_PickTime = 2.0 * this.Location_DelayTime + 1000.0 * offset / this.Location_Velocity;
                    return;
                }
                priorVel = this.InterpolatedVel;
                priorDT = this.InterpolatedDt;
                oldMaxOff = this.InterpolatedMaxOff;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getMinimumBranchVelocity(int branch) throws Exception {
        try {
            double min = Double.MAX_VALUE;
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    if (branch != entry.Refractor) continue;
                    double dx = entry.MaximumOffset - entry.MinimumOffset;
                    double dt = entry.TimeAtMaximumOffset - entry.TimeAtMinimumOffset;
                    double v = Math.abs(1000.0 * dx / dt);
                    min = Math.min(min, v);
                }
            }
            if (min > 1.0E20) {
                throw new Exception("Branch not valid");
            }
            return min;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getMinimumBranchOffset(int branch) throws Exception {
        try {
            double min = Double.MAX_VALUE;
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    if (branch != entry.Refractor) continue;
                    min = Math.min(min, entry.MinimumOffset);
                }
            }
            if (min > 1.0E20) {
                throw new Exception("Branch not valid");
            }
            return min;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getMaximumBranchOffset(int branch) throws Exception {
        try {
            double max = Double.MIN_VALUE;
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    if (branch != entry.Refractor) continue;
                    max = Math.max(max, entry.MaximumOffset);
                }
            }
            if (max > 1.0E20) {
                throw new Exception("Branch not valid");
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean apply_interactive_model(Ensemble ensemble, int branch) {
        try {
            if (!this.hasBranch(branch)) {
                return false;
            }
            if (ensemble.traceCount() < 1) {
                return false;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double off = trace.header().getDouble(indexOff);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                this.interpolateBranchAtLocation(branch, sx, sy);
                double vels = this.InterpolatedVel;
                double dts = this.InterpolatedDt;
                this.interpolateBranchAtLocation(branch, rx, ry);
                double velr = this.InterpolatedVel;
                double dtr = this.InterpolatedDt;
                double vel = 0.5 * (velr + vels);
                double t = dts + dtr + 1000.0 * off / vel;
                trace.data().addShiftToFirstSampleCoord(-((float)t));
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public Java2D_PaintablePointArray createPointArray(MapPlotType pt, int branch) {
        try {
            if (!this.hasBranch(branch)) {
                return null;
            }
            Java2D_PaintablePointArray ppa = null;
            int numValid = 0;
            for (int t = 0; t <= 1; ++t) {
                Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
                if (t == 1) {
                    table = RefractionStaticsProject.singleton().receiverTable();
                }
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int r = 0; r < table.row_count(); ++r) {
                    if (table.getBool(r, indexKilled)) continue;
                    ++numValid;
                }
            }
            if (numValid < 1) {
                return null;
            }
            ppa = new Java2D_PaintablePointArray();
            ppa.setLength(numValid);
            int counter = 0;
            for (int t = 0; t <= 1; ++t) {
                Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
                if (t == 1) {
                    table = RefractionStaticsProject.singleton().receiverTable();
                }
                int indexKilled = table.column_indexOfColumn("Killed");
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                for (int r = 0; r < table.row_count(); ++r) {
                    if (table.getBool(r, indexKilled)) continue;
                    double x = table.getDouble(r, indexX);
                    double y = table.getDouble(r, indexY);
                    this.interpolateBranchAtLocation(branch, x, y);
                    ppa.setX(counter, x);
                    ppa.setY(counter, y);
                    if (pt == MapPlotType.InterpolatedV0) {
                        ppa.setC(counter, this.InterpolatedV0);
                    }
                    if (pt == MapPlotType.DelayTime) {
                        ppa.setC(counter, this.InterpolatedDt);
                    }
                    if (pt == MapPlotType.Velocity) {
                        ppa.setC(counter, this.InterpolatedVel);
                    }
                    if (pt == MapPlotType.MinOffset) {
                        ppa.setC(counter, this.InterpolatedMinOff);
                    }
                    if (pt == MapPlotType.MaxOffset) {
                        ppa.setC(counter, this.InterpolatedMaxOff);
                    }
                    if (pt == MapPlotType.OffsetRange) {
                        ppa.setC(counter, this.InterpolatedMaxOff - this.InterpolatedMinOff);
                    }
                    ++counter;
                }
            }
            return ppa;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean interpolateBranchAtLocation(int branch, double x, double y) {
        try {
            this.InterpolatedValid = false;
            this.InterpolatedBranch = branch;
            double sumWeightV0 = 1.0E-80;
            double sumWeight = 1.0E-80;
            this.InterpolatedMinOff = 0.0;
            this.InterpolatedMaxOff = 0.0;
            this.InterpolatedVel = 0.0;
            this.InterpolatedDt = 0.0;
            this.InterpolatedV0 = 0.0;
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    double w;
                    double rsq;
                    double dy;
                    double dx;
                    if (entry.Refractor == 1) {
                        dx = x - location.X;
                        dy = y - location.Y;
                        rsq = dx * dx + dy * dy;
                        w = 1.0E10 / (1.0 + rsq);
                        if (this.m_interpolationMethod == InterpolationMethod.InverseFourth) {
                            w *= w;
                        }
                        sumWeightV0 += w;
                        double v0 = 1000.0 * entry.MinimumOffset / entry.TimeAtMinimumOffset;
                        this.InterpolatedV0 += v0 * w;
                    }
                    if (branch != entry.Refractor) continue;
                    dx = x - location.X;
                    dy = y - location.Y;
                    rsq = dx * dx + dy * dy;
                    w = 1.0E10 / (1.0 + rsq);
                    if (this.m_interpolationMethod == InterpolationMethod.InverseFourth) {
                        w *= w;
                    }
                    sumWeight += w;
                    this.InterpolatedMinOff += w * entry.MinimumOffset;
                    this.InterpolatedMaxOff += w * entry.MaximumOffset;
                    double vel = 1000.0 * (entry.MaximumOffset - entry.MinimumOffset) / (entry.TimeAtMaximumOffset - entry.TimeAtMinimumOffset);
                    double dt = 0.5 * (entry.TimeAtMinimumOffset - 1000.0 * entry.MinimumOffset / vel);
                    this.InterpolatedVel += w * vel;
                    this.InterpolatedDt += w * dt;
                }
            }
            if (sumWeight < 1.0E-19) {
                return false;
            }
            this.InterpolatedMinOff /= sumWeight;
            this.InterpolatedMaxOff /= sumWeight;
            this.InterpolatedVel /= sumWeight;
            this.InterpolatedDt /= sumWeight;
            this.InterpolatedV0 /= sumWeightV0;
            this.InterpolatedValid = true;
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void removeEmpty() {
        try {
            boolean changed = false;
            for (int n = this.LocationList.size() - 1; n >= 0; --n) {
                Location location = this.LocationList.get(n);
                if (location == this.m_currentLocation || location.EntryList.size() >= 1) continue;
                this.LocationList.remove(n);
                changed = true;
            }
            if (changed) {
                this.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolateCurrentLocation() {
        try {
            if (this.m_currentLocation == null) {
                return;
            }
            this.m_currentLocation.InterpList.clear();
            double x = this.m_currentLocation.X;
            double y = this.m_currentLocation.Y;
            int max = this.maxBranch();
            for (int b = 1; b <= max; ++b) {
                int count = 0;
                double sumMinTime = 0.0;
                double sumMaxTime = 0.0;
                double sumMinOff = 0.0;
                double sumMaxOff = 0.0;
                double sumWeight = 1.0E-80;
                for (Location location : this.LocationList) {
                    if (location == this.m_currentLocation) continue;
                    double dx = x - location.X;
                    double dy = y - location.Y;
                    double off = Math.sqrt(1.0 + dx * dx + dy * dy);
                    double weight = 1.0E10 / off;
                    if (this.m_interpolationMethod == InterpolationMethod.InverseFourth) {
                        weight *= weight;
                    }
                    for (Entry entry : location.EntryList) {
                        if (entry.Refractor != b) continue;
                        ++count;
                        sumWeight += weight;
                        sumMinOff += weight * entry.MinimumOffset;
                        sumMaxOff += weight * entry.MaximumOffset;
                        sumMinTime += weight * entry.TimeAtMinimumOffset;
                        sumMaxTime += weight * entry.TimeAtMaximumOffset;
                    }
                }
                if (count < true) continue;
                Entry e = new Entry();
                e.Refractor = b;
                e.MinimumOffset = sumMinOff / sumWeight;
                e.MaximumOffset = sumMaxOff / sumWeight;
                e.TimeAtMinimumOffset = sumMinTime / sumWeight;
                e.TimeAtMaximumOffset = sumMaxTime / sumWeight;
                this.m_currentLocation.InterpList.add(e);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean hasBranch(int branch) {
        try {
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    if (branch != entry.Refractor) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public int maxBranch() {
        try {
            int max = 0;
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    max = Math.max(max, entry.Refractor);
                }
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void setBranchOffset(int b, double minOff, double maxOff) {
        try {
            for (Location location : this.LocationList) {
                for (Entry entry : location.EntryList) {
                    if (entry.Refractor != b) continue;
                    entry.resetOffsets(minOff, maxOff);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setBranch(int b, double minOff, double maxOff, double minT, double maxT) {
        try {
            if (this.m_currentLocation == null) {
                return;
            }
            if (b < 1) {
                return;
            }
            Entry entry = null;
            for (Entry e : this.m_currentLocation.EntryList) {
                if (e.Refractor != b) continue;
                entry = e;
            }
            if (entry == null) {
                entry = new Entry();
                this.m_currentLocation.EntryList.add(entry);
            }
            entry.Refractor = b;
            entry.MinimumOffset = minOff;
            entry.MaximumOffset = maxOff;
            entry.TimeAtMinimumOffset = minT;
            entry.TimeAtMaximumOffset = maxT;
            this.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeClosest(int pixelX, int pixelY) {
        try {
            this.m_currentLocation = null;
            int minPixelDist = 3000;
            int nearest = -1;
            for (int n = 0; n < this.LocationList.size(); ++n) {
                Location location = this.LocationList.get(n);
                int dist = Math.abs(pixelX - location.PixelX) + Math.abs(pixelY - location.PixelY);
                if (dist >= minPixelDist) continue;
                minPixelDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                this.LocationList.remove(nearest);
                this.broadcast(this, null);
            }
            this.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeAll() {
        try {
            this.LocationList.clear();
            this.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearLocation() {
        this.m_currentLocation = null;
    }

    public void selectLocation_Coords(double worldX, double worldY, double minDist) {
        try {
            this.m_currentLocation = null;
            for (Location location : this.LocationList) {
                double dist = Math.abs(worldX - location.X) + Math.abs(worldY - location.Y);
                if (!(dist < minDist)) continue;
                minDist = dist;
                this.m_currentLocation = location;
            }
            if (this.m_currentLocation == null) {
                this.m_currentLocation = new Location();
                this.m_currentLocation.X = worldX;
                this.m_currentLocation.Y = worldY;
                this.LocationList.add(this.m_currentLocation);
                System.out.println("selectLocation_Coords, added location");
                this.broadcast(this, null);
            }
            this.removeEmpty();
            this.interpolateCurrentLocation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void printMouseMoveStuff(int pixelX, int pixelY, double worldX, double worldY) {
        try {
            this.m_currentLocation = null;
            for (Location location : this.LocationList) {
                int dist = Math.abs(pixelX - location.PixelX) + Math.abs(pixelY - location.PixelY);
                double world = Math.abs(worldX - location.X) + Math.abs(worldY - location.Y);
                System.out.println(" ");
                String s = String.format("Mouse = %d, %d  Location = %d, %d", pixelX, pixelY, location.PixelX, location.PixelY);
                System.out.println(s);
                s = String.format("Pixel dist = %d   World dist = %f", dist, Float.valueOf((float)world));
                System.out.println(s);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectLocation(int pixelX, int pixelY, double worldX, double worldY, boolean resetCoords) {
        try {
            this.m_currentLocation = null;
            int minPixelDist = 25;
            for (Location location : this.LocationList) {
                int dist = Math.abs(pixelX - location.PixelX) + Math.abs(pixelY - location.PixelY);
                if (dist >= minPixelDist) continue;
                minPixelDist = dist;
                this.m_currentLocation = location;
            }
            if (this.m_currentLocation != null && resetCoords) {
                this.m_currentLocation.PixelX = pixelX;
                this.m_currentLocation.PixelY = pixelY;
                this.m_currentLocation.X = worldX;
                this.m_currentLocation.Y = worldY;
            }
            if (this.m_currentLocation == null) {
                this.m_currentLocation = new Location();
                this.m_currentLocation.PixelX = pixelX;
                this.m_currentLocation.PixelY = pixelY;
                this.m_currentLocation.X = worldX;
                this.m_currentLocation.Y = worldY;
                this.LocationList.add(this.m_currentLocation);
                System.out.println("selectLocation, added location");
                this.broadcast(this, null);
            }
            this.removeEmpty();
            this.interpolateCurrentLocation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readFromNode(Element node) throws Exception {
        try {
            String ims = Tools_XML.getString(node, "InterpMethod", "InverseSquare");
            this.m_interpolationMethod = ims.equalsIgnoreCase("InverseFourth") ? InterpolationMethod.InverseFourth : InterpolationMethod.InverseSquare;
            this.m_showKillRadius = Tools_XML.getBoolean(node, "ShowKill", true);
            this.m_killRadius = Tools_XML.getDouble(node, "KillRadius", 40.0);
            this.LocationList.clear();
            ArrayList<Element> locationNodes = Tools_XML.getChildListWithTagName(node, KeyLocation);
            for (Element locationElement : locationNodes) {
                Location location = new Location();
                this.LocationList.add(location);
                location.X = Double.parseDouble(locationElement.getAttribute(KeyX));
                location.Y = Double.parseDouble(locationElement.getAttribute(KeyY));
                ArrayList<Element> entryNodes = Tools_XML.getChildListWithTagName(locationElement, KeyEntry);
                for (Element entryElement : entryNodes) {
                    Entry entry = new Entry();
                    location.EntryList.add(entry);
                    entry.Refractor = Integer.parseInt(entryElement.getAttribute(KeyRefractor));
                    entry.MinimumOffset = Double.parseDouble(entryElement.getAttribute(KeyMinimumOffset));
                    entry.MaximumOffset = Double.parseDouble(entryElement.getAttribute(KeyMaximumOffset));
                    entry.TimeAtMinimumOffset = Double.parseDouble(entryElement.getAttribute(KeyTimeAtMinimumOffset));
                    entry.TimeAtMaximumOffset = Double.parseDouble(entryElement.getAttribute(KeyTimeAtMaximumOffset));
                }
            }
            this.removeEmpty();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean checkOffsetRanges() {
        try {
            this.OffsetRangesOK = true;
            for (Location location : this.LocationList) {
                location.sort();
                for (int n = 1; n < location.EntryList.size(); ++n) {
                    Entry e1 = location.EntryList.get(n - 1);
                    Entry e2 = location.EntryList.get(n);
                    if (!(e1.MaximumOffset > e2.MinimumOffset)) continue;
                    this.OffsetRangesOK = false;
                    this.OffsetRangeErrorMessage = "Overlapping branch offset ranges";
                }
            }
            return this.OffsetRangesOK;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            if (this.m_interpolationMethod == InterpolationMethod.InverseFourth) {
                node.setAttribute("InterpMethod", "InverseFourth");
            } else {
                node.setAttribute("InterpMethod", "InverseSquare");
            }
            Tools_XML.putBoolean(node, "ShowKill", this.m_showKillRadius);
            node.setAttribute("KillRadius", Double.toString(this.m_killRadius));
            for (Location location : this.LocationList) {
                location.sort();
                Element locationNode = node.getOwnerDocument().createElement(KeyLocation);
                locationNode.setAttribute(KeyX, Tools_Strings.getString(location.X, 1));
                locationNode.setAttribute(KeyY, Tools_Strings.getString(location.Y, 1));
                node.appendChild(locationNode);
                for (Entry entry : location.EntryList) {
                    Element entryNode = node.getOwnerDocument().createElement(KeyEntry);
                    entryNode.setAttribute(KeyRefractor, Integer.toString(entry.Refractor));
                    entryNode.setAttribute(KeyMinimumOffset, Tools_Strings.getString(entry.MinimumOffset, 1));
                    entryNode.setAttribute(KeyMaximumOffset, Tools_Strings.getString(entry.MaximumOffset, 1));
                    entryNode.setAttribute(KeyTimeAtMinimumOffset, Tools_Strings.getString(entry.TimeAtMinimumOffset, 1));
                    entryNode.setAttribute(KeyTimeAtMaximumOffset, Tools_Strings.getString(entry.TimeAtMaximumOffset, 1));
                    locationNode.appendChild(entryNode);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void readFromNodeSS(Element node) throws Exception {
        try {
            this.LocationList.clear();
            ArrayList<Element> locationNodes = Tools_XML.getChildListWithTagName(node, "BranchPosition");
            for (Element locationElement : locationNodes) {
                Location location = new Location();
                this.LocationList.add(location);
                location.X = Double.parseDouble(locationElement.getAttribute(KeyX));
                location.Y = Double.parseDouble(locationElement.getAttribute(KeyY));
                ArrayList<Element> entryNodes = Tools_XML.getChildListWithTagName(locationElement, "Branch");
                for (Element entryElement : entryNodes) {
                    Entry entry = new Entry();
                    location.EntryList.add(entry);
                    entry.Refractor = Integer.parseInt(entryElement.getAttribute("Layer"));
                    double minOff = Double.parseDouble(entryElement.getAttribute("MinOffset"));
                    double maxOff = Double.parseDouble(entryElement.getAttribute("MaxOffset"));
                    double dt = Double.parseDouble(entryElement.getAttribute("DelayTime"));
                    double vel = Double.parseDouble(entryElement.getAttribute("Velocity"));
                    entry.MinimumOffset = minOff;
                    entry.MaximumOffset = maxOff;
                    entry.TimeAtMinimumOffset = 2.0 * dt + 1000.0 * minOff / vel;
                    entry.TimeAtMaximumOffset = 2.0 * dt + 1000.0 * maxOff / vel;
                }
            }
            this.removeEmpty();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void importCSV(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            this.LocationList.clear();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            HashMap_Integers<Location> map = new HashMap_Integers<Location>();
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_comma(line, false);
                if (tokens.size() == 8) {
                    int index = Integer.parseInt(tokens.get(0).trim());
                    double x = Double.parseDouble(tokens.get(1));
                    double y = Double.parseDouble(tokens.get(2));
                    int branch = Integer.parseInt(tokens.get(3).trim());
                    double min = Double.parseDouble(tokens.get(4));
                    double max = Double.parseDouble(tokens.get(5));
                    double v = Double.parseDouble(tokens.get(6));
                    double dt = Double.parseDouble(tokens.get(7));
                    int roundX = (int)(x / 3.0);
                    int roundY = (int)(y / 3.0);
                    if (map.containsKey(roundX, roundY)) {
                        currLoc = (Location)map.get(roundX, roundY);
                        e = new Entry();
                        e.Refractor = branch;
                        e.MinimumOffset = min;
                        e.MaximumOffset = max;
                        e.TimeAtMinimumOffset = 2.0 * dt + 1000.0 * min / v;
                        e.TimeAtMaximumOffset = 2.0 * dt + 1000.0 * max / v;
                        currLoc.EntryList.add(e);
                    } else {
                        currLoc = new Location();
                        currLoc.X = x;
                        currLoc.Y = y;
                        e = new Entry();
                        e.Refractor = branch;
                        e.MinimumOffset = min;
                        e.MaximumOffset = max;
                        e.TimeAtMinimumOffset = 2.0 * dt + 1000.0 * min / v;
                        e.TimeAtMaximumOffset = 2.0 * dt + 1000.0 * max / v;
                        currLoc.EntryList.add(e);
                        map.put(currLoc, roundX, roundY);
                    }
                    line = br.readLine();
                    continue;
                }
                throw new Exception("Branch assignment CSV must have 8 columns");
            }
            this.LocationList = map.getValues();
            this.removeEmpty();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void exportCSV(String fileName) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            int index = 999;
            for (Location location : this.LocationList) {
                ++index;
                for (Entry entry : location.EntryList) {
                    writer.write(Integer.toString(index));
                    writer.write(", ");
                    writer.write(Double.toString(location.X));
                    writer.write(", ");
                    writer.write(Double.toString(location.Y));
                    writer.write(", ");
                    writer.write(Integer.toString(entry.Refractor));
                    writer.write(", ");
                    writer.write(Double.toString(entry.MinimumOffset));
                    writer.write(", ");
                    writer.write(Double.toString(entry.MaximumOffset));
                    writer.write(", ");
                    double vel = 1000.0 * (entry.MaximumOffset - entry.MinimumOffset) / (entry.TimeAtMaximumOffset - entry.TimeAtMinimumOffset);
                    double dt = (entry.TimeAtMinimumOffset - 1000.0 * entry.MinimumOffset / vel) / 2.0;
                    writer.write(Double.toString(vel));
                    writer.write(", ");
                    writer.write(Double.toString(dt));
                    writer.newLine();
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void importBrazos(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            this.LocationList.clear();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            int currentID = -9999;
            Location currLoc = null;
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_comma(line, false);
                int id = Integer.valueOf(tokens.get(0));
                double x = Double.valueOf(tokens.get(1));
                double y = Double.valueOf(tokens.get(2));
                int b = (int)(0.01 + Double.valueOf(tokens.get(3)));
                double off1 = Double.valueOf(tokens.get(4));
                double off2 = Double.valueOf(tokens.get(5));
                double v = Double.valueOf(tokens.get(6));
                double dt = Double.valueOf(tokens.get(7));
                if (id != currentID) {
                    currentID = id;
                    currLoc = new Location();
                    currLoc.X = x;
                    currLoc.Y = y;
                    this.LocationList.add(currLoc);
                }
                Entry e = new Entry();
                e.Refractor = b;
                e.MinimumOffset = off1;
                e.MaximumOffset = off2;
                e.TimeAtMinimumOffset = 2.0 * dt + 1000.0 * off1 / v;
                e.TimeAtMaximumOffset = 2.0 * dt + 1000.0 * off2 / v;
                currLoc.EntryList.add(e);
                line = br.readLine();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void importSS(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNodeSS(root);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNode(root);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) throws Exception {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("RefractorBranch");
            document.appendChild(root);
            this.writeToNode(root);
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    protected void branchPaint(Java2D_PaintParameter paintParameter, Object supplementalData) {
        try {
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int w = transform.sizeX();
            int h = transform.sizeY();
            if (this.m_currentLocation != null) {
                int x2;
                int x1;
                int y2;
                int y1;
                double t2;
                double t1;
                for (Entry entry : this.m_currentLocation.EntryList) {
                    t1 = entry.TimeAtMinimumOffset;
                    t2 = entry.TimeAtMaximumOffset;
                    if (this.ApplyLMO) {
                        t1 -= 1000.0 * entry.MinimumOffset / this.VelLMO;
                        t2 -= 1000.0 * entry.MaximumOffset / this.VelLMO;
                    }
                    if (this.ModelApplied) {
                        t1 = 0.0;
                        t2 = 0.0;
                    }
                    if (this.m_showKillRadius) {
                        g2d.setColor(this.m_killColor);
                        this.m_polyX[0] = transform.getPixelFromWorld_X(entry.MinimumOffset);
                        this.m_polyY[0] = transform.getPixelFromWorld_Y(t1 + this.m_killRadius);
                        this.m_polyX[1] = transform.getPixelFromWorld_X(entry.MinimumOffset);
                        this.m_polyY[1] = transform.getPixelFromWorld_Y(t1 - this.m_killRadius);
                        this.m_polyX[2] = transform.getPixelFromWorld_X(entry.MaximumOffset);
                        this.m_polyY[2] = transform.getPixelFromWorld_Y(t2 - this.m_killRadius);
                        this.m_polyX[3] = transform.getPixelFromWorld_X(entry.MaximumOffset);
                        this.m_polyY[3] = transform.getPixelFromWorld_Y(t2 + this.m_killRadius);
                        g2d.setColor(this.m_killColor);
                        g2d.fillPolygon(this.m_polyX, this.m_polyY, 4);
                    }
                    g2d.setColor(BranchColors.solidColor(entry.Refractor));
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                    y1 = (int)(scaleY * t1 + shiftY);
                    y2 = (int)(scaleY * t2 + shiftY);
                    x1 = (int)(scaleX * entry.MinimumOffset + shiftX);
                    x2 = (int)(scaleX * entry.MaximumOffset + shiftX);
                    g2d.drawLine(x1, 0, x1, h);
                    g2d.drawLine(x2, 0, x2, h);
                    g2d.drawLine(x1, y1, x2, y2);
                }
                for (Entry entry : this.m_currentLocation.InterpList) {
                    if (this.m_currentLocation.hasBranch(entry.Refractor)) continue;
                    g2d.setColor(BranchColors.solidColor(entry.Refractor));
                    g2d.setStroke(Tools_GraphicalObjectLibrary.DashStroke_5);
                    t1 = entry.TimeAtMinimumOffset;
                    t2 = entry.TimeAtMaximumOffset;
                    if (this.ApplyLMO) {
                        t1 -= 1000.0 * entry.MinimumOffset / this.VelLMO;
                        t2 -= 1000.0 * entry.MaximumOffset / this.VelLMO;
                    }
                    if (this.ModelApplied) {
                        t1 = 0.0;
                        t2 = 0.0;
                    }
                    y1 = (int)(scaleY * t1 + shiftY);
                    y2 = (int)(scaleY * t2 + shiftY);
                    x1 = (int)(scaleX * entry.MinimumOffset + shiftX);
                    x2 = (int)(scaleX * entry.MaximumOffset + shiftX);
                    g2d.drawLine(x1, 0, x1, h);
                    g2d.drawLine(x2, 0, x2, h);
                    g2d.drawLine(x1, y1, x2, y2);
                }
            }
            g2d.setFont(Tools_FontLibrary.Font14);
            int stringHeight = g2d.getFontMetrics().getHeight();
            String s = this.m_branchMessage;
            int stringWidth = g2d.getFontMetrics().stringWidth(s);
            int boxLeft = w - stringWidth - 10;
            int boxHeight = 3 * stringHeight + 8;
            g2d.setColor(this.m_boxColor);
            g2d.fillRect(boxLeft, 0, stringWidth + 20, boxHeight);
            int strY = stringHeight;
            int strX = w - stringWidth - 8;
            g2d.setColor(Color.BLACK);
            g2d.drawString(s, strX, strY);
            strY = strY + 2 + stringHeight;
            s = this.m_interpMessage;
            g2d.setColor(Color.BLACK);
            g2d.drawString(s, strX, strY);
            strY = strY + 2 + stringHeight;
            s = String.format("Left-click and drag to define branch %d", this.DefiningBranch);
            g2d.setColor(BranchColors.solidColor(this.DefiningBranch));
            g2d.drawString(s, strX, strY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void mapPaint(Java2D_PaintParameter paintParameter, Object supplementalData) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.m_dotColor);
            for (Location location : this.LocationList) {
                location.PixelX = (int)(scaleX * location.X + shiftX);
                location.PixelY = (int)(scaleY * location.Y + shiftY);
                if (location.EntryList.size() >= 1) {
                    g2d.setColor(this.m_dotColor);
                } else {
                    g2d.setColor(Color.YELLOW);
                }
                g2d.fillOval(location.PixelX - h, location.PixelY - h, size, size);
            }
            g2d.setColor(Color.red);
            if (this.m_currentLocation != null) {
                this.m_currentLocation.PixelX = (int)(scaleX * this.m_currentLocation.X + shiftX);
                this.m_currentLocation.PixelY = (int)(scaleY * this.m_currentLocation.Y + shiftY);
                g2d.drawOval(this.m_currentLocation.PixelX - h, this.m_currentLocation.PixelY - h, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (supplementalData == PlotType.Map.ordinal()) {
                this.mapPaint(paintParameter, supplementalData);
            }
            if (supplementalData == PlotType.Branch.ordinal()) {
                this.branchPaint(paintParameter, supplementalData);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static enum InterpolationMethod {
        InverseSquare,
        InverseFourth;

    }

    public static class Location
    implements Serializable {
        public double X;
        public double Y;
        public ArrayList<Entry> EntryList = new ArrayList();
        public int PixelX;
        public int PixelY;
        public ArrayList<Entry> InterpList = new ArrayList();

        public Location duplicate() {
            try {
                Location loc = new Location();
                loc.X = this.X;
                loc.Y = this.Y;
                for (Entry entry : this.EntryList) {
                    loc.EntryList.add(entry.duplicate());
                }
                return loc;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return null;
            }
        }

        public void copy(int from, int to) {
            try {
                if (from == to) {
                    return;
                }
                if (from < 1 || to < 1) {
                    return;
                }
                for (int n = this.EntryList.size() - 1; n >= 0; --n) {
                    Entry entry = this.EntryList.get(n);
                    if (entry.Refractor != to) continue;
                    this.EntryList.remove(n);
                }
                for (Entry entry : this.EntryList) {
                    if (entry.Refractor != from) continue;
                    entry.Refractor = to;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public boolean hasBranch(int b) {
            try {
                for (Entry entry : this.EntryList) {
                    if (entry.Refractor != b) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return false;
            }
        }

        public void sort() {
            try {
                if (this.EntryList.size() < 2) {
                    return;
                }
                Collections.sort(this.EntryList, new Sorter_Refractor());
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public static enum PlotType {
        None,
        Map,
        Branch;

    }

    public static class Entry
    implements Serializable {
        public int Refractor = -9999;
        public double MinimumOffset = -9999.0;
        public double MaximumOffset = -9999.0;
        public double TimeAtMinimumOffset = -9999.0;
        public double TimeAtMaximumOffset = -9999.0;
        public int PixelMinX;
        public int PixelMinY;
        public int PixelMaxX;
        public int PixelMaxY;

        public Entry duplicate() {
            Entry e = new Entry();
            e.Refractor = this.Refractor;
            e.MinimumOffset = this.MinimumOffset;
            e.MaximumOffset = this.MaximumOffset;
            e.TimeAtMinimumOffset = this.TimeAtMinimumOffset;
            e.TimeAtMaximumOffset = this.TimeAtMaximumOffset;
            return e;
        }

        public void resetOffsets(double min, double max) {
            try {
                if (min >= max - 1.0) {
                    return;
                }
                double dx = this.MaximumOffset - this.MinimumOffset;
                double dt = this.TimeAtMaximumOffset - this.TimeAtMinimumOffset;
                if (dt > 0.0) {
                    double alpha = dx / dt;
                    double beta = this.MinimumOffset - alpha * this.TimeAtMinimumOffset;
                    this.TimeAtMinimumOffset = (min - beta) / alpha;
                    this.TimeAtMaximumOffset = (max - beta) / alpha;
                }
                this.MinimumOffset = min;
                this.MaximumOffset = max;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void resetMinimumOffset(double v) {
            try {
                v = Math.min(v, this.MaximumOffset - 1.0);
                double dx = this.MaximumOffset - this.MinimumOffset;
                double dt = this.TimeAtMaximumOffset - this.TimeAtMinimumOffset;
                if (dt > 0.0) {
                    double alpha = dx / dt;
                    double beta = this.MinimumOffset - alpha * this.TimeAtMinimumOffset;
                    this.TimeAtMinimumOffset = (v - beta) / alpha;
                }
                this.MinimumOffset = v;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void resetMaximumOffset(double v) {
            try {
                v = Math.max(v, this.MinimumOffset + 1.0);
                double dx = this.MaximumOffset - this.MinimumOffset;
                double dt = this.TimeAtMaximumOffset - this.TimeAtMinimumOffset;
                if (dt > 0.0) {
                    double alpha = dx / dt;
                    double beta = this.MinimumOffset - alpha * this.TimeAtMinimumOffset;
                    this.TimeAtMaximumOffset = (v - beta) / alpha;
                }
                this.MaximumOffset = v;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static enum MapPlotType {
        Velocity,
        DelayTime,
        MinOffset,
        MaxOffset,
        OffsetRange,
        InterpolatedV0;

    }

    public static class Sorter_Refractor
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.Refractor == e2.Refractor) {
                    return 0;
                }
                if (e1.Refractor < e2.Refractor) {
                    return -1;
                }
                return 1;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }
}

