/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;

public class Matrix_Simple {
    public int RowCount;
    public int ColumnCount;
    public double[][] Data;

    public Matrix_Simple(int rows, int columns) {
        this.RowCount = rows;
        this.ColumnCount = columns;
        this.Data = new double[rows][columns];
    }

    public Matrix_Simple(double[][] data) {
        this.RowCount = data.length;
        this.ColumnCount = data[0].length;
        this.Data = new double[this.RowCount][this.ColumnCount];
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                this.Data[i][j] = data[i][j];
            }
        }
    }

    private Matrix_Simple(Matrix_Simple A) {
        this(A.Data);
    }

    public static Matrix_Simple random(int rows, int columns) {
        Matrix_Simple A = new Matrix_Simple(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                A.Data[i][j] = Math.random();
            }
        }
        return A;
    }

    public static Matrix_Simple identity(int N) {
        Matrix_Simple I = new Matrix_Simple(N, N);
        for (int i = 0; i < N; ++i) {
            I.Data[i][i] = 1.0;
        }
        return I;
    }

    private void swap(int i, int j) {
        double[] temp = this.Data[i];
        this.Data[i] = this.Data[j];
        this.Data[j] = temp;
    }

    public Matrix_Simple transpose() {
        Matrix_Simple A = new Matrix_Simple(this.ColumnCount, this.RowCount);
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                A.Data[j][i] = this.Data[i][j];
            }
        }
        return A;
    }

    public double magnitude() throws Exception {
        try {
            double sum = 0.0;
            for (int row = 0; row < this.RowCount; ++row) {
                for (int col = 0; col < this.ColumnCount; ++col) {
                    sum += this.Data[row][col] * this.Data[row][col];
                }
            }
            return sum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Matrix_Simple plus(Matrix_Simple B) {
        Matrix_Simple A = this;
        if (B.RowCount != A.RowCount || B.ColumnCount != A.ColumnCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple C = new Matrix_Simple(this.RowCount, this.ColumnCount);
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                C.Data[i][j] = A.Data[i][j] + B.Data[i][j];
            }
        }
        return C;
    }

    public Matrix_Simple plus(Matrix_Simple B, double scalar) {
        Matrix_Simple A = this;
        if (B.RowCount != A.RowCount || B.ColumnCount != A.ColumnCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple C = new Matrix_Simple(this.RowCount, this.ColumnCount);
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                C.Data[i][j] = A.Data[i][j] + scalar * B.Data[i][j];
            }
        }
        return C;
    }

    public Matrix_Simple minus(Matrix_Simple B) {
        Matrix_Simple A = this;
        if (B.RowCount != A.RowCount || B.ColumnCount != A.ColumnCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple C = new Matrix_Simple(this.RowCount, this.ColumnCount);
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                C.Data[i][j] = A.Data[i][j] - B.Data[i][j];
            }
        }
        return C;
    }

    public Matrix_Simple minus(Matrix_Simple B, double scalar) {
        Matrix_Simple A = this;
        if (B.RowCount != A.RowCount || B.ColumnCount != A.ColumnCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple C = new Matrix_Simple(this.RowCount, this.ColumnCount);
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                C.Data[i][j] = A.Data[i][j] - scalar * B.Data[i][j];
            }
        }
        return C;
    }

    public boolean eq(Matrix_Simple B) {
        Matrix_Simple A = this;
        if (B.RowCount != A.RowCount || B.ColumnCount != A.ColumnCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                if (A.Data[i][j] == B.Data[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix_Simple times(Matrix_Simple B) {
        Matrix_Simple A = this;
        if (A.ColumnCount != B.RowCount) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple C = new Matrix_Simple(A.RowCount, B.ColumnCount);
        for (int i = 0; i < C.RowCount; ++i) {
            for (int j = 0; j < C.ColumnCount; ++j) {
                for (int k = 0; k < A.ColumnCount; ++k) {
                    double[] dArray = C.Data[i];
                    int n = j;
                    dArray[n] = dArray[n] + A.Data[i][k] * B.Data[k][j];
                }
            }
        }
        return C;
    }

    public Matrix_Simple solve(Matrix_Simple rhs) {
        if (this.RowCount != this.ColumnCount || rhs.RowCount != this.ColumnCount || rhs.ColumnCount != 1) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix_Simple A = new Matrix_Simple(this);
        Matrix_Simple b = new Matrix_Simple(rhs);
        for (int i = 0; i < this.ColumnCount; ++i) {
            int j;
            int max = i;
            for (j = i + 1; j < this.ColumnCount; ++j) {
                if (!(Math.abs(A.Data[j][i]) > Math.abs(A.Data[max][i]))) continue;
                max = j;
            }
            A.swap(i, max);
            b.swap(i, max);
            if (A.Data[i][i] == 0.0) {
                throw new RuntimeException("Matrix is singular.");
            }
            for (j = i + 1; j < this.ColumnCount; ++j) {
                double[] dArray = b.Data[j];
                dArray[0] = dArray[0] - b.Data[i][0] * A.Data[j][i] / A.Data[i][i];
            }
            for (j = i + 1; j < this.ColumnCount; ++j) {
                double m = A.Data[j][i] / A.Data[i][i];
                for (int k = i + 1; k < this.ColumnCount; ++k) {
                    double[] dArray = A.Data[j];
                    int n = k;
                    dArray[n] = dArray[n] - A.Data[i][k] * m;
                }
                A.Data[j][i] = 0.0;
            }
        }
        Matrix_Simple x = new Matrix_Simple(this.ColumnCount, 1);
        for (int j = this.ColumnCount - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < this.ColumnCount; ++k) {
                t += A.Data[j][k] * x.Data[k][0];
            }
            x.Data[j][0] = (b.Data[j][0] - t) / A.Data[j][j];
        }
        return x;
    }

    public void show() {
        for (int i = 0; i < this.RowCount; ++i) {
            for (int j = 0; j < this.ColumnCount; ++j) {
                System.out.printf("%9.4f ", this.Data[i][j]);
            }
            System.out.println();
        }
    }

    public static Matrix_Simple copy(Matrix_Simple input) {
        int rows = input.RowCount;
        int columns = input.ColumnCount;
        Matrix_Simple A = new Matrix_Simple(rows, columns);
        A.RowCount = rows;
        A.ColumnCount = columns;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                A.Data[row][col] = input.Data[row][col];
            }
        }
        return A;
    }
}

