/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;

public class LineFit {
    public double SumX = 0.0;
    public double SumY = 0.0;
    public double SumXX = 0.0;
    public double SumXY = 0.0;
    public int Count = 0;
    public boolean m_computed = false;
    public double A = 0.0;
    public double B = 0.0;
    protected boolean m_valid = false;
    public double NearestY;
    public double NearestX;
    public double DistanceFromX0;

    public boolean valid() {
        return this.m_valid;
    }

    public void clear() {
        this.m_valid = false;
        this.SumX = 0.0;
        this.SumY = 0.0;
        this.SumXX = 0.0;
        this.SumXY = 0.0;
        this.Count = 0;
    }

    public double get_y(double x) {
        return this.A * x + this.B;
    }

    public void findNearestPoint(double x, double y) {
        try {
            double error = y - (this.A * x + this.B);
            double t2 = this.A * y;
            double t3 = this.A * this.B;
            double t1 = x + t2 - t3;
            this.NearestX = (x + this.A * y - this.A * this.B) / (1.0 + this.A * this.A);
            this.NearestY = this.A * this.NearestX + this.B;
            this.DistanceFromX0 = this.NearestX * Math.sqrt(1.0 + this.A * this.A);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void add(double x, double y) {
        this.m_valid = false;
        this.m_computed = false;
        this.SumX += x;
        this.SumY += y;
        this.SumXX += x * x;
        this.SumXY += x * y;
        ++this.Count;
    }

    public boolean compute() {
        try {
            this.m_valid = false;
            this.m_computed = false;
            if (this.Count < 2) {
                return false;
            }
            double sumTop = (double)this.Count * this.SumXY - this.SumX * this.SumY;
            double sumBottom = (double)this.Count * this.SumXX - this.SumX * this.SumX;
            if (Math.abs(sumBottom) < 1.0E-20) {
                return false;
            }
            this.A = sumTop / sumBottom;
            this.B = (this.SumY - this.A * this.SumX) / (double)this.Count;
            this.m_valid = true;
            this.m_computed = true;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

