/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Math.Grid3D_InterpolationElement;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;

public class Grid3D
extends Grid3D_Conversion
implements Java2D_PaintableInterface,
Serializable {
    public static final String FileSuffix = ".grid3d";
    protected float[][] m_data = null;
    public boolean[][] DataValid;
    protected float[] m_distanceWeight;
    public float[][] InterpSum;
    public float[][] InterpWeight;
    public boolean[][] InterpValid;
    public float[][] InterpCoarseSum;
    public float[][] InterpCoarseValue;
    public float[][] InterpCoarseWeight;
    public boolean[][] InterpCoarseValid;
    public int m_coarseBinCount = 10;
    public int m_numCoarseInline;
    public int m_numCoarseCrossline;
    public int MaxCount = 0;
    public float[][] Count = null;
    public float[][] SumW = null;
    public float[][] SumU = null;
    public float[][] SumUU = null;
    public float[][] SumUV = null;
    public float[][] SumV = null;
    public float[][] Weight = null;
    public boolean[][] Valid = null;
    public float[][] Alpha = null;
    public float[][] Beta = null;
    protected int SmearRadius = 7;
    public boolean DrawColor = true;
    public boolean DrawLines = false;
    protected int m_indexCrossline;
    protected int m_indexInline;
    public float AverageDistance = 0.0f;
    protected int m_sprayRadius = 0;
    public boolean ImageDirty = true;
    public Color LineColor = Color.lightGray;
    public boolean ArrayDirty = true;
    public float ArrayMin;
    public float ArrayMax;

    public Grid3D(Grid3D_Conversion grid) throws Exception {
        try {
            this.m_worldCoordAtOriginX = grid.m_worldCoordAtOriginX;
            this.m_worldCoordAtOriginY = grid.m_worldCoordAtOriginY;
            this.m_inlineAtOrigin = grid.m_inlineAtOrigin;
            this.m_crosslineAtOrigin = grid.m_crosslineAtOrigin;
            this.m_inlineIncrement = grid.m_inlineIncrement;
            this.m_crosslineIncrement = grid.m_crosslineIncrement;
            this.m_inlineBinSize = grid.m_inlineBinSize;
            this.m_crosslineBinSize = grid.m_crosslineBinSize;
            this.m_inlineAngle = grid.m_inlineAngle;
            this.computeInternals(false);
            this.m_minInline = grid.inlineMin();
            this.m_maxInline = grid.inlineMax();
            this.m_minCrossline = grid.crosslineMin();
            this.m_maxCrossline = grid.crosslineMax();
            this.allocateGrid();
            if (grid instanceof Grid3D) {
                Grid3D g3d = (Grid3D)grid;
                float[][] data = g3d.data();
                for (int x = 0; x < this.m_numInline; ++x) {
                    for (int y = 0; y < this.m_numCrossline; ++y) {
                        this.m_data[x][y] = data[x][y];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Grid3D(String fileName) throws Exception {
        try {
            this.read(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void getRange(Range_Double range) {
        try {
            range.clearRange();
            this.ArrayDirty = true;
            if (this.m_data == null) {
                return;
            }
            this.ArrayMin = Float.MAX_VALUE;
            this.ArrayMax = Float.MIN_VALUE;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    this.ArrayMin = Math.min(this.ArrayMin, this.m_data[x][y]);
                    this.ArrayMax = Math.max(this.ArrayMax, this.m_data[x][y]);
                }
            }
            if (this.ArrayMin <= this.ArrayMax) {
                this.ArrayDirty = false;
                range.expandRange(this.ArrayMin);
                range.expandRange(this.ArrayMax);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clip(float min, float max, PolygonUsage polyUsage, Java2D_Polygon poly) throws Exception {
        try {
            for (int ix = 0; ix < this.m_numInline; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline; ++iy) {
                    double x = this.getWorldX_Indices(ix, iy);
                    double y = this.getWorldY_Indices(ix, iy);
                    boolean clip = true;
                    if (polyUsage == PolygonUsage.Inside) {
                        boolean bl = clip = poly.contains(x, y);
                    }
                    if (polyUsage == PolygonUsage.Outside) {
                        boolean bl = clip = !poly.contains(x, y);
                    }
                    if (!clip) continue;
                    this.m_data[ix][iy] = Math.max(this.m_data[ix][iy], min);
                    this.m_data[ix][iy] = Math.min(this.m_data[ix][iy], max);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setValue(float val, PolygonUsage polyUsage, Java2D_Polygon poly) throws Exception {
        try {
            for (int ix = 0; ix < this.m_numInline; ++ix) {
                for (int iy = 0; iy < this.m_numCrossline; ++iy) {
                    double x = this.getWorldX_Indices(ix, iy);
                    double y = this.getWorldY_Indices(ix, iy);
                    boolean set = true;
                    if (polyUsage == PolygonUsage.Inside) {
                        boolean bl = set = poly.contains(x, y);
                    }
                    if (polyUsage == PolygonUsage.Outside) {
                        boolean bl = set = !poly.contains(x, y);
                    }
                    if (!set) continue;
                    this.m_data[ix][iy] = val;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setValue(float v) throws Exception {
        try {
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    this.m_data[x][y] = v;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getNearestValue(double x, double y) throws Exception {
        try {
            this.setWorldLocation(x, y);
            this.m_indexCrossline = (this.Crossline - this.m_minCrossline) / this.m_crosslineIncrement;
            this.m_indexCrossline = Math.max(this.m_indexCrossline, 0);
            this.m_indexCrossline = Math.min(this.m_indexCrossline, this.m_numCrossline - 1);
            this.m_indexInline = (this.Inline - this.m_minInline) / this.m_inlineIncrement;
            this.m_indexInline = Math.max(this.m_indexInline, 0);
            this.m_indexInline = Math.min(this.m_indexInline, this.m_numInline - 1);
            return this.m_data[this.m_indexInline][this.m_indexCrossline];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float getNearestValue(double x, double y, boolean interpolate) throws Exception {
        try {
            if (!interpolate) {
                return this.getNearestValue(x, y);
            }
            double dx = x - this.m_worldCoordAtOriginX;
            double dy = y - this.m_worldCoordAtOriginY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            int x1 = 0;
            int x2 = 0;
            int y1 = 0;
            int y2 = 0;
            float fx = 0.0f;
            float fy = 0.0f;
            double gx = this.GridX * this.m_inverseInlineBinSize - (double)this.m_minInline;
            x1 = gx >= 0.0 ? (int)gx : -1 - (int)(-gx);
            x2 = x1 + 1;
            fx = (float)(gx - (double)x1);
            x1 = Math.max(x1, 0);
            x1 = Math.min(x1, this.m_numInline - 1);
            x2 = Math.max(x2, 0);
            x2 = Math.min(x2, this.m_numInline - 1);
            double gy = this.GridY * this.m_inverseCrosslineBinSize - (double)this.m_minCrossline;
            y1 = gy >= 0.0 ? (int)gy : -1 - (int)(-gy);
            y2 = y1 + 1;
            fy = (float)(gy - (double)y1);
            y1 = Math.max(y1, 0);
            y1 = Math.min(y1, this.m_numCrossline - 1);
            y2 = Math.max(y2, 0);
            y2 = Math.min(y2, this.m_numCrossline - 1);
            float v11 = (1.0f - fx) * (1.0f - fy) * this.m_data[x1][y1];
            float v12 = (1.0f - fx) * fy * this.m_data[x1][y2];
            float v21 = fx * (1.0f - fy) * this.m_data[x2][y1];
            float v22 = fx * fy * this.m_data[x2][y2];
            return v11 + v12 + v21 + v22;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void smooth(int rad) throws Exception {
        try {
            rad = Math.max(rad, 1);
            rad = Math.min(rad, 200);
            float[][] temp = new float[this.m_numInline][this.m_numCrossline];
            this.smoothCode(null, this.m_data, null, temp, rad, this.m_numInline, this.m_numCrossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void despike(double percent) {
        try {
            this.despike(this.m_data, null, percent, percent);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void despike(float[][] data, float[][] weight, double minPercent, double maxPercent) {
        try {
            double sum = 0.0;
            double sumWeight = 1.0E-40;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    double w = 1.0;
                    if (weight != null) {
                        w = weight[x][y];
                    }
                    sum += w * (double)data[x][y];
                    sumWeight += w;
                }
            }
            maxPercent = Math.max(maxPercent, 0.0);
            maxPercent = Math.min(maxPercent, 1000.0);
            minPercent = Math.max(minPercent, 0.0);
            minPercent = Math.min(minPercent, 99.0);
            double avg = sum / sumWeight;
            float min = (float)(avg - 0.01 * minPercent * avg);
            float max = (float)(avg + 0.01 * maxPercent * avg);
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    data[x][y] = Math.max(data[x][y], min);
                    data[x][y] = Math.min(data[x][y], max);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void rangeCompression(double compression) {
        try {
            double sum = 0.0;
            double sumWeight = 1.0E-40;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    sum += (double)this.m_data[x][y];
                    sumWeight += 1.0;
                }
            }
            double avg = sum / sumWeight;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    double diff = (double)this.m_data[x][y] - avg;
                    this.m_data[x][y] = (float)(avg + diff / compression);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float average() {
        try {
            double sum = 0.0;
            double sumWeight = 1.0E-40;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    sum += (double)this.m_data[x][y];
                    sumWeight += 1.0;
                }
            }
            float average = (float)(sum / sumWeight);
            sum = 0.0;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    sum += (double)Math.abs(average - this.m_data[x][y]);
                }
            }
            this.AverageDistance = (float)(sum / sumWeight);
            return average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public void interp_Prep(int sprayRadius) throws Exception {
        try {
            this.interp_SetSprayRadius(sprayRadius);
            this.InterpSum = new float[this.m_numInline][this.m_numCrossline];
            this.InterpWeight = new float[this.m_numInline][this.m_numCrossline];
            this.InterpValid = new boolean[this.m_numInline][this.m_numCrossline];
            this.m_coarseBinCount = 10;
            this.m_numCoarseInline = 1 + this.m_numInline / this.m_coarseBinCount;
            this.m_numCoarseCrossline = 1 + this.m_numCrossline / this.m_coarseBinCount;
            this.InterpCoarseValue = new float[this.m_numCoarseInline][this.m_numCoarseCrossline];
            this.InterpCoarseSum = new float[this.m_numCoarseInline][this.m_numCoarseCrossline];
            this.InterpCoarseWeight = new float[this.m_numCoarseInline][this.m_numCoarseCrossline];
            this.InterpCoarseValid = new boolean[this.m_numCoarseInline][this.m_numCoarseCrossline];
            this.interp_ZeroArrays();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_Prep() throws Exception {
        try {
            this.interp_Prep(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_Free() {
        try {
            this.InterpSum = null;
            this.InterpWeight = null;
            this.InterpValid = null;
            this.InterpCoarseSum = null;
            this.InterpCoarseWeight = null;
            this.InterpCoarseValid = null;
            this.InterpCoarseValue = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interp_ZeroArrays() throws Exception {
        try {
            int y;
            int x;
            for (x = 0; x < this.m_numInline; ++x) {
                for (y = 0; y < this.m_numCrossline; ++y) {
                    this.InterpValid[x][y] = false;
                    this.InterpSum[x][y] = 0.0f;
                    this.InterpWeight[x][y] = 1.0E-40f;
                }
            }
            for (x = 0; x < this.m_numCoarseInline; ++x) {
                for (y = 0; y < this.m_numCoarseCrossline; ++y) {
                    this.InterpCoarseValid[x][y] = false;
                    this.InterpCoarseSum[x][y] = 0.0f;
                    this.InterpCoarseWeight[x][y] = 1.0E-40f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_SetSprayRadius(int sprayRadius) {
        this.m_sprayRadius = Math.max(sprayRadius, 0);
    }

    public void interp_AddIndex(int ix, int iy, int radius, float v, float w) throws Exception {
        try {
            ix = Math.max(0, ix);
            ix = Math.min(ix, this.m_numInline - 1);
            iy = Math.max(0, iy);
            iy = Math.min(iy, this.m_numCrossline - 1);
            int minX = Math.max(0, ix - radius);
            int maxX = Math.min(this.m_numInline - 1, ix + radius);
            int minY = Math.max(0, iy - radius);
            int maxY = Math.min(this.m_numCrossline - 1, iy + radius);
            for (ix = minX; ix <= maxX; ++ix) {
                for (iy = minY; iy <= maxY; ++iy) {
                    float[] fArray = this.InterpSum[ix];
                    int n = iy;
                    fArray[n] = fArray[n] + v * w;
                    float[] fArray2 = this.InterpWeight[ix];
                    int n2 = iy;
                    fArray2[n2] = fArray2[n2] + w;
                    this.InterpValid[ix][iy] = true;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_Add(double x, double y, float v, float w) throws Exception {
        try {
            this.setWorldLocation(x, y);
            int ix = (this.Inline - this.m_minInline) / this.m_inlineIncrement;
            int iy = (this.Crossline - this.m_minCrossline) / this.m_crosslineIncrement;
            this.interp_AddIndex(ix, iy, this.m_sprayRadius, v, w);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_Finish(int smoothRad) throws Exception {
        try {
            this.interp_Finish(smoothRad, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void interp_Finish(int smoothRad, boolean applyLock) throws Exception {
        try {
            int y;
            int x;
            int y2;
            int x2;
            float minValidCoarse = Float.MAX_VALUE;
            int numValid = 0;
            boolean[][] lockedCoarse = new boolean[this.m_numCoarseInline][this.m_numCoarseCrossline];
            float validMax = Float.MIN_VALUE;
            float validMin = Float.MAX_VALUE;
            for (x2 = 0; x2 < this.m_numCoarseInline; ++x2) {
                for (y2 = 0; y2 < this.m_numCoarseCrossline; ++y2) {
                    this.InterpCoarseValid[x2][y2] = false;
                    this.InterpCoarseSum[x2][y2] = 0.0f;
                    this.InterpCoarseWeight[x2][y2] = 1.0E-40f;
                    int minX = x2 * this.m_coarseBinCount;
                    int maxX = minX + this.m_coarseBinCount - 1;
                    minX = Math.max(0, minX);
                    maxX = Math.min(this.m_numInline - 1, maxX);
                    int minY = y2 * this.m_coarseBinCount;
                    int maxY = minY + this.m_coarseBinCount - 1;
                    minY = Math.max(0, minY);
                    maxY = Math.min(this.m_numCrossline - 1, maxY);
                    for (int ix = minX; ix <= maxX; ++ix) {
                        for (int iy = minY; iy <= maxY; ++iy) {
                            if (!this.InterpValid[ix][iy]) continue;
                            this.InterpCoarseValid[x2][y2] = true;
                            float w = this.InterpWeight[ix][iy];
                            float v = this.InterpSum[ix][iy] / w;
                            float[] fArray = this.InterpCoarseSum[x2];
                            int n = y2;
                            fArray[n] = fArray[n] + v * w;
                            float[] fArray2 = this.InterpCoarseWeight[x2];
                            int n2 = y2;
                            fArray2[n2] = fArray2[n2] + w;
                            ++numValid;
                        }
                    }
                    lockedCoarse[x2][y2] = false;
                    if (!this.InterpCoarseValid[x2][y2]) continue;
                    lockedCoarse[x2][y2] = true;
                    minValidCoarse = Math.min(minValidCoarse, this.InterpCoarseWeight[x2][y2]);
                    this.InterpCoarseValue[x2][y2] = this.InterpCoarseSum[x2][y2] / this.InterpCoarseWeight[x2][y2];
                }
            }
            if (numValid < 1) {
                throw new Exception("numValid < 1");
            }
            for (int r = 0; r < this.m_distanceWeight.length; ++r) {
                this.m_distanceWeight[r] = 1.0f + 1000.0f / (1.0f + (float)(r * r));
            }
            for (x2 = 0; x2 < this.m_numCoarseInline; ++x2) {
                for (y2 = 0; y2 < this.m_numCoarseCrossline; ++y2) {
                    this.InterpCoarseWeight[x2][y2] = !this.InterpCoarseValid[x2][y2] ? 0.0f : 1.0f;
                }
            }
            boolean done = false;
            while (!done) {
                int maxY;
                int minY;
                int maxX;
                int minX;
                int y3;
                int x3;
                done = true;
                for (x3 = 0; x3 < this.m_numCoarseInline; ++x3) {
                    for (y3 = 0; y3 < this.m_numCoarseCrossline; ++y3) {
                        this.InterpCoarseSum[x3][y3] = 1.0f;
                        if (!(this.InterpCoarseWeight[x3][y3] < 0.05f)) continue;
                        done = false;
                        minX = Math.max(x3 - 1, 0);
                        maxX = Math.min(x3 + 1, this.m_numCoarseInline - 1);
                        minY = Math.max(y3 - 1, 0);
                        maxY = Math.min(y3 + 1, this.m_numCoarseCrossline - 1);
                        int count = 0;
                        for (int ix = minX; ix <= maxX; ++ix) {
                            for (int iy = minY; iy <= maxY; ++iy) {
                                float weight = this.InterpCoarseWeight[ix][iy];
                                if (!(weight > 0.05f)) continue;
                                ++count;
                            }
                        }
                        if (count < true) continue;
                        this.InterpCoarseSum[x3][y3] = 0.0f;
                    }
                }
                for (x3 = 0; x3 < this.m_numCoarseInline; ++x3) {
                    for (y3 = 0; y3 < this.m_numCoarseCrossline; ++y3) {
                        if (!(this.InterpCoarseSum[x3][y3] < 0.05f)) continue;
                        done = false;
                        minX = Math.max(x3 - 1, 0);
                        maxX = Math.min(x3 + 1, this.m_numCoarseInline - 1);
                        minY = Math.max(y3 - 1, 0);
                        maxY = Math.min(y3 + 1, this.m_numCoarseCrossline - 1);
                        float sum1 = 0.0f;
                        float sum2 = 0.0f;
                        for (int ix = minX; ix <= maxX; ++ix) {
                            for (int iy = minY; iy <= maxY; ++iy) {
                                float weight = this.InterpCoarseWeight[ix][iy];
                                if (!(weight > 0.05f)) continue;
                                sum1 += weight * this.InterpCoarseValue[ix][iy];
                                sum2 += weight;
                            }
                        }
                        if (!(sum2 > 0.05f)) continue;
                        this.InterpCoarseValue[x3][y3] = sum1 / sum2;
                        this.InterpCoarseWeight[x3][y3] = 0.1f;
                    }
                }
            }
            float minValidWeight = Float.MAX_VALUE;
            for (int x4 = 0; x4 < this.m_numInline; ++x4) {
                for (int y4 = 0; y4 < this.m_numCrossline; ++y4) {
                    if (!this.InterpValid[x4][y4]) continue;
                    minValidWeight = Math.min(minValidWeight, this.InterpWeight[x4][y4]);
                }
            }
            boolean[][] locked = new boolean[this.m_numInline][this.m_numCrossline];
            for (x = 0; x < this.m_numInline; ++x) {
                for (y = 0; y < this.m_numCrossline; ++y) {
                    if (!this.InterpValid[x][y]) continue;
                    locked[x][y] = true;
                    this.m_data[x][y] = this.InterpSum[x][y] / this.InterpWeight[x][y];
                    validMax = Math.max(validMax, this.m_data[x][y]);
                    validMin = Math.min(validMin, this.m_data[x][y]);
                }
            }
            for (x = 0; x < this.m_numInline; ++x) {
                for (y = 0; y < this.m_numCrossline; ++y) {
                    if (this.InterpValid[x][y]) continue;
                    int ix = x / this.m_coarseBinCount;
                    int iy = y / this.m_coarseBinCount;
                    this.m_data[x][y] = this.InterpCoarseValue[ix][iy];
                    this.m_data[x][y] = Math.min(this.m_data[x][y], validMax);
                    this.m_data[x][y] = Math.max(this.m_data[x][y], validMin);
                    this.InterpWeight[x][y] = 0.5f * minValidWeight;
                }
            }
            if (applyLock) {
                this.smoothCode(locked, this.m_data, this.InterpWeight, this.InterpSum, smoothRad, this.m_numInline, this.m_numCrossline);
            } else {
                this.smoothCode(null, this.m_data, this.InterpWeight, this.InterpSum, smoothRad, this.m_numInline, this.m_numCrossline);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void smoothCode(boolean[][] locked, float[][] value, float[][] weight, float[][] temp, int rad, int numInline, int numCrossline) throws Exception {
        try {
            int y;
            int x;
            for (int r = 0; r < this.m_distanceWeight.length; ++r) {
                this.m_distanceWeight[r] = 1.0f / (1.0f + (float)r);
            }
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (x = 0; x < numInline; ++x) {
                for (y = 0; y < numCrossline; ++y) {
                    temp[x][y] = value[x][y];
                    min = Math.min(min, value[x][y]);
                    max = Math.max(max, value[x][y]);
                }
            }
            for (x = 0; x < numInline; ++x) {
                for (y = 0; y < numCrossline; ++y) {
                    boolean lock = false;
                    if (locked != null) {
                        lock = locked[x][y];
                    }
                    if (lock) continue;
                    int minX = Math.max(x - rad, 0);
                    int maxX = Math.min(x + rad, numInline - 1);
                    int minY = Math.max(y - rad, 0);
                    int maxY = Math.min(y + rad, numCrossline - 1);
                    float sum = 0.0f;
                    float sumWeight = 1.0E-40f;
                    for (int ix = minX; ix <= maxX; ++ix) {
                        for (int iy = minY; iy <= maxY; ++iy) {
                            int r = Math.min(Math.abs(x - ix) + Math.abs(y - iy), this.m_distanceWeight.length - 1);
                            float w = this.m_distanceWeight[r];
                            if (weight != null) {
                                w *= weight[ix][iy];
                            }
                            sum += w * temp[ix][iy];
                            sumWeight += w;
                        }
                    }
                    value[x][y] = sum / sumWeight;
                    value[x][y] = Math.min(value[x][y], max);
                    value[x][y] = Math.max(value[x][y], min);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void deadZoneCode(float[][] value, float[][] weight, float minValidWeight, int numInline, int numCrossline) throws Exception {
        try {
            boolean bad = true;
            while (bad) {
                bad = false;
                for (int x = 0; x < numInline; ++x) {
                    for (int y = 0; y < numCrossline; ++y) {
                        if (!(weight[x][y] < minValidWeight)) continue;
                        bad = true;
                        int minX = Math.max(0, x - 6);
                        int maxX = Math.min(numInline - 1, x + 6);
                        int minY = Math.max(0, y - 6);
                        int maxY = Math.min(numCrossline - 1, y + 6);
                        int num = 0;
                        float sumWeight = 0.0f;
                        float sumValue = 0.0f;
                        for (int ix = minX; ix <= maxX; ++ix) {
                            for (int iy = minY; iy <= maxY; ++iy) {
                                if (!(weight[ix][iy] >= minValidWeight)) continue;
                                ++num;
                                double dist = Math.abs(ix - x) + Math.abs(iy - y);
                                double w = (double)weight[ix][iy] / (1.0 + dist);
                                sumWeight += (float)w;
                                sumValue += (float)w * value[ix][iy];
                            }
                        }
                        if (num <= 0) continue;
                        weight[x][y] = 1.01f * minValidWeight;
                        value[x][y] = sumValue / sumWeight;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void linearFit_Free() {
        try {
            this.Count = null;
            this.SumW = null;
            this.SumU = null;
            this.SumUU = null;
            this.SumUV = null;
            this.SumV = null;
            this.Weight = null;
            this.Alpha = null;
            this.Beta = null;
            this.Valid = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void linearFit_ZeroArrays() throws Exception {
        try {
            this.MaxCount = 0;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    this.Valid[x][y] = false;
                    this.Alpha[x][y] = 0.0f;
                    this.Beta[x][y] = 0.0f;
                    this.Count[x][y] = 1.0E-40f;
                    this.SumW[x][y] = 1.0E-40f;
                    this.SumU[x][y] = 1.0E-40f;
                    this.SumUU[x][y] = 1.0E-40f;
                    this.SumUV[x][y] = 1.0E-40f;
                    this.Weight[x][y] = 1.0E-40f;
                    this.SumV[x][y] = 1.0E-40f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void linearFit_Prep() throws Exception {
        try {
            this.MaxCount = 0;
            this.Count = new float[this.m_numInline][this.m_numCrossline];
            this.SumW = new float[this.m_numInline][this.m_numCrossline];
            this.SumU = new float[this.m_numInline][this.m_numCrossline];
            this.SumUU = new float[this.m_numInline][this.m_numCrossline];
            this.SumUV = new float[this.m_numInline][this.m_numCrossline];
            this.SumV = new float[this.m_numInline][this.m_numCrossline];
            this.Weight = new float[this.m_numInline][this.m_numCrossline];
            this.Alpha = new float[this.m_numInline][this.m_numCrossline];
            this.Beta = new float[this.m_numInline][this.m_numCrossline];
            this.Valid = new boolean[this.m_numInline][this.m_numCrossline];
            this.linearFit_ZeroArrays();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void linearFit_AddIndex(int ix, int iy, int radius, float u, float v, float w) throws Exception {
        try {
            ix = Math.max(0, ix);
            ix = Math.min(ix, this.m_numInline - 1);
            iy = Math.max(0, iy);
            iy = Math.min(iy, this.m_numCrossline - 1);
            int minX = Math.max(0, ix - radius);
            int maxX = Math.min(this.m_numInline - 1, ix + radius);
            int minY = Math.max(0, iy - radius);
            int maxY = Math.min(this.m_numCrossline - 1, iy + radius);
            for (ix = minX; ix <= maxX; ++ix) {
                iy = minY;
                while (iy <= maxY) {
                    float[] fArray = this.Count[ix];
                    int n = iy;
                    fArray[n] = fArray[n] + 1.0f;
                    this.MaxCount = Math.max(this.MaxCount, (int)this.Count[ix][iy]);
                    float[] fArray2 = this.SumW[ix];
                    int n2 = iy;
                    fArray2[n2] = fArray2[n2] + w;
                    float[] fArray3 = this.SumU[ix];
                    int n3 = iy;
                    fArray3[n3] = fArray3[n3] + w * u;
                    float[] fArray4 = this.SumUU[ix];
                    int n4 = iy;
                    fArray4[n4] = fArray4[n4] + w * u * u;
                    float[] fArray5 = this.SumUV[ix];
                    int n5 = iy;
                    fArray5[n5] = fArray5[n5] + w * u * v;
                    float[] fArray6 = this.SumV[ix];
                    int n6 = iy++;
                    fArray6[n6] = fArray6[n6] + w * v;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void linearFit_Add(double x, double y, float u, float v, float w) throws Exception {
        try {
            this.setWorldLocation(x, y);
            int ix = (this.Inline - this.m_minInline) / this.m_inlineIncrement;
            int iy = (this.Crossline - this.m_minCrossline) / this.m_crosslineIncrement;
            this.linearFit_AddIndex(ix, iy, this.SmearRadius, u, v, w);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void linearFit_Compute(double despikePercentLimit, boolean applyDespiking) throws Exception {
        try {
            int y;
            int x;
            int numValid = 0;
            for (int x2 = 0; x2 < this.m_numInline; ++x2) {
                for (int y2 = 0; y2 < this.m_numCrossline; ++y2) {
                    this.Valid[x2][y2] = false;
                    this.Weight[x2][y2] = 0.0f;
                    int N = (int)this.Count[x2][y2];
                    if (N < 6) continue;
                    ++numValid;
                    double sumW = this.SumW[x2][y2];
                    double sumU = this.SumU[x2][y2];
                    double sumUU = this.SumUU[x2][y2];
                    double sumUV = this.SumUV[x2][y2];
                    double sumV = this.SumV[x2][y2];
                    this.Weight[x2][y2] = (float)sumW;
                    double denom = sumW * sumUU - sumU * sumU;
                    if (!(Math.abs(denom) > 1.0E-5)) continue;
                    double b = (sumV * sumUU - sumU * sumUV) / denom;
                    double a = (sumW * sumUV - sumU * sumV) / denom;
                    this.Alpha[x2][y2] = (float)a;
                    this.Beta[x2][y2] = (float)b;
                    this.Valid[x2][y2] = true;
                }
            }
            if (numValid < 1) {
                throw new Exception("numValid < 1");
            }
            boolean bad = true;
            while (bad) {
                bad = false;
                for (x = 0; x < this.m_numInline; ++x) {
                    for (y = 0; y < this.m_numCrossline; ++y) {
                        if (this.Valid[x][y]) continue;
                        bad = true;
                        int minX = Math.max(0, x - 6);
                        int maxX = Math.min(this.m_numInline - 1, x + 6);
                        int minY = Math.max(0, y - 6);
                        int maxY = Math.min(this.m_numCrossline - 1, y + 6);
                        int num = 0;
                        float sumWeight = 1.0E-40f;
                        float sumAlpha = 0.0f;
                        float sumBeta = 0.0f;
                        for (int ix = minX; ix <= maxX; ++ix) {
                            for (int iy = minY; iy <= maxY; ++iy) {
                                if (!this.Valid[ix][iy]) continue;
                                ++num;
                                double dist = Math.abs(ix - x) + Math.abs(iy - y);
                                double w = (double)this.Weight[ix][iy] / (1.0 + dist);
                                sumWeight += (float)w;
                                sumAlpha += (float)w * this.Alpha[ix][iy];
                                sumBeta += (float)w * this.Beta[ix][iy];
                            }
                        }
                        if (num <= 0) continue;
                        this.Valid[x][y] = true;
                        this.Weight[x][y] = 0.01f;
                        this.Alpha[x][y] = sumAlpha / sumWeight;
                        this.Beta[x][y] = sumBeta / sumWeight;
                    }
                }
            }
            if (applyDespiking) {
                this.despike(this.Alpha, this.Weight, despikePercentLimit, despikePercentLimit);
                this.despike(this.Beta, this.Weight, despikePercentLimit, despikePercentLimit);
            }
            for (x = 0; x < this.m_numInline; ++x) {
                for (y = 0; y < this.m_numCrossline; ++y) {
                    int rad = 3;
                    int minX = Math.max(0, x - rad);
                    int maxX = Math.min(this.m_numInline - 1, x + rad);
                    int minY = Math.max(0, y - rad);
                    int maxY = Math.min(this.m_numCrossline - 1, y + rad);
                    int num = 0;
                    float sumWeight = 1.0E-40f;
                    float sumAlpha = 0.0f;
                    float sumBeta = 0.0f;
                    for (int ix = minX; ix <= maxX; ++ix) {
                        for (int iy = minY; iy <= maxY; ++iy) {
                            ++num;
                            double dist = Math.abs(ix - x) + Math.abs(iy - y);
                            double w = 1.0 / (1.0 + dist);
                            sumWeight += (float)w;
                            sumAlpha += (float)w * this.Alpha[ix][iy];
                            sumBeta += (float)w * this.Beta[ix][iy];
                        }
                    }
                    this.SumU[x][y] = sumAlpha / sumWeight;
                    this.SumV[x][y] = sumBeta / sumWeight;
                }
            }
            for (x = 0; x < this.m_numInline; ++x) {
                for (y = 0; y < this.m_numCrossline; ++y) {
                    this.Alpha[x][y] = this.SumU[x][y];
                    this.Beta[x][y] = this.SumV[x][y];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public int numInline() {
        return this.m_numInline;
    }

    @Override
    public int numCrossline() {
        return this.m_numCrossline;
    }

    public int getInlineFromIndex(int index) {
        return this.m_minInline + index * this.m_inlineIncrement;
    }

    public int getCrosslineFromIndex(int index) {
        return this.m_minCrossline + index * this.m_crosslineIncrement;
    }

    public double getWorldX_Indices(int indexInline, int indexCrossline) {
        double inlineNumber = this.getInlineFromIndex(indexInline);
        double crosslineNumber = this.getCrosslineFromIndex(indexCrossline);
        return this.getWorldX(inlineNumber, crosslineNumber);
    }

    public double getWorldY_Indices(int indexInline, int indexCrossline) {
        double inlineNumber = this.getInlineFromIndex(indexInline);
        double crosslineNumber = this.getCrosslineFromIndex(indexCrossline);
        return this.getWorldY(inlineNumber, crosslineNumber);
    }

    public float[][] data() {
        return this.m_data;
    }

    public void dumpInfo() {
        try {
            double inlineDist = (double)this.m_numInline * this.m_inlineBinSize;
            double crosslineDist = (double)this.m_numCrossline * this.m_crosslineBinSize;
            double area = inlineDist * crosslineDist;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String s = p.units_feet() ? Double.toString(area / 2.78784E7) + " square miles" : Double.toString(area / 1000000.0) + " square km";
            System.out.println("Grid3D dumpInfo   " + s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void read(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (1000923 != magic) {
                throw new Exception("1000923 != magic");
            }
            int version = file.readInt();
            if (version == 1000) {
                this.m_inlineAtOrigin = file.readInt();
                this.m_crosslineAtOrigin = file.readInt();
                this.m_inlineIncrement = file.readInt();
                this.m_crosslineIncrement = file.readInt();
                this.m_worldCoordAtOriginX = file.readDouble();
                this.m_worldCoordAtOriginY = file.readDouble();
                this.m_inlineBinSize = file.readDouble();
                this.m_crosslineBinSize = file.readDouble();
                this.m_inlineAngle = file.readDouble();
                this.m_maxInline = file.readInt();
                this.m_minInline = file.readInt();
                this.m_numInline = file.readInt();
                this.m_maxCrossline = file.readInt();
                this.m_minCrossline = file.readInt();
                this.m_numCrossline = file.readInt();
                this.m_data = new float[this.m_numInline][this.m_numCrossline];
                this.m_distanceWeight = new float[this.m_numCrossline + this.m_numInline + 10];
                int numBytes = 4 * this.m_numInline * this.m_numCrossline;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                buff.rewind();
                file.read(buff.array(), 0, numBytes);
                buff.rewind();
                for (int x = 0; x < this.m_numInline; ++x) {
                    for (int y = 0; y < this.m_numCrossline; ++y) {
                        this.m_data[x][y] = buff.getFloat();
                    }
                }
            } else {
                throw new Exception("bad version");
            }
            this.computeInternals(false);
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void save(String fileName) {
        try {
            this.save(fileName, this.m_data);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName, float[][] array) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 1000923;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_inlineAtOrigin);
                file.writeInt(this.m_crosslineAtOrigin);
                file.writeInt(this.m_inlineIncrement);
                file.writeInt(this.m_crosslineIncrement);
                file.writeDouble(this.m_worldCoordAtOriginX);
                file.writeDouble(this.m_worldCoordAtOriginY);
                file.writeDouble(this.m_inlineBinSize);
                file.writeDouble(this.m_crosslineBinSize);
                file.writeDouble(this.m_inlineAngle);
                file.writeInt(this.m_maxInline);
                file.writeInt(this.m_minInline);
                file.writeInt(this.m_numInline);
                file.writeInt(this.m_maxCrossline);
                file.writeInt(this.m_minCrossline);
                file.writeInt(this.m_numCrossline);
                int numBytes = 4 * this.m_numInline * this.m_numCrossline;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                buff.rewind();
                for (int x = 0; x < this.m_numInline; ++x) {
                    for (int y = 0; y < this.m_numCrossline; ++y) {
                        buff.putFloat(array[x][y]);
                    }
                }
                buff.rewind();
                file.write(buff.array(), 0, numBytes);
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void allocateGrid() throws Exception {
        try {
            if (this.m_maxCrossline < this.m_minCrossline) {
                throw new Exception("CrosslineMax < CrosslineMin");
            }
            if (this.m_maxInline < this.m_minInline) {
                throw new Exception("InlineMax < InlineMin");
            }
            this.m_numCrossline = 1 + (this.m_maxCrossline - this.m_minCrossline);
            this.m_numInline = 1 + (this.m_maxInline - this.m_minInline);
            this.m_data = new float[this.m_numInline][this.m_numCrossline];
            int maxLen = 10 + this.m_numInline + this.m_numCrossline;
            this.m_distanceWeight = new float[maxLen];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int ix;
            if (this.m_numCrossline < 1 || this.m_numInline < 1) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (this.m_data == null) {
                return;
            }
            double cornerInline = (double)this.m_minInline - 0.5 * (double)this.m_inlineIncrement;
            double cornerCrossline = (double)this.m_minCrossline - 0.5 * (double)this.m_crosslineIncrement;
            double cornerX = this.getWorldX(cornerInline, cornerCrossline);
            double cornerY = this.getWorldY(cornerInline, cornerCrossline);
            double inlineDeltaX = this.m_cosineInlineAngle * this.m_inlineBinSize;
            double inlineDeltaY = this.m_sineInlineAngle * this.m_inlineBinSize;
            double crosslineDeltaX = -this.m_sineInlineAngle * this.m_crosslineBinSize;
            double crosslineDeltaY = this.m_cosineInlineAngle * this.m_crosslineBinSize;
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            boolean vok = false;
            if (this.DataValid != null) {
                vok = this.DataValid.length == this.m_data.length;
                vok = vok && this.DataValid[0].length == this.m_data[0].length;
            }
            int[] px = new int[4];
            int[] py = new int[4];
            if (this.DrawColor) {
                for (ix = 0; ix < this.m_numInline; ++ix) {
                    for (int iy = 0; iy < this.m_numCrossline; ++iy) {
                        boolean ok = true;
                        if (vok) {
                            ok = this.DataValid[ix][iy];
                        }
                        if (!ok || !colorWrapper.valueOK(this.m_data[ix][iy])) continue;
                        g2d.setColor(colorWrapper.colorUsingValue(this.m_data[ix][iy]));
                        double x1 = cornerX + (double)ix * inlineDeltaX + (double)iy * crosslineDeltaX;
                        double y1 = cornerY + (double)ix * inlineDeltaY + (double)iy * crosslineDeltaY;
                        px[0] = (int)(scaleX * x1 + shiftX);
                        py[0] = (int)(scaleY * y1 + shiftY);
                        px[1] = (int)(scaleX * (x1 + inlineDeltaX) + shiftX);
                        py[1] = (int)(scaleY * (y1 + inlineDeltaY) + shiftY);
                        px[2] = (int)(scaleX * (x1 + inlineDeltaX + crosslineDeltaX) + shiftX);
                        py[2] = (int)(scaleY * (y1 + inlineDeltaY + crosslineDeltaY) + shiftY);
                        px[3] = (int)(scaleX * (x1 + crosslineDeltaX) + shiftX);
                        py[3] = (int)(scaleY * (y1 + crosslineDeltaY) + shiftY);
                        g2d.fillPolygon(px, py, 4);
                    }
                }
            }
            if (this.DrawLines) {
                int iy2;
                int ix2;
                int iy1;
                int ix1;
                double y2;
                double x2;
                double y1;
                g2d.setColor(this.LineColor);
                for (ix = 0; ix <= this.m_numInline; ++ix) {
                    double x1 = cornerX + (double)ix * inlineDeltaX;
                    y1 = cornerY + (double)ix * inlineDeltaY;
                    x2 = x1 + (double)this.m_numCrossline * crosslineDeltaX;
                    y2 = y1 + (double)this.m_numCrossline * crosslineDeltaY;
                    ix1 = (int)(scaleX * x1 + shiftX);
                    iy1 = (int)(scaleY * y1 + shiftY);
                    ix2 = (int)(scaleX * x2 + shiftX);
                    iy2 = (int)(scaleY * y2 + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
                for (int iy = 0; iy <= this.m_numCrossline; ++iy) {
                    double x1 = cornerX + (double)iy * crosslineDeltaX;
                    y1 = cornerY + (double)iy * crosslineDeltaY;
                    x2 = x1 + (double)this.m_numInline * inlineDeltaX;
                    y2 = y1 + (double)this.m_numInline * inlineDeltaY;
                    ix1 = (int)(scaleX * x1 + shiftX);
                    iy1 = (int)(scaleY * y1 + shiftY);
                    ix2 = (int)(scaleX * x2 + shiftX);
                    iy2 = (int)(scaleY * y2 + shiftY);
                    g2d.drawLine(ix1, iy1, ix2, iy2);
                }
            }
            this.ImageDirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (this.m_numCrossline < 1 || this.m_numInline < 1) {
                return;
            }
            if (this.m_data == null) {
                return;
            }
            rangeX.expandRange(this.getWorldX_Indices(-1, -1));
            rangeY.expandRange(this.getWorldY_Indices(-1, -1));
            rangeX.expandRange(this.getWorldX_Indices(-1, this.m_numCrossline));
            rangeY.expandRange(this.getWorldY_Indices(-1, this.m_numCrossline));
            rangeX.expandRange(this.getWorldX_Indices(this.m_numInline, -1));
            rangeY.expandRange(this.getWorldY_Indices(this.m_numInline, -1));
            rangeX.expandRange(this.getWorldX_Indices(this.m_numInline, this.m_numCrossline));
            rangeY.expandRange(this.getWorldY_Indices(this.m_numInline, this.m_numCrossline));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.ArrayDirty && this.ArrayMin <= this.ArrayMax) {
                rangeC.expandRange(this.ArrayMin);
                rangeC.expandRange(this.ArrayMax);
                return;
            }
            this.ArrayDirty = true;
            if (this.m_data == null) {
                return;
            }
            boolean vok = false;
            if (this.DataValid != null) {
                vok = this.DataValid.length == this.m_data.length;
                vok = vok && this.DataValid[0].length == this.m_data[0].length;
            }
            this.ArrayMin = 1.0E20f;
            this.ArrayMax = -1.0E20f;
            for (int x = 0; x < this.m_numInline; ++x) {
                for (int y = 0; y < this.m_numCrossline; ++y) {
                    boolean ok = true;
                    if (vok) {
                        ok = this.DataValid[x][y];
                    }
                    if (!ok) continue;
                    this.ArrayMin = Math.min(this.ArrayMin, this.m_data[x][y]);
                    this.ArrayMax = Math.max(this.ArrayMax, this.m_data[x][y]);
                }
            }
            if (this.ArrayMin <= this.ArrayMax) {
                this.ArrayDirty = false;
                rangeC.expandRange(this.ArrayMin);
                rangeC.expandRange(this.ArrayMax);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getSmearRadius() {
        return this.SmearRadius;
    }

    public void mergeLinearFit(Map<Long, Grid3D_InterpolationElement> elementMap) throws Exception {
        try {
            Set<Long> keys = elementMap.keySet();
            for (Long key : keys) {
                Grid3D_InterpolationElement element = elementMap.get(key);
                int x = Grid3D_InterpolationElement.getBinX(key);
                int y = Grid3D_InterpolationElement.getBinY(key);
                if (x < 0 || x >= this.m_numInline || y < 0 || y >= this.m_numCrossline) continue;
                this.Valid[x][y] = true;
                float[] fArray = this.Count[x];
                int n = y;
                fArray[n] = fArray[n] + (float)element.Count;
                float[] fArray2 = this.SumW[x];
                int n2 = y;
                fArray2[n2] = fArray2[n2] + element.SumW;
                float[] fArray3 = this.SumU[x];
                int n3 = y;
                fArray3[n3] = fArray3[n3] + element.SumU;
                float[] fArray4 = this.SumUU[x];
                int n4 = y;
                fArray4[n4] = fArray4[n4] + element.SumUU;
                float[] fArray5 = this.SumUV[x];
                int n5 = y;
                fArray5[n5] = fArray5[n5] + element.SumUV;
                float[] fArray6 = this.SumV[x];
                int n6 = y;
                fArray6[n6] = fArray6[n6] + element.SumV;
                this.MaxCount = Math.max(this.MaxCount, (int)this.Count[x][y]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void deallocate() {
        try {
            this.m_data = null;
            this.m_distanceWeight = null;
            this.InterpSum = null;
            this.InterpWeight = null;
            this.InterpValid = null;
            this.InterpCoarseSum = null;
            this.InterpCoarseValue = null;
            this.InterpCoarseWeight = null;
            this.InterpCoarseValid = null;
            this.Count = null;
            this.SumW = null;
            this.SumU = null;
            this.SumUU = null;
            this.SumUV = null;
            this.SumV = null;
            this.Weight = null;
            this.Valid = null;
            this.Alpha = null;
            this.Beta = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getInline(double x, double y) throws Exception {
        try {
            this.setWorldLocation(x, y);
            return this.Inline;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int getCrossline(double x, double y) throws Exception {
        try {
            this.setWorldLocation(x, y);
            return this.Crossline;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

