/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Filter;

import com.PecosLibrary.Math.Filter.FilterResponse_Abstract;

public class FilterResponse_ButterworthLowPass
extends FilterResponse_Abstract {
    protected float m_corner = 35.0f;
    protected int m_poleCount = 4;

    public void setCorner(float c) {
        float diff = Math.abs(c - this.m_corner);
        if (diff < 0.01f) {
            return;
        }
        this.m_corner = c;
        this.m_corner = Math.max(1.0E-5f, this.m_corner);
        this.m_modified = true;
    }

    public void setPoleCount(int poleCount) {
        if (poleCount == this.m_poleCount) {
            return;
        }
        this.m_poleCount = poleCount;
        this.m_poleCount = Math.max(1, this.m_poleCount);
        this.m_modified = true;
    }

    @Override
    public float response(float frequency) {
        float temp = frequency / this.m_corner;
        float temp1 = (float)Math.pow(temp, 2.0 * (double)this.m_poleCount);
        float temp2 = (float)Math.sqrt(1.0 / (1.0 + (double)temp1));
        return temp2;
    }
}

