/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.IWorkerMonitor;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobWorkerThread;
import com.PecosLibrary.Job.Worker_Base;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JobManagerWorkerMonitor
implements IWorkerMonitor {
    List<JobWorkerThread> _registeredThreads;

    public JobManagerWorkerMonitor() {
        try {
            this._registeredThreads = Collections.synchronizedList(new ArrayList());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkerThread(JobWorkerThread thread) {
        try {
            List<JobWorkerThread> list = this._registeredThreads;
            synchronized (list) {
                this._registeredThreads.add(thread);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkerThread(JobWorkerThread thread) {
        try {
            List<JobWorkerThread> list = this._registeredThreads;
            synchronized (list) {
                this._registeredThreads.remove(thread);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobWorkerThread findWorkerThreadFromJobID(String sJobID) {
        try {
            List<JobWorkerThread> list = this._registeredThreads;
            synchronized (list) {
                for (JobWorkerThread tmpThread : this._registeredThreads) {
                    JobState jobState;
                    if (tmpThread == null || (jobState = tmpThread.getJobState()) == null || !jobState.getJobID().equals(sJobID)) continue;
                    return tmpThread;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobWorkerThread findWorkerThread(Worker_Base worker) {
        JobWorkerThread thread = null;
        try {
            List<JobWorkerThread> list = this._registeredThreads;
            synchronized (list) {
                for (JobWorkerThread tmpThread : this._registeredThreads) {
                    if (tmpThread == null || tmpThread.getWorker() != worker) continue;
                    thread = tmpThread;
                    break;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return thread;
    }

    @Override
    public void setPercentDone(Object sender, double percent, String sMessage) throws InterruptedException {
    }

    @Override
    public void setPercentDone(Object sender, double percent) throws InterruptedException {
    }

    @Override
    public void addMessageLevel1(Object sender, String message) throws InterruptedException {
    }

    @Override
    public void addMemoryAtTimeEntry(Object sender) throws InterruptedException {
    }
}

