/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobTableModel;
import com.PecosLibrary.Job.KillButtonEditor;
import com.PecosLibrary.Job.KillButtonRenderer;
import com.PecosLibrary.Job.Worker_TestA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JobManagerPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener {
    JButton _btnAddTestJob;
    JButton _btnRefreshTable;
    LinearLayoutWidget _topWidget;
    JTable _table;
    JobTableModel _jobTableModel;

    public JobManagerPanel() {
        try {
            this.setLayout(new BorderLayout());
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._btnAddTestJob = this._topWidget.createButton("Launch Test Job", this, 1);
            this._btnRefreshTable = this._topWidget.createButton("Refresh Table", this, 1);
            this.add((Component)this._topWidget, "North");
            this._jobTableModel = new JobTableModel();
            this._table = new JTable(this._jobTableModel);
            this._table.setSelectionMode(1);
            this._table.getSelectionModel().addListSelectionListener(this);
            this._table.addKeyListener(this);
            this._table.getColumn("Kill Job").setCellRenderer(new KillButtonRenderer());
            this._table.getColumn("Kill Job").setCellEditor(new KillButtonEditor(new JCheckBox()));
            JScrollPane scroll = new JScrollPane(this._table);
            this.add((Component)scroll, "Center");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void refreshTable() {
        try {
            this._jobTableModel.updateData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnAddTestJob) {
                boolean bRunInExe = true;
                Worker_TestA worker = new Worker_TestA();
                Worker_TestA.prepareScratchDirectory(worker);
            }
            if (e.getSource() == this._btnRefreshTable) {
                JobManager.singleton().getFileMonitor().reset();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getSource() != this._table) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            int iKeyCode = e.getKeyCode();
            if (iKeyCode == 127) {
                int[] selectedRows = this._table.getSelectedRows();
                this._jobTableModel.deleteSelectedRows(selectedRows);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

