/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.JDBC.DerbyDatabaseConnection;
import com.PecosLibrary.JDBC.DerbyMemoryConnection;
import com.PecosLibrary.JDBC.H2DatabaseConnection;
import com.PecosLibrary.JDBC.HyperDatabaseConnection;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.SqliteDatabaseConnection;
import java.util.ArrayList;

public class Tools_JDBC {
    public static IDatabaseConnection getConnection(String driver, boolean memory, String databasePath) {
        try {
            if (driver.equalsIgnoreCase("SQLITE")) {
                return new SqliteDatabaseConnection(memory, databasePath);
            }
            if (driver.equalsIgnoreCase("HSQLDB")) {
                return new HyperDatabaseConnection(memory, databasePath);
            }
            if (driver.equalsIgnoreCase("HSQLDB")) {
                return new HyperDatabaseConnection(memory, databasePath);
            }
            if (driver.equalsIgnoreCase("H2")) {
                return new H2DatabaseConnection(memory, databasePath);
            }
            if (driver.equalsIgnoreCase("Derby")) {
                if (memory) {
                    return new DerbyMemoryConnection(databasePath);
                }
                return new DerbyDatabaseConnection(databasePath);
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static IDatabaseConnection getConnection(boolean memory, String databasePath) {
        try {
            String driver = SharedApplicationData.singleton().databaseDriver();
            return Tools_JDBC.getConnection(driver, memory, databasePath);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static void convert_hsqldb_to_csv(String hsqldb_path, String path_csv, boolean overwrite) {
        try {
            HyperDatabaseConnection conn1 = new HyperDatabaseConnection(false, hsqldb_path);
            String prefix = "SELECT LINENUMBER,POINTNUMBER,POINTINDEX,EASTING,NORTHING,ELEVATION";
            ArrayList<String> tables = conn1.getTableNames();
            for (String s : tables) {
                if (!s.equalsIgnoreCase("SHOT") && !s.equalsIgnoreCase("RECEIVER")) continue;
                String file = path_csv + "/" + s + ".csv";
                if (!overwrite && Tools_FileSystem.exists_file(file)) continue;
                Object sql = prefix;
                if (conn1.columnExists(s, "SHOTID")) {
                    sql = (String)sql + ",SHOTID";
                }
                if (conn1.columnExists(s, "RECEIVERID")) {
                    sql = (String)sql + ",RECEIVERID";
                }
                if (conn1.columnExists(s, "POLARITY")) {
                    sql = (String)sql + ",POLARITY";
                }
                if (conn1.columnExists(s, "UPHOLETIME")) {
                    sql = (String)sql + ",UPHOLETIME";
                }
                if (conn1.columnExists(s, "POINTDEPTH")) {
                    sql = (String)sql + ",POINTDEPTH";
                }
                if (conn1.columnExists(s, "WATERDEPTH")) {
                    sql = (String)sql + ",WATERDEPTH";
                }
                sql = (String)sql + " FROM " + s;
                try {
                    Table_Abstract tbl = conn1.extractTableDataUsingQuery(s, (String)sql, 1000000000);
                    System.out.println("convert_hsqldb_to_csv " + s + "  " + tbl.row_count());
                    tbl.exportCSV(file);
                }
                catch (Exception serr) {
                    serr.printStackTrace();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static String getColumnDefinitionString(String colName, DataType type) {
        try {
            int sqlType = Tools_JDBC.getJdbcTypeFromDataType(type);
            if (sqlType == -5) {
                return colName + " BIGINT DEFAULT -999999 ";
            }
            if (sqlType == 16) {
                return colName + " BOOLEAN DEFAULT FALSE ";
            }
            if (sqlType == 5) {
                return colName + " SMALLINT DEFAULT -9999 ";
            }
            if (sqlType == 4) {
                return colName + " INTEGER DEFAULT -999999 ";
            }
            if (sqlType == 12) {
                return colName + " VARCHAR(255) DEFAULT '' ";
            }
            if (sqlType == 8) {
                return colName + " DOUBLE DEFAULT -999999 ";
            }
            if (sqlType == 6) {
                return colName + " FLOAT DEFAULT -999999 ";
            }
            return colName + " INT DEFAULT -999999";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "INTEGER";
        }
    }

    public static String getColumnDefinitionString(int sqlType) {
        try {
            if (sqlType == -5) {
                return " BIGINT DEFAULT -999999 ";
            }
            if (sqlType == 16) {
                return " BOOLEAN DEFAULT FALSE ";
            }
            if (sqlType == 5) {
                return " SMALLINT DEFAULT -9999 ";
            }
            if (sqlType == 4) {
                return " INTEGER DEFAULT -999999 ";
            }
            if (sqlType == 12) {
                return " VARCHAR(255) DEFAULT '' ";
            }
            if (sqlType == 8) {
                return " DOUBLE DEFAULT -999999 ";
            }
            if (sqlType == 6) {
                return " FLOAT DEFAULT -999999 ";
            }
            return " INT DEFAULT -999999";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "INTEGER";
        }
    }

    public static int getJdbcTypeFromDataType(DataType type) throws Exception {
        if (type == DataType.Bool) {
            return 16;
        }
        if (type == DataType.Short) {
            return 5;
        }
        if (type == DataType.Int) {
            return 4;
        }
        if (type == DataType.Long) {
            return -5;
        }
        if (type == DataType.Float) {
            return 6;
        }
        if (type == DataType.Double) {
            return 8;
        }
        if (type == DataType.Text) {
            return 12;
        }
        throw new Exception("Unrecognized DataType Type");
    }

    public static DataType getDataTypeFromJdbcType(int jdbcType) throws Exception {
        if (jdbcType == -5) {
            return DataType.Int;
        }
        if (jdbcType == 16) {
            return DataType.Bool;
        }
        if (jdbcType == 8) {
            return DataType.Double;
        }
        if (jdbcType == 6) {
            return DataType.Float;
        }
        if (jdbcType == 7) {
            return DataType.Float;
        }
        if (jdbcType == 4) {
            return DataType.Int;
        }
        if (jdbcType == 5) {
            return DataType.Short;
        }
        if (jdbcType == 12) {
            return DataType.Text;
        }
        return DataType.Text;
    }
}

