/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Geometry.GeometryProject_Base;
import java.util.ArrayList;

public class GeometryProject_Pattern
extends GeometryProject_Base {
    public ArrayList<Shot> ShotList = new ArrayList();
    public HashMap_Integers<Receiver> ReceiverHash = new HashMap_Integers();
    public ArrayList<Receiver> ReceiverList = new ArrayList();
    public int MinPeg;
    public int MaxPeg;

    public boolean createShots(Table_Abstract table) {
        try {
            this.ShotList.clear();
            int indexFFID = table.column_indexOfColumn("FFID");
            int indexShotPeg = table.column_indexOfColumn("ShotPeg");
            int indexSkidI = table.column_indexOfColumn("SkidI");
            int indexSkidC = table.column_indexOfColumn("SkidC");
            int indexDepth = table.column_indexOfColumn("Depth");
            int indexCh1 = table.column_indexOfColumn("Ch1");
            int indexCh2 = table.column_indexOfColumn("Ch2");
            int indexCh3 = table.column_indexOfColumn("Ch3");
            int indexCh4 = table.column_indexOfColumn("Ch4");
            int indexPeg1 = table.column_indexOfColumn("Peg1");
            int indexPeg2 = table.column_indexOfColumn("Peg2");
            int indexPeg3 = table.column_indexOfColumn("Peg3");
            int indexPeg4 = table.column_indexOfColumn("Peg4");
            Shot currentShot = new Shot();
            for (int n = 0; n < table.row_count(); ++n) {
                int nextShotPeg = table.getInt(n, indexShotPeg);
                int peg1 = table.getInt(n, indexPeg1);
                int peg2 = table.getInt(n, indexPeg2);
                int peg3 = table.getInt(n, indexPeg3);
                int peg4 = table.getInt(n, indexPeg4);
                int ch1 = table.getInt(n, indexCh1);
                int ch2 = table.getInt(n, indexCh2);
                int ch3 = table.getInt(n, indexCh3);
                int ch4 = table.getInt(n, indexCh4);
                if (nextShotPeg < 1) {
                    if (currentShot.ShotPeg <= 0) continue;
                    currentShot.addPattern(ch1, ch2, peg1, peg2);
                    currentShot.addPattern(ch3, ch4, peg3, peg4);
                    continue;
                }
                currentShot = new Shot();
                currentShot.ShotPeg = nextShotPeg;
                currentShot.addPattern(ch1, ch2, peg1, peg2);
                currentShot.addPattern(ch3, ch4, peg3, peg4);
                currentShot.Depth = this.getValid(table.getDouble(n, indexDepth), 0.0);
                currentShot.SkidI = this.getValid(table.getDouble(n, indexSkidI), 0.0);
                currentShot.SkidC = this.getValid(table.getDouble(n, indexSkidC), 0.0);
                currentShot.FFID = table.getInt(n, indexFFID);
                this.ShotList.add(currentShot);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected double getValid(double v, double ok) {
        if (Math.abs(v) < 99999.0) {
            return v;
        }
        return ok;
    }

    public boolean createReceivers(Table_Abstract table) {
        try {
            this.ReceiverList.clear();
            this.ReceiverHash.clear();
            this.MinPeg = Integer.MAX_VALUE;
            this.MaxPeg = Integer.MIN_VALUE;
            int indexPeg = table.column_indexOfColumn("Peg");
            int indexDistance = table.column_indexOfColumn("Distance");
            int indexElevation = table.column_indexOfColumn("Elevation");
            int indexEasting = table.column_indexOfColumn("Easting");
            int indexNorthing = table.column_indexOfColumn("Northing");
            int indexIncrement = table.column_indexOfColumn("Increment");
            for (int n = 0; n < table.row_count(); ++n) {
                Receiver r = new Receiver();
                r.TableRow = n;
                r.Peg = table.getInt(n, indexPeg);
                r.Distance = table.getInt(n, indexDistance);
                r.Elevation = table.getInt(n, indexElevation);
                r.Easting = table.getInt(n, indexEasting);
                r.Northing = table.getInt(n, indexNorthing);
                r.Increment = table.getInt(n, indexIncrement);
                this.ReceiverHash.put(r, r.Peg);
                this.MinPeg = Math.min(this.MinPeg, r.Peg);
                this.MaxPeg = Math.max(this.MaxPeg, r.Peg);
            }
            for (int p = this.MinPeg; p <= this.MaxPeg; ++p) {
                if (!this.ReceiverHash.containsKey(p)) continue;
                this.ReceiverList.add(this.ReceiverHash.get(p));
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void clearAll() {
        try {
            this.ReceiverList.clear();
            this.ReceiverHash.clear();
            this.ShotList.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public GeometryProject_Pattern(String projectName) throws Exception {
        try {
            this.m_projectName = projectName;
            String path = SharedApplicationData.geometryProjectPath();
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(path, this.m_projectName);
            this.m_parameterTreeFileName = this.m_projectPath + "/ProjectDescription.xml";
            this.m_parameterTree.read(this.m_parameterTreeFileName);
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public class Shot {
        public int TableRow = -9999;
        public int FFID = -9999;
        public int ShotPeg = -9999;
        public double SkidI = 0.0;
        public double SkidC = 0.0;
        public double Depth = 0.0;
        public double Easting = 0.0;
        public double Northing = 0.0;
        public double Elevation = 0.0;
        public ArrayList<Pattern> PatternList = new ArrayList();

        public boolean addPattern(int ch1, int ch2, int peg1, int peg2) {
            if (ch1 < 0 || ch2 < 0 || peg1 < 0 || peg2 < 0) {
                return false;
            }
            Pattern p = new Pattern(ch1, ch2, peg1, peg2);
            if (p.Valid) {
                this.PatternList.add(p);
                return true;
            }
            return false;
        }
    }

    public class Receiver {
        public int TableRow = -9999;
        public int Peg = -9999;
        public double Distance = 0.0;
        public double Elevation = 0.0;
        public double Easting = 0.0;
        public double Northing = 0.0;
        public double Increment = 0.0;
    }

    public class Pattern {
        public boolean Valid = false;
        public int ChanFrom;
        public int ChanTo;
        public int PegFrom;
        public int PegTo;

        public Pattern(int ch1, int ch2, int peg1, int peg2) {
            this.ChanFrom = ch1;
            this.ChanTo = ch2;
            this.PegFrom = peg1;
            this.PegTo = peg2;
            this.Valid = this.ChanFrom < this.ChanTo && this.ChanTo - this.ChanFrom == this.PegTo - this.PegFrom;
        }
    }
}

