/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import java.util.HashMap;

public class GeometryProject_Base {
    public static String Shot = "Shot";
    public static String Receiver = "Receiver";
    public static String Relation = "Relation";
    public static String ColumnDefinitionSuffix = "_ColumnDefinition";
    public static String AsciiFileSuffix = "_AsciiFile";
    protected boolean m_valid = false;
    protected String m_projectName;
    protected String m_projectPath;
    protected String m_parameterTreeFileName;
    protected ParameterTree m_parameterTree = new ParameterTree();
    public HashMap<String, Table_Abstract> TableHash = new HashMap();
    protected HashMap<String, AsciiImportData> m_dataHash = new HashMap();

    public boolean valid() {
        return this.m_valid;
    }

    public String projectName() {
        return this.m_projectName;
    }

    public String projectPath() {
        return this.m_projectPath;
    }

    public ParameterTree parameterTree() {
        return this.m_parameterTree;
    }

    public void saveParameters() {
        this.m_parameterTree.save(this.m_parameterTreeFileName);
    }

    public void setAsciiFileName(String key, String fileName) {
        try {
            key = (String)key + AsciiFileSuffix;
            this.m_parameterTree.string_put((String)key, fileName);
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String asciiFileName(String key) {
        try {
            key = (String)key + AsciiFileSuffix;
            return this.m_parameterTree.string_get((String)key, "Error");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    public void setColumnDefinitionFileName(String key, String fileName) {
        try {
            key = (String)key + ColumnDefinitionSuffix;
            this.m_parameterTree.string_put((String)key, fileName);
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String columnDefinitionFileName(String key) {
        try {
            String key2 = key + ColumnDefinitionSuffix;
            if (!this.m_parameterTree.string_exists(key2)) {
                String fileName = this.m_projectPath + "/" + key + "ColumnDef.xml";
                this.m_parameterTree.string_put(key2, fileName);
            }
            return this.m_parameterTree.string_get(key2, "Error");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "Error";
        }
    }

    public AsciiImportData asciiImportData(String key) {
        try {
            if (!this.m_dataHash.containsKey(key)) {
                AsciiImportData data = new AsciiImportData();
                String fileName = this.columnDefinitionFileName(key);
                if (Tools_FileSystem.exists_file(fileName)) {
                    data.read(fileName);
                }
                data.UseDataType = false;
                this.m_dataHash.put(key, data);
            }
            return this.m_dataHash.get(key);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveColumnDefinitions() {
        try {
            for (String name : this.m_dataHash.keySet()) {
                this.asciiImportData(name).save(this.columnDefinitionFileName(name));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

