/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.TimeShift;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.TableColumnSelectorWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EnsembleWorker_HeaderShift
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected JTabbedPane m_tabs;
    protected ArrayList<TableColumnSelectorWidget> m_comboList;
    protected ArrayList<JCheckBox> m_checkList;
    protected ArrayList<JTextField> m_textList;
    protected ArrayList<String> m_tableKeyList = new ArrayList();
    protected ArrayList<String> m_columnKeyList = new ArrayList();
    protected ArrayList<String> m_scalarKeyList = new ArrayList();
    protected ArrayList<String> m_onKeyList = new ArrayList();

    public EnsembleWorker_HeaderShift() {
        try {
            this.Abbreviation = "Header shift";
            this.ShortDescription = "Shift T0 using headers";
            this.WorkerType = "Shift T0";
            this.InteractiveFlowsOkay = true;
            for (int n = 0; n < 4; ++n) {
                this.m_tableKeyList.add("Table" + Integer.toString(n));
                this.m_columnKeyList.add("Column" + Integer.toString(n));
                this.m_scalarKeyList.add("Scalar" + Integer.toString(n));
                this.m_onKeyList.add("On" + Integer.toString(n));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_HeaderShift";
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadCombo();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            for (int n = 0; n < this.m_comboList.size(); ++n) {
                if (e.getSource() == this.m_checkList.get(n)) {
                    this.m_parameterTree.bool_put(this.m_onKeyList.get(n), this.m_checkList.get(n).isSelected());
                }
                if (e.getSource() != this.m_textList.get(n)) continue;
                this.m_parameterTree.double_put(this.m_scalarKeyList.get(n), Double.parseDouble(this.m_textList.get(n).getText()));
            }
            this.broadcast(this, "Modified");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_tabs == null) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            for (int n = 0; n < this.m_comboList.size(); ++n) {
                this.m_parameterTree.bool_put(this.m_onKeyList.get(n), this.m_checkList.get(n).isSelected());
                this.m_parameterTree.double_put(this.m_scalarKeyList.get(n), Double.parseDouble(this.m_textList.get(n).getText()));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_tabs == null) {
                this.m_tabs = new JTabbedPane();
                this.m_checkList = new ArrayList();
                this.m_textList = new ArrayList();
                this.m_comboList = new ArrayList();
                for (int n = 0; n < this.m_tableKeyList.size(); ++n) {
                    LinearLayoutWidget page = LinearLayoutWidget.vert(0, null);
                    this.m_tabs.addTab(String.format("Hdr %d", n + 1), page);
                    TableColumnSelectorWidget selWidget = new TableColumnSelectorWidget(null, 0, this.m_parameterTree, this, this.m_tableKeyList.get(n), this.m_columnKeyList.get(n), "Shot", "Elevation");
                    JCheckBox chk = new JCheckBox("On");
                    chk.addActionListener(this);
                    this.m_checkList.add(chk);
                    JTextField txt = new JTextField("1.0");
                    txt.addActionListener(this);
                    this.m_textList.add(txt);
                    this.m_comboList.add(selWidget);
                    selWidget.addSimple(2, new JLabel("Scalar:"), txt);
                    selWidget.addSimple(3, new JLabel(" "), chk);
                    page.addComponent(selWidget, 0);
                    double scalar = this.m_parameterTree.double_get(this.m_scalarKeyList.get(n), 1.0);
                    txt.setText(Double.toString(scalar));
                    boolean on = this.m_parameterTree.bool_get(this.m_onKeyList.get(n), false);
                    chk.setSelected(on);
                    page.addStretch(10);
                }
                this.reloadCombo();
                Tools_FontChanger.changeSizeOfFont(this.m_tabs, -2, null, true);
                Messenger.singleton().addListener(this);
            }
            return this.m_tabs;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void reloadCombo() {
    }

    @Override
    public boolean requiresTraceTableColumns() {
        try {
            for (int n = 0; n < this.m_tableKeyList.size(); ++n) {
                String table = this.m_parameterTree.string_get(this.m_tableKeyList.get(n), "Unused");
                boolean on = this.m_parameterTree.bool_get(this.m_onKeyList.get(n), false);
                if (!on || !table.equalsIgnoreCase("Trace")) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            int n;
            this.m_inputEnsemble = ensemble;
            if (this.m_tabs != null) {
                for (n = 0; n < this.m_scalarKeyList.size(); ++n) {
                    this.m_parameterTree.double_put(this.m_scalarKeyList.get(n), Double.parseDouble(this.m_textList.get(n).getText()));
                }
            }
            for (n = 0; n < this.m_tableKeyList.size(); ++n) {
                String table = this.m_parameterTree.string_get(this.m_tableKeyList.get(n), "Unused");
                String column = this.m_parameterTree.string_get(this.m_columnKeyList.get(n), "Unused");
                double scalar = this.m_parameterTree.double_get(this.m_scalarKeyList.get(n), 1.0);
                boolean on = this.m_parameterTree.bool_get(this.m_onKeyList.get(n), false);
                if (!on || !this.m_inputEnsemble.dictionary().containsEntry(table, column)) continue;
                int index = this.m_inputEnsemble.dictionary().getEntryIndex(table, column);
                for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                    double shift = scalar * trace.header().getDouble(index);
                    trace.data().addShiftToFirstSampleCoord((float)shift);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

