/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.TimeShift;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class EnsembleWorker_GeneralShtRecStackPick
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
Messenger.Listener,
IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;

    public EnsembleWorker_GeneralShtRecStackPick() {
        try {
            this.Abbreviation = "Apply general Shot/Receiver stack pick times";
            this.ShortDescription = "Apply general Shot/Receiver stack pick times";
            this.WorkerType = "Shift T0";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_GeneralShtRecStackPick";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.broadcast(this, "Modified");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean requiresTraceTableColumns() {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (!this.m_inputEnsemble.dictionary().containsEntry("Shot", "SharedPickTime")) {
                return;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Receiver", "SharedPickTime")) {
                return;
            }
            int indexShot = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "SharedPickTime");
            int indexRec = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "SharedPickTime");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                float shiftShot = trace.header().getFloat(indexShot);
                float shiftRec = trace.header().getFloat(indexRec);
                float shift = 0.0f;
                if (Math.abs(shiftRec) < 2000.0f) {
                    shift -= shiftRec;
                }
                if (Math.abs(shiftShot) < 2000.0f) {
                    shift -= shiftShot;
                }
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                data.addShiftToFirstSampleCoord(shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

