/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.TimeShift;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EnsembleWorker_ElevationStatics
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editorElevation;
    protected SliderWidget m_editorVelocity;
    protected JCheckBox m_chkShot;
    protected JCheckBox m_chkRec;
    protected JCheckBox m_chkZeroMean;
    protected JCheckBox m_chkOffsetCompensation;

    public EnsembleWorker_ElevationStatics() {
        try {
            this.Abbreviation = "ELSTAT";
            this.ShortDescription = "Elevation statics";
            this.WorkerType = "Shift T0";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ElevationStatics";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            double vel = this.m_editorVelocity.getDoubleValue();
            this.m_parameterTree.double_put("Velocity", vel);
            double elev = this.m_editorElevation.getDoubleValue();
            this.m_parameterTree.double_put("Elevation", elev);
            this.m_parameterTree.bool_put("ZeroMean", this.m_chkZeroMean.isSelected());
            this.m_parameterTree.bool_put("Shot", this.m_chkShot.isSelected());
            this.m_parameterTree.bool_put("Rec", this.m_chkRec.isSelected());
            this.m_parameterTree.bool_put("OffsetComp", this.m_chkOffsetCompensation.isSelected());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double elev = this.m_parameterTree.double_get("Elevation", 2000.0);
                double vel = this.m_parameterTree.double_get("Velocity", 5000.0);
                this.m_editorElevation = new SliderWidget(this, null, "Elevation", 0, elev, -1000.0, 20000.0);
                this.m_editorVelocity = new SliderWidget(this, null, "Velocity", 0, vel, 1000.0, 20000.0);
                this.m_editorElevation.setRangeLocked(false);
                this.m_editorVelocity.setRangeLocked(false);
                this.m_mainWidget.addComponent(this.m_editorElevation, 0);
                this.m_mainWidget.addComponent(this.m_editorVelocity, 0);
                this.m_chkZeroMean = new JCheckBox("Make shifts zero-mean");
                this.m_chkRec = new JCheckBox("Apply to receivers");
                this.m_chkShot = new JCheckBox("Apply to shots");
                this.m_chkOffsetCompensation = new JCheckBox("Offset compensation");
                this.m_chkZeroMean.addActionListener(this);
                this.m_chkRec.addActionListener(this);
                this.m_chkShot.addActionListener(this);
                this.m_chkOffsetCompensation.addActionListener(this);
                boolean zeroMean = this.m_parameterTree.bool_get("ZeroMean", true);
                boolean applyShot = this.m_parameterTree.bool_get("Shot", true);
                boolean applyRec = this.m_parameterTree.bool_get("Rec", true);
                this.m_chkZeroMean.setSelected(zeroMean);
                this.m_chkShot.setSelected(applyShot);
                this.m_chkRec.setSelected(applyRec);
                this.m_mainWidget.addComponent(this.m_chkShot, 0);
                this.m_mainWidget.addComponent(this.m_chkRec, 0);
                this.m_mainWidget.addComponent(this.m_chkZeroMean, 0);
                this.m_mainWidget.addComponent(this.m_chkOffsetCompensation, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.getAll(false);
            this.m_inputEnsemble = ensemble;
            double datum = this.m_parameterTree.double_get("Elevation", 2000.0);
            double vel = this.m_parameterTree.double_get("Velocity", 5000.0);
            boolean zeroMean = this.m_parameterTree.bool_get("ZeroMean", true);
            boolean applyShot = this.m_parameterTree.bool_get("Shot", true);
            boolean applyRec = this.m_parameterTree.bool_get("Rec", true);
            boolean offComp = this.m_parameterTree.bool_get("OffsetComp", false);
            int indexShotZ = -9999;
            int indexRecZ = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", "Elevation")) {
                indexShotZ = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Elevation");
            }
            if (this.m_inputEnsemble.dictionary().containsEntry("Receiver", "Elevation")) {
                indexRecZ = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Elevation");
            }
            int indexOffset = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            double average = 0.0;
            double count = 1.0E-40;
            double shiftSum = 0.0;
            for (int k = this.m_inputEnsemble.traceCount() - 1; k >= 0; --k) {
                double elevation;
                EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                double shift = 0.0;
                double totalShiftDistance = 0.0;
                if (applyRec && indexRecZ >= 0) {
                    elevation = trace.header().getDouble(indexRecZ);
                    shift += 1000.0 * (datum - elevation) / vel;
                    totalShiftDistance += elevation - datum;
                }
                if (applyShot && indexShotZ >= 0) {
                    elevation = trace.header().getDouble(indexShotZ);
                    shift += 1000.0 * (datum - elevation) / vel;
                    totalShiftDistance += elevation - datum;
                }
                double offset = trace.header().getDouble(indexOffset);
                if (offComp) {
                    trace.header().putDouble(indexOffset, offset - totalShiftDistance);
                }
                if (offComp && offset <= totalShiftDistance) {
                    this.m_inputEnsemble.removeTrace(k);
                    continue;
                }
                shiftSum += shift;
                count += 1.0;
            }
            average = zeroMean ? shiftSum / count : 0.0;
            int index = this.m_inputEnsemble.dictionary().addEntry("Trace", "ElevStatic", DataType.Double);
            for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                double elevation;
                EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                double shift = 0.0;
                if (applyRec && indexRecZ >= 0) {
                    elevation = trace.header().getDouble(indexRecZ);
                    shift += 1000.0 * (datum - elevation) / vel;
                }
                if (applyShot && indexShotZ >= 0) {
                    elevation = trace.header().getDouble(indexShotZ);
                    shift += 1000.0 * (datum - elevation) / vel;
                }
                trace.data().addShiftToFirstSampleCoord((float)(shift -= average));
                trace.header().putDouble(index, shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

