/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Stacks;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EnsembleWorker_BruteStack
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    protected ArrayList<DataInfo> m_dataList = new ArrayList();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JComboBox<String> m_numTracesCombo;
    protected JCheckBox m_applyNoiseWeight;
    protected JTextField m_textNoiseWindow;
    protected float[] m_tempTraceArray = new float[20];

    public EnsembleWorker_BruteStack() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "BRUTESTACK";
            this.ShortDescription = "Brute stack";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_BruteStack";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(0, null);
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                grid.createLabel("Number of stacked traces", row, 0);
                int numTraces = this.m_parameterTree.int_get("NumTraces", 7);
                int index = numTraces / 2 - 1;
                this.m_numTracesCombo = new JComboBox();
                for (int n = 1; n < 11; ++n) {
                    String s1 = String.format("%d total traces ( +/- %d traces)", 1 + 2 * n, n);
                    this.m_numTracesCombo.addItem(s1);
                }
                this.m_numTracesCombo.setSelectedIndex(index);
                this.m_numTracesCombo.addItemListener(this);
                grid.addComponent(this.m_numTracesCombo, row++, 1);
                this.m_applyNoiseWeight = new JCheckBox("Weight traces using noise measure");
                this.m_applyNoiseWeight.addActionListener(this);
                this.m_applyNoiseWeight.setSelected(this.m_parameterTree.bool_get("Noise", true));
                grid.addComponent(this.m_applyNoiseWeight, row++, 1);
                grid.createLabel("Noise window (ms)", row, 0);
                double scalar = this.m_parameterTree.double_get("NoiseWindow", 300.0);
                scalar = Math.max(50.0, scalar);
                scalar = Math.min(2000.0, scalar);
                this.m_textNoiseWindow = new JTextField(Double.toString(scalar));
                this.m_textNoiseWindow.addActionListener(this);
                grid.addComponent(this.m_textNoiseWindow, row++, 1);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            int numTraces = 3 + 2 * this.m_numTracesCombo.getSelectedIndex();
            this.m_parameterTree.int_put("NumTraces", numTraces);
            boolean applyNoise = this.m_applyNoiseWeight.isSelected();
            this.m_parameterTree.bool_put("Noise", applyNoise);
            double scalar = Tools_Widget.extractDouble(this.m_textNoiseWindow, 300.0, 50.0, 2000.0);
            this.m_parameterTree.double_put("NoiseWindow", scalar);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            EnsembleGroupManager egm = new EnsembleGroupManager();
            egm.setParentEnsemble(this.m_inputEnsemble);
            egm.prepareGroupsBasedOnInteger("Receiver", "LineNumber");
            for (int group = 0; group < egm.GroupList.size(); ++group) {
                Ensemble subEnsemble = egm.GroupList.get((int)group).GroupEnsemble;
                subEnsemble.sortInt(0, "Receiver", "PointNumber", "Receiver", "PointIndex");
                if (subEnsemble.traceCount() < 5) continue;
                this.prepDataList(subEnsemble);
                this.makeStacks(subEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    protected void makeStacks(Ensemble ensemble) {
        try {
            int numTraces = this.m_parameterTree.int_get("NumTraces", 3);
            int rad = numTraces / 2;
            rad = Math.max(1, rad);
            rad = Math.min(10, rad);
            float[] sum = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                DataInfo infoMain = this.m_dataList.get(n);
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                if (!infoMain.Interpolator.inputValid() || wrapper.length() <= 10) continue;
                if (sum.length != wrapper.length()) {
                    sum = new float[wrapper.length()];
                }
                for (int s = 0; s < sum.length; ++s) {
                    sum[s] = 0.0f;
                }
                float t0 = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                int numAdded = 0;
                for (int k = n - rad; k <= n + rad; ++k) {
                    if (k < 0 || k >= ensemble.traceCount()) continue;
                    DataInfo info = this.m_dataList.get(k);
                    if (!info.Valid || !info.Interpolator.inputValid()) continue;
                    ++numAdded;
                    float corrShift = 0.0f;
                    float outputTime = t0;
                    for (int s = 0; s < sum.length; ++s) {
                        float inputSample = info.Interpolator.interpolate(outputTime + corrShift);
                        sum[s] = sum[s] + inputSample;
                        outputTime += digi;
                    }
                }
                if (numAdded < 2) continue;
                float inv = 1.0f / (float)numAdded;
                for (int s = 0; s < sum.length; ++s) {
                    sum[s] = sum[s] * inv;
                }
                wrapper.insertArray(sum, sum.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepDataList(Ensemble ensemble) {
        try {
            boolean applyNoise = this.m_parameterTree.bool_get("Noise", false);
            double scalar = this.m_parameterTree.double_get("NoiseScalar", 0.03);
            scalar = Math.max(0.01, scalar);
            scalar = Math.min(1.0, scalar);
            double noiseWindow = this.m_parameterTree.double_get("NoiseWindow", 300.0);
            while (this.m_dataList.size() < ensemble.traceCount()) {
                this.m_dataList.add(new DataInfo());
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                DataInfo info = this.m_dataList.get(n);
                FloatArrayWrapper wrapper = trace.data();
                info.Valid = false;
                info.Digi = wrapper.getSampleInterval();
                info.Time0 = wrapper.getFirstSampleCoord_WithShifts();
                info.NoiseLevel = 1.0f;
                info.NoiseWeight = 1.0f;
                info.SpikeWeight = 1.0f;
                info.TotalWeight = 1.0f;
                if (wrapper.length() <= 10 || !trace.traceOkay()) continue;
                info.Valid = true;
                if (this.m_tempTraceArray.length <= wrapper.length()) {
                    this.m_tempTraceArray = new float[100 + wrapper.length()];
                }
                wrapper.copyToArray(this.m_tempTraceArray);
                if (applyNoise) {
                    int window = (int)(noiseWindow / (double)info.Digi);
                    float noise = wrapper.noise(window);
                    float w = 1.0f / (0.1f + noise);
                    info.NoiseWeight = w * w;
                    info.TotalWeight *= info.NoiseWeight;
                }
                for (int s = 0; s < this.m_tempTraceArray.length; ++s) {
                    this.m_tempTraceArray[s] = this.m_tempTraceArray[s] * info.TotalWeight;
                }
                info.Interpolator.prepareInput(this.m_tempTraceArray, info.Time0, info.Digi);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    protected class DataInfo {
        public boolean Valid = false;
        public float Digi;
        public float Time0;
        public float NoiseLevel;
        public float NoiseWeight;
        public float SpikeWeight = 1.0f;
        public float TotalWeight = 1.0f;
        public CubicTraceInterpolator Interpolator = new CubicTraceInterpolator();

        protected DataInfo() {
        }
    }
}

