/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Selectors;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EnsembleWorker_PolygonSelector
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JCheckBox m_chkShot;
    protected JCheckBox m_chkRec;
    protected JCheckBox m_chkCMP;

    public EnsembleWorker_PolygonSelector() {
        try {
            this.Abbreviation = "TSPP";
            this.ShortDescription = "Trace selector: project polygon";
            this.WorkerType = "Trace selection";
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PolygonSelector";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.bool_put("Shot", this.m_chkShot.isSelected());
            this.m_parameterTree.bool_put("Receiver", this.m_chkRec.isSelected());
            this.m_parameterTree.bool_put("CMP", this.m_chkCMP.isSelected());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_chkShot = new JCheckBox("The shot must be inside project polygon");
                this.m_chkRec = new JCheckBox("The receiver must be inside project polygon");
                this.m_chkCMP = new JCheckBox("The midpoint must be inside project polygon");
                this.m_chkShot.addActionListener(this);
                this.m_chkRec.addActionListener(this);
                this.m_chkCMP.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_chkShot, 0);
                this.m_mainWidget.addComponent(this.m_chkRec, 0);
                this.m_mainWidget.addComponent(this.m_chkCMP, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            boolean shot = this.m_parameterTree.bool_get("Shot", false);
            boolean rec = this.m_parameterTree.bool_get("Receiver", false);
            boolean cmp = this.m_parameterTree.bool_get("CMP", false);
            Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
            if (poly == null) {
                return;
            }
            int indexSX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexSY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = this.m_inputEnsemble.traceCount() - 1; n >= 0; --n) {
                double sx = this.m_inputEnsemble.trace(n).header().getDouble(indexSX);
                double sy = this.m_inputEnsemble.trace(n).header().getDouble(indexSY);
                double rx = this.m_inputEnsemble.trace(n).header().getDouble(indexRX);
                double ry = this.m_inputEnsemble.trace(n).header().getDouble(indexRY);
                double mx = 0.5 * (sx + rx);
                double my = 0.5 * (sy + ry);
                boolean shotInside = poly.contains(sx, sy);
                boolean recInside = poly.contains(rx, ry);
                boolean midInside = poly.contains(mx, my);
                boolean ok = true;
                if (shot) {
                    boolean bl = ok = ok && shotInside;
                }
                if (rec) {
                    boolean bl = ok = ok && recInside;
                }
                if (cmp) {
                    boolean bl = ok = ok && midInside;
                }
                if (ok) continue;
                this.m_inputEnsemble.removeTrace(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

