/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.QC;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EnsembleWorker_KillDC
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JCheckBox m_killCheck;
    protected JTextField m_killWindowText;
    protected Tools_Ensemble m_tools = new Tools_Ensemble();

    public EnsembleWorker_KillDC() {
        try {
            this.Abbreviation = "DCKILL";
            this.ShortDescription = "DC measurement";
            this.WorkerType = "Trace noise measurement";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_KillDC";
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Window", Tools_Widget.extractDouble(this.m_killWindowText, 150.0, 50.0, 1.0E9));
            this.m_parameterTree.bool_put("Kill", this.m_killCheck.isSelected());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                boolean kill = this.m_parameterTree.bool_get("Kill", true);
                this.m_killCheck = new JCheckBox("Kill DC traces");
                this.m_killCheck.setSelected(kill);
                this.m_killCheck.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_killCheck, 0);
                double window = this.m_parameterTree.double_get("Window", 150.0);
                this.m_killWindowText = this.m_mainWidget.createSubTextField("Max DC length (ms)", Double.toString(window), this);
                this.m_killWindowText.addActionListener(this);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double window = this.m_parameterTree.double_get("Window", 150.0);
            boolean kill = this.m_parameterTree.bool_get("Kill", true);
            if (Math.abs(window) < 4.0) {
                this.Success = false;
                this.Reason = "Window too short";
                return;
            }
            this.m_tools.computeDCBias(ensemble, kill, window);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

