/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.PickEventCombo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_NearestTimePicker
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JComboBox m_outputPick;
    protected ArrayList<String> m_stringList;
    protected JTextField m_timeText;
    protected PickEventCombo m_eventCombo;
    protected JButton m_btnReload;
    protected JCheckBox m_branchLimitCheck;
    protected JComboBox<String> m_branchCombo;
    protected JCheckBox m_windowLimitCheck;
    protected JTextField m_windowLimitText;
    protected JButton m_launchButton;
    protected JCheckBox m_checkSnap;
    protected JCheckBox m_checkOffsetLimit;
    protected JTextField m_textMinOffset;
    protected JTextField m_textMaxOffset;
    protected boolean m_bReloadingPicks = false;
    protected String m_existsString = "Pick with that name already exists";

    public EnsembleWorker_NearestTimePicker() {
        try {
            this.FirstBreakAutoPicker = true;
            this.Abbreviation = "PickT";
            this.ShortDescription = "Pick event nearest time";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_NearestTimePicker";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String info = "<HTML>You can use the function to, for example, create picks based on the current delay time analysis.</HTML>";
                JLabel lbl = new JLabel(info);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                this.m_outputPick = new JComboBox();
                this.m_outputPick.addItemListener(this);
                double time = this.m_parameterTree.double_get("Time", 0.0);
                this.m_timeText = new JTextField(Double.toString(time));
                this.m_timeText.addActionListener(this);
                this.m_eventCombo = new PickEventCombo();
                this.m_eventCombo.listener().addListener(this);
                this.m_branchLimitCheck = new JCheckBox("Only pick traces assigned to branch");
                this.m_branchLimitCheck.addActionListener(this);
                this.m_branchCombo = new JComboBox();
                this.m_branchCombo.addItem("All branchs");
                for (int b = 1; b < 10; ++b) {
                    this.m_branchCombo.addItem(String.format("Branch %d", b));
                }
                int whichBranch = this.m_parameterTree.int_get("WhichBranch", 0);
                whichBranch = Math.max(whichBranch, 0);
                whichBranch = Math.min(whichBranch, 6);
                this.m_branchCombo.setSelectedIndex(whichBranch);
                this.m_branchCombo.addItemListener(this);
                boolean limit = this.m_parameterTree.bool_get("BranchLimit", false);
                this.m_branchLimitCheck.setSelected(limit);
                this.m_windowLimitCheck = new JCheckBox("Kill picks outside window: ");
                this.m_windowLimitCheck.addActionListener(this);
                boolean windowLimit = this.m_parameterTree.bool_get("WindowLimit", false);
                this.m_windowLimitCheck.setSelected(windowLimit);
                this.m_windowLimitText = new JTextField();
                this.m_windowLimitText.addActionListener(this);
                this.m_windowLimitText.setText("100");
                if (this.m_parameterTree.double_exists("WindowLimitTime")) {
                    double windowLimitTime = this.m_parameterTree.double_get("WindowLimitTime", 100.0);
                    this.m_windowLimitText.setText(Double.toString(windowLimitTime));
                }
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                grid.addSimple(row, new JLabel("Output pick name"), this.m_outputPick);
                this.m_btnReload = grid.createButton("Reload pick info", this, row++, 2);
                grid.addSimple(row++, new JLabel("Event"), this.m_eventCombo);
                grid.addSimple(row++, new JLabel("Pick time"), this.m_timeText);
                boolean snap = this.m_parameterTree.bool_get("Snap", true);
                this.m_checkSnap = new JCheckBox("Snap pick to nearest event");
                this.m_mainWidget.addComponent(this.m_checkSnap, 0);
                this.m_checkSnap.setSelected(snap);
                this.m_checkSnap.addActionListener(this);
                this.m_mainWidget.addHorzPair(this.m_branchLimitCheck, 0, this.m_branchCombo, 10);
                this.m_branchCombo.setEnabled(this.m_branchLimitCheck.isSelected());
                this.m_mainWidget.addHorzPair(this.m_windowLimitCheck, 0, this.m_windowLimitText, 10);
                this.m_windowLimitText.setEditable(this.m_windowLimitCheck.isSelected());
                this.m_windowLimitText.setEnabled(this.m_windowLimitCheck.isSelected());
                if (projectOK) {
                    // empty if block
                }
                this.m_mainWidget.createGapLabel(20);
                GridLayoutWidget batchGrid = this.m_mainWidget.createGridLayoutWidget(0, "Offset limits (BATCH JOB ONLY!)", 0);
                int batchRow = 0;
                this.m_checkOffsetLimit = new JCheckBox("Apply offset limits");
                this.m_checkOffsetLimit.setSelected(this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false));
                batchGrid.addComponent(this.m_checkOffsetLimit, batchRow, 1, 1.0, 10.0);
                this.m_textMinOffset = new JTextField(this.m_parameterTree.string_get("BatchMinOffset", "0"));
                this.m_textMaxOffset = new JTextField(this.m_parameterTree.string_get("BatchMaxOffset", "100000"));
                int n = ++batchRow;
                batchGrid.addSimple(n, new JLabel("Min offset"), this.m_textMinOffset);
                int n2 = ++batchRow;
                ++batchRow;
                batchGrid.addSimple(n2, new JLabel("Max offset"), this.m_textMaxOffset);
                String txt = "";
                txt = projectOK ? "Start batch picker, add entry to trace table" : "Start batch picker, create ASCII pick file";
                this.m_launchButton = this.m_mainWidget.createButton(txt, this, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
                this.reload_picks();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void reload_picks() {
        try {
            this.m_bReloadingPicks = true;
            String s1 = this.m_parameterTree.string_get("m_outputPick", "FBP_PickT");
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_stringList = p.traceTableWrapper().traceTable().columns("FBP");
            this.m_outputPick.removeAllItems();
            int index = 0;
            int sel = 0;
            for (String s : this.m_stringList) {
                this.m_outputPick.addItem(s);
                if (s.equalsIgnoreCase(s1)) {
                    sel = index;
                }
                ++index;
            }
            this.m_outputPick.setSelectedIndex(sel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        this.m_bReloadingPicks = false;
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_eventCombo) {
                if (!PickerGizmo.singleton().PickEventJustChanged) {
                    return;
                }
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setOverwritePicks() {
        try {
            this.m_parameterTree.bool_put("Overwrite", true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            String s = this.m_outputPick.getSelectedItem().toString();
            this.m_parameterTree.string_put("m_outputPick", s);
            double time = Tools_Widget.extractDouble(this.m_timeText, 0.0, -200000.0, 200000.0);
            this.m_parameterTree.double_put("Time", time);
            this.m_parameterTree.bool_put("Snap", this.m_checkSnap.isSelected());
            this.m_parameterTree.bool_put("BranchLimit", this.m_branchLimitCheck.isSelected());
            this.m_parameterTree.int_put("WhichBranch", this.m_branchCombo.getSelectedIndex());
            this.m_branchCombo.setEnabled(this.m_branchLimitCheck.isSelected());
            double windowLimitTime = Tools_Widget.extractDouble(this.m_windowLimitText, 100.0, 0.0, 200000.0);
            this.m_parameterTree.bool_put("WindowLimit", this.m_windowLimitCheck.isSelected());
            this.m_parameterTree.double_put("WindowLimitTime", windowLimitTime);
            this.m_windowLimitText.setEditable(this.m_windowLimitCheck.isSelected());
            this.m_windowLimitText.setEnabled(this.m_windowLimitCheck.isSelected());
            this.m_parameterTree.bool_put("BatchApplyOffsetLimits", this.m_checkOffsetLimit.isSelected());
            this.m_parameterTree.double_put("BatchMinOffset", Tools_Widget.extractDouble(this.m_textMinOffset, 0.0, 0.0, 1000000.0));
            this.m_parameterTree.double_put("BatchMaxOffset", Tools_Widget.extractDouble(this.m_textMaxOffset, 0.0, 0.0, 1000000.0));
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return this.m_parameterTree.string_get("m_outputPick", "FBP_PickT");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_bReloadingPicks) {
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_bReloadingPicks) {
                return;
            }
            if (e.getSource() == this.m_btnReload) {
                this.reload_picks();
                return;
            }
            if (this.m_launchButton == e.getSource()) {
                this.broadcast(this, "SendMessageToOwner");
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            boolean applyOffsetLimits = false;
            double minOffset = 0.0;
            double maxOffset = 100000.0;
            if (this.SharedData.Batch) {
                applyOffsetLimits = this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false);
                minOffset = this.m_parameterTree.double_get("BatchMinOffset", 0.0);
                maxOffset = this.m_parameterTree.double_get("BatchMaxOffset", 0.0);
                if (applyOffsetLimits) {
                    ensemble.filter("Trace", "Offset", minOffset, maxOffset);
                }
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean projectOK = project.valid();
            this.m_inputEnsemble = ensemble;
            double time = this.m_parameterTree.double_get("Time", 0.0);
            String name = this.m_parameterTree.string_get("m_outputPick", "FBP_PickT");
            boolean overwrite = this.m_parameterTree.bool_get("Overwrite", false);
            boolean branchLimit = this.m_parameterTree.bool_get("BranchLimit", false);
            int whichBranch = this.m_parameterTree.int_get("WhichBranch", 0);
            boolean snap = this.m_parameterTree.bool_get("Snap", true);
            PickEvent pe = PickerGizmo.singleton().pickEvent();
            Tools_Picking.pickEventNearestTime(ensemble, name, pe, (float)time, branchLimit, whichBranch, snap);
            boolean windowLimit = this.m_parameterTree.bool_get("WindowLimit", false);
            if (windowLimit) {
                double window = this.m_parameterTree.double_get("WindowLimitTime", 100.0);
                Tools_Picking.killPicksOutsideTimeWindow(ensemble, name, (float)time, (float)window);
            }
            ensemble.pickPlotData().addRequiredPick(name);
            if (!projectOK) {
                ensemble.pickPlotData().add(name, Color.red, 9, Java2D_PointSymbol.FilledOval);
            }
            this.IasAutopicker = true;
            this.AutopickerColumnName = name;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

