/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Moveout;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class EnsembleWorker_ApplyNMO
extends EnsembleWorker_Base
implements IParameterWidgetListener,
Messenger.Listener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editor;
    protected StackGizmo m_stackerGizmo = new StackGizmo();

    public EnsembleWorker_ApplyNMO() {
        try {
            this.Abbreviation = "NMO";
            this.ShortDescription = "Apply NMO";
            this.WorkerType = "Moveout";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ApplyNMO";
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble.traceCount() < 1) {
                return;
            }
            int numSamp = this.m_inputEnsemble.trace(0).data().length();
            VelocityManager velManager = RefractionStaticsProject.singleton().getVelocityManager();
            String velname = velManager.getVersionList().get(0);
            VelocityLocationCollection velField = velManager.getVelocityLocationCollection(velname);
            this.m_stackerGizmo.applyMoveout(this.m_inputEnsemble, velField, 0.0f, 35.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

