/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.ModelTimeShifts;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_HybridTimeShifts
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JCheckBox m_velCheck;
    protected JCheckBox m_dtCheck;
    protected JCheckBox m_residualCheck;
    protected JCheckBox m_upCheck;

    public EnsembleWorker_HybridTimeShifts() {
        try {
            this.Abbreviation = "DT";
            this.ShortDescription = "Apply hybrid GLI model shifts";
            this.WorkerType = "Model/analysis time shifts";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_HybridTimeShifts";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.bool_put("ApplyVelocities", this.m_velCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyResidual", this.m_residualCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyDelayTimes", this.m_dtCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyUphole", this.m_upCheck.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String s = "<HTML>Traces not assigned to a branch will be given interpolated values</HTML>";
                JLabel lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                s = "<HTML><font color=\"red\">If no traces in the selected group are assigned to a branch then no shifts will be applied. </font></HTML>";
                lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                boolean applyDelayTimes = this.m_parameterTree.bool_get("ApplyDelayTimes", true);
                boolean applyResiduals = this.m_parameterTree.bool_get("ApplyResidual", true);
                boolean applyVelocities = this.m_parameterTree.bool_get("ApplyVelocities", true);
                boolean applyUphole = this.m_parameterTree.bool_get("ApplyUphole", true);
                this.m_velCheck = new JCheckBox("Apply refractor travel time");
                this.m_dtCheck = new JCheckBox("Apply computed \"delay times\"");
                this.m_residualCheck = new JCheckBox("Apply residual (high frequency) terms");
                this.m_upCheck = new JCheckBox("Apply uphole correction term");
                this.m_velCheck.setSelected(applyVelocities);
                this.m_dtCheck.setSelected(applyDelayTimes);
                this.m_upCheck.setSelected(applyUphole);
                this.m_residualCheck.setSelected(applyResiduals);
                this.m_mainWidget.addComponent(this.m_velCheck, 0);
                this.m_mainWidget.addComponent(this.m_dtCheck, 0);
                this.m_mainWidget.addComponent(this.m_residualCheck, 0);
                this.m_mainWidget.addComponent(this.m_upCheck, 0);
                this.m_velCheck.addActionListener(this);
                this.m_dtCheck.addActionListener(this);
                this.m_upCheck.addActionListener(this);
                this.m_residualCheck.addActionListener(this);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            boolean applyDelayTimes = this.m_parameterTree.bool_get("ApplyDelayTimes", true);
            boolean applyVelocities = this.m_parameterTree.bool_get("ApplyVelocities", true);
            boolean applyUphole = this.m_parameterTree.bool_get("ApplyUphole", true);
            boolean applyResiduals = this.m_parameterTree.bool_get("ApplyResidual", true);
            HybridGliData hybrid = RefractionStaticsProject.singleton().hybridGliData();
            hybrid.applyShifts(ensemble, applyDelayTimes, applyVelocities, applyUphole, applyResiduals);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

