/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_ScanVelocity
extends EnsembleWorker_Base
implements ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected long m_totalRead = 0L;
    protected long m_totalTraces = 0L;
    protected long[] m_indices = new long[1000];
    protected Ensemble m_scanEnsemble = new Ensemble();
    protected int m_minBin2D = Integer.MAX_VALUE;
    protected int m_maxBin2D = Integer.MIN_VALUE;
    protected int m_currentBin2D;
    protected int m_minInline = Integer.MAX_VALUE;
    protected int m_maxInline = Integer.MIN_VALUE;
    protected int m_minCrossline = Integer.MAX_VALUE;
    protected int m_maxCrossline = Integer.MIN_VALUE;
    protected int m_currentInline;
    protected int m_currentCrossline;
    protected RefractionStaticsProject m_project;
    protected VelocityLocationCollection m_velField;
    protected float m_digi = 4.0f;
    protected int m_sampleCount = 500;
    protected LinearLayoutWidget m_mainWidget = null;
    protected JTextField m_txtDigi;
    protected JTextField m_txtCount;

    public EnsembleWorker_ScanVelocity() {
        try {
            this.Abbreviation = "SCANVEL";
            this.ShortDescription = "Scan velocity";
            this.WorkerType = "Input";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = true;
            this.EnsembleSource = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ScanVelocity";
    }

    protected boolean prepBin2D() {
        try {
            this.m_minBin2D = Integer.MAX_VALUE;
            this.m_maxBin2D = Integer.MIN_VALUE;
            ITraceTable table = this.m_project.traceTableWrapper().traceTable();
            int index = table.column_indexOfColumn("Bin2D");
            for (long n = 0L; n < table.rowCount(); ++n) {
                int b = table.getInt(n, index);
                this.m_maxBin2D = Math.max(this.m_maxBin2D, b);
                this.m_minBin2D = Math.min(this.m_minBin2D, b);
            }
            this.m_currentBin2D = this.m_minBin2D;
            this.m_totalTraces = this.m_maxBin2D - this.m_minBin2D + 1;
            return this.m_minBin2D < this.m_maxBin2D;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean prepBin3D() {
        try {
            this.m_minInline = Integer.MAX_VALUE;
            this.m_maxInline = Integer.MIN_VALUE;
            this.m_minCrossline = Integer.MAX_VALUE;
            this.m_maxCrossline = Integer.MIN_VALUE;
            ITraceTable table = this.m_project.traceTableWrapper().traceTable();
            int indexInline = table.column_indexOfColumn("Inline");
            int indexCrossline = table.column_indexOfColumn("Crossline");
            for (long n = 0L; n < table.rowCount(); ++n) {
                int inline = table.getInt(n, indexInline);
                int crossline = table.getInt(n, indexCrossline);
                this.m_maxInline = Math.max(this.m_maxInline, inline);
                this.m_minInline = Math.min(this.m_minInline, inline);
                this.m_maxCrossline = Math.max(this.m_maxCrossline, crossline);
                this.m_minCrossline = Math.min(this.m_minCrossline, crossline);
            }
            this.m_currentInline = this.m_minInline - 1;
            this.m_currentCrossline = this.m_minCrossline;
            this.m_totalTraces = (long)(this.m_maxInline - this.m_minInline + 1) * (long)(this.m_maxCrossline - this.m_minCrossline + 1);
            return this.m_minInline < this.m_maxInline;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            boolean loadKilled = this.m_parameterTree.bool_get("LoadKilled", false);
            this.m_project.setLoadKilledTraces(loadKilled);
            this.m_scanEnsemble.clearTraces(false);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_velField == null) {
                this.m_sampleCount = this.m_parameterTree.int_get("Count", 500);
                this.m_digi = (float)this.m_parameterTree.double_get("Digi", 4.0);
                VelocityManager velManager = p.getVelocityManager();
                String velname = velManager.getVersionList().get(0);
                this.m_velField = velManager.getVelocityLocationCollection(velname);
                this.m_velField.setRequestedInterp(0.0f, this.m_digi, this.m_sampleCount);
            }
            if (this.m_project.dim3D()) {
                if (this.m_currentInline >= this.m_maxInline) {
                    this.m_currentInline = this.m_minInline;
                    ++this.m_currentCrossline;
                }
                if (this.m_currentCrossline >= this.m_maxCrossline) {
                    return false;
                }
                ++this.m_currentInline;
                p.getGrid3D_Conversion().setInlineCrossline(this.m_currentInline, this.m_currentCrossline);
                double x = p.getGrid3D_Conversion().WorldX;
                double y = p.getGrid3D_Conversion().WorldY;
                float[] v = this.m_velField.getVelocity(x, y);
                this.m_scanEnsemble.clearTraces(false);
                int indexIn = this.m_scanEnsemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexCr = this.m_scanEnsemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexx = this.m_scanEnsemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
                int indexy = this.m_scanEnsemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
                EnsembleTrace trace = this.m_scanEnsemble.addTrace();
                trace.data().insertArray(v, this.m_sampleCount);
                trace.data().setFirstSampleCoord(0.0f);
                trace.data().setSampleInterval(this.m_digi);
                trace.header().putInt(indexIn, this.m_currentInline);
                trace.header().putInt(indexCr, this.m_currentCrossline);
                trace.header().putDouble(indexx, x);
                trace.header().putDouble(indexy, y);
            } else {
                if (this.m_currentBin2D >= this.m_maxBin2D) {
                    return false;
                }
                ++this.m_currentBin2D;
            }
            this.m_project.setLoadKilledTraces(false);
            ++this.m_totalRead;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public long totalTraces() {
        return this.m_totalTraces;
    }

    public long totalRead() {
        return this.m_totalRead;
    }

    @Override
    public double percentDone() {
        if (this.m_totalTraces > 0L) {
            return 100.0 * (double)this.m_totalRead / (double)this.m_totalTraces;
        }
        return 0.0;
    }

    @Override
    public Ensemble nextEnsemble() {
        return this.m_scanEnsemble;
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            double digi = Tools_Widget.extractDouble(this.m_txtDigi, 4.0, 1.0, 0.0);
            int count = Tools_Widget.extractInteger(this.m_txtCount, 500, 5, 5000);
            this.m_parameterTree.double_put("Digi", digi);
            this.m_parameterTree.int_put("Count", count);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                this.m_txtCount = new JTextField(this.m_parameterTree.string_get("Count", "500"));
                this.m_txtDigi = new JTextField(this.m_parameterTree.string_get("Digi", "4"));
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(0, 0);
                grid.addSimple(0, new JLabel("Sample interval"), this.m_txtDigi);
                grid.addSimple(0, new JLabel("Sample count"), this.m_txtCount);
                this.m_mainWidget.addStretch(10);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getParametersFromWidget();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

