/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Import;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_ScanProjectTraces
extends EnsembleWorker_Base
implements ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected ScanPlaneEnum m_scanPlane = ScanPlaneEnum.Sequential;
    protected long m_totalRead = 0L;
    protected long[] m_indices = new long[1000];
    protected Ensemble m_scanEnsemble = new Ensemble();
    protected boolean m_is3D = false;
    protected int m_minBin2D = Integer.MAX_VALUE;
    protected int m_maxBin2D = Integer.MIN_VALUE;
    protected int m_currentBin2D;
    protected int m_minInline = Integer.MAX_VALUE;
    protected int m_maxInline = Integer.MIN_VALUE;
    protected int m_minCrossline = Integer.MAX_VALUE;
    protected int m_maxCrossline = Integer.MIN_VALUE;
    protected int m_currentInline;
    protected int m_currentCrossline;
    protected RefractionStaticsProject m_project;
    protected ITraceTable m_traceTable;
    protected long m_totalTraces = 0L;
    protected int m_currentShotIndex = -1;
    protected long m_currentIndex;
    protected boolean m_applyOffsetFilter = false;
    protected double m_minOffset = 0.0;
    protected double m_maxOffset = 100000.0;
    public Java2D_Polygon Polygon;
    public boolean RequireShotInsidePolygon = false;
    public boolean RequireReceiverInsidePolygon = false;
    public boolean RequireCdpInsidePolygon = false;
    protected LinearLayoutWidget m_mainWidget = null;
    protected JComboBox<String> m_planeCombo;
    protected JLabel m_label;
    protected JCheckBox m_chkLoadKilledTraces;

    public EnsembleWorker_ScanProjectTraces() {
        try {
            this.Abbreviation = "SCANPRJ";
            this.ShortDescription = "Scan project traces";
            this.WorkerType = "Input";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = true;
            this.EnsembleSource = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ScanProjectTraces";
    }

    public void setOffsetFilter(boolean apply, double min, double max) {
        this.m_applyOffsetFilter = apply;
        this.m_maxOffset = max;
        this.m_minOffset = min;
    }

    public void setScanPlane(ScanPlaneEnum plane) {
        try {
            this.m_parameterTree.string_put("ScanPlane", plane.name());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean prepBin2D() {
        try {
            this.m_minBin2D = Integer.MAX_VALUE;
            this.m_maxBin2D = Integer.MIN_VALUE;
            ITraceTable table = this.m_project.traceTableWrapper().traceTable();
            int index = table.column_indexOfColumn("Bin2D");
            for (long n = 0L; n < table.rowCount(); ++n) {
                int b = table.getInt(n, index);
                this.m_maxBin2D = Math.max(this.m_maxBin2D, b);
                this.m_minBin2D = Math.min(this.m_minBin2D, b);
            }
            this.m_currentBin2D = this.m_minBin2D;
            return this.m_minBin2D < this.m_maxBin2D;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean prepBin3D() {
        try {
            this.m_minInline = Integer.MAX_VALUE;
            this.m_maxInline = Integer.MIN_VALUE;
            this.m_minCrossline = Integer.MAX_VALUE;
            this.m_maxCrossline = Integer.MIN_VALUE;
            ITraceTable table = this.m_project.traceTableWrapper().traceTable();
            int indexInline = table.column_indexOfColumn("Inline");
            int indexCrossline = table.column_indexOfColumn("Crossline");
            for (long n = 0L; n < table.rowCount(); ++n) {
                int inline = table.getInt(n, indexInline);
                int crossline = table.getInt(n, indexCrossline);
                this.m_maxInline = Math.max(this.m_maxInline, inline);
                this.m_minInline = Math.min(this.m_minInline, inline);
                this.m_maxCrossline = Math.max(this.m_maxCrossline, crossline);
                this.m_minCrossline = Math.min(this.m_minCrossline, crossline);
            }
            this.m_currentInline = this.m_minInline;
            this.m_currentCrossline = this.m_minCrossline;
            return this.m_minInline < this.m_maxInline;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public boolean prepareSource() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            if (!this.m_project.valid()) {
                return false;
            }
            this.m_traceTable = this.m_project.traceTableWrapper().traceTable();
            this.m_totalTraces = this.m_traceTable.rowCount();
            this.m_totalRead = 0L;
            String plane = this.m_parameterTree.string_get("ScanPlane", ScanPlaneEnum.Sequential.name());
            try {
                this.m_scanPlane = ScanPlaneEnum.valueOf(plane);
            }
            catch (Exception ex2) {
                this.m_scanPlane = ScanPlaneEnum.Sequential;
                ex2.printStackTrace();
            }
            if (this.m_scanPlane == ScanPlaneEnum.Bin) {
                if (this.m_project.dim3D()) {
                    return this.prepBin3D();
                }
                return this.prepBin2D();
            }
            if (this.m_scanPlane == ScanPlaneEnum.Shot) {
                this.m_currentShotIndex = 0;
                return this.m_currentShotIndex < this.m_project.shotTable().row_count();
            }
            if (this.m_scanPlane == ScanPlaneEnum.Sequential) {
                this.m_currentIndex = 0L;
                return this.m_currentIndex < this.m_totalTraces;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            boolean poly;
            boolean loadKilled = this.m_parameterTree.bool_get("LoadKilled", false);
            this.m_project.setLoadKilledTraces(loadKilled);
            this.m_scanEnsemble.clearTraces(false);
            if (this.m_scanPlane == ScanPlaneEnum.Shot) {
                if (this.m_currentShotIndex >= this.m_project.shotTable().row_count()) {
                    return false;
                }
                int index = this.m_project.shotTable().column_indexOfColumn("ShotID");
                int id = this.m_project.shotTable().getInt(this.m_currentShotIndex, index);
                this.m_project.ensemble_Shot(this.m_scanEnsemble, id, true);
                ++this.m_currentShotIndex;
            } else if (this.m_scanPlane == ScanPlaneEnum.Sequential) {
                if (this.m_currentIndex >= this.m_totalTraces) {
                    return false;
                }
                this.m_project.ensemble_Sequence(this.m_scanEnsemble, this.m_currentIndex, 10000, true);
                this.m_currentIndex += 10000L;
                double index = 100.0 * (double)this.m_currentIndex / (double)this.m_totalTraces;
            } else if (this.m_scanPlane == ScanPlaneEnum.Bin) {
                if (this.m_project.dim3D()) {
                    if (this.m_currentInline >= this.m_maxInline) {
                        this.m_currentInline = this.m_minInline;
                        ++this.m_currentCrossline;
                    }
                    if (this.m_currentCrossline >= this.m_maxCrossline) {
                        return false;
                    }
                    this.m_project.ensemble_Bin3D(this.m_scanEnsemble, this.m_currentInline, this.m_currentCrossline, 0, true);
                    ++this.m_currentInline;
                } else {
                    if (this.m_currentBin2D >= this.m_maxBin2D) {
                        return false;
                    }
                    this.m_project.ensemble_Bin2D(this.m_scanEnsemble, this.m_currentBin2D, 0, true);
                    ++this.m_currentBin2D;
                }
                this.m_scanEnsemble.sortDouble(0, "Trace", "Offset");
            } else {
                this.m_project.setLoadKilledTraces(false);
                return false;
            }
            this.m_project.setLoadKilledTraces(false);
            this.m_totalRead += (long)this.m_scanEnsemble.traceCount();
            this.ActionString = String.format("%d of %d", this.m_totalRead, this.m_totalTraces);
            if (this.m_applyOffsetFilter) {
                this.m_scanEnsemble.filter("Trace", "Offset", this.m_minOffset, this.m_maxOffset);
            }
            boolean bl = poly = this.RequireShotInsidePolygon || this.RequireReceiverInsidePolygon || this.RequireCdpInsidePolygon;
            if (poly && this.Polygon != null) {
                this.Polygon.filterEnsemble(this.m_scanEnsemble, this.RequireShotInsidePolygon, this.RequireReceiverInsidePolygon, this.RequireCdpInsidePolygon);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void resetInputWorker() {
        this.m_currentShotIndex = 0;
        this.m_currentIndex = 0L;
        this.m_currentInline = this.m_minInline;
        this.m_currentCrossline = this.m_minCrossline;
        this.m_currentBin2D = this.m_minBin2D;
        this.m_totalRead = 0L;
    }

    public long totalTraces() {
        return this.m_totalTraces;
    }

    public long totalRead() {
        return this.m_totalRead;
    }

    @Override
    public double percentDone() {
        if (this.m_totalTraces > 0L) {
            return 100.0 * (double)this.m_totalRead / (double)this.m_totalTraces;
        }
        return 0.0;
    }

    @Override
    public Ensemble nextEnsemble() {
        return this.m_scanEnsemble;
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            String plane = (String)this.m_planeCombo.getSelectedItem();
            this.m_parameterTree.string_put("ScanPlane", plane);
            this.m_parameterTree.bool_put("LoadKilled", this.m_chkLoadKilledTraces.isSelected());
            this.m_scanPlane = ScanPlaneEnum.valueOf(plane);
            this.m_label.setText(" ");
            if (this.m_scanPlane == ScanPlaneEnum.Receiver) {
                this.m_label.setText("Receiver plane may be extremely slow!!!");
                this.m_label.setForeground(Color.red);
            }
            if (this.m_scanPlane == ScanPlaneEnum.Bin) {
                this.m_label.setText("Bin plane may be extremely slow!!!");
                this.m_label.setForeground(Color.red);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                LinearLayoutWidget sub = this.m_mainWidget.createHorizontal(3, "Select input sort order", 0);
                this.m_planeCombo = new JComboBox();
                this.m_planeCombo.addItem(ScanPlaneEnum.Sequential.name());
                this.m_planeCombo.addItem(ScanPlaneEnum.Shot.name());
                this.m_planeCombo.addItem(ScanPlaneEnum.Receiver.name());
                this.m_planeCombo.addItem(ScanPlaneEnum.Bin.name());
                sub.addComponent(this.m_planeCombo, 0);
                String plane = this.m_parameterTree.string_get("ScanPlane", ScanPlaneEnum.Sequential.name());
                try {
                    this.m_planeCombo.setSelectedIndex(ScanPlaneEnum.valueOf(plane).ordinal());
                }
                catch (Exception err) {
                    this.m_planeCombo.setSelectedIndex(0);
                }
                this.m_planeCombo.addItemListener(this);
                this.m_label = new JLabel("");
                sub.addComponent(this.m_label, 10);
                this.m_chkLoadKilledTraces = new JCheckBox("Include killed traces");
                boolean load = this.m_parameterTree.bool_get("LoadKilled", false);
                this.m_chkLoadKilledTraces.setSelected(load);
                this.m_mainWidget.addComponent(this.m_chkLoadKilledTraces, 0);
                this.m_mainWidget.addStretch(10);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getParametersFromWidget();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    public static enum ScanPlaneEnum {
        Sequential,
        Shot,
        Receiver,
        Bin;

    }
}

