/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import javax.swing.JComponent;

public class EnsembleWorker_PositionPredictor
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected int m_indexX;
    protected int m_indexY;
    protected int m_indexOtherX;
    protected int m_indexOtherY;
    protected double m_startX;
    protected double m_startY;
    protected double m_currentX;
    protected double m_currentY;
    protected double m_maximumEnergy;
    protected double m_startEnergy;
    protected double m_decay = 100.0;
    protected double m_stepSize = 1000.0;
    protected String m_colName = "TempShift";
    protected float m_window = 30.0f;
    protected double m_minOffset = 0.0;
    protected double m_maxOffset = 3000.0;

    public EnsembleWorker_PositionPredictor() {
        try {
            this.Abbreviation = "POSEST";
            this.ShortDescription = "Crude position estimate";
            this.WorkerType = "Geometry";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PositionPredictor";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
    }

    @Override
    public boolean hasEditorWidget() {
        return false;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            throw new Exception("Does not have an editor");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean doWork(Ensemble ensemble) {
        try {
            this.work(ensemble);
            return this.Success;
        }
        catch (Exception error) {
            return false;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.Success = false;
            ensemble.CrudePositionEstimateValid = false;
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble.traceCount() < 1) {
                this.Success = false;
                this.Reason = "No traces in gather";
                return;
            }
            boolean ok = Tools_Ensemble.computeAzimuthAndOffset(this.m_inputEnsemble);
            if (!ok) {
                this.Success = false;
                this.Reason = "Shot/receiver coords not valid";
                return;
            }
            float timeWindow = 200.0f;
            Tools_Ensemble.computeEnergy(this.m_inputEnsemble, "Energy", timeWindow);
            int shotID = Tools_Ensemble.isShotEnsemble(this.m_inputEnsemble);
            int recID = Tools_Ensemble.isReceiverEnsemble(this.m_inputEnsemble);
            if (recID >= 0) {
                this.m_indexX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
                this.m_indexY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
                this.m_indexOtherX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
                this.m_indexOtherY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            } else if (shotID >= 0) {
                this.m_indexOtherX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
                this.m_indexOtherY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
                this.m_indexX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
                this.m_indexY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            } else {
                this.Success = false;
                this.Reason = "Must be a shot or receiver gather";
                return;
            }
            this.m_startX = this.m_inputEnsemble.trace(0).header().getDouble(this.m_indexX);
            this.m_startY = this.m_inputEnsemble.trace(0).header().getDouble(this.m_indexY);
            this.m_currentX = this.m_startX;
            this.m_currentY = this.m_startY;
            this.m_maximumEnergy = this.m_startEnergy = this.fitness(this.m_inputEnsemble, this.m_startX, this.m_startY);
            System.out.println("start m_maximumEnergy = " + Double.toString(this.m_maximumEnergy));
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            double searchDistance = 5000.0;
            if (p.units_feet()) {
                searchDistance = 6000.0;
                this.m_decay = 200.0;
                this.m_stepSize = 400.0;
            } else {
                searchDistance = 2000.0;
                this.m_decay = 10.0;
                this.m_stepSize = 100.0;
            }
            int rad = (int)(0.5 + searchDistance / this.m_stepSize);
            double bestX = this.m_currentX;
            double bestY = this.m_currentY;
            for (int loop = 0; loop < 6; ++loop) {
                for (int ix = -rad; ix <= rad; ++ix) {
                    for (int iy = -rad; iy <= rad; ++iy) {
                        double x = this.m_currentX + (double)ix * this.m_stepSize;
                        double y = this.m_currentY + (double)iy * this.m_stepSize;
                        double energy = this.fitness(this.m_inputEnsemble, x, y);
                        if (!(energy > this.m_maximumEnergy)) continue;
                        this.m_maximumEnergy = energy;
                        bestX = x;
                        bestY = y;
                    }
                }
                System.out.println(String.format("loop = %d  step = %f energy = %f", loop, Float.valueOf((float)this.m_stepSize), Float.valueOf((float)this.m_maximumEnergy)));
                this.m_currentX = bestX;
                this.m_currentY = bestY;
                this.m_stepSize *= 0.6;
            }
            double movedX = this.m_currentX - this.m_startX;
            double movedY = this.m_currentY - this.m_startY;
            double dist = Math.sqrt(movedX * movedX + movedY * movedY + 1.0E-6);
            double az = Math.atan2(movedY, movedX);
            System.err.println(String.format("Distance = %f", Float.valueOf((float)dist)));
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace t = ensemble.trace(n);
                t.header().putDouble(this.m_indexX, this.m_startX);
                t.header().putDouble(this.m_indexY, this.m_startY);
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            ensemble.CrudePositionEstimateValid = true;
            ensemble.CrudePositionEstimateAzimuth = az;
            ensemble.CrudePositionEstimateDistance = dist;
            ensemble.CrudePositionEstimateX = this.m_currentX;
            ensemble.CrudePositionEstimateY = this.m_currentY;
            this.Success = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    protected double fitness(Ensemble ensemble, double x, double y) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace t = ensemble.trace(n);
                t.header().putDouble(this.m_indexX, x);
                t.header().putDouble(this.m_indexY, y);
            }
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            RefractionStaticsProject.singleton().moveoutTrendData().putShiftTimeInHeader(ensemble, this.m_colName, false);
            double sum = 0.0;
            int indexEnergy = ensemble.dictionary().addEntry("Trace", "Energy", DataType.Double);
            int indexTimeShift = ensemble.dictionary().getEntryIndex("Trace", this.m_colName);
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                boolean killed;
                EnsembleTrace t = ensemble.trace(n);
                boolean bl = killed = t.Removed || t.TooNoisy || t.TraceKilled || t.header().getBool(indexShotKilled) || t.header().getBool(indexRecKilled);
                if (killed) continue;
                double dx = x - t.header().getDouble(this.m_indexOtherX);
                double dy = y - t.header().getDouble(this.m_indexOtherY);
                double off = Math.sqrt(1.0E-4 + dx * dx + dy * dy);
                double w = this.m_decay / (this.m_decay + off);
                double e = t.header().getDouble(indexEnergy);
                sum += e * w;
            }
            return sum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

