/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Geometry;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import javax.swing.JComponent;

public class EnsembleWorker_ComputeAzimuthAndOffset
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;

    public EnsembleWorker_ComputeAzimuthAndOffset() {
        try {
            this.Abbreviation = "AZOFF";
            this.ShortDescription = "Compute azimuth and offset";
            this.WorkerType = "Geometry";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ComputeAzimuthAndOffset";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
    }

    @Override
    public boolean hasEditorWidget() {
        return false;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            throw new Exception("Does not have an editor");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            boolean ok = Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            if (!ok) {
                this.Success = false;
                this.Reason = "Shot/receiver coords not valid";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

