/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Filter.FilterResponse_ButterworthLowPass;
import com.PecosLibrary.Math.Filter.ZeroPhaseFilter_TimeDomain;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_ButterworthLowPass
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ZeroPhaseFilter_TimeDomain m_filter = new ZeroPhaseFilter_TimeDomain();
    protected FilterResponse_ButterworthLowPass m_response = new FilterResponse_ButterworthLowPass();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_freqSlider;
    protected JTextField m_poleText;
    protected JTextField m_lengthText;

    public EnsembleWorker_ButterworthLowPass() {
        try {
            this.Abbreviation = "BWLP";
            this.ShortDescription = "Butterworth low pass filter";
            this.WorkerType = "Filter";
            this.m_filter.setResponse(this.m_response);
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ButterworthLowPass";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_lengthText) {
                this.getAll(true);
            }
            if (e.getSource() == this.m_poleText) {
                this.getAll(true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            int len = Tools_Widget.extractInteger(this.m_lengthText, 21, 11, 121);
            this.m_parameterTree.int_put("Length", len);
            int poles = Tools_Widget.extractInteger(this.m_poleText, 4, 1, 20);
            this.m_parameterTree.int_put("PoleCount", poles);
            this.m_parameterTree.double_put("Frequency", this.m_freqSlider.getDoubleValue());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double freq = this.m_parameterTree.double_get("Frequency", 35.0);
                this.m_freqSlider = new SliderWidget(this, null, "Corner frequency", 0, freq, 1.0, 100.0);
                this.m_freqSlider.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_freqSlider, -1, null, true);
                this.m_mainWidget.addComponent(this.m_freqSlider, 0);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int filterLen = this.m_parameterTree.int_get("Length", 21);
                int poleCount = this.m_parameterTree.int_get("PoleCount", 4);
                this.m_lengthText = new JTextField(Integer.toString(filterLen));
                this.m_poleText = new JTextField(Integer.toString(poleCount));
                this.m_lengthText.addActionListener(this);
                this.m_poleText.addActionListener(this);
                grid.addSimple(0, new JLabel("Filter length (samples)"), this.m_lengthText);
                grid.addSimple(1, new JLabel("Filter pole count (>= 1)"), this.m_poleText);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setCutoffFrequency(double freq) {
        try {
            this.m_parameterTree.double_put("Frequency", freq);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFilterLengthInSamples(int len) {
        try {
            this.m_parameterTree.int_put("Length", len);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setPoleCount(int poleCount) {
        try {
            this.m_parameterTree.int_put("PoleCount", poleCount);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int filterLen = this.m_parameterTree.int_get("Length", 21);
            int poleCount = this.m_parameterTree.int_get("PoleCount", 4);
            double freq = this.m_parameterTree.double_get("Frequency", 35.0);
            this.m_response.setCorner((float)freq);
            this.m_response.setPoleCount(poleCount);
            this.m_filter.setFilterLength(filterLen);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_filter.setDigi(data.getSampleInterval());
                this.m_filter.apply(this.m_tempArray, this.m_tempArray.length);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

