/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Attribute;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.FFT.FFT_ShortWindowAnalysis;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.LineFit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_EnergyAbsorption
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected FFT_ShortWindowAnalysis m_analyzer = new FFT_ShortWindowAnalysis();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_windowText;
    protected JTextField m_taperText;
    protected JTextField m_decayMinFreqText;
    protected JTextField m_decayMaxFreqText;
    protected JTextField m_growMinFreqText;
    protected JTextField m_growMaxFreqText;
    protected LineFit m_lineFit = new LineFit();

    public EnsembleWorker_EnergyAbsorption() {
        try {
            this.Abbreviation = "ENERABS";
            this.ShortDescription = "Energy absorption";
            this.WorkerType = "Attributes";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_EnergyAbsorption";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll() {
        try {
            float c1 = (float)Tools_Widget.extractDouble(this.m_decayMinFreqText, 35.0, 0.0, 120.0);
            float c2 = (float)Tools_Widget.extractDouble(this.m_decayMaxFreqText, 80.0, (double)(c1 + 1.0f), 240.0);
            float c3 = (float)Tools_Widget.extractDouble(this.m_growMinFreqText, 0.0, 0.0, 120.0);
            float c4 = (float)Tools_Widget.extractDouble(this.m_growMaxFreqText, 25.0, (double)(c3 + 1.0f), 240.0);
            float window = (float)Tools_Widget.extractDouble(this.m_windowText, 64.0, 10.0, 1020.0);
            float taper = (float)Tools_Widget.extractDouble(this.m_taperText, 12.0, 4.0, 100.0);
            this.m_parameterTree.double_put("Window", window);
            this.m_parameterTree.double_put("Taper", taper);
            this.m_parameterTree.double_put("DecayMinFreq", c1);
            this.m_parameterTree.double_put("DecayMaxFreq", c2);
            this.m_parameterTree.double_put("GrowMinFreq", c3);
            this.m_parameterTree.double_put("GrowMaxFreq", c4);
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                float window = (float)this.m_parameterTree.double_get("Window", 64.0);
                float taper = (float)this.m_parameterTree.double_get("Taper", 12.0);
                float c1 = (float)this.m_parameterTree.double_get("DecayMinFreq", 35.0);
                float c2 = (float)this.m_parameterTree.double_get("DecayMaxFreq", 80.0);
                float c3 = (float)this.m_parameterTree.double_get("GrowMinFreq", 5.0);
                float c4 = (float)this.m_parameterTree.double_get("GrowMaxFreq", 25.0);
                this.m_windowText = new JTextField(Float.toString(window));
                this.m_taperText = new JTextField(Float.toString(taper));
                this.m_decayMinFreqText = new JTextField(Float.toString(c1));
                this.m_decayMaxFreqText = new JTextField(Float.toString(c2));
                this.m_growMinFreqText = new JTextField(Float.toString(c3));
                this.m_growMaxFreqText = new JTextField(Float.toString(c4));
                this.m_windowText.addActionListener(this);
                this.m_taperText.addActionListener(this);
                this.m_decayMinFreqText.addActionListener(this);
                this.m_decayMaxFreqText.addActionListener(this);
                this.m_growMinFreqText.addActionListener(this);
                this.m_growMaxFreqText.addActionListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, "Window parameters", 0);
                grid.addSimple(1, new JLabel("Window (ms)"), this.m_windowText);
                grid.addSimple(2, new JLabel("Taper (ms)"), this.m_taperText);
                grid = this.m_mainWidget.createGridLayoutWidget(3, "High frequency decay", 0);
                grid.addSimple(1, new JLabel("Min frequency"), this.m_decayMinFreqText);
                grid.addSimple(2, new JLabel("Max  frequency"), this.m_decayMaxFreqText);
                grid = this.m_mainWidget.createGridLayoutWidget(3, "Low frequency growth", 0);
                grid.addSimple(3, new JLabel("Min frequency"), this.m_growMinFreqText);
                grid.addSimple(4, new JLabel("Max frequency"), this.m_growMaxFreqText);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeFit(float[] amp, float digi, float minFreq, float maxFreq, boolean applyLog) {
        try {
            int startIndex = (int)(0.5 + (double)(minFreq / digi));
            int endIndex = (int)(0.5 + (double)(maxFreq / digi));
            startIndex = Math.max(0, startIndex);
            endIndex = Math.min(endIndex, amp.length / 2);
            this.m_lineFit.clear();
            for (int n = startIndex; n <= endIndex; ++n) {
                float amplitude = amp[n];
                if (applyLog) {
                    amplitude = (float)Math.log10(amplitude);
                }
                this.m_lineFit.add(digi * (float)n, amplitude);
            }
            this.m_lineFit.compute();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected float[] getArray(int len, float[] array) {
        try {
            len = Math.max(10, len);
            if (array == null) {
                return new float[len];
            }
            if (array.length == len) {
                return array;
            }
            return new float[len];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new float[len];
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int filterLen = this.m_parameterTree.int_get("Length", 21);
            float c1 = (float)this.m_parameterTree.double_get("DecayMinFreq", 35.0);
            float c2 = (float)this.m_parameterTree.double_get("DecayMaxFreq", 80.0);
            float c3 = (float)this.m_parameterTree.double_get("GrowMinFreq", 5.0);
            float c4 = (float)this.m_parameterTree.double_get("GrowMaxFreq", 25.0);
            float window = (float)this.m_parameterTree.double_get("Window", 64.0);
            float taper = (float)this.m_parameterTree.double_get("Taper", 12.0);
            float[] decaySlope = new float[10];
            float[] decayAmp = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                decaySlope = this.getArray(data.length(), decaySlope);
                decayAmp = this.getArray(data.length(), decayAmp);
                this.m_tempArray = this.getArray(data.length(), this.m_tempArray);
                data.copyToArray(this.m_tempArray);
                this.m_analyzer.insertTraceData(this.m_tempArray, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
                this.m_analyzer.computeResampledTrace();
                this.m_analyzer.computeAllData(window, taper, true);
                float[][] amp = this.m_analyzer.fftAmp();
                for (int s = 0; s < data.length(); ++s) {
                    this.computeFit(amp[s], this.m_analyzer.frequencyIncrement(), c1, c2, false);
                    decayAmp[s] = (float)this.m_lineFit.B;
                    decaySlope[s] = (float)this.m_lineFit.A;
                }
                float digi = data.getSampleInterval();
                float t0 = data.getFirstSampleCoord_WithShifts();
                trace.putSupplementalData("DecaySlope", decaySlope, digi, t0);
                trace.putSupplementalData("DecayAmp", decayAmp, digi, t0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

