/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Amplitude;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import javax.swing.JComponent;

public class EnsembleWorker_NLAMP
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowEditor;
    protected SliderWidget m_thresholdEditor;

    public EnsembleWorker_NLAMP() {
        try {
            this.Abbreviation = "NLAMP";
            this.ShortDescription = "Non-linear amplitude adjustment";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_NLAMP";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Threshold", this.m_thresholdEditor.getDoubleValue());
            this.m_parameterTree.double_put("Window", this.m_windowEditor.getDoubleValue());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double window = this.m_parameterTree.double_get("Window", 200.0);
                this.m_windowEditor = new SliderWidget(this, null, "Window length, milliseconds", 0, window, 12.0, 2000.0);
                this.m_windowEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowEditor, -1, null, true);
                double thresh = this.m_parameterTree.double_get("Threshold", 10.0);
                this.m_thresholdEditor = new SliderWidget(this, null, "Peak amplitude, percent", 0, thresh, 0.0, 100.0);
                this.m_thresholdEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_thresholdEditor, -1, null, true);
                this.m_mainWidget.addComponent(this.m_windowEditor, 0);
                this.m_mainWidget.addComponent(this.m_thresholdEditor, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double window = this.m_parameterTree.double_get("Window", 200.0);
            float thresh = (float)this.m_parameterTree.double_get("Threshold", 1.0);
            double peakFraction = 0.01 * (double)thresh;
            if (Math.abs(window) < 4.0) {
                this.Success = false;
                this.Reason = "Window too short";
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(window / (double)data.getSampleInterval());
                this.m_renorm.applyLogAmp(this.m_tempArray, peakFraction, totalWindowLength);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

