/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Amplitude;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import javax.swing.JComponent;

public class EnsembleWorker_AGC
extends EnsembleWorker_Base
implements IParameterWidgetListener,
GenericObjectListener.Listener {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowEditor;
    protected SliderWidget m_thresholdEditor;
    protected RadioPanel m_method;

    public EnsembleWorker_AGC() {
        try {
            this.Abbreviation = "AGC";
            this.ShortDescription = "Automatic gain control";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
            this.m_parameterTree.double_put("Window", 400.0);
            this.m_parameterTree.double_put("Threshold", 0.0);
            double window = this.m_parameterTree.double_get("Window", 200.0);
            float f = (float)this.m_parameterTree.double_get("Threshold", 0.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_AGC";
    }

    public void setWindow(double window) {
        try {
            window = Math.max(20.0, window);
            this.m_parameterTree.double_put("Window", window);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double window = this.m_parameterTree.double_get("Window", 200.0);
                this.m_windowEditor = new SliderWidget(this, null, "Window length, milliseconds", 0, window, 12.0, 2000.0);
                this.m_windowEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowEditor, -1, null, true);
                double thresh = this.m_parameterTree.double_get("Threshold", 0.0);
                this.m_thresholdEditor = new SliderWidget(this, null, "Cut-off threshold, percent", 0, thresh, 0.0, 100.0);
                this.m_thresholdEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_thresholdEditor, -1, null, true);
                this.m_method = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Window location", "Output sample centered in time window", "Output sample at bottom of time window");
                int method = this.m_parameterTree.int_get("Method", 0);
                if (method == 0) {
                    this.m_method.setSelectedIndex(0);
                } else {
                    this.m_method.setSelectedIndex(1);
                }
                this.m_method.listener().addListener(this);
                this.m_mainWidget.addComponent(this.m_windowEditor, 0);
                this.m_mainWidget.addComponent(this.m_thresholdEditor, 0);
                this.m_mainWidget.addComponent(this.m_method, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Threshold", this.m_thresholdEditor.getDoubleValue());
            this.m_parameterTree.double_put("Window", this.m_windowEditor.getDoubleValue());
            this.m_parameterTree.int_put("Method", this.m_method.getSelectedIndex());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double window = this.m_parameterTree.double_get("Window", 200.0);
            float thresh = (float)this.m_parameterTree.double_get("Threshold", 0.0);
            if (Math.abs(window) < 4.0) {
                this.Success = false;
                this.Reason = "Window too short";
                return;
            }
            int method = this.m_parameterTree.int_get("Method", 0);
            ArrayRenormalization.AgcMethod m = ArrayRenormalization.AgcMethod.Center;
            if (method == 1) {
                m = ArrayRenormalization.AgcMethod.Bottom;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(window / (double)data.getSampleInterval());
                this.m_renorm.applyAGC(this.m_tempArray, thresh, totalWindowLength, m);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

