/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Echos;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.ImportLimit;
import com.PecosCore.Seismic.SeismicFileType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosLibrary.Echos.EchosInterface;
import com.PecosLibrary.Echos.SWIGTYPE_p_float;
import com.PecosLibrary.Echos.XtParadigmTfGather;
import com.PecosLibrary.Echos.XtParadigmTraceFile;
import com.PecosLibrary.Echos.XtParadigmTraceFileTools;
import com.PecosLibrary.Echos.XtTraceHeader;
import com.PecosLibrary.Echos.XtType;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import java.util.ArrayList;
import java.util.HashMap;

public class EchosSeismicFile
implements ISeismicFile {
    XtParadigmTraceFile _traceFile;
    String _sSurvey;
    String _sHost;
    String _sFileName;
    long _iEchosFileID;
    int _iEchosLineID;
    Echos_Dictionary _echosDictionary;
    int _iEchosSurveyType;
    XtParadigmTfGather _gather;
    SWIGTYPE_p_float _swigFloatArrayBuffer;
    float[] _sampleFloatArrayBuffer;
    int _nAllocatedSamples;
    int _nHeaders = 0;
    String[] _headerNames;
    int[] _headerIndexes;
    int[] _headerTypes;
    XtType[] _headerXtTypes;
    boolean _bHeaderInfoInitialized = false;
    HashMap<String, Integer> _headerIndexMap;
    HashMap<String, Integer> _headerWordIndexMap;
    HashMap<String, Integer> _headerTypeMap;
    HashMap<String, XtType> _headerXtTypeMap;
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    XtTraceHeader _traceHeader = null;
    Echos_Dictionary.Entry[] _echosHeaderEntries = null;
    public ArrayList<ImportLimit> ImportLimitList = new ArrayList();
    XtParadigmTfGather _populateEnsembleGather = null;
    float[] _populateEnsembleFloatArrayBuffer = null;
    SWIGTYPE_p_float _populateEnsembleSwigFloatArrayBuffer = null;

    public EchosSeismicFile(Echos_Dictionary echosDictionary, XtParadigmTraceFile traceFile, String sSurvey, String sHost, String sFileName, long echosFileID, int iEchosSurveyType, int iEchosLineID) {
        this._sSurvey = sSurvey;
        this._sHost = sHost;
        this._sFileName = sFileName;
        this._iEchosFileID = echosFileID;
        this._traceFile = traceFile;
        this._echosDictionary = echosDictionary;
        this._iEchosSurveyType = iEchosSurveyType;
        this._iEchosLineID = iEchosLineID;
    }

    void initializeHeaderInfo() throws Exception {
        this._nHeaders = this._traceFile.getHdrFields();
        this._headerNames = new String[this._nHeaders];
        this._headerIndexes = new int[this._nHeaders];
        this._headerTypes = new int[this._nHeaders];
        this._headerXtTypes = new XtType[this._nHeaders];
        this._headerIndexMap = new HashMap();
        this._headerWordIndexMap = new HashMap();
        this._headerTypeMap = new HashMap();
        this._headerXtTypeMap = new HashMap();
        for (int iHeader = 0; iHeader < this._nHeaders; ++iHeader) {
            String sHeaderName = this._traceFile.getHdrName(iHeader);
            int iHdrIndex = this._traceFile.GetHdrIndex(sHeaderName);
            int iHdrType = this._traceFile.GetHdrType(sHeaderName);
            XtType xtType = this._traceFile.GetXtType(sHeaderName);
            this._headerNames[iHeader] = sHeaderName;
            this._headerIndexes[iHeader] = iHdrIndex;
            this._headerTypes[iHeader] = iHdrType;
            this._headerXtTypes[iHeader] = xtType;
            this._headerWordIndexMap.put(sHeaderName, iHdrIndex);
            this._headerTypeMap.put(sHeaderName, iHdrType);
            this._headerXtTypeMap.put(sHeaderName, xtType);
            this._headerIndexMap.put(sHeaderName, iHeader);
        }
        this.prepareEchos_Dictionary();
        for (ImportLimit lim : this.ImportLimitList) {
            String sTable = lim.Table;
            String sColumn = lim.Column;
            lim.HeaderWordIndex = -1;
            lim.Header = -1;
            if (!this._headerWordIndexMap.containsKey(lim.HeaderName)) continue;
            lim.HeaderWordIndex = this._headerWordIndexMap.get(lim.HeaderName);
            lim.Header = this._headerIndexMap.get(lim.HeaderName);
        }
        this._bHeaderInfoInitialized = true;
    }

    public int getLineID() {
        return this._iEchosLineID;
    }

    public String getFilePath() {
        String sFilePath = "";
        try {
            sFilePath = XtParadigmTraceFileTools.getFileRecXmlDescriptor(this._iEchosFileID, this._sFileName, this._sHost, this._sSurvey, this._iEchosLineID, this._iEchosSurveyType);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sFilePath;
    }

    @Override
    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    @Override
    public void setDictionary(Object objDictionary) {
        try {
            if (objDictionary instanceof Echos_Dictionary) {
                Echos_Dictionary dict;
                this._echosDictionary = dict = (Echos_Dictionary)objDictionary;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getName() {
        return this.getFilePath();
    }

    @Override
    public String getDirectory() {
        return "";
    }

    @Override
    public SeismicFileType getFileType() {
        return SeismicFileType.Echos;
    }

    public XtParadigmTraceFile getXtParadigmTraceFile() {
        return this._traceFile;
    }

    public String getFileDescription() {
        return "Survey = " + this._sSurvey + " Host = " + this._sHost + " FileID = " + Long.toString(this._iEchosFileID);
    }

    public void prepareEchos_Dictionary() throws Exception {
        int nEntries = this._echosDictionary.entryCount();
        for (int i = 0; i < nEntries; ++i) {
            int iTest;
            Echos_Dictionary.Entry entry = this._echosDictionary.getEntry(i);
            XtType xtType = XtType.XtTypeUnknown;
            int iEchosHeaderWordIndex = -1;
            int iEchosHeaderIndex = -1;
            if (this._headerWordIndexMap.containsKey(entry.EchosHeader) && this._headerXtTypeMap.containsKey(entry.EchosHeader)) {
                iEchosHeaderWordIndex = this._headerWordIndexMap.get(entry.EchosHeader);
                iEchosHeaderIndex = this._headerIndexMap.get(entry.EchosHeader);
                xtType = this._headerXtTypeMap.get(entry.EchosHeader);
            }
            if ((iTest = entry.HeaderIndex) < 0) {
                int k = 0;
                ++k;
            }
            entry.EchosHeaderWordIndex = iEchosHeaderWordIndex;
            entry.EchosHeaderIndex = iEchosHeaderIndex;
            entry.EchosType = xtType;
            entry.Valid = entry.EchosHeaderWordIndex >= 0;
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, long[] indices, int indexCount, boolean bGetHeaders, boolean bGetData) throws Exception {
        boolean bOpenedFile = false;
        try {
            if (!this.isFileOK()) {
                throw new Exception("!this.isFileOK()");
            }
            if (this._traceFile == null) {
                throw new Exception("null trace file");
            }
            if (this._traceFile.IsOpened() == 0) {
                boolean bOpenOK = this._traceFile.Open();
                if (!bOpenOK) {
                    throw new Exception("Failed to open Echos file : " + this.getFileDescription());
                }
                bOpenedFile = true;
            }
            long nTracesInFile = this._traceFile.GetNumTraces();
            int nSamples = this._traceFile.GetTraceLen();
            float fSampleInterval = (float)this._traceFile.getSampleIntervalInMilliseconds();
            if (nSamples != this._nAllocatedSamples) {
                this._nAllocatedSamples = nSamples;
                this._swigFloatArrayBuffer = EchosInterface.new_floatArray(this._nAllocatedSamples);
                this._sampleFloatArrayBuffer = new float[this._nAllocatedSamples];
            }
            long startTime = System.nanoTime();
            bGetHeaders = bGetHeaders && this._echosDictionary != null;
            int nHeaders = ensemble.dictionary().size();
            EnsembleHeaderDictionary ensembleDictionary = ensemble.dictionary();
            if (bGetHeaders) {
                this._echosDictionary.prepareSeismicHeaderDictionary(ensemble.dictionary());
                nHeaders = ensemble.dictionary().size();
                if (this._echosHeaderEntries == null) {
                    this._echosHeaderEntries = new Echos_Dictionary.Entry[nHeaders];
                }
                if (this._echosHeaderEntries.length != nHeaders) {
                    this._echosHeaderEntries = new Echos_Dictionary.Entry[nHeaders];
                }
                for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                    EnsembleHeaderDictionary.Entry ensembleEntry = ensembleDictionary.getEntry(iHeader);
                    Echos_Dictionary.Entry echosEntry = null;
                    String sTable = ensembleEntry.Table;
                    String sColumn = ensembleEntry.Column;
                    if (this._echosDictionary.hasEntry(sTable, sColumn)) {
                        echosEntry = this._echosDictionary.getEntry(sTable, sColumn);
                    }
                    this._echosHeaderEntries[iHeader] = echosEntry;
                }
            }
            if (this._echosDictionary == null) {
                throw new Exception("null Echos dictionary");
            }
            if (!this._bHeaderInfoInitialized) {
                this.initializeHeaderInfo();
            }
            bGetData = bGetData && nSamples > 0;
            boolean isFirstTrace = true;
            float traceTime0 = 0.0f;
            indexCount = Math.min(indexCount, indices.length);
            if (this._traceHeader == null) {
                this._traceHeader = new XtTraceHeader(this._traceFile);
            }
            for (int k = 0; k < indexCount; ++k) {
                long n = indices[k];
                if (n < 0L || n >= (long)((int)nTracesInFile)) continue;
                int iError = this._traceFile.ReadTrace(this._swigFloatArrayBuffer, nSamples, 0, this._traceHeader, n);
                if (iError != 0) {
                    throw new Exception("Echos ReadTrace error : " + Integer.toString(iError) + " file = " + this.getName());
                }
                boolean importTrace = true;
                try {
                    if (this.ImportLimitList.size() >= 1) {
                        for (ImportLimit lim : this.ImportLimitList) {
                            if (lim.Header < 0) continue;
                            XtType dataType = this._headerXtTypes[lim.Header];
                            double dVal = 0.0;
                            if (dataType == XtType.XtTypeInt) {
                                dVal = this._traceHeader.getIntValue(lim.Header);
                            } else if (dataType == XtType.XtTypeDouble) {
                                dVal = this._traceHeader.getDoubleValue(lim.Header);
                            } else if (dataType == XtType.XtTypeFloat) {
                                dVal = this._traceHeader.getFloatValue(lim.Header);
                            } else if (dataType == XtType.XtTypeLong) {
                                dVal = this._traceHeader.getLongValue(lim.Header);
                            }
                            if (!(dVal < (double)lim.Min) && !(dVal > (double)lim.Max)) continue;
                            importTrace = false;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!importTrace) continue;
                if (bGetData) {
                    boolean shitty = false;
                    for (int iSample = 0; iSample < nSamples; ++iSample) {
                        float fSampleValue = EchosInterface.floatArray_getitem(this._swigFloatArrayBuffer, iSample);
                        shitty = shitty || Float.isInfinite(fSampleValue) || Float.isNaN(fSampleValue);
                        this._sampleFloatArrayBuffer[iSample] = fSampleValue;
                    }
                    if (shitty) {
                        for (int s = 0; s < nSamples; ++s) {
                            this._sampleFloatArrayBuffer[s] = 0.0f;
                        }
                    }
                    if (isFirstTrace) {
                        isFirstTrace = false;
                    }
                }
                EnsembleTrace trace = ensemble.addTrace();
                Column_Abstract headers = trace.header();
                if (bGetHeaders) {
                    for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                        Echos_Dictionary.Entry echosEntry = this._echosHeaderEntries[iHeader];
                        EnsembleHeaderDictionary.Entry ensembleEntry = ensembleDictionary.getEntry(iHeader);
                        double dHeaderValue = -9999.0;
                        if (echosEntry != null) {
                            int iEchosHeaderWordIndex = echosEntry.EchosHeaderWordIndex;
                            int iEchosHeaderIndex = echosEntry.EchosHeaderIndex;
                            XtType xtType = echosEntry.EchosType;
                            dHeaderValue = echosEntry.DefaultValue;
                            if (iEchosHeaderWordIndex >= 0) {
                                if (xtType == XtType.XtTypeInt) {
                                    int iVal = this._traceHeader.getIntValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        iVal /= echosEntry.Factor;
                                    }
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorRemainder) {
                                        iVal %= echosEntry.Factor;
                                    }
                                    dHeaderValue = iVal;
                                } else if (xtType == XtType.XtTypeFloat) {
                                    float fVal = this._traceHeader.getFloatValue(iEchosHeaderIndex);
                                    dHeaderValue = fVal;
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        dHeaderValue /= (double)echosEntry.Factor;
                                    }
                                } else if (xtType == XtType.XtTypeDouble) {
                                    dHeaderValue = this._traceHeader.getDoubleValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        dHeaderValue /= (double)echosEntry.Factor;
                                    }
                                } else if (xtType == XtType.XtTypeLong) {
                                    long iVal = this._traceHeader.getLongValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        iVal /= (long)echosEntry.Factor;
                                    }
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorRemainder) {
                                        iVal %= (long)echosEntry.Factor;
                                    }
                                    dHeaderValue = iVal;
                                }
                            }
                        }
                        headers.putDouble(iHeader, dHeaderValue);
                    }
                }
                if (!bGetData) continue;
                trace.data().insertArray(this._sampleFloatArrayBuffer, this._sampleFloatArrayBuffer.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(fSampleInterval);
            }
            long l = System.nanoTime() - startTime;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
        finally {
            if (bOpenedFile) {
                this._traceFile.Close();
            }
        }
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID) throws Exception {
        this.populateEnsembleWithData(ensemble, fileID, false, true);
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID, boolean bReadHeaders, boolean bReadSamples) throws Exception {
        boolean bOpenedFile = false;
        try {
            if (this._traceFile == null) {
                throw new Exception("null trace file for Echos File : " + this.getFileDescription());
            }
            if (this._traceFile.IsOpened() == 0) {
                boolean bOpenOK = this._traceFile.Open();
                if (!bOpenOK) {
                    throw new Exception("Failed to open Echos file : " + this.getFileDescription());
                }
                bOpenedFile = true;
            }
            long nTracesInFile = this._traceFile.GetNumTraces();
            if (this._echosDictionary == null) {
                throw new Exception("null Echos dictionary");
            }
            if (!this._bHeaderInfoInitialized) {
                this.initializeHeaderInfo();
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FileID")) {
                throw new Exception("(Trace,FileID) not valid");
            }
            if (!ensemble.dictionary().containsEntry("Trace", "IndexInFile")) {
                throw new Exception("(Trace,IndexInFile) not valid");
            }
            int headerIndexFileID = ensemble.dictionary().getEntryIndex("Trace", "FileID");
            int headerIndexIndex = ensemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int headerIndexShotTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "TimeShift")) {
                headerIndexShotTimeShift = ensemble.dictionary().getEntryIndex("Shot", "TimeShift");
            }
            int headerIndexRecTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Receiver", "TimeShift")) {
                headerIndexRecTimeShift = ensemble.dictionary().getEntryIndex("Receiver", "TimeShift");
            }
            int count = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int fid = ensemble.trace(n).header().getInt(headerIndexFileID);
                if (fid != fileID) continue;
                ++count;
            }
            if (count < 1) {
                return;
            }
            int nSamples = this._traceFile.GetTraceLen();
            if (nSamples != this._nAllocatedSamples) {
                this._nAllocatedSamples = nSamples;
                this._swigFloatArrayBuffer = EchosInterface.new_floatArray(this._nAllocatedSamples);
                this._sampleFloatArrayBuffer = new float[this._nAllocatedSamples];
            }
            EnsembleHeaderDictionary ensembleDictionary = ensemble.dictionary();
            int nHeaders = ensemble.dictionary().size();
            if (bReadHeaders) {
                if (this._echosHeaderEntries == null) {
                    this._echosHeaderEntries = new Echos_Dictionary.Entry[nHeaders];
                }
                if (this._echosHeaderEntries.length != nHeaders) {
                    this._echosHeaderEntries = new Echos_Dictionary.Entry[nHeaders];
                }
                for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                    EnsembleHeaderDictionary.Entry ensembleEntry = ensembleDictionary.getEntry(iHeader);
                    Echos_Dictionary.Entry echosEntry = null;
                    String sTable = ensembleEntry.Table;
                    String sColumn = ensembleEntry.Column;
                    if (this._echosDictionary.hasEntry(sTable, sColumn)) {
                        echosEntry = this._echosDictionary.getEntry(sTable, sColumn);
                    }
                    this._echosHeaderEntries[iHeader] = echosEntry;
                }
            }
            if (this._traceHeader == null) {
                this._traceHeader = new XtTraceHeader(this._traceFile);
            }
            float time0 = 0.0f;
            float fSampleInterval = (float)this._traceFile.getSampleIntervalInMilliseconds();
            for (int k = 0; k < ensemble.traceCount(); ++k) {
                EnsembleTrace trace = ensemble.trace(k);
                Column_Abstract headers = trace.header();
                int fid = headers.getInt(headerIndexFileID);
                if (fid != fileID) continue;
                long traceIndex = trace.header().getLong(headerIndexIndex);
                if (traceIndex < 0L || traceIndex >= nTracesInFile) {
                    throw new Exception("Invalid trace index : " + Long.toString(traceIndex) + " Num Traces = " + Long.toString(nTracesInFile) + " file = " + this.getName());
                }
                int iError = this._traceFile.ReadTrace(this._swigFloatArrayBuffer, nSamples, 0, this._traceHeader, traceIndex);
                if (iError != 0) {
                    throw new Exception("Echos ReadTrace error : " + Integer.toString(iError) + " file = " + this.getName());
                }
                if (bReadHeaders) {
                    for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                        Echos_Dictionary.Entry echosEntry = this._echosHeaderEntries[iHeader];
                        EnsembleHeaderDictionary.Entry ensembleEntry = ensembleDictionary.getEntry(iHeader);
                        double dHeaderValue = -9999.0;
                        if (echosEntry != null) {
                            if (echosEntry.Table.equalsIgnoreCase("Shot") && echosEntry.Column.equalsIgnoreCase("Northing")) {
                                int kkk = 0;
                                ++kkk;
                            }
                            int iEchosHeaderWordIndex = echosEntry.EchosHeaderWordIndex;
                            int iEchosHeaderIndex = echosEntry.EchosHeaderIndex;
                            XtType xtType = echosEntry.EchosType;
                            dHeaderValue = echosEntry.DefaultValue;
                            if (iEchosHeaderIndex >= 0) {
                                if (xtType == XtType.XtTypeInt) {
                                    int iVal = this._traceHeader.getIntValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        iVal /= echosEntry.Factor;
                                    }
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorRemainder) {
                                        iVal %= echosEntry.Factor;
                                    }
                                    dHeaderValue = iVal;
                                } else if (xtType == XtType.XtTypeFloat) {
                                    float fVal = this._traceHeader.getFloatValue(iEchosHeaderIndex);
                                    dHeaderValue = fVal;
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        dHeaderValue /= (double)echosEntry.Factor;
                                    }
                                } else if (xtType == XtType.XtTypeDouble) {
                                    dHeaderValue = this._traceHeader.getDoubleValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        dHeaderValue /= (double)echosEntry.Factor;
                                    }
                                } else if (xtType == XtType.XtTypeLong) {
                                    long iVal = this._traceHeader.getLongValue(iEchosHeaderIndex);
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorDivide) {
                                        iVal /= (long)echosEntry.Factor;
                                    }
                                    if (echosEntry.ModMethod == Echos_Dictionary.Modification.FactorRemainder) {
                                        iVal %= (long)echosEntry.Factor;
                                    }
                                    dHeaderValue = iVal;
                                }
                            }
                        }
                        headers.putDouble(iHeader, dHeaderValue);
                    }
                }
                if (!bReadSamples) continue;
                for (int iSample = 0; iSample < nSamples; ++iSample) {
                    float fSampleValue;
                    this._sampleFloatArrayBuffer[iSample] = fSampleValue = EchosInterface.floatArray_getitem(this._swigFloatArrayBuffer, iSample);
                }
                float traceTime0 = time0;
                if (headerIndexShotTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexShotTimeShift);
                }
                if (headerIndexRecTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexRecTimeShift);
                }
                trace.data().insertArray(this._sampleFloatArrayBuffer, this._sampleFloatArrayBuffer.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(fSampleInterval);
            }
        }
        catch (Exception error) {
            throw error;
        }
        finally {
            try {
                if (bOpenedFile) {
                    this._traceFile.Close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int samplesPerTrace() {
        if (this._traceFile == null) {
            return 0;
        }
        int nSamplesPerTrace = this._traceFile.GetTraceLen();
        return nSamplesPerTrace;
    }

    @Override
    public float sampleInterval() {
        if (this._traceFile == null) {
            return 0.0f;
        }
        float fSampleInterval = (float)this._traceFile.getSampleIntervalInMilliseconds();
        return fSampleInterval;
    }

    @Override
    public long traceCount() {
        if (this._traceFile == null) {
            return 0L;
        }
        long nTraces = this._traceFile.GetNumTraces();
        return nTraces;
    }

    @Override
    public boolean isFileOK() {
        return this._traceFile != null;
    }

    @Override
    public void openPecosRAF() {
        if (this._traceFile == null) {
            return;
        }
        if (this._traceFile.IsOpened() == 0) {
            boolean bl = this._traceFile.Open();
        }
    }

    @Override
    public void closePecosRAF() {
        if (this._traceFile == null) {
            return;
        }
        this._traceFile.Close();
    }

    @Override
    public void addImportLimit(ImportLimit il) {
        ImportLimit lim = new ImportLimit();
        lim.HeaderName = il.HeaderName;
        lim.Header = il.Header;
        lim.Min = il.Min;
        lim.Max = il.Max;
        lim.Type = il.Type;
        lim.Table = il.Table;
        lim.Column = il.Column;
        this.ImportLimitList.add(lim);
    }

    @Override
    public void clearImportLimitList() {
        this.ImportLimitList.clear();
    }

    public void populateEnsemble(Ensemble ensemble, int minInline, int maxInline, int minCrossline, int maxCrossline) throws Exception {
        boolean bOpenOK;
        if (this._traceFile == null) {
            throw new Exception("null trace file for Echos File : " + this.getFileDescription());
        }
        if (this._traceFile.IsOpened() == 0 && !(bOpenOK = this._traceFile.Open())) {
            throw new Exception("Failed to open Echos file : " + this.getFileDescription());
        }
        boolean bReadHeaders = true;
        boolean bReadSamples = true;
        int nSamples = this._traceFile.GetTraceLen();
        if (this._populateEnsembleGather == null) {
            this._populateEnsembleGather = new XtParadigmTfGather(this._traceFile);
        }
        if (this._populateEnsembleSwigFloatArrayBuffer == null) {
            this._populateEnsembleSwigFloatArrayBuffer = EchosInterface.new_floatArray(nSamples);
        }
        if (this._populateEnsembleFloatArrayBuffer == null) {
            this._populateEnsembleFloatArrayBuffer = new float[nSamples];
        }
        for (int iInline = minInline; iInline <= maxInline; ++iInline) {
            for (int iCrossline = minCrossline; iCrossline <= maxCrossline; ++iCrossline) {
                boolean bOk;
                int iCmp = this._traceFile.GetCmpNo(iInline, iCrossline);
                int nTracesRead = this._populateEnsembleGather.ReadGather(iCmp);
                if (nTracesRead <= 0 || (bOk = XtParadigmTraceFileTools.populateEnsemble(this._echosDictionary, this._populateEnsembleGather, ensemble, bReadHeaders, bReadSamples, this._populateEnsembleSwigFloatArrayBuffer, nSamples, this._populateEnsembleFloatArrayBuffer))) continue;
                throw new Exception("failed to read inline : " + Integer.toString(iInline) + " Crossline " + Integer.toString(iCrossline) + " in Echos File " + this.getFileDescription());
            }
        }
    }
}

