/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;

public class TraceTable_Scanner_TomoSynth
extends TraceTable_ScannerBase {
    protected TomoEikonal3D m_model;
    TomoEikonal3DProfile m_profile;
    protected int m_indexToCol = -999;

    public TraceTable_Scanner_TomoSynth() {
        try {
            this.m_model = RefractionStaticsProject.singleton().getEikonal3D();
            this.m_profile = this.m_model.createNewProfile();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_indexToCol < 0) {
                this.m_indexToCol = this.m_traceTable.column_indexOfColumn("FBP_User");
            }
            double time = 0.0;
            if (this.m_offset < 3.0 * this.m_model.binSizeHorz()) {
                this.m_model.fireStraightLine(this.m_shotX, this.m_shotY, this.m_shotZ, this.m_recX, this.m_recY, this.m_recZ);
                time = this.m_model.StraightLineTotalTime;
            } else {
                this.m_model.populateProfile(this.m_profile, this.m_shotX, this.m_shotY, this.m_recX, this.m_recY);
                this.m_profile.fireShot((float)this.m_shotZ);
                this.m_profile.setReceiver((float)this.m_recZ, 0.0f);
                time = this.m_profile.ReceiverTime;
            }
            this.m_traceTable.putFloat(this.m_traceRow, this.m_indexToCol, (float)time);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

