/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;

public class TraceTable_Scanner_LayerSyn
extends TraceTable_ScannerBase {
    public double[] V = new double[10];
    public double[] Z = new double[10];
    public double[] DT = new double[10];
    protected int m_indexToCol = -9999;
    public boolean WorkCalled = false;
    protected DelayTimeMath m_dt;

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_indexToCol < 0) {
                this.m_indexToCol = this.m_traceTable.column_indexOfColumn("FBP_User");
            }
            if (this.m_dt == null) {
                this.m_dt = new DelayTimeMath();
                this.m_dt.MaxBranch = 2;
                this.m_dt.Thickness[1] = this.Z[1] - this.Z[2];
                this.m_dt.Velocity[0] = this.V[0];
                this.m_dt.Velocity[1] = this.V[1];
                this.m_dt.Velocity[2] = this.V[2];
                this.DT[1] = this.m_dt.computeDelayTime(1);
                this.DT[2] = this.m_dt.computeDelayTime(2);
            }
            double shotZ = this.m_shotZ - this.m_shotDepth;
            this.m_dt.Thickness[0] = shotZ - this.Z[1];
            double sdt1 = this.m_dt.computeDelayTime(1);
            double sdt2 = this.m_dt.computeDelayTime(2);
            this.m_dt.Thickness[0] = this.m_recZ - this.Z[1];
            double rdt1 = this.m_dt.computeDelayTime(1);
            double rdt2 = this.m_dt.computeDelayTime(2);
            float time = 0.0f;
            double t0 = 1000.0 * this.m_offset / this.V[0];
            double t1 = 1000.0 * this.m_offset / this.V[1] + sdt1 + rdt1;
            double t2 = 1000.0 * this.m_offset / this.V[2] + sdt2 + rdt2;
            time = (float)Math.min(t0, Math.min(t1, t2));
            this.m_traceTable.putFloat(this.m_traceRow, this.m_indexToCol, time);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

