/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import java.util.ArrayList;

public class TraceTable_Scanner_ColumnCopy
extends TraceTable_ScannerBase {
    protected boolean m_justCopyInsideBranch;
    protected int m_whichBranch = 0;
    protected boolean m_overwriteAllValues;
    protected int m_indexFromCol;
    protected int m_indexToCol;
    protected float m_badValueCutoff;
    protected float m_minimumRequiredFromValue = -9999999.0f;
    public boolean ApplyShift = false;
    public float Shift = 0.0f;
    protected ArrayList<Restriction> m_restriction = new ArrayList();
    protected DataType m_fromType;
    protected DataType m_toType;
    public boolean WorkCalled = false;

    public void clearRestrictions() {
        this.m_restriction.clear();
    }

    public void addRestriction(String table, String column, double min, double max) {
        try {
            Restriction r = new Restriction();
            r.Column = column;
            r.TableName = table;
            r.Minimum = min;
            r.Maximum = max;
            this.m_restriction.add(r);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TraceTable_Scanner_ColumnCopy(ITraceTable traceTable, String fromCol, String toCol, boolean justCopyInsideBranch, int whichBranch, boolean overwriteAllValues, float badValueCutoff, float minimumRequiredFromValue) {
        try {
            this.m_minimumRequiredFromValue = minimumRequiredFromValue;
            this.m_justCopyInsideBranch = justCopyInsideBranch;
            this.m_whichBranch = whichBranch;
            this.m_overwriteAllValues = overwriteAllValues;
            this.m_indexToCol = traceTable.column_indexOfColumn(toCol);
            this.m_indexFromCol = traceTable.column_indexOfColumn(fromCol);
            this.m_badValueCutoff = badValueCutoff;
            this.m_toType = traceTable.column_type(this.m_indexToCol);
            this.m_fromType = traceTable.column_type(this.m_indexFromCol);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            if (!this.WorkCalled) {
                try {
                    for (Restriction r : this.m_restriction) {
                        r.Valid = false;
                        if ("Trace".equalsIgnoreCase(r.TableName)) {
                            if ("Offset".equalsIgnoreCase(r.Column)) {
                                r.Valid = true;
                                r.IsOffset = true;
                                r.TableIndex = -9999;
                            } else {
                                r.Valid = true;
                                r.IsTrace = true;
                                r.TableIndex = this.m_traceTable.column_indexOfColumn(r.Column);
                            }
                        }
                        if ("Receiver".equalsIgnoreCase(r.TableName)) {
                            r.Valid = true;
                            r.IsRec = true;
                            r.TableIndex = this.m_recTable.column_indexOfColumn(r.Column);
                        }
                        if (!"Shot".equalsIgnoreCase(r.TableName)) continue;
                        r.Valid = true;
                        r.IsShot = true;
                        r.TableIndex = this.m_shotTable.column_indexOfColumn(r.Column);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.WorkCalled = true;
            if (this.m_justCopyInsideBranch) {
                if (this.m_branch < 1) {
                    return;
                }
                if (this.m_whichBranch >= 1 && this.m_branch != this.m_whichBranch) {
                    return;
                }
            }
            boolean polyOK = true;
            if (this.CheckIfMidInsidePolygon && !this.m_isMidInsidePolygon) {
                polyOK = false;
            }
            if (this.CheckIfRecInsidePolygon && !this.m_isRecInsidePolygon) {
                polyOK = false;
            }
            if (this.CheckIfShotInsidePolygon && !this.m_isShotInsidePolygon) {
                polyOK = false;
            }
            if (!polyOK) {
                return;
            }
            double fromValue = -9999.0;
            if (this.m_fromType == DataType.Float) {
                fromValue = this.m_traceTable.getFloat(this.m_traceRow, this.m_indexFromCol);
            } else if (this.m_fromType == DataType.Long) {
                fromValue = this.m_traceTable.getLong(this.m_traceRow, this.m_indexFromCol);
            } else if (this.m_fromType == DataType.Int) {
                fromValue = this.m_traceTable.getInt(this.m_traceRow, this.m_indexFromCol);
            }
            if (this.ApplyShift) {
                fromValue += (double)this.Shift;
            }
            float toValue = -9999.0f;
            if (this.m_toType == DataType.Float) {
                toValue = this.m_traceTable.getFloat(this.m_traceRow, this.m_indexToCol);
            } else if (this.m_toType == DataType.Long) {
                toValue = this.m_traceTable.getLong(this.m_traceRow, this.m_indexToCol);
            } else if (this.m_toType == DataType.Int) {
                toValue = this.m_traceTable.getInt(this.m_traceRow, this.m_indexToCol);
            }
            if (fromValue < (double)this.m_minimumRequiredFromValue) {
                return;
            }
            boolean output = false;
            if (this.m_overwriteAllValues) {
                output = true;
            } else if (toValue < this.m_badValueCutoff) {
                output = true;
            }
            if (!output) {
                return;
            }
            for (Restriction r : this.m_restriction) {
                if (!r.Valid) continue;
                double v = -99999.0;
                if (r.IsOffset) {
                    v = this.m_offset;
                }
                if (r.IsTrace) {
                    v = this.m_traceTable.getFloat(this.m_traceRow, r.TableIndex);
                }
                if (r.IsRec) {
                    v = this.m_recTable.getDouble(this.m_recRow, r.TableIndex);
                }
                if (r.IsShot) {
                    v = this.m_shotTable.getDouble(this.m_shotRow, r.TableIndex);
                }
                if (v < r.Minimum) {
                    return;
                }
                if (!(v > r.Maximum)) continue;
                return;
            }
            if (this.m_toType == DataType.Float) {
                this.m_traceTable.putFloat(this.m_traceRow, this.m_indexToCol, (float)fromValue);
            } else if (this.m_toType == DataType.Long) {
                this.m_traceTable.putLong(this.m_traceRow, this.m_indexToCol, (long)fromValue);
            } else if (this.m_toType == DataType.Int) {
                this.m_traceTable.putInt(this.m_traceRow, this.m_indexToCol, (int)fromValue);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class Restriction {
        public String TableName;
        public String Column;
        public double Minimum;
        public double Maximum;
        public boolean Valid = false;
        public int TableIndex;
        public boolean IsShot = false;
        public boolean IsRec = false;
        public boolean IsTrace = false;
        public boolean IsOffset = false;

        protected Restriction() {
        }
    }
}

