/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import java.io.BufferedWriter;

public class TraceTable_Scanner_AsciiCoordExport
extends TraceTable_ScannerBase {
    protected int m_indexCol;
    protected BufferedWriter m_writer;
    protected boolean m_setKilledToInvalid;
    protected boolean m_excludeInvalid;
    protected boolean m_ffid;
    protected boolean m_ffidPoint;
    protected boolean m_coords;
    protected boolean m_combined;
    protected boolean m_separate;
    protected int m_indexFFID = -9999;
    protected int m_indexChannel = -9999;

    public TraceTable_Scanner_AsciiCoordExport(ITraceTableScannerMonitor monitor, ITraceTable traceTable, BufferedWriter writer, String column, boolean overwriteInvalid, boolean excludeInvalid, boolean coords, boolean ffid, boolean ffidPoint, boolean combined, boolean separate) {
        try {
            this.m_coords = coords;
            this.m_ffid = ffid;
            this.m_ffidPoint = ffidPoint;
            this.m_combined = combined;
            this.m_separate = separate;
            this.m_setKilledToInvalid = overwriteInvalid;
            this.m_excludeInvalid = excludeInvalid;
            this.m_monitor = monitor;
            this.m_writer = writer;
            this.m_indexCol = traceTable.column_indexOfColumn(column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            int ffid;
            float v = this.m_traceTable.getFloat(this.m_traceRow, this.m_indexCol);
            if (this.m_shotKilled || this.m_recKilled) {
                if (this.m_setKilledToInvalid) {
                    v = -9999.0f;
                }
                if (this.m_excludeInvalid) {
                    return;
                }
            }
            if (v < 0.0f && this.m_excludeInvalid) {
                return;
            }
            String s = "";
            if (this.m_coords) {
                s = String.format("%12d %12d %12d %12d %f", (int)this.m_shotX, (int)this.m_shotY, (int)this.m_recX, (int)this.m_recY, Float.valueOf(v));
            }
            if (this.m_ffid) {
                if (this.m_indexFFID < 0) {
                    this.m_indexFFID = this.m_shotTable.column_indexOfColumn("FFID");
                }
                if (this.m_indexChannel < 0) {
                    this.m_indexChannel = this.m_traceTable.column_indexOfColumn("Channel");
                }
                ffid = this.m_shotTable.getInt(this.m_shotRow, this.m_indexFFID);
                int chan = this.m_traceTable.getInt(this.m_traceRow, this.m_indexChannel);
                s = String.format("%12d %12d        %f", ffid, chan, Float.valueOf(v));
            }
            if (this.m_ffidPoint) {
                if (this.m_indexFFID < 0) {
                    this.m_indexFFID = this.m_shotTable.column_indexOfColumn("FFID");
                }
                ffid = this.m_shotTable.getInt(this.m_shotRow, this.m_indexFFID);
                s = String.format("%12d %12d        %f", ffid, this.m_recPoint, Float.valueOf(v));
            }
            if (this.m_combined) {
                if (this.m_indexShotPoint < 0) {
                    this.m_indexShotPoint = this.m_shotTable.column_indexOfColumn("PointNumber");
                }
                if (this.m_indexRecPoint < 0) {
                    this.m_indexRecPoint = this.m_recTable.column_indexOfColumn("PointNumber");
                }
                int shotPoint = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotPoint);
                int recPoint = this.m_recTable.getInt(this.m_recRow, this.m_indexRecPoint);
                s = String.format("%12d %12d        %f", shotPoint, recPoint, Float.valueOf(v));
            }
            if (this.m_separate) {
                if (this.m_indexShotLine < 0) {
                    this.m_indexShotLine = this.m_shotTable.column_indexOfColumn("LineNumber");
                }
                if (this.m_indexShotPoint < 0) {
                    this.m_indexShotPoint = this.m_shotTable.column_indexOfColumn("PointNumber");
                }
                if (this.m_indexRecLine < 0) {
                    this.m_indexRecLine = this.m_recTable.column_indexOfColumn("LineNumber");
                }
                if (this.m_indexRecPoint < 0) {
                    this.m_indexRecPoint = this.m_recTable.column_indexOfColumn("PointNumber");
                }
                int shotLine = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotLine);
                int shotPoint = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotPoint);
                int recLine = this.m_recTable.getInt(this.m_recRow, this.m_indexRecLine);
                int recPoint = this.m_recTable.getInt(this.m_recRow, this.m_indexRecPoint);
                s = String.format("%12d %12d %12d %12d %f", shotLine, shotPoint, recLine, recPoint, Float.valueOf(v));
            }
            this.m_writer.write(s);
            this.m_writer.newLine();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

