/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;

public class TraceTable_BranchPickKiller
extends TraceTable_ScannerBase {
    public boolean KillOutsideAcceptanceZone = false;
    public boolean KillAllPicksOutsideBranch = false;
    public boolean KillPicksLessThanMinimimOffset = false;
    public boolean KillPicksGreaterThanMaximumOffset = false;
    protected int m_indexPick;
    public int NumKilled = 0;

    public TraceTable_BranchPickKiller(ITraceTable traceTable, String pickCol) throws Exception {
        try {
            this.m_indexPick = traceTable.column_exists(pickCol) ? traceTable.column_indexOfColumn(pickCol) : -999;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_indexPick < 0) {
                return;
            }
            float pick = this.m_traceTable.getFloat(this.m_traceRow, this.m_indexPick);
            if (pick < -200.0f) {
                return;
            }
            this.m_branchAssignment.interpolateAtLocation(this.m_midX, this.m_midX, this.m_offset);
            if (this.m_branchAssignment.Location_ExactBranch >= 1) {
                double killRadius;
                if (!this.KillOutsideAcceptanceZone) {
                    return;
                }
                double diff = Math.abs(this.m_branchAssignment.Location_PickTime - (double)pick);
                if (diff > (killRadius = this.m_branchAssignment.getKillRadius())) {
                    this.m_traceTable.putFloat(this.m_traceRow, this.m_indexPick, -9999.0f);
                    ++this.NumKilled;
                }
                return;
            }
            if (this.KillAllPicksOutsideBranch) {
                this.m_traceTable.putFloat(this.m_traceRow, this.m_indexPick, -9999.0f);
                ++this.NumKilled;
                return;
            }
            if (this.KillPicksLessThanMinimimOffset && this.m_branchAssignment.Location_OffsetLessThanFirst) {
                this.m_traceTable.putFloat(this.m_traceRow, this.m_indexPick, -9999.0f);
                ++this.NumKilled;
                return;
            }
            if (this.KillPicksGreaterThanMaximumOffset && this.m_branchAssignment.Location_OffsetMoreThanLast) {
                this.m_traceTable.putFloat(this.m_traceRow, this.m_indexPick, -9999.0f);
                ++this.NumKilled;
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

